# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetModelDeploymentModelStatesResult',
    'AwaitableGetModelDeploymentModelStatesResult',
    'get_model_deployment_model_states',
    'get_model_deployment_model_states_output',
]

@pulumi.output_type
class GetModelDeploymentModelStatesResult:
    """
    A collection of values returned by getModelDeploymentModelStates.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, inference_key=None, model_deployment_id=None, model_deployment_model_states=None, model_id=None, project_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inference_key and not isinstance(inference_key, str):
            raise TypeError("Expected argument 'inference_key' to be a str")
        pulumi.set(__self__, "inference_key", inference_key)
        if model_deployment_id and not isinstance(model_deployment_id, str):
            raise TypeError("Expected argument 'model_deployment_id' to be a str")
        pulumi.set(__self__, "model_deployment_id", model_deployment_id)
        if model_deployment_model_states and not isinstance(model_deployment_model_states, list):
            raise TypeError("Expected argument 'model_deployment_model_states' to be a list")
        pulumi.set(__self__, "model_deployment_model_states", model_deployment_model_states)
        if model_id and not isinstance(model_id, str):
            raise TypeError("Expected argument 'model_id' to be a str")
        pulumi.set(__self__, "model_id", model_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetModelDeploymentModelStatesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inferenceKey")
    def inference_key(self) -> Optional[_builtins.str]:
        """
        SaaS friendly name for the model OCID.
        """
        return pulumi.get(self, "inference_key")

    @_builtins.property
    @pulumi.getter(name="modelDeploymentId")
    def model_deployment_id(self) -> _builtins.str:
        return pulumi.get(self, "model_deployment_id")

    @_builtins.property
    @pulumi.getter(name="modelDeploymentModelStates")
    def model_deployment_model_states(self) -> Sequence['outputs.GetModelDeploymentModelStatesModelDeploymentModelStateResult']:
        """
        The list of model_deployment_model_states.
        """
        return pulumi.get(self, "model_deployment_model_states")

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployed model in model deployment.
        """
        return pulumi.get(self, "model_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project associated with the model.
        """
        return pulumi.get(self, "project_id")


class AwaitableGetModelDeploymentModelStatesResult(GetModelDeploymentModelStatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelDeploymentModelStatesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            inference_key=self.inference_key,
            model_deployment_id=self.model_deployment_id,
            model_deployment_model_states=self.model_deployment_model_states,
            model_id=self.model_id,
            project_id=self.project_id)


def get_model_deployment_model_states(compartment_id: Optional[_builtins.str] = None,
                                      display_name: Optional[_builtins.str] = None,
                                      filters: Optional[Sequence[Union['GetModelDeploymentModelStatesFilterArgs', 'GetModelDeploymentModelStatesFilterArgsDict']]] = None,
                                      inference_key: Optional[_builtins.str] = None,
                                      model_deployment_id: Optional[_builtins.str] = None,
                                      model_id: Optional[_builtins.str] = None,
                                      project_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelDeploymentModelStatesResult:
    """
    This data source provides the list of Model Deployment Model States in Oracle Cloud Infrastructure Data Science service.

    Lists the status of models in a model group deployment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model_deployment_model_states = oci.DataScience.get_model_deployment_model_states(compartment_id=compartment_id,
        model_deployment_id=test_model_deployment["id"],
        display_name=model_deployment_model_state_display_name,
        inference_key=model_deployment_model_state_inference_key,
        model_id=test_model["id"],
        project_id=test_project["id"])
    ```


    :param _builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: <b>Filter</b> results by its user-friendly name.
    :param _builtins.str inference_key: <b>Filter</b> results by the inference key.
    :param _builtins.str model_deployment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model deployment.
    :param _builtins.str model_id: <b>Filter</b> results by the model ocid.
    :param _builtins.str project_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['inferenceKey'] = inference_key
    __args__['modelDeploymentId'] = model_deployment_id
    __args__['modelId'] = model_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getModelDeploymentModelStates:getModelDeploymentModelStates', __args__, opts=opts, typ=GetModelDeploymentModelStatesResult).value

    return AwaitableGetModelDeploymentModelStatesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        inference_key=pulumi.get(__ret__, 'inference_key'),
        model_deployment_id=pulumi.get(__ret__, 'model_deployment_id'),
        model_deployment_model_states=pulumi.get(__ret__, 'model_deployment_model_states'),
        model_id=pulumi.get(__ret__, 'model_id'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_model_deployment_model_states_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                             display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetModelDeploymentModelStatesFilterArgs', 'GetModelDeploymentModelStatesFilterArgsDict']]]]] = None,
                                             inference_key: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             model_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                             model_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetModelDeploymentModelStatesResult]:
    """
    This data source provides the list of Model Deployment Model States in Oracle Cloud Infrastructure Data Science service.

    Lists the status of models in a model group deployment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model_deployment_model_states = oci.DataScience.get_model_deployment_model_states(compartment_id=compartment_id,
        model_deployment_id=test_model_deployment["id"],
        display_name=model_deployment_model_state_display_name,
        inference_key=model_deployment_model_state_inference_key,
        model_id=test_model["id"],
        project_id=test_project["id"])
    ```


    :param _builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: <b>Filter</b> results by its user-friendly name.
    :param _builtins.str inference_key: <b>Filter</b> results by the inference key.
    :param _builtins.str model_deployment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model deployment.
    :param _builtins.str model_id: <b>Filter</b> results by the model ocid.
    :param _builtins.str project_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['inferenceKey'] = inference_key
    __args__['modelDeploymentId'] = model_deployment_id
    __args__['modelId'] = model_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getModelDeploymentModelStates:getModelDeploymentModelStates', __args__, opts=opts, typ=GetModelDeploymentModelStatesResult)
    return __ret__.apply(lambda __response__: GetModelDeploymentModelStatesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        inference_key=pulumi.get(__response__, 'inference_key'),
        model_deployment_id=pulumi.get(__response__, 'model_deployment_id'),
        model_deployment_model_states=pulumi.get(__response__, 'model_deployment_model_states'),
        model_id=pulumi.get(__response__, 'model_id'),
        project_id=pulumi.get(__response__, 'project_id')))
