# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVulnerabilityNotificationsResult',
    'AwaitableGetVulnerabilityNotificationsResult',
    'get_vulnerability_notifications',
    'get_vulnerability_notifications_output',
]

@pulumi.output_type
class GetVulnerabilityNotificationsResult:
    """
    A collection of values returned by getVulnerabilityNotifications.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, notification_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if notification_collections and not isinstance(notification_collections, list):
            raise TypeError("Expected argument 'notification_collections' to be a list")
        pulumi.set(__self__, "notification_collections", notification_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVulnerabilityNotificationsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="notificationCollections")
    def notification_collections(self) -> Sequence['outputs.GetVulnerabilityNotificationsNotificationCollectionResult']:
        """
        The list of notification_collection.
        """
        return pulumi.get(self, "notification_collections")


class AwaitableGetVulnerabilityNotificationsResult(GetVulnerabilityNotificationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVulnerabilityNotificationsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            notification_collections=self.notification_collections)


def get_vulnerability_notifications(compartment_id: Optional[_builtins.str] = None,
                                    filters: Optional[Sequence[Union['GetVulnerabilityNotificationsFilterArgs', 'GetVulnerabilityNotificationsFilterArgsDict']]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVulnerabilityNotificationsResult:
    """
    This data source provides the list of Vulnerability Notifications in Oracle Cloud Infrastructure Dblm service.

    List of notifications

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_notifications = oci.Dblm.get_vulnerability_notifications(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The required ID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dblm/getVulnerabilityNotifications:getVulnerabilityNotifications', __args__, opts=opts, typ=GetVulnerabilityNotificationsResult).value

    return AwaitableGetVulnerabilityNotificationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        notification_collections=pulumi.get(__ret__, 'notification_collections'))
def get_vulnerability_notifications_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVulnerabilityNotificationsFilterArgs', 'GetVulnerabilityNotificationsFilterArgsDict']]]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVulnerabilityNotificationsResult]:
    """
    This data source provides the list of Vulnerability Notifications in Oracle Cloud Infrastructure Dblm service.

    List of notifications

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_notifications = oci.Dblm.get_vulnerability_notifications(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The required ID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dblm/getVulnerabilityNotifications:getVulnerabilityNotifications', __args__, opts=opts, typ=GetVulnerabilityNotificationsResult)
    return __ret__.apply(lambda __response__: GetVulnerabilityNotificationsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        notification_collections=pulumi.get(__response__, 'notification_collections')))
