# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DrPlanExecutionArgs', 'DrPlanExecution']

@pulumi.input_type
class DrPlanExecutionArgs:
    def __init__(__self__, *,
                 execution_options: pulumi.Input['DrPlanExecutionExecutionOptionsArgs'],
                 plan_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DrPlanExecution resource.
        :param pulumi.Input['DrPlanExecutionExecutionOptionsArgs'] execution_options: The options for a plan execution.
        :param pulumi.Input[_builtins.str] plan_id: The OCID of the DR plan.  Example: `ocid1.drplan.oc1..uniqueID` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the DR plan execution.  Example: `Execution - EBS Switchover PHX to IAD`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "execution_options", execution_options)
        pulumi.set(__self__, "plan_id", plan_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="executionOptions")
    def execution_options(self) -> pulumi.Input['DrPlanExecutionExecutionOptionsArgs']:
        """
        The options for a plan execution.
        """
        return pulumi.get(self, "execution_options")

    @execution_options.setter
    def execution_options(self, value: pulumi.Input['DrPlanExecutionExecutionOptionsArgs']):
        pulumi.set(self, "execution_options", value)

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the DR plan.  Example: `ocid1.drplan.oc1..uniqueID` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the DR plan execution.  Example: `Execution - EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _DrPlanExecutionState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dr_protection_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_duration_in_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 execution_options: Optional[pulumi.Input['DrPlanExecutionExecutionOptionsArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 group_executions: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionArgs']]]] = None,
                 life_cycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 log_locations: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionLogLocationArgs']]]] = None,
                 peer_dr_protection_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_region: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_execution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_ended: Optional[pulumi.Input[_builtins.str]] = None,
                 time_started: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DrPlanExecution resources.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment containing this DR plan execution.  Example: `ocid1.compartment.oc1..uniqueID`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the DR plan execution.  Example: `Execution - EBS Switchover PHX to IAD`
        :param pulumi.Input[_builtins.str] dr_protection_group_id: The OCID of the DR protection group to which this DR plan execution belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        :param pulumi.Input[_builtins.int] execution_duration_in_sec: The total duration in seconds taken to complete the step execution.  Example: `35`
        :param pulumi.Input['DrPlanExecutionExecutionOptionsArgs'] execution_options: The options for a plan execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionArgs']]] group_executions: A list of groups executed in this DR plan execution.
        :param pulumi.Input[_builtins.str] life_cycle_details: A message describing the DR plan execution's current state in more detail.
        :param pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionLogLocationArgs']]] log_locations: The details of an object storage log location for a DR protection group.
        :param pulumi.Input[_builtins.str] peer_dr_protection_group_id: The OCID of peer DR protection group associated with this plan's DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        :param pulumi.Input[_builtins.str] peer_region: The region of the peer DR protection group associated with this plan's DR protection group.  Example: `us-ashburn-1`
        :param pulumi.Input[_builtins.str] plan_execution_type: The type of the DR plan executed.
        :param pulumi.Input[_builtins.str] plan_id: The OCID of the DR plan.  Example: `ocid1.drplan.oc1..uniqueID` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of the DR plan execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time at which DR plan execution was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[_builtins.str] time_ended: The date and time at which DR plan execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[_builtins.str] time_started: The date and time at which DR plan execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[_builtins.str] time_updated: The time when DR plan execution was last updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dr_protection_group_id is not None:
            pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        if execution_duration_in_sec is not None:
            pulumi.set(__self__, "execution_duration_in_sec", execution_duration_in_sec)
        if execution_options is not None:
            pulumi.set(__self__, "execution_options", execution_options)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if group_executions is not None:
            pulumi.set(__self__, "group_executions", group_executions)
        if life_cycle_details is not None:
            pulumi.set(__self__, "life_cycle_details", life_cycle_details)
        if log_locations is not None:
            pulumi.set(__self__, "log_locations", log_locations)
        if peer_dr_protection_group_id is not None:
            pulumi.set(__self__, "peer_dr_protection_group_id", peer_dr_protection_group_id)
        if peer_region is not None:
            pulumi.set(__self__, "peer_region", peer_region)
        if plan_execution_type is not None:
            pulumi.set(__self__, "plan_execution_type", plan_execution_type)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_ended is not None:
            pulumi.set(__self__, "time_ended", time_ended)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compartment containing this DR plan execution.  Example: `ocid1.compartment.oc1..uniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the DR plan execution.  Example: `Execution - EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the DR protection group to which this DR plan execution belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @dr_protection_group_id.setter
    def dr_protection_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dr_protection_group_id", value)

    @_builtins.property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total duration in seconds taken to complete the step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @execution_duration_in_sec.setter
    def execution_duration_in_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "execution_duration_in_sec", value)

    @_builtins.property
    @pulumi.getter(name="executionOptions")
    def execution_options(self) -> Optional[pulumi.Input['DrPlanExecutionExecutionOptionsArgs']]:
        """
        The options for a plan execution.
        """
        return pulumi.get(self, "execution_options")

    @execution_options.setter
    def execution_options(self, value: Optional[pulumi.Input['DrPlanExecutionExecutionOptionsArgs']]):
        pulumi.set(self, "execution_options", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="groupExecutions")
    def group_executions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionArgs']]]]:
        """
        A list of groups executed in this DR plan execution.
        """
        return pulumi.get(self, "group_executions")

    @group_executions.setter
    def group_executions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionArgs']]]]):
        pulumi.set(self, "group_executions", value)

    @_builtins.property
    @pulumi.getter(name="lifeCycleDetails")
    def life_cycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the DR plan execution's current state in more detail.
        """
        return pulumi.get(self, "life_cycle_details")

    @life_cycle_details.setter
    def life_cycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "life_cycle_details", value)

    @_builtins.property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionLogLocationArgs']]]]:
        """
        The details of an object storage log location for a DR protection group.
        """
        return pulumi.get(self, "log_locations")

    @log_locations.setter
    def log_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionLogLocationArgs']]]]):
        pulumi.set(self, "log_locations", value)

    @_builtins.property
    @pulumi.getter(name="peerDrProtectionGroupId")
    def peer_dr_protection_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of peer DR protection group associated with this plan's DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "peer_dr_protection_group_id")

    @peer_dr_protection_group_id.setter
    def peer_dr_protection_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_dr_protection_group_id", value)

    @_builtins.property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the peer DR protection group associated with this plan's DR protection group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @peer_region.setter
    def peer_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_region", value)

    @_builtins.property
    @pulumi.getter(name="planExecutionType")
    def plan_execution_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the DR plan executed.
        """
        return pulumi.get(self, "plan_execution_type")

    @plan_execution_type.setter
    def plan_execution_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_execution_type", value)

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the DR plan.  Example: `ocid1.drplan.oc1..uniqueID` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the DR plan execution.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time at which DR plan execution was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time at which DR plan execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @time_ended.setter
    def time_ended(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_ended", value)

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time at which DR plan execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_started", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when DR plan execution was last updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DisasterRecovery/drPlanExecution:DrPlanExecution")
class DrPlanExecution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_options: Optional[pulumi.Input[Union['DrPlanExecutionExecutionOptionsArgs', 'DrPlanExecutionExecutionOptionsArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Dr Plan Execution resource in Oracle Cloud Infrastructure Disaster Recovery service.

        Execute a DR plan for a DR protection group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_dr_plan_execution = oci.disasterrecovery.DrPlanExecution("test_dr_plan_execution",
            execution_options={
                "plan_execution_type": dr_plan_execution_execution_options_plan_execution_type,
                "are_prechecks_enabled": dr_plan_execution_execution_options_are_prechecks_enabled,
                "are_warnings_ignored": dr_plan_execution_execution_options_are_warnings_ignored,
            },
            plan_id=test_plan["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=dr_plan_execution_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        DrPlanExecutions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DisasterRecovery/drPlanExecution:DrPlanExecution test_dr_plan_execution "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the DR plan execution.  Example: `Execution - EBS Switchover PHX to IAD`
        :param pulumi.Input[Union['DrPlanExecutionExecutionOptionsArgs', 'DrPlanExecutionExecutionOptionsArgsDict']] execution_options: The options for a plan execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] plan_id: The OCID of the DR plan.  Example: `ocid1.drplan.oc1..uniqueID` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DrPlanExecutionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Dr Plan Execution resource in Oracle Cloud Infrastructure Disaster Recovery service.

        Execute a DR plan for a DR protection group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_dr_plan_execution = oci.disasterrecovery.DrPlanExecution("test_dr_plan_execution",
            execution_options={
                "plan_execution_type": dr_plan_execution_execution_options_plan_execution_type,
                "are_prechecks_enabled": dr_plan_execution_execution_options_are_prechecks_enabled,
                "are_warnings_ignored": dr_plan_execution_execution_options_are_warnings_ignored,
            },
            plan_id=test_plan["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=dr_plan_execution_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        DrPlanExecutions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DisasterRecovery/drPlanExecution:DrPlanExecution test_dr_plan_execution "id"
        ```

        :param str resource_name: The name of the resource.
        :param DrPlanExecutionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DrPlanExecutionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_options: Optional[pulumi.Input[Union['DrPlanExecutionExecutionOptionsArgs', 'DrPlanExecutionExecutionOptionsArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DrPlanExecutionArgs.__new__(DrPlanExecutionArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if execution_options is None and not opts.urn:
                raise TypeError("Missing required property 'execution_options'")
            __props__.__dict__["execution_options"] = execution_options
            __props__.__dict__["freeform_tags"] = freeform_tags
            if plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'plan_id'")
            __props__.__dict__["plan_id"] = plan_id
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["dr_protection_group_id"] = None
            __props__.__dict__["execution_duration_in_sec"] = None
            __props__.__dict__["group_executions"] = None
            __props__.__dict__["life_cycle_details"] = None
            __props__.__dict__["log_locations"] = None
            __props__.__dict__["peer_dr_protection_group_id"] = None
            __props__.__dict__["peer_region"] = None
            __props__.__dict__["plan_execution_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_ended"] = None
            __props__.__dict__["time_started"] = None
            __props__.__dict__["time_updated"] = None
        super(DrPlanExecution, __self__).__init__(
            'oci:DisasterRecovery/drPlanExecution:DrPlanExecution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            dr_protection_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            execution_duration_in_sec: Optional[pulumi.Input[_builtins.int]] = None,
            execution_options: Optional[pulumi.Input[Union['DrPlanExecutionExecutionOptionsArgs', 'DrPlanExecutionExecutionOptionsArgsDict']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            group_executions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DrPlanExecutionGroupExecutionArgs', 'DrPlanExecutionGroupExecutionArgsDict']]]]] = None,
            life_cycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            log_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DrPlanExecutionLogLocationArgs', 'DrPlanExecutionLogLocationArgsDict']]]]] = None,
            peer_dr_protection_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            peer_region: Optional[pulumi.Input[_builtins.str]] = None,
            plan_execution_type: Optional[pulumi.Input[_builtins.str]] = None,
            plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_ended: Optional[pulumi.Input[_builtins.str]] = None,
            time_started: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'DrPlanExecution':
        """
        Get an existing DrPlanExecution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment containing this DR plan execution.  Example: `ocid1.compartment.oc1..uniqueID`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the DR plan execution.  Example: `Execution - EBS Switchover PHX to IAD`
        :param pulumi.Input[_builtins.str] dr_protection_group_id: The OCID of the DR protection group to which this DR plan execution belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        :param pulumi.Input[_builtins.int] execution_duration_in_sec: The total duration in seconds taken to complete the step execution.  Example: `35`
        :param pulumi.Input[Union['DrPlanExecutionExecutionOptionsArgs', 'DrPlanExecutionExecutionOptionsArgsDict']] execution_options: The options for a plan execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['DrPlanExecutionGroupExecutionArgs', 'DrPlanExecutionGroupExecutionArgsDict']]]] group_executions: A list of groups executed in this DR plan execution.
        :param pulumi.Input[_builtins.str] life_cycle_details: A message describing the DR plan execution's current state in more detail.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DrPlanExecutionLogLocationArgs', 'DrPlanExecutionLogLocationArgsDict']]]] log_locations: The details of an object storage log location for a DR protection group.
        :param pulumi.Input[_builtins.str] peer_dr_protection_group_id: The OCID of peer DR protection group associated with this plan's DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        :param pulumi.Input[_builtins.str] peer_region: The region of the peer DR protection group associated with this plan's DR protection group.  Example: `us-ashburn-1`
        :param pulumi.Input[_builtins.str] plan_execution_type: The type of the DR plan executed.
        :param pulumi.Input[_builtins.str] plan_id: The OCID of the DR plan.  Example: `ocid1.drplan.oc1..uniqueID` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of the DR plan execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time at which DR plan execution was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[_builtins.str] time_ended: The date and time at which DR plan execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[_builtins.str] time_started: The date and time at which DR plan execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[_builtins.str] time_updated: The time when DR plan execution was last updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DrPlanExecutionState.__new__(_DrPlanExecutionState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dr_protection_group_id"] = dr_protection_group_id
        __props__.__dict__["execution_duration_in_sec"] = execution_duration_in_sec
        __props__.__dict__["execution_options"] = execution_options
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["group_executions"] = group_executions
        __props__.__dict__["life_cycle_details"] = life_cycle_details
        __props__.__dict__["log_locations"] = log_locations
        __props__.__dict__["peer_dr_protection_group_id"] = peer_dr_protection_group_id
        __props__.__dict__["peer_region"] = peer_region
        __props__.__dict__["plan_execution_type"] = plan_execution_type
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_ended"] = time_ended
        __props__.__dict__["time_started"] = time_started
        __props__.__dict__["time_updated"] = time_updated
        return DrPlanExecution(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the compartment containing this DR plan execution.  Example: `ocid1.compartment.oc1..uniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The display name of the DR plan execution.  Example: `Execution - EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the DR protection group to which this DR plan execution belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @_builtins.property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> pulumi.Output[_builtins.int]:
        """
        The total duration in seconds taken to complete the step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @_builtins.property
    @pulumi.getter(name="executionOptions")
    def execution_options(self) -> pulumi.Output['outputs.DrPlanExecutionExecutionOptions']:
        """
        The options for a plan execution.
        """
        return pulumi.get(self, "execution_options")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="groupExecutions")
    def group_executions(self) -> pulumi.Output[Sequence['outputs.DrPlanExecutionGroupExecution']]:
        """
        A list of groups executed in this DR plan execution.
        """
        return pulumi.get(self, "group_executions")

    @_builtins.property
    @pulumi.getter(name="lifeCycleDetails")
    def life_cycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the DR plan execution's current state in more detail.
        """
        return pulumi.get(self, "life_cycle_details")

    @_builtins.property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> pulumi.Output[Sequence['outputs.DrPlanExecutionLogLocation']]:
        """
        The details of an object storage log location for a DR protection group.
        """
        return pulumi.get(self, "log_locations")

    @_builtins.property
    @pulumi.getter(name="peerDrProtectionGroupId")
    def peer_dr_protection_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of peer DR protection group associated with this plan's DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "peer_dr_protection_group_id")

    @_builtins.property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the peer DR protection group associated with this plan's DR protection group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @_builtins.property
    @pulumi.getter(name="planExecutionType")
    def plan_execution_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the DR plan executed.
        """
        return pulumi.get(self, "plan_execution_type")

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the DR plan.  Example: `ocid1.drplan.oc1..uniqueID` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "plan_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the DR plan execution.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time at which DR plan execution was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time at which DR plan execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time at which DR plan execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time when DR plan execution was last updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")

