# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDkimsDkimCollectionResult',
    'GetDkimsDkimCollectionItemResult',
    'GetDkimsFilterResult',
    'GetEmailDomainsEmailDomainCollectionResult',
    'GetEmailDomainsEmailDomainCollectionItemResult',
    'GetEmailDomainsFilterResult',
    'GetEmailReturnPathsEmailReturnPathCollectionResult',
    'GetEmailReturnPathsEmailReturnPathCollectionItemResult',
    'GetEmailReturnPathsFilterResult',
    'GetSendersFilterResult',
    'GetSendersSenderResult',
    'GetSuppressionsFilterResult',
    'GetSuppressionsSuppressionResult',
]

@pulumi.output_type
class GetDkimsDkimCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDkimsDkimCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDkimsDkimCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDkimsDkimCollectionItemResult(dict):
    def __init__(__self__, *,
                 cname_record_value: _builtins.str,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 dns_subdomain_name: _builtins.str,
                 email_domain_id: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_imported: _builtins.bool,
                 key_length: _builtins.int,
                 lifecycle_details: _builtins.str,
                 name: _builtins.str,
                 private_key: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 txt_record_value: _builtins.str):
        """
        :param _builtins.str cname_record_value: The DNS CNAME record value to provision to the DKIM DNS subdomain, when using the CNAME method for DKIM setup (preferred).
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains this DKIM.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: The description of the DKIM. Avoid entering confidential information.
        :param _builtins.str dns_subdomain_name: The name of the DNS subdomain that must be provisioned to enable email recipients to verify DKIM signatures. It is usually created with a CNAME record set to the cnameRecordValue.
        :param _builtins.str email_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the email domain to which this DKIM belongs.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: A filter to only return resources that match the given id exactly.
        :param _builtins.bool is_imported: Indicates whether the DKIM was imported.
        :param _builtins.int key_length: Length of the RSA key used in the DKIM.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource.
        :param _builtins.str name: A filter to only return resources that match the given name exactly.
        :param _builtins.str state: Filter returned list by specified lifecycle state. This parameter is case-insensitive.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The time the DKIM was created. Times are expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".  Example: `2021-02-12T22:47:12.613Z`
        :param _builtins.str time_updated: The time of the last change to the DKIM configuration, due to a state change or an update operation. Times are expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".
        :param _builtins.str txt_record_value: The DNS TXT record value to provision to the DKIM DNS subdomain in place of using a CNAME record. This is used in cases where a CNAME cannot be used, such as when the cnameRecordValue would exceed the maximum length for a DNS entry. You can also use this if you have an existing procedure to directly provision TXT records for DKIM. Many DNS APIs require you to break this string into segments of fewer than 255 characters.
        """
        pulumi.set(__self__, "cname_record_value", cname_record_value)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dns_subdomain_name", dns_subdomain_name)
        pulumi.set(__self__, "email_domain_id", email_domain_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_imported", is_imported)
        pulumi.set(__self__, "key_length", key_length)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "txt_record_value", txt_record_value)

    @_builtins.property
    @pulumi.getter(name="cnameRecordValue")
    def cname_record_value(self) -> _builtins.str:
        """
        The DNS CNAME record value to provision to the DKIM DNS subdomain, when using the CNAME method for DKIM setup (preferred).
        """
        return pulumi.get(self, "cname_record_value")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains this DKIM.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the DKIM. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsSubdomainName")
    def dns_subdomain_name(self) -> _builtins.str:
        """
        The name of the DNS subdomain that must be provisioned to enable email recipients to verify DKIM signatures. It is usually created with a CNAME record set to the cnameRecordValue.
        """
        return pulumi.get(self, "dns_subdomain_name")

    @_builtins.property
    @pulumi.getter(name="emailDomainId")
    def email_domain_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the email domain to which this DKIM belongs.
        """
        return pulumi.get(self, "email_domain_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A filter to only return resources that match the given id exactly.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isImported")
    def is_imported(self) -> _builtins.bool:
        """
        Indicates whether the DKIM was imported.
        """
        return pulumi.get(self, "is_imported")

    @_builtins.property
    @pulumi.getter(name="keyLength")
    def key_length(self) -> _builtins.int:
        """
        Length of the RSA key used in the DKIM.
        """
        return pulumi.get(self, "key_length")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to only return resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> _builtins.str:
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Filter returned list by specified lifecycle state. This parameter is case-insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the DKIM was created. Times are expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".  Example: `2021-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time of the last change to the DKIM configuration, due to a state change or an update operation. Times are expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="txtRecordValue")
    def txt_record_value(self) -> _builtins.str:
        """
        The DNS TXT record value to provision to the DKIM DNS subdomain in place of using a CNAME record. This is used in cases where a CNAME cannot be used, such as when the cnameRecordValue would exceed the maximum length for a DNS entry. You can also use this if you have an existing procedure to directly provision TXT records for DKIM. Many DNS APIs require you to break this string into segments of fewer than 255 characters.
        """
        return pulumi.get(self, "txt_record_value")


@pulumi.output_type
class GetDkimsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A filter to only return resources that match the given name exactly.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to only return resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetEmailDomainsEmailDomainCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetEmailDomainsEmailDomainCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetEmailDomainsEmailDomainCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetEmailDomainsEmailDomainCollectionItemResult(dict):
    def __init__(__self__, *,
                 active_dkim_id: _builtins.str,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 domain_verification_id: _builtins.str,
                 domain_verification_status: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_spf: _builtins.bool,
                 name: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str):
        """
        :param _builtins.str active_dkim_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DKIM key that will be used to sign mail sent from this email domain.
        :param _builtins.str compartment_id: The OCID for the compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: The description of an email domain.
        :param _builtins.str domain_verification_id: Id for Domain in Domain Management (under governance) if DOMAINID verification method used.
        :param _builtins.str domain_verification_status: The current domain verification status.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: A filter to only return resources that match the given id exactly.
        :param _builtins.bool is_spf: Value of the SPF field. For more information about SPF, please see [SPF Authentication](https://docs.cloud.oracle.com/iaas/Content/Email/Concepts/overview.htm#components).
        :param _builtins.str name: A filter to only return resources that match the given name exactly.
        :param _builtins.str state: Filter returned list by specified lifecycle state. This parameter is case-insensitive.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The time the email domain was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".  Example: `2021-02-12T22:47:12.613Z`
        """
        pulumi.set(__self__, "active_dkim_id", active_dkim_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "domain_verification_id", domain_verification_id)
        pulumi.set(__self__, "domain_verification_status", domain_verification_status)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_spf", is_spf)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="activeDkimId")
    def active_dkim_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DKIM key that will be used to sign mail sent from this email domain.
        """
        return pulumi.get(self, "active_dkim_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID for the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of an email domain.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainVerificationId")
    def domain_verification_id(self) -> _builtins.str:
        """
        Id for Domain in Domain Management (under governance) if DOMAINID verification method used.
        """
        return pulumi.get(self, "domain_verification_id")

    @_builtins.property
    @pulumi.getter(name="domainVerificationStatus")
    def domain_verification_status(self) -> _builtins.str:
        """
        The current domain verification status.
        """
        return pulumi.get(self, "domain_verification_status")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A filter to only return resources that match the given id exactly.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSpf")
    def is_spf(self) -> _builtins.bool:
        """
        Value of the SPF field. For more information about SPF, please see [SPF Authentication](https://docs.cloud.oracle.com/iaas/Content/Email/Concepts/overview.htm#components).
        """
        return pulumi.get(self, "is_spf")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to only return resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Filter returned list by specified lifecycle state. This parameter is case-insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the email domain was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".  Example: `2021-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetEmailDomainsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A filter to only return resources that match the given name exactly.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to only return resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetEmailReturnPathsEmailReturnPathCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetEmailReturnPathsEmailReturnPathCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetEmailReturnPathsEmailReturnPathCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetEmailReturnPathsEmailReturnPathCollectionItemResult(dict):
    def __init__(__self__, *,
                 cname_record_value: _builtins.str,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 dns_subdomain_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 name: _builtins.str,
                 parent_resource_id: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str cname_record_value: The DNS CNAME record value to provision to the Return Patn DNS subdomain, when using the CNAME method for Email Return Path setup (preferred).
        :param _builtins.str compartment_id: The OCID for the compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: The description of the email return path. Avoid entering confidential information.
        :param _builtins.str dns_subdomain_name: The name of the DNS subdomain that must be provisioned to enable email recipients to verify Email Return Path. It is usually created with a CNAME record set to the cnameRecordValue.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: A filter to only return resources that match the given id exactly.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        :param _builtins.str name: A filter to only return resources that match the given name exactly.
        :param _builtins.str parent_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Email Domain to which this Email Return Path belongs.
        :param _builtins.str state: Filter returned list by specified lifecycle state. This parameter is case-insensitive.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The time the email return path was created. Times are expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".  Example: `2021-02-12T22:47:12.613Z`
        :param _builtins.str time_updated: The time of the last change to the Email Return Path configuration, due to a state change or an update operation. Times are expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".
        """
        pulumi.set(__self__, "cname_record_value", cname_record_value)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dns_subdomain_name", dns_subdomain_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="cnameRecordValue")
    def cname_record_value(self) -> _builtins.str:
        """
        The DNS CNAME record value to provision to the Return Patn DNS subdomain, when using the CNAME method for Email Return Path setup (preferred).
        """
        return pulumi.get(self, "cname_record_value")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID for the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the email return path. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsSubdomainName")
    def dns_subdomain_name(self) -> _builtins.str:
        """
        The name of the DNS subdomain that must be provisioned to enable email recipients to verify Email Return Path. It is usually created with a CNAME record set to the cnameRecordValue.
        """
        return pulumi.get(self, "dns_subdomain_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A filter to only return resources that match the given id exactly.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to only return resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Email Domain to which this Email Return Path belongs.
        """
        return pulumi.get(self, "parent_resource_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Filter returned list by specified lifecycle state. This parameter is case-insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the email return path was created. Times are expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".  Example: `2021-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time of the last change to the Email Return Path configuration, due to a state change or an update operation. Times are expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, "YYYY-MM-ddThh:mmZ".
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetEmailReturnPathsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A filter to only return resources that match the given name exactly.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to only return resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSendersFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSendersSenderResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 email_address: _builtins.str,
                 email_domain_id: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_spf: _builtins.bool,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID for the compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str email_address: The email address of the approved sender.
        :param _builtins.str email_domain_id: The email domain used to assert responsibility for emails sent from this sender.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: The unique OCID of the sender.
        :param _builtins.bool is_spf: Value of the SPF field. For more information about SPF, please see [SPF Authentication](https://docs.cloud.oracle.com/iaas/Content/Email/Concepts/overview.htm#components).
        :param _builtins.str state: The current state of a sender.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The date and time the approved sender was added in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "email_domain_id", email_domain_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_spf", is_spf)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID for the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> _builtins.str:
        """
        The email address of the approved sender.
        """
        return pulumi.get(self, "email_address")

    @_builtins.property
    @pulumi.getter(name="emailDomainId")
    def email_domain_id(self) -> _builtins.str:
        """
        The email domain used to assert responsibility for emails sent from this sender.
        """
        return pulumi.get(self, "email_domain_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique OCID of the sender.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSpf")
    def is_spf(self) -> _builtins.bool:
        """
        Value of the SPF field. For more information about SPF, please see [SPF Authentication](https://docs.cloud.oracle.com/iaas/Content/Email/Concepts/overview.htm#components).
        """
        return pulumi.get(self, "is_spf")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of a sender.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the approved sender was added in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetSuppressionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSuppressionsSuppressionResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 email_address: _builtins.str,
                 error_detail: _builtins.str,
                 error_source: _builtins.str,
                 id: _builtins.str,
                 message_id: _builtins.str,
                 reason: _builtins.str,
                 time_created: _builtins.str,
                 time_last_suppressed: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID for the compartment.
        :param _builtins.str email_address: The email address of the suppression.
        :param _builtins.str error_detail: The specific error message returned by a system that resulted in the suppression. This message is usually an SMTP error code with additional descriptive text. Not provided for all types of suppressions.
        :param _builtins.str error_source: DNS name of the source of the error that caused the suppression. Will be set to either the remote-mta or reporting-mta field from a delivery status notification (RFC 3464) when available. Not provided for all types of suppressions, and not always known.
        :param _builtins.str id: The unique OCID of the suppression.
        :param _builtins.str message_id: The value of the Message-ID header from the email that triggered a suppression. This value is as defined in RFC 5322 section 3.6.4, excluding angle-brackets. Not provided for all types of suppressions.
        :param _builtins.str reason: The reason that the email address was suppressed. For more information on the types of bounces, see [Suppression List](https://docs.cloud.oracle.com/iaas/Content/Email/Concepts/overview.htm#components).
        :param _builtins.str time_created: The date and time a recipient's email address was added to the suppression list, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
        :param _builtins.str time_last_suppressed: The last date and time the suppression prevented submission in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "error_detail", error_detail)
        pulumi.set(__self__, "error_source", error_source)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "message_id", message_id)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_last_suppressed", time_last_suppressed)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID for the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> _builtins.str:
        """
        The email address of the suppression.
        """
        return pulumi.get(self, "email_address")

    @_builtins.property
    @pulumi.getter(name="errorDetail")
    def error_detail(self) -> _builtins.str:
        """
        The specific error message returned by a system that resulted in the suppression. This message is usually an SMTP error code with additional descriptive text. Not provided for all types of suppressions.
        """
        return pulumi.get(self, "error_detail")

    @_builtins.property
    @pulumi.getter(name="errorSource")
    def error_source(self) -> _builtins.str:
        """
        DNS name of the source of the error that caused the suppression. Will be set to either the remote-mta or reporting-mta field from a delivery status notification (RFC 3464) when available. Not provided for all types of suppressions, and not always known.
        """
        return pulumi.get(self, "error_source")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique OCID of the suppression.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="messageId")
    def message_id(self) -> _builtins.str:
        """
        The value of the Message-ID header from the email that triggered a suppression. This value is as defined in RFC 5322 section 3.6.4, excluding angle-brackets. Not provided for all types of suppressions.
        """
        return pulumi.get(self, "message_id")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        The reason that the email address was suppressed. For more information on the types of bounces, see [Suppression List](https://docs.cloud.oracle.com/iaas/Content/Email/Concepts/overview.htm#components).
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time a recipient's email address was added to the suppression list, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastSuppressed")
    def time_last_suppressed(self) -> _builtins.str:
        """
        The last date and time the suppression prevented submission in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_last_suppressed")


