# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFusionEnvironmentRefreshActivityResult',
    'AwaitableGetFusionEnvironmentRefreshActivityResult',
    'get_fusion_environment_refresh_activity',
    'get_fusion_environment_refresh_activity_output',
]

@pulumi.output_type
class GetFusionEnvironmentRefreshActivityResult:
    """
    A collection of values returned by getFusionEnvironmentRefreshActivity.
    """
    def __init__(__self__, display_name=None, fusion_environment_id=None, id=None, is_data_masking_opted=None, lifecycle_details=None, refresh_activity_id=None, refresh_issue_details_lists=None, service_availability=None, source_fusion_environment_id=None, state=None, time_accepted=None, time_expected_finish=None, time_finished=None, time_of_restoration_point=None, time_updated=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if fusion_environment_id and not isinstance(fusion_environment_id, str):
            raise TypeError("Expected argument 'fusion_environment_id' to be a str")
        pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_data_masking_opted and not isinstance(is_data_masking_opted, bool):
            raise TypeError("Expected argument 'is_data_masking_opted' to be a bool")
        pulumi.set(__self__, "is_data_masking_opted", is_data_masking_opted)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if refresh_activity_id and not isinstance(refresh_activity_id, str):
            raise TypeError("Expected argument 'refresh_activity_id' to be a str")
        pulumi.set(__self__, "refresh_activity_id", refresh_activity_id)
        if refresh_issue_details_lists and not isinstance(refresh_issue_details_lists, list):
            raise TypeError("Expected argument 'refresh_issue_details_lists' to be a list")
        pulumi.set(__self__, "refresh_issue_details_lists", refresh_issue_details_lists)
        if service_availability and not isinstance(service_availability, str):
            raise TypeError("Expected argument 'service_availability' to be a str")
        pulumi.set(__self__, "service_availability", service_availability)
        if source_fusion_environment_id and not isinstance(source_fusion_environment_id, str):
            raise TypeError("Expected argument 'source_fusion_environment_id' to be a str")
        pulumi.set(__self__, "source_fusion_environment_id", source_fusion_environment_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_accepted and not isinstance(time_accepted, str):
            raise TypeError("Expected argument 'time_accepted' to be a str")
        pulumi.set(__self__, "time_accepted", time_accepted)
        if time_expected_finish and not isinstance(time_expected_finish, str):
            raise TypeError("Expected argument 'time_expected_finish' to be a str")
        pulumi.set(__self__, "time_expected_finish", time_expected_finish)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_of_restoration_point and not isinstance(time_of_restoration_point, str):
            raise TypeError("Expected argument 'time_of_restoration_point' to be a str")
        pulumi.set(__self__, "time_of_restoration_point", time_of_restoration_point)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A friendly name for the refresh activity. Can be changed later.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> _builtins.str:
        return pulumi.get(self, "fusion_environment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier (OCID) of the refresh activity. Can't be changed after creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDataMaskingOpted")
    def is_data_masking_opted(self) -> _builtins.bool:
        """
        Represents if the customer opted for Data Masking or not during refreshActivity.
        """
        return pulumi.get(self, "is_data_masking_opted")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="refreshActivityId")
    def refresh_activity_id(self) -> _builtins.str:
        return pulumi.get(self, "refresh_activity_id")

    @_builtins.property
    @pulumi.getter(name="refreshIssueDetailsLists")
    def refresh_issue_details_lists(self) -> Sequence['outputs.GetFusionEnvironmentRefreshActivityRefreshIssueDetailsListResult']:
        """
        Details of refresh investigation information, each item represents a different issue.
        """
        return pulumi.get(self, "refresh_issue_details_lists")

    @_builtins.property
    @pulumi.getter(name="serviceAvailability")
    def service_availability(self) -> _builtins.str:
        """
        Service availability / impact during refresh activity execution up down
        """
        return pulumi.get(self, "service_availability")

    @_builtins.property
    @pulumi.getter(name="sourceFusionEnvironmentId")
    def source_fusion_environment_id(self) -> _builtins.str:
        """
        The OCID of the Fusion environment that is the source environment for the refresh.
        """
        return pulumi.get(self, "source_fusion_environment_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the refreshActivity.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> _builtins.str:
        """
        The time the refresh activity record was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_accepted")

    @_builtins.property
    @pulumi.getter(name="timeExpectedFinish")
    def time_expected_finish(self) -> _builtins.str:
        """
        The time the refresh activity is scheduled to end. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_expected_finish")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> _builtins.str:
        """
        The time the refresh activity actually completed / cancelled / failed. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeOfRestorationPoint")
    def time_of_restoration_point(self) -> _builtins.str:
        """
        The date and time of the most recent source environment backup used for the environment refresh.
        """
        return pulumi.get(self, "time_of_restoration_point")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the refresh activity record was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetFusionEnvironmentRefreshActivityResult(GetFusionEnvironmentRefreshActivityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFusionEnvironmentRefreshActivityResult(
            display_name=self.display_name,
            fusion_environment_id=self.fusion_environment_id,
            id=self.id,
            is_data_masking_opted=self.is_data_masking_opted,
            lifecycle_details=self.lifecycle_details,
            refresh_activity_id=self.refresh_activity_id,
            refresh_issue_details_lists=self.refresh_issue_details_lists,
            service_availability=self.service_availability,
            source_fusion_environment_id=self.source_fusion_environment_id,
            state=self.state,
            time_accepted=self.time_accepted,
            time_expected_finish=self.time_expected_finish,
            time_finished=self.time_finished,
            time_of_restoration_point=self.time_of_restoration_point,
            time_updated=self.time_updated)


def get_fusion_environment_refresh_activity(fusion_environment_id: Optional[_builtins.str] = None,
                                            refresh_activity_id: Optional[_builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFusionEnvironmentRefreshActivityResult:
    """
    This data source provides details about a specific Fusion Environment Refresh Activity resource in Oracle Cloud Infrastructure Fusion Apps service.

    Gets a RefreshActivity by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_refresh_activity = oci.Functions.get_fusion_environment_refresh_activity(fusion_environment_id=test_fusion_environment["id"],
        refresh_activity_id=test_refresh_activity["id"])
    ```


    :param _builtins.str fusion_environment_id: unique FusionEnvironment identifier
    :param _builtins.str refresh_activity_id: The unique identifier (OCID) of the Refresh activity.
    """
    __args__ = dict()
    __args__['fusionEnvironmentId'] = fusion_environment_id
    __args__['refreshActivityId'] = refresh_activity_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getFusionEnvironmentRefreshActivity:getFusionEnvironmentRefreshActivity', __args__, opts=opts, typ=GetFusionEnvironmentRefreshActivityResult).value

    return AwaitableGetFusionEnvironmentRefreshActivityResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        fusion_environment_id=pulumi.get(__ret__, 'fusion_environment_id'),
        id=pulumi.get(__ret__, 'id'),
        is_data_masking_opted=pulumi.get(__ret__, 'is_data_masking_opted'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        refresh_activity_id=pulumi.get(__ret__, 'refresh_activity_id'),
        refresh_issue_details_lists=pulumi.get(__ret__, 'refresh_issue_details_lists'),
        service_availability=pulumi.get(__ret__, 'service_availability'),
        source_fusion_environment_id=pulumi.get(__ret__, 'source_fusion_environment_id'),
        state=pulumi.get(__ret__, 'state'),
        time_accepted=pulumi.get(__ret__, 'time_accepted'),
        time_expected_finish=pulumi.get(__ret__, 'time_expected_finish'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_of_restoration_point=pulumi.get(__ret__, 'time_of_restoration_point'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_fusion_environment_refresh_activity_output(fusion_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                   refresh_activity_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFusionEnvironmentRefreshActivityResult]:
    """
    This data source provides details about a specific Fusion Environment Refresh Activity resource in Oracle Cloud Infrastructure Fusion Apps service.

    Gets a RefreshActivity by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_refresh_activity = oci.Functions.get_fusion_environment_refresh_activity(fusion_environment_id=test_fusion_environment["id"],
        refresh_activity_id=test_refresh_activity["id"])
    ```


    :param _builtins.str fusion_environment_id: unique FusionEnvironment identifier
    :param _builtins.str refresh_activity_id: The unique identifier (OCID) of the Refresh activity.
    """
    __args__ = dict()
    __args__['fusionEnvironmentId'] = fusion_environment_id
    __args__['refreshActivityId'] = refresh_activity_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Functions/getFusionEnvironmentRefreshActivity:getFusionEnvironmentRefreshActivity', __args__, opts=opts, typ=GetFusionEnvironmentRefreshActivityResult)
    return __ret__.apply(lambda __response__: GetFusionEnvironmentRefreshActivityResult(
        display_name=pulumi.get(__response__, 'display_name'),
        fusion_environment_id=pulumi.get(__response__, 'fusion_environment_id'),
        id=pulumi.get(__response__, 'id'),
        is_data_masking_opted=pulumi.get(__response__, 'is_data_masking_opted'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        refresh_activity_id=pulumi.get(__response__, 'refresh_activity_id'),
        refresh_issue_details_lists=pulumi.get(__response__, 'refresh_issue_details_lists'),
        service_availability=pulumi.get(__response__, 'service_availability'),
        source_fusion_environment_id=pulumi.get(__response__, 'source_fusion_environment_id'),
        state=pulumi.get(__response__, 'state'),
        time_accepted=pulumi.get(__response__, 'time_accepted'),
        time_expected_finish=pulumi.get(__response__, 'time_expected_finish'),
        time_finished=pulumi.get(__response__, 'time_finished'),
        time_of_restoration_point=pulumi.get(__response__, 'time_of_restoration_point'),
        time_updated=pulumi.get(__response__, 'time_updated')))
