# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFusionEnvironmentStatusResult',
    'AwaitableGetFusionEnvironmentStatusResult',
    'get_fusion_environment_status',
    'get_fusion_environment_status_output',
]

@pulumi.output_type
class GetFusionEnvironmentStatusResult:
    """
    A collection of values returned by getFusionEnvironmentStatus.
    """
    def __init__(__self__, fusion_environment_id=None, id=None, status=None):
        if fusion_environment_id and not isinstance(fusion_environment_id, str):
            raise TypeError("Expected argument 'fusion_environment_id' to be a str")
        pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> _builtins.str:
        return pulumi.get(self, "fusion_environment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The data plane status of FusionEnvironment.
        """
        return pulumi.get(self, "status")


class AwaitableGetFusionEnvironmentStatusResult(GetFusionEnvironmentStatusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFusionEnvironmentStatusResult(
            fusion_environment_id=self.fusion_environment_id,
            id=self.id,
            status=self.status)


def get_fusion_environment_status(fusion_environment_id: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFusionEnvironmentStatusResult:
    """
    This data source provides details about a specific Fusion Environment Status resource in Oracle Cloud Infrastructure Fusion Apps service.

    Gets the status of a Fusion environment identified by its OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_status = oci.Functions.get_fusion_environment_status(fusion_environment_id=test_fusion_environment["id"])
    ```


    :param _builtins.str fusion_environment_id: unique FusionEnvironment identifier
    """
    __args__ = dict()
    __args__['fusionEnvironmentId'] = fusion_environment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getFusionEnvironmentStatus:getFusionEnvironmentStatus', __args__, opts=opts, typ=GetFusionEnvironmentStatusResult).value

    return AwaitableGetFusionEnvironmentStatusResult(
        fusion_environment_id=pulumi.get(__ret__, 'fusion_environment_id'),
        id=pulumi.get(__ret__, 'id'),
        status=pulumi.get(__ret__, 'status'))
def get_fusion_environment_status_output(fusion_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFusionEnvironmentStatusResult]:
    """
    This data source provides details about a specific Fusion Environment Status resource in Oracle Cloud Infrastructure Fusion Apps service.

    Gets the status of a Fusion environment identified by its OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_status = oci.Functions.get_fusion_environment_status(fusion_environment_id=test_fusion_environment["id"])
    ```


    :param _builtins.str fusion_environment_id: unique FusionEnvironment identifier
    """
    __args__ = dict()
    __args__['fusionEnvironmentId'] = fusion_environment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Functions/getFusionEnvironmentStatus:getFusionEnvironmentStatus', __args__, opts=opts, typ=GetFusionEnvironmentStatusResult)
    return __ret__.apply(lambda __response__: GetFusionEnvironmentStatusResult(
        fusion_environment_id=pulumi.get(__response__, 'fusion_environment_id'),
        id=pulumi.get(__response__, 'id'),
        status=pulumi.get(__response__, 'status')))
