# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDomainResult',
    'AwaitableGetDomainResult',
    'get_domain',
    'get_domain_output',
]

@pulumi.output_type
class GetDomainResult:
    """
    A collection of values returned by getDomain.
    """
    def __init__(__self__, admin_email=None, admin_first_name=None, admin_last_name=None, admin_user_name=None, compartment_id=None, defined_tags=None, description=None, display_name=None, domain_id=None, freeform_tags=None, home_region=None, home_region_url=None, id=None, is_hidden_on_login=None, is_notification_bypassed=None, is_primary_email_required=None, license_type=None, lifecycle_details=None, replica_regions=None, state=None, time_created=None, type=None, url=None):
        if admin_email and not isinstance(admin_email, str):
            raise TypeError("Expected argument 'admin_email' to be a str")
        pulumi.set(__self__, "admin_email", admin_email)
        if admin_first_name and not isinstance(admin_first_name, str):
            raise TypeError("Expected argument 'admin_first_name' to be a str")
        pulumi.set(__self__, "admin_first_name", admin_first_name)
        if admin_last_name and not isinstance(admin_last_name, str):
            raise TypeError("Expected argument 'admin_last_name' to be a str")
        pulumi.set(__self__, "admin_last_name", admin_last_name)
        if admin_user_name and not isinstance(admin_user_name, str):
            raise TypeError("Expected argument 'admin_user_name' to be a str")
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if home_region and not isinstance(home_region, str):
            raise TypeError("Expected argument 'home_region' to be a str")
        pulumi.set(__self__, "home_region", home_region)
        if home_region_url and not isinstance(home_region_url, str):
            raise TypeError("Expected argument 'home_region_url' to be a str")
        pulumi.set(__self__, "home_region_url", home_region_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_hidden_on_login and not isinstance(is_hidden_on_login, bool):
            raise TypeError("Expected argument 'is_hidden_on_login' to be a bool")
        pulumi.set(__self__, "is_hidden_on_login", is_hidden_on_login)
        if is_notification_bypassed and not isinstance(is_notification_bypassed, bool):
            raise TypeError("Expected argument 'is_notification_bypassed' to be a bool")
        pulumi.set(__self__, "is_notification_bypassed", is_notification_bypassed)
        if is_primary_email_required and not isinstance(is_primary_email_required, bool):
            raise TypeError("Expected argument 'is_primary_email_required' to be a bool")
        pulumi.set(__self__, "is_primary_email_required", is_primary_email_required)
        if license_type and not isinstance(license_type, str):
            raise TypeError("Expected argument 'license_type' to be a str")
        pulumi.set(__self__, "license_type", license_type)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if replica_regions and not isinstance(replica_regions, list):
            raise TypeError("Expected argument 'replica_regions' to be a list")
        pulumi.set(__self__, "replica_regions", replica_regions)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="adminEmail")
    def admin_email(self) -> _builtins.str:
        return pulumi.get(self, "admin_email")

    @_builtins.property
    @pulumi.getter(name="adminFirstName")
    def admin_first_name(self) -> _builtins.str:
        return pulumi.get(self, "admin_first_name")

    @_builtins.property
    @pulumi.getter(name="adminLastName")
    def admin_last_name(self) -> _builtins.str:
        return pulumi.get(self, "admin_last_name")

    @_builtins.property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> _builtins.str:
        return pulumi.get(self, "admin_user_name")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment containing the domain.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The domain descripition
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The mutable display name of the domain
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> _builtins.str:
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> _builtins.str:
        """
        The home region for the domain. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1`
        """
        return pulumi.get(self, "home_region")

    @_builtins.property
    @pulumi.getter(name="homeRegionUrl")
    def home_region_url(self) -> _builtins.str:
        """
        Region specific domain URL.
        """
        return pulumi.get(self, "home_region_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the domain
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isHiddenOnLogin")
    def is_hidden_on_login(self) -> _builtins.bool:
        """
        Indicates whether domain is hidden on login screen or not.
        """
        return pulumi.get(self, "is_hidden_on_login")

    @_builtins.property
    @pulumi.getter(name="isNotificationBypassed")
    def is_notification_bypassed(self) -> _builtins.bool:
        return pulumi.get(self, "is_notification_bypassed")

    @_builtins.property
    @pulumi.getter(name="isPrimaryEmailRequired")
    def is_primary_email_required(self) -> _builtins.bool:
        return pulumi.get(self, "is_primary_email_required")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> _builtins.str:
        """
        The License type of Domain
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Any additional details about the current state of the Domain.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="replicaRegions")
    def replica_regions(self) -> Sequence['outputs.GetDomainReplicaRegionResult']:
        """
        The regions domain is replication to.
        """
        return pulumi.get(self, "replica_regions")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Date and time the domain was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the domain.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Region agnostic domain URL.
        """
        return pulumi.get(self, "url")


class AwaitableGetDomainResult(GetDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainResult(
            admin_email=self.admin_email,
            admin_first_name=self.admin_first_name,
            admin_last_name=self.admin_last_name,
            admin_user_name=self.admin_user_name,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            domain_id=self.domain_id,
            freeform_tags=self.freeform_tags,
            home_region=self.home_region,
            home_region_url=self.home_region_url,
            id=self.id,
            is_hidden_on_login=self.is_hidden_on_login,
            is_notification_bypassed=self.is_notification_bypassed,
            is_primary_email_required=self.is_primary_email_required,
            license_type=self.license_type,
            lifecycle_details=self.lifecycle_details,
            replica_regions=self.replica_regions,
            state=self.state,
            time_created=self.time_created,
            type=self.type,
            url=self.url)


def get_domain(domain_id: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainResult:
    """
    This data source provides details about a specific Domain resource in Oracle Cloud Infrastructure Identity service.

    Get the specified domain's information.

    - If the domain doesn't exists, returns 404 NOT FOUND.
    - If any internal error occurs, returns 500 INTERNAL SERVER ERROR.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_domain = oci.Identity.get_domain(domain_id=test_domain_oci_identity_domain["id"])
    ```


    :param _builtins.str domain_id: The OCID of the domain
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getDomain:getDomain', __args__, opts=opts, typ=GetDomainResult).value

    return AwaitableGetDomainResult(
        admin_email=pulumi.get(__ret__, 'admin_email'),
        admin_first_name=pulumi.get(__ret__, 'admin_first_name'),
        admin_last_name=pulumi.get(__ret__, 'admin_last_name'),
        admin_user_name=pulumi.get(__ret__, 'admin_user_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        home_region=pulumi.get(__ret__, 'home_region'),
        home_region_url=pulumi.get(__ret__, 'home_region_url'),
        id=pulumi.get(__ret__, 'id'),
        is_hidden_on_login=pulumi.get(__ret__, 'is_hidden_on_login'),
        is_notification_bypassed=pulumi.get(__ret__, 'is_notification_bypassed'),
        is_primary_email_required=pulumi.get(__ret__, 'is_primary_email_required'),
        license_type=pulumi.get(__ret__, 'license_type'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        replica_regions=pulumi.get(__ret__, 'replica_regions'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        type=pulumi.get(__ret__, 'type'),
        url=pulumi.get(__ret__, 'url'))
def get_domain_output(domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainResult]:
    """
    This data source provides details about a specific Domain resource in Oracle Cloud Infrastructure Identity service.

    Get the specified domain's information.

    - If the domain doesn't exists, returns 404 NOT FOUND.
    - If any internal error occurs, returns 500 INTERNAL SERVER ERROR.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_domain = oci.Identity.get_domain(domain_id=test_domain_oci_identity_domain["id"])
    ```


    :param _builtins.str domain_id: The OCID of the domain
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getDomain:getDomain', __args__, opts=opts, typ=GetDomainResult)
    return __ret__.apply(lambda __response__: GetDomainResult(
        admin_email=pulumi.get(__response__, 'admin_email'),
        admin_first_name=pulumi.get(__response__, 'admin_first_name'),
        admin_last_name=pulumi.get(__response__, 'admin_last_name'),
        admin_user_name=pulumi.get(__response__, 'admin_user_name'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        home_region=pulumi.get(__response__, 'home_region'),
        home_region_url=pulumi.get(__response__, 'home_region_url'),
        id=pulumi.get(__response__, 'id'),
        is_hidden_on_login=pulumi.get(__response__, 'is_hidden_on_login'),
        is_notification_bypassed=pulumi.get(__response__, 'is_notification_bypassed'),
        is_primary_email_required=pulumi.get(__response__, 'is_primary_email_required'),
        license_type=pulumi.get(__response__, 'license_type'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        replica_regions=pulumi.get(__response__, 'replica_regions'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        type=pulumi.get(__response__, 'type'),
        url=pulumi.get(__response__, 'url')))
