# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTagResult',
    'AwaitableGetTagResult',
    'get_tag',
    'get_tag_output',
]

@pulumi.output_type
class GetTagResult:
    """
    A collection of values returned by getTag.
    """
    def __init__(__self__, defined_tags=None, description=None, freeform_tags=None, id=None, is_cost_tracking=None, is_retired=None, name=None, state=None, tag_name=None, tag_namespace_id=None, time_created=None, validators=None):
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_cost_tracking and not isinstance(is_cost_tracking, bool):
            raise TypeError("Expected argument 'is_cost_tracking' to be a bool")
        pulumi.set(__self__, "is_cost_tracking", is_cost_tracking)
        if is_retired and not isinstance(is_retired, bool):
            raise TypeError("Expected argument 'is_retired' to be a bool")
        pulumi.set(__self__, "is_retired", is_retired)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tag_name and not isinstance(tag_name, str):
            raise TypeError("Expected argument 'tag_name' to be a str")
        pulumi.set(__self__, "tag_name", tag_name)
        if tag_namespace_id and not isinstance(tag_namespace_id, str):
            raise TypeError("Expected argument 'tag_namespace_id' to be a str")
        pulumi.set(__self__, "tag_namespace_id", tag_namespace_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if validators and not isinstance(validators, list):
            raise TypeError("Expected argument 'validators' to be a list")
        pulumi.set(__self__, "validators", validators)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description you assign to the tag.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the tag definition.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCostTracking")
    def is_cost_tracking(self) -> _builtins.bool:
        """
        Indicates whether the tag is enabled for cost tracking.
        """
        return pulumi.get(self, "is_cost_tracking")

    @_builtins.property
    @pulumi.getter(name="isRetired")
    def is_retired(self) -> _builtins.bool:
        """
        Indicates whether the tag is retired. See [Retiring Key Definitions and Namespace Definitions](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/taggingoverview.htm#Retiring).
        """
        return pulumi.get(self, "is_retired")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name assigned to the tag during creation. This is the tag key definition. The name must be unique within the tag namespace and cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The tag's current state. After creating a tag, make sure its `lifecycleState` is ACTIVE before using it. After retiring a tag, make sure its `lifecycleState` is INACTIVE before using it. If you delete a tag, you cannot delete another tag until the deleted tag's `lifecycleState` changes from DELETING to DELETED.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> _builtins.str:
        return pulumi.get(self, "tag_name")

    @_builtins.property
    @pulumi.getter(name="tagNamespaceId")
    def tag_namespace_id(self) -> _builtins.str:
        """
        The OCID of the namespace that contains the tag definition.
        """
        return pulumi.get(self, "tag_namespace_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Date and time the tag was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def validators(self) -> Sequence['outputs.GetTagValidatorResult']:
        """
        Validates a definedTag value. Each validator performs validation steps in addition to the standard validation for definedTag values. For more information, see [Limits on Tags](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/taggingoverview.htm#Limits).
        """
        return pulumi.get(self, "validators")


class AwaitableGetTagResult(GetTagResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagResult(
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_cost_tracking=self.is_cost_tracking,
            is_retired=self.is_retired,
            name=self.name,
            state=self.state,
            tag_name=self.tag_name,
            tag_namespace_id=self.tag_namespace_id,
            time_created=self.time_created,
            validators=self.validators)


def get_tag(tag_name: Optional[_builtins.str] = None,
            tag_namespace_id: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagResult:
    """
    This data source provides details about a specific Tag resource in Oracle Cloud Infrastructure Identity service.

    Gets the specified tag's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tag = oci.Identity.get_tag(tag_name=test_tag_oci_identity_tag["name"],
        tag_namespace_id=test_tag_namespace["id"])
    ```


    :param _builtins.str tag_name: The name of the tag.
    :param _builtins.str tag_namespace_id: The OCID of the tag namespace.
    """
    __args__ = dict()
    __args__['tagName'] = tag_name
    __args__['tagNamespaceId'] = tag_namespace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getTag:getTag', __args__, opts=opts, typ=GetTagResult).value

    return AwaitableGetTagResult(
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_cost_tracking=pulumi.get(__ret__, 'is_cost_tracking'),
        is_retired=pulumi.get(__ret__, 'is_retired'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        tag_name=pulumi.get(__ret__, 'tag_name'),
        tag_namespace_id=pulumi.get(__ret__, 'tag_namespace_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        validators=pulumi.get(__ret__, 'validators'))
def get_tag_output(tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                   tag_namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTagResult]:
    """
    This data source provides details about a specific Tag resource in Oracle Cloud Infrastructure Identity service.

    Gets the specified tag's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tag = oci.Identity.get_tag(tag_name=test_tag_oci_identity_tag["name"],
        tag_namespace_id=test_tag_namespace["id"])
    ```


    :param _builtins.str tag_name: The name of the tag.
    :param _builtins.str tag_namespace_id: The OCID of the tag namespace.
    """
    __args__ = dict()
    __args__['tagName'] = tag_name
    __args__['tagNamespaceId'] = tag_namespace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getTag:getTag', __args__, opts=opts, typ=GetTagResult)
    return __ret__.apply(lambda __response__: GetTagResult(
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_cost_tracking=pulumi.get(__response__, 'is_cost_tracking'),
        is_retired=pulumi.get(__response__, 'is_retired'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        tag_name=pulumi.get(__response__, 'tag_name'),
        tag_namespace_id=pulumi.get(__response__, 'tag_namespace_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        validators=pulumi.get(__response__, 'validators')))
