# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetJmsPluginsResult',
    'AwaitableGetJmsPluginsResult',
    'get_jms_plugins',
    'get_jms_plugins_output',
]

@pulumi.output_type
class GetJmsPluginsResult:
    """
    A collection of values returned by getJmsPlugins.
    """
    def __init__(__self__, agent_id=None, agent_type=None, availability_status=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, fleet_id=None, hostname_contains=None, id=None, jms_plugin_collections=None, state=None, time_last_seen_less_than_or_equal_to=None, time_registered_less_than_or_equal_to=None):
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if agent_type and not isinstance(agent_type, str):
            raise TypeError("Expected argument 'agent_type' to be a str")
        pulumi.set(__self__, "agent_type", agent_type)
        if availability_status and not isinstance(availability_status, str):
            raise TypeError("Expected argument 'availability_status' to be a str")
        pulumi.set(__self__, "availability_status", availability_status)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if hostname_contains and not isinstance(hostname_contains, str):
            raise TypeError("Expected argument 'hostname_contains' to be a str")
        pulumi.set(__self__, "hostname_contains", hostname_contains)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if jms_plugin_collections and not isinstance(jms_plugin_collections, list):
            raise TypeError("Expected argument 'jms_plugin_collections' to be a list")
        pulumi.set(__self__, "jms_plugin_collections", jms_plugin_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_last_seen_less_than_or_equal_to and not isinstance(time_last_seen_less_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_last_seen_less_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_last_seen_less_than_or_equal_to", time_last_seen_less_than_or_equal_to)
        if time_registered_less_than_or_equal_to and not isinstance(time_registered_less_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_registered_less_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_registered_less_than_or_equal_to", time_registered_less_than_or_equal_to)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent (OMA) or the Oracle Cloud Agent (OCA) instance where the JMS plugin is deployed.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="agentType")
    def agent_type(self) -> Optional[_builtins.str]:
        """
        The agent type.
        """
        return pulumi.get(self, "agent_type")

    @_builtins.property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> Optional[_builtins.str]:
        """
        The availability status.
        """
        return pulumi.get(self, "availability_status")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The OMA/OCA agent's compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetJmsPluginsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the fleet.
        """
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter(name="hostnameContains")
    def hostname_contains(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "hostname_contains")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to identify this JmsPlugin.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jmsPluginCollections")
    def jms_plugin_collections(self) -> Sequence['outputs.GetJmsPluginsJmsPluginCollectionResult']:
        """
        The list of jms_plugin_collection.
        """
        return pulumi.get(self, "jms_plugin_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeLastSeenLessThanOrEqualTo")
    def time_last_seen_less_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_last_seen_less_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="timeRegisteredLessThanOrEqualTo")
    def time_registered_less_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_registered_less_than_or_equal_to")


class AwaitableGetJmsPluginsResult(GetJmsPluginsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJmsPluginsResult(
            agent_id=self.agent_id,
            agent_type=self.agent_type,
            availability_status=self.availability_status,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            fleet_id=self.fleet_id,
            hostname_contains=self.hostname_contains,
            id=self.id,
            jms_plugin_collections=self.jms_plugin_collections,
            state=self.state,
            time_last_seen_less_than_or_equal_to=self.time_last_seen_less_than_or_equal_to,
            time_registered_less_than_or_equal_to=self.time_registered_less_than_or_equal_to)


def get_jms_plugins(agent_id: Optional[_builtins.str] = None,
                    agent_type: Optional[_builtins.str] = None,
                    availability_status: Optional[_builtins.str] = None,
                    compartment_id: Optional[_builtins.str] = None,
                    compartment_id_in_subtree: Optional[_builtins.bool] = None,
                    filters: Optional[Sequence[Union['GetJmsPluginsFilterArgs', 'GetJmsPluginsFilterArgsDict']]] = None,
                    fleet_id: Optional[_builtins.str] = None,
                    hostname_contains: Optional[_builtins.str] = None,
                    id: Optional[_builtins.str] = None,
                    state: Optional[_builtins.str] = None,
                    time_last_seen_less_than_or_equal_to: Optional[_builtins.str] = None,
                    time_registered_less_than_or_equal_to: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJmsPluginsResult:
    """
    This data source provides the list of Jms Plugins in Oracle Cloud Infrastructure Jms service.

    Lists the JmsPlugins.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_jms_plugins = oci.Jms.get_jms_plugins(agent_id=jms_plugin_agent_id,
        agent_type=jms_plugin_agent_type,
        availability_status=jms_plugin_availability_status,
        compartment_id=compartment_id,
        compartment_id_in_subtree=jms_plugin_compartment_id_in_subtree,
        fleet_id=test_fleet["id"],
        hostname_contains=jms_plugin_hostname_contains,
        id=jms_plugin_id,
        state=jms_plugin_state,
        time_last_seen_less_than_or_equal_to=jms_plugin_time_last_seen_less_than_or_equal_to,
        time_registered_less_than_or_equal_to=jms_plugin_time_registered_less_than_or_equal_to)
    ```


    :param _builtins.str agent_id: The ManagementAgent (OMA) or Instance (OCA) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that identifies the Agent.
    :param _builtins.str agent_type: Filter JmsPlugin with agent type.
    :param _builtins.str availability_status: Filter JmsPlugin with its availability status.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.bool compartment_id_in_subtree: Flag to determine whether the info should be gathered only in the compartment or in the compartment and its subcompartments.
    :param _builtins.str fleet_id: The ID of the Fleet.
    :param _builtins.str hostname_contains: Filter the list with hostname contains the given value.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the JmsPlugin.
    :param _builtins.str state: Filter JmsPlugin with its lifecycle state.
    :param _builtins.str time_last_seen_less_than_or_equal_to: If present, only plugins with a last seen time before this parameter are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param _builtins.str time_registered_less_than_or_equal_to: If present, only plugins with a registration time before this parameter are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['agentType'] = agent_type
    __args__['availabilityStatus'] = availability_status
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['hostnameContains'] = hostname_contains
    __args__['id'] = id
    __args__['state'] = state
    __args__['timeLastSeenLessThanOrEqualTo'] = time_last_seen_less_than_or_equal_to
    __args__['timeRegisteredLessThanOrEqualTo'] = time_registered_less_than_or_equal_to
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getJmsPlugins:getJmsPlugins', __args__, opts=opts, typ=GetJmsPluginsResult).value

    return AwaitableGetJmsPluginsResult(
        agent_id=pulumi.get(__ret__, 'agent_id'),
        agent_type=pulumi.get(__ret__, 'agent_type'),
        availability_status=pulumi.get(__ret__, 'availability_status'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        hostname_contains=pulumi.get(__ret__, 'hostname_contains'),
        id=pulumi.get(__ret__, 'id'),
        jms_plugin_collections=pulumi.get(__ret__, 'jms_plugin_collections'),
        state=pulumi.get(__ret__, 'state'),
        time_last_seen_less_than_or_equal_to=pulumi.get(__ret__, 'time_last_seen_less_than_or_equal_to'),
        time_registered_less_than_or_equal_to=pulumi.get(__ret__, 'time_registered_less_than_or_equal_to'))
def get_jms_plugins_output(agent_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           agent_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           availability_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetJmsPluginsFilterArgs', 'GetJmsPluginsFilterArgsDict']]]]] = None,
                           fleet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           hostname_contains: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           time_last_seen_less_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           time_registered_less_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJmsPluginsResult]:
    """
    This data source provides the list of Jms Plugins in Oracle Cloud Infrastructure Jms service.

    Lists the JmsPlugins.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_jms_plugins = oci.Jms.get_jms_plugins(agent_id=jms_plugin_agent_id,
        agent_type=jms_plugin_agent_type,
        availability_status=jms_plugin_availability_status,
        compartment_id=compartment_id,
        compartment_id_in_subtree=jms_plugin_compartment_id_in_subtree,
        fleet_id=test_fleet["id"],
        hostname_contains=jms_plugin_hostname_contains,
        id=jms_plugin_id,
        state=jms_plugin_state,
        time_last_seen_less_than_or_equal_to=jms_plugin_time_last_seen_less_than_or_equal_to,
        time_registered_less_than_or_equal_to=jms_plugin_time_registered_less_than_or_equal_to)
    ```


    :param _builtins.str agent_id: The ManagementAgent (OMA) or Instance (OCA) [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that identifies the Agent.
    :param _builtins.str agent_type: Filter JmsPlugin with agent type.
    :param _builtins.str availability_status: Filter JmsPlugin with its availability status.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.bool compartment_id_in_subtree: Flag to determine whether the info should be gathered only in the compartment or in the compartment and its subcompartments.
    :param _builtins.str fleet_id: The ID of the Fleet.
    :param _builtins.str hostname_contains: Filter the list with hostname contains the given value.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the JmsPlugin.
    :param _builtins.str state: Filter JmsPlugin with its lifecycle state.
    :param _builtins.str time_last_seen_less_than_or_equal_to: If present, only plugins with a last seen time before this parameter are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param _builtins.str time_registered_less_than_or_equal_to: If present, only plugins with a registration time before this parameter are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['agentType'] = agent_type
    __args__['availabilityStatus'] = availability_status
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['hostnameContains'] = hostname_contains
    __args__['id'] = id
    __args__['state'] = state
    __args__['timeLastSeenLessThanOrEqualTo'] = time_last_seen_less_than_or_equal_to
    __args__['timeRegisteredLessThanOrEqualTo'] = time_registered_less_than_or_equal_to
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getJmsPlugins:getJmsPlugins', __args__, opts=opts, typ=GetJmsPluginsResult)
    return __ret__.apply(lambda __response__: GetJmsPluginsResult(
        agent_id=pulumi.get(__response__, 'agent_id'),
        agent_type=pulumi.get(__response__, 'agent_type'),
        availability_status=pulumi.get(__response__, 'availability_status'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        hostname_contains=pulumi.get(__response__, 'hostname_contains'),
        id=pulumi.get(__response__, 'id'),
        jms_plugin_collections=pulumi.get(__response__, 'jms_plugin_collections'),
        state=pulumi.get(__response__, 'state'),
        time_last_seen_less_than_or_equal_to=pulumi.get(__response__, 'time_last_seen_less_than_or_equal_to'),
        time_registered_less_than_or_equal_to=pulumi.get(__response__, 'time_registered_less_than_or_equal_to')))
