# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GeneratedKeyArgs', 'GeneratedKey']

@pulumi.input_type
class GeneratedKeyArgs:
    def __init__(__self__, *,
                 crypto_endpoint: pulumi.Input[_builtins.str],
                 include_plaintext_key: pulumi.Input[_builtins.bool],
                 key_id: pulumi.Input[_builtins.str],
                 key_shape: pulumi.Input['GeneratedKeyKeyShapeArgs'],
                 associated_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a GeneratedKey resource.
        :param pulumi.Input[_builtins.str] crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,' and 'GenerateDataEncryptionKey' operations. see Vault Crypto endpoint.
        :param pulumi.Input[_builtins.bool] include_plaintext_key: If true, the generated key is also returned unencrypted.
        :param pulumi.Input[_builtins.str] key_id: The OCID of the master encryption key to encrypt the generated data encryption key with.
        :param pulumi.Input['GeneratedKeyKeyShapeArgs'] key_shape: The cryptographic properties of a key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] associated_data: Information that can be used to provide an encryption context for the encrypted data. The length of the string representation of the associated data must be fewer than 4096 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] logging_context: Information that provides context for audit logging. You can provide this additional data by formatting it as key-value pairs to include in audit logs when audit logging is enabled. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "crypto_endpoint", crypto_endpoint)
        pulumi.set(__self__, "include_plaintext_key", include_plaintext_key)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_shape", key_shape)
        if associated_data is not None:
            pulumi.set(__self__, "associated_data", associated_data)
        if logging_context is not None:
            pulumi.set(__self__, "logging_context", logging_context)

    @_builtins.property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,' and 'GenerateDataEncryptionKey' operations. see Vault Crypto endpoint.
        """
        return pulumi.get(self, "crypto_endpoint")

    @crypto_endpoint.setter
    def crypto_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "crypto_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="includePlaintextKey")
    def include_plaintext_key(self) -> pulumi.Input[_builtins.bool]:
        """
        If true, the generated key is also returned unencrypted.
        """
        return pulumi.get(self, "include_plaintext_key")

    @include_plaintext_key.setter
    def include_plaintext_key(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "include_plaintext_key", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the master encryption key to encrypt the generated data encryption key with.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="keyShape")
    def key_shape(self) -> pulumi.Input['GeneratedKeyKeyShapeArgs']:
        """
        The cryptographic properties of a key.
        """
        return pulumi.get(self, "key_shape")

    @key_shape.setter
    def key_shape(self, value: pulumi.Input['GeneratedKeyKeyShapeArgs']):
        pulumi.set(self, "key_shape", value)

    @_builtins.property
    @pulumi.getter(name="associatedData")
    def associated_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Information that can be used to provide an encryption context for the encrypted data. The length of the string representation of the associated data must be fewer than 4096 characters.
        """
        return pulumi.get(self, "associated_data")

    @associated_data.setter
    def associated_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "associated_data", value)

    @_builtins.property
    @pulumi.getter(name="loggingContext")
    def logging_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Information that provides context for audit logging. You can provide this additional data by formatting it as key-value pairs to include in audit logs when audit logging is enabled. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "logging_context")

    @logging_context.setter
    def logging_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "logging_context", value)


@pulumi.input_type
class _GeneratedKeyState:
    def __init__(__self__, *,
                 associated_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ciphertext: Optional[pulumi.Input[_builtins.str]] = None,
                 crypto_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 include_plaintext_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_shape: Optional[pulumi.Input['GeneratedKeyKeyShapeArgs']] = None,
                 logging_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plaintext: Optional[pulumi.Input[_builtins.str]] = None,
                 plaintext_checksum: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GeneratedKey resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] associated_data: Information that can be used to provide an encryption context for the encrypted data. The length of the string representation of the associated data must be fewer than 4096 characters.
        :param pulumi.Input[_builtins.str] ciphertext: The encrypted data encryption key generated from a master encryption key.
        :param pulumi.Input[_builtins.str] crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,' and 'GenerateDataEncryptionKey' operations. see Vault Crypto endpoint.
        :param pulumi.Input[_builtins.bool] include_plaintext_key: If true, the generated key is also returned unencrypted.
        :param pulumi.Input[_builtins.str] key_id: The OCID of the master encryption key to encrypt the generated data encryption key with.
        :param pulumi.Input['GeneratedKeyKeyShapeArgs'] key_shape: The cryptographic properties of a key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] logging_context: Information that provides context for audit logging. You can provide this additional data by formatting it as key-value pairs to include in audit logs when audit logging is enabled. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] plaintext: The plaintext data encryption key, a base64-encoded sequence of random bytes, which is included if the [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) request includes the `includePlaintextKey` parameter and sets its value to "true".
        :param pulumi.Input[_builtins.str] plaintext_checksum: The checksum of the plaintext data encryption key, which is included if the [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) request includes the `includePlaintextKey` parameter and sets its value to "true".
        """
        if associated_data is not None:
            pulumi.set(__self__, "associated_data", associated_data)
        if ciphertext is not None:
            pulumi.set(__self__, "ciphertext", ciphertext)
        if crypto_endpoint is not None:
            pulumi.set(__self__, "crypto_endpoint", crypto_endpoint)
        if include_plaintext_key is not None:
            pulumi.set(__self__, "include_plaintext_key", include_plaintext_key)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_shape is not None:
            pulumi.set(__self__, "key_shape", key_shape)
        if logging_context is not None:
            pulumi.set(__self__, "logging_context", logging_context)
        if plaintext is not None:
            pulumi.set(__self__, "plaintext", plaintext)
        if plaintext_checksum is not None:
            pulumi.set(__self__, "plaintext_checksum", plaintext_checksum)

    @_builtins.property
    @pulumi.getter(name="associatedData")
    def associated_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Information that can be used to provide an encryption context for the encrypted data. The length of the string representation of the associated data must be fewer than 4096 characters.
        """
        return pulumi.get(self, "associated_data")

    @associated_data.setter
    def associated_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "associated_data", value)

    @_builtins.property
    @pulumi.getter
    def ciphertext(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encrypted data encryption key generated from a master encryption key.
        """
        return pulumi.get(self, "ciphertext")

    @ciphertext.setter
    def ciphertext(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ciphertext", value)

    @_builtins.property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,' and 'GenerateDataEncryptionKey' operations. see Vault Crypto endpoint.
        """
        return pulumi.get(self, "crypto_endpoint")

    @crypto_endpoint.setter
    def crypto_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "crypto_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="includePlaintextKey")
    def include_plaintext_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the generated key is also returned unencrypted.
        """
        return pulumi.get(self, "include_plaintext_key")

    @include_plaintext_key.setter
    def include_plaintext_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_plaintext_key", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the master encryption key to encrypt the generated data encryption key with.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="keyShape")
    def key_shape(self) -> Optional[pulumi.Input['GeneratedKeyKeyShapeArgs']]:
        """
        The cryptographic properties of a key.
        """
        return pulumi.get(self, "key_shape")

    @key_shape.setter
    def key_shape(self, value: Optional[pulumi.Input['GeneratedKeyKeyShapeArgs']]):
        pulumi.set(self, "key_shape", value)

    @_builtins.property
    @pulumi.getter(name="loggingContext")
    def logging_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Information that provides context for audit logging. You can provide this additional data by formatting it as key-value pairs to include in audit logs when audit logging is enabled. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "logging_context")

    @logging_context.setter
    def logging_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "logging_context", value)

    @_builtins.property
    @pulumi.getter
    def plaintext(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The plaintext data encryption key, a base64-encoded sequence of random bytes, which is included if the [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) request includes the `includePlaintextKey` parameter and sets its value to "true".
        """
        return pulumi.get(self, "plaintext")

    @plaintext.setter
    def plaintext(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plaintext", value)

    @_builtins.property
    @pulumi.getter(name="plaintextChecksum")
    def plaintext_checksum(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The checksum of the plaintext data encryption key, which is included if the [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) request includes the `includePlaintextKey` parameter and sets its value to "true".
        """
        return pulumi.get(self, "plaintext_checksum")

    @plaintext_checksum.setter
    def plaintext_checksum(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plaintext_checksum", value)


@pulumi.type_token("oci:Kms/generatedKey:GeneratedKey")
class GeneratedKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 crypto_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 include_plaintext_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_shape: Optional[pulumi.Input[Union['GeneratedKeyKeyShapeArgs', 'GeneratedKeyKeyShapeArgsDict']]] = None,
                 logging_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Generated Key resource in Oracle Cloud Infrastructure Kms service.

        Generates a key that you can use to encrypt or decrypt data.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_generated_key = oci.kms.GeneratedKey("test_generated_key",
            crypto_endpoint=generated_key_crypto_endpoint,
            include_plaintext_key=generated_key_include_plaintext_key,
            key_id=test_key["id"],
            key_shape={
                "algorithm": generated_key_key_shape_algorithm,
                "length": generated_key_key_shape_length,
                "curve_id": test_curve["id"],
            },
            associated_data=generated_key_associated_data,
            logging_context=generated_key_logging_context)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] associated_data: Information that can be used to provide an encryption context for the encrypted data. The length of the string representation of the associated data must be fewer than 4096 characters.
        :param pulumi.Input[_builtins.str] crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,' and 'GenerateDataEncryptionKey' operations. see Vault Crypto endpoint.
        :param pulumi.Input[_builtins.bool] include_plaintext_key: If true, the generated key is also returned unencrypted.
        :param pulumi.Input[_builtins.str] key_id: The OCID of the master encryption key to encrypt the generated data encryption key with.
        :param pulumi.Input[Union['GeneratedKeyKeyShapeArgs', 'GeneratedKeyKeyShapeArgsDict']] key_shape: The cryptographic properties of a key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] logging_context: Information that provides context for audit logging. You can provide this additional data by formatting it as key-value pairs to include in audit logs when audit logging is enabled. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GeneratedKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Generated Key resource in Oracle Cloud Infrastructure Kms service.

        Generates a key that you can use to encrypt or decrypt data.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_generated_key = oci.kms.GeneratedKey("test_generated_key",
            crypto_endpoint=generated_key_crypto_endpoint,
            include_plaintext_key=generated_key_include_plaintext_key,
            key_id=test_key["id"],
            key_shape={
                "algorithm": generated_key_key_shape_algorithm,
                "length": generated_key_key_shape_length,
                "curve_id": test_curve["id"],
            },
            associated_data=generated_key_associated_data,
            logging_context=generated_key_logging_context)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param GeneratedKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GeneratedKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 crypto_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 include_plaintext_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_shape: Optional[pulumi.Input[Union['GeneratedKeyKeyShapeArgs', 'GeneratedKeyKeyShapeArgsDict']]] = None,
                 logging_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GeneratedKeyArgs.__new__(GeneratedKeyArgs)

            __props__.__dict__["associated_data"] = associated_data
            if crypto_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'crypto_endpoint'")
            __props__.__dict__["crypto_endpoint"] = crypto_endpoint
            if include_plaintext_key is None and not opts.urn:
                raise TypeError("Missing required property 'include_plaintext_key'")
            __props__.__dict__["include_plaintext_key"] = include_plaintext_key
            if key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_id'")
            __props__.__dict__["key_id"] = key_id
            if key_shape is None and not opts.urn:
                raise TypeError("Missing required property 'key_shape'")
            __props__.__dict__["key_shape"] = key_shape
            __props__.__dict__["logging_context"] = logging_context
            __props__.__dict__["ciphertext"] = None
            __props__.__dict__["plaintext"] = None
            __props__.__dict__["plaintext_checksum"] = None
        super(GeneratedKey, __self__).__init__(
            'oci:Kms/generatedKey:GeneratedKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ciphertext: Optional[pulumi.Input[_builtins.str]] = None,
            crypto_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            include_plaintext_key: Optional[pulumi.Input[_builtins.bool]] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_shape: Optional[pulumi.Input[Union['GeneratedKeyKeyShapeArgs', 'GeneratedKeyKeyShapeArgsDict']]] = None,
            logging_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            plaintext: Optional[pulumi.Input[_builtins.str]] = None,
            plaintext_checksum: Optional[pulumi.Input[_builtins.str]] = None) -> 'GeneratedKey':
        """
        Get an existing GeneratedKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] associated_data: Information that can be used to provide an encryption context for the encrypted data. The length of the string representation of the associated data must be fewer than 4096 characters.
        :param pulumi.Input[_builtins.str] ciphertext: The encrypted data encryption key generated from a master encryption key.
        :param pulumi.Input[_builtins.str] crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,' and 'GenerateDataEncryptionKey' operations. see Vault Crypto endpoint.
        :param pulumi.Input[_builtins.bool] include_plaintext_key: If true, the generated key is also returned unencrypted.
        :param pulumi.Input[_builtins.str] key_id: The OCID of the master encryption key to encrypt the generated data encryption key with.
        :param pulumi.Input[Union['GeneratedKeyKeyShapeArgs', 'GeneratedKeyKeyShapeArgsDict']] key_shape: The cryptographic properties of a key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] logging_context: Information that provides context for audit logging. You can provide this additional data by formatting it as key-value pairs to include in audit logs when audit logging is enabled. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] plaintext: The plaintext data encryption key, a base64-encoded sequence of random bytes, which is included if the [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) request includes the `includePlaintextKey` parameter and sets its value to "true".
        :param pulumi.Input[_builtins.str] plaintext_checksum: The checksum of the plaintext data encryption key, which is included if the [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) request includes the `includePlaintextKey` parameter and sets its value to "true".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GeneratedKeyState.__new__(_GeneratedKeyState)

        __props__.__dict__["associated_data"] = associated_data
        __props__.__dict__["ciphertext"] = ciphertext
        __props__.__dict__["crypto_endpoint"] = crypto_endpoint
        __props__.__dict__["include_plaintext_key"] = include_plaintext_key
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["key_shape"] = key_shape
        __props__.__dict__["logging_context"] = logging_context
        __props__.__dict__["plaintext"] = plaintext
        __props__.__dict__["plaintext_checksum"] = plaintext_checksum
        return GeneratedKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="associatedData")
    def associated_data(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Information that can be used to provide an encryption context for the encrypted data. The length of the string representation of the associated data must be fewer than 4096 characters.
        """
        return pulumi.get(self, "associated_data")

    @_builtins.property
    @pulumi.getter
    def ciphertext(self) -> pulumi.Output[_builtins.str]:
        """
        The encrypted data encryption key generated from a master encryption key.
        """
        return pulumi.get(self, "ciphertext")

    @_builtins.property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The service endpoint to perform cryptographic operations against. Cryptographic operations include 'Encrypt,' 'Decrypt,' and 'GenerateDataEncryptionKey' operations. see Vault Crypto endpoint.
        """
        return pulumi.get(self, "crypto_endpoint")

    @_builtins.property
    @pulumi.getter(name="includePlaintextKey")
    def include_plaintext_key(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, the generated key is also returned unencrypted.
        """
        return pulumi.get(self, "include_plaintext_key")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the master encryption key to encrypt the generated data encryption key with.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyShape")
    def key_shape(self) -> pulumi.Output['outputs.GeneratedKeyKeyShape']:
        """
        The cryptographic properties of a key.
        """
        return pulumi.get(self, "key_shape")

    @_builtins.property
    @pulumi.getter(name="loggingContext")
    def logging_context(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Information that provides context for audit logging. You can provide this additional data by formatting it as key-value pairs to include in audit logs when audit logging is enabled. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "logging_context")

    @_builtins.property
    @pulumi.getter
    def plaintext(self) -> pulumi.Output[_builtins.str]:
        """
        The plaintext data encryption key, a base64-encoded sequence of random bytes, which is included if the [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) request includes the `includePlaintextKey` parameter and sets its value to "true".
        """
        return pulumi.get(self, "plaintext")

    @_builtins.property
    @pulumi.getter(name="plaintextChecksum")
    def plaintext_checksum(self) -> pulumi.Output[_builtins.str]:
        """
        The checksum of the plaintext data encryption key, which is included if the [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) request includes the `includePlaintextKey` parameter and sets its value to "true".
        """
        return pulumi.get(self, "plaintext_checksum")

