# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLogAnalyticsResourceCategoriesListResult',
    'AwaitableGetLogAnalyticsResourceCategoriesListResult',
    'get_log_analytics_resource_categories_list',
    'get_log_analytics_resource_categories_list_output',
]

@pulumi.output_type
class GetLogAnalyticsResourceCategoriesListResult:
    """
    A collection of values returned by getLogAnalyticsResourceCategoriesList.
    """
    def __init__(__self__, categories=None, compartment_id=None, id=None, items=None, namespace=None, resource_categories=None, resource_ids=None, resource_types=None):
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if resource_categories and not isinstance(resource_categories, str):
            raise TypeError("Expected argument 'resource_categories' to be a str")
        pulumi.set(__self__, "resource_categories", resource_categories)
        if resource_ids and not isinstance(resource_ids, str):
            raise TypeError("Expected argument 'resource_ids' to be a str")
        pulumi.set(__self__, "resource_ids", resource_ids)
        if resource_types and not isinstance(resource_types, str):
            raise TypeError("Expected argument 'resource_types' to be a str")
        pulumi.set(__self__, "resource_types", resource_types)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetLogAnalyticsResourceCategoriesListCategoryResult']:
        """
        An array of categories. The array contents include detailed information about the distinct set of categories assigned to all the listed resources under items.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The compartment ID of the resource, if applicable.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetLogAnalyticsResourceCategoriesListItemResult']:
        """
        A list of resources and their category assignments
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="resourceCategories")
    def resource_categories(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_categories")

    @_builtins.property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_ids")

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_types")


class AwaitableGetLogAnalyticsResourceCategoriesListResult(GetLogAnalyticsResourceCategoriesListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsResourceCategoriesListResult(
            categories=self.categories,
            compartment_id=self.compartment_id,
            id=self.id,
            items=self.items,
            namespace=self.namespace,
            resource_categories=self.resource_categories,
            resource_ids=self.resource_ids,
            resource_types=self.resource_types)


def get_log_analytics_resource_categories_list(compartment_id: Optional[_builtins.str] = None,
                                               namespace: Optional[_builtins.str] = None,
                                               resource_categories: Optional[_builtins.str] = None,
                                               resource_ids: Optional[_builtins.str] = None,
                                               resource_types: Optional[_builtins.str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsResourceCategoriesListResult:
    """
    This data source provides details about Resource Categories in Oracle Cloud Infrastructure Log Analytics service.

    Returns a list of resources and their category assignments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_resource_categories_list = oci.LogAnalytics.get_log_analytics_resource_categories_list(namespace=log_analytics_resource_categories_list_namespace,
        compartment_id=log_analytics_resource_categories_compartment_id,
        resource_ids=log_analytics_resource_categories_list_resource_ids,
        resource_types=log_analytics_resource_categories_list_resource_types,
        resource_categories=log_analytics_resource_categories_list_resource_categories)
    ```


    :param _builtins.str compartment_id: The compartment id in which to list resources.
    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    :param _builtins.str resource_categories: A comma-separated list of category names used for filtering
    :param _builtins.str resource_ids: A comma-separated list of resource unique identifiers used for filtering. Only resources with matching unique identifiers will be returned.
    :param _builtins.str resource_types: A comma-separated list of resource types used for filtering. Only resources of the types specified will be returned. Examples include SOURCE, PARSER, LOOKUP, etc.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['namespace'] = namespace
    __args__['resourceCategories'] = resource_categories
    __args__['resourceIds'] = resource_ids
    __args__['resourceTypes'] = resource_types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsResourceCategoriesList:getLogAnalyticsResourceCategoriesList', __args__, opts=opts, typ=GetLogAnalyticsResourceCategoriesListResult).value

    return AwaitableGetLogAnalyticsResourceCategoriesListResult(
        categories=pulumi.get(__ret__, 'categories'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        namespace=pulumi.get(__ret__, 'namespace'),
        resource_categories=pulumi.get(__ret__, 'resource_categories'),
        resource_ids=pulumi.get(__ret__, 'resource_ids'),
        resource_types=pulumi.get(__ret__, 'resource_types'))
def get_log_analytics_resource_categories_list_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                      namespace: Optional[pulumi.Input[_builtins.str]] = None,
                                                      resource_categories: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                      resource_ids: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                      resource_types: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogAnalyticsResourceCategoriesListResult]:
    """
    This data source provides details about Resource Categories in Oracle Cloud Infrastructure Log Analytics service.

    Returns a list of resources and their category assignments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_resource_categories_list = oci.LogAnalytics.get_log_analytics_resource_categories_list(namespace=log_analytics_resource_categories_list_namespace,
        compartment_id=log_analytics_resource_categories_compartment_id,
        resource_ids=log_analytics_resource_categories_list_resource_ids,
        resource_types=log_analytics_resource_categories_list_resource_types,
        resource_categories=log_analytics_resource_categories_list_resource_categories)
    ```


    :param _builtins.str compartment_id: The compartment id in which to list resources.
    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    :param _builtins.str resource_categories: A comma-separated list of category names used for filtering
    :param _builtins.str resource_ids: A comma-separated list of resource unique identifiers used for filtering. Only resources with matching unique identifiers will be returned.
    :param _builtins.str resource_types: A comma-separated list of resource types used for filtering. Only resources of the types specified will be returned. Examples include SOURCE, PARSER, LOOKUP, etc.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['namespace'] = namespace
    __args__['resourceCategories'] = resource_categories
    __args__['resourceIds'] = resource_ids
    __args__['resourceTypes'] = resource_types
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getLogAnalyticsResourceCategoriesList:getLogAnalyticsResourceCategoriesList', __args__, opts=opts, typ=GetLogAnalyticsResourceCategoriesListResult)
    return __ret__.apply(lambda __response__: GetLogAnalyticsResourceCategoriesListResult(
        categories=pulumi.get(__response__, 'categories'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        namespace=pulumi.get(__response__, 'namespace'),
        resource_categories=pulumi.get(__response__, 'resource_categories'),
        resource_ids=pulumi.get(__response__, 'resource_ids'),
        resource_types=pulumi.get(__response__, 'resource_types')))
