# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LogAnalyticsUnprocessedDataBucketManagementArgs', 'LogAnalyticsUnprocessedDataBucketManagement']

@pulumi.input_type
class LogAnalyticsUnprocessedDataBucketManagementArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a LogAnalyticsUnprocessedDataBucketManagement resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the Object Storage bucket.
        :param pulumi.Input[_builtins.str] namespace: The Logging Analytics namespace used for the request. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] is_enabled: Flag that specifies if this configuration is enabled or not.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Object Storage bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The Logging Analytics namespace used for the request. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that specifies if this configuration is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)


@pulumi.input_type
class _LogAnalyticsUnprocessedDataBucketManagementState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogAnalyticsUnprocessedDataBucketManagement resources.
        :param pulumi.Input[_builtins.str] bucket: Name of the Object Storage bucket.
        :param pulumi.Input[_builtins.bool] is_enabled: Flag that specifies if this configuration is enabled or not.
        :param pulumi.Input[_builtins.str] namespace: The Logging Analytics namespace used for the request. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The time when this record is created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The latest time when this record is updated. An RFC3339 formatted datetime string.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Object Storage bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that specifies if this configuration is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Logging Analytics namespace used for the request. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when this record is created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest time when this record is updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:LogAnalytics/logAnalyticsUnprocessedDataBucketManagement:LogAnalyticsUnprocessedDataBucketManagement")
class LogAnalyticsUnprocessedDataBucketManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Log Analytics Unprocessed Data Bucket Management resource in Oracle Cloud Infrastructure Log Analytics service.

        This API configures a bucket to store unprocessed payloads.
        While processing there could be reasons a payload cannot be processed (mismatched structure, corrupted archive format, etc),
        if configured the payload would be uploaded to the bucket for verification.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log_analytics_unprocessed_data_bucket_management = oci.loganalytics.LogAnalyticsUnprocessedDataBucketManagement("test_log_analytics_unprocessed_data_bucket_management",
            bucket=log_analytics_unprocessed_data_bucket_management_bucket,
            namespace=log_analytics_unprocessed_data_bucket_management_namespace)
        ```

        ## Import

        Import is not supported for LogAnalyticsUnprocessedDataBucketManagement

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the Object Storage bucket.
        :param pulumi.Input[_builtins.bool] is_enabled: Flag that specifies if this configuration is enabled or not.
        :param pulumi.Input[_builtins.str] namespace: The Logging Analytics namespace used for the request. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogAnalyticsUnprocessedDataBucketManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Log Analytics Unprocessed Data Bucket Management resource in Oracle Cloud Infrastructure Log Analytics service.

        This API configures a bucket to store unprocessed payloads.
        While processing there could be reasons a payload cannot be processed (mismatched structure, corrupted archive format, etc),
        if configured the payload would be uploaded to the bucket for verification.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log_analytics_unprocessed_data_bucket_management = oci.loganalytics.LogAnalyticsUnprocessedDataBucketManagement("test_log_analytics_unprocessed_data_bucket_management",
            bucket=log_analytics_unprocessed_data_bucket_management_bucket,
            namespace=log_analytics_unprocessed_data_bucket_management_namespace)
        ```

        ## Import

        Import is not supported for LogAnalyticsUnprocessedDataBucketManagement

        :param str resource_name: The name of the resource.
        :param LogAnalyticsUnprocessedDataBucketManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogAnalyticsUnprocessedDataBucketManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogAnalyticsUnprocessedDataBucketManagementArgs.__new__(LogAnalyticsUnprocessedDataBucketManagementArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["is_enabled"] = is_enabled
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(LogAnalyticsUnprocessedDataBucketManagement, __self__).__init__(
            'oci:LogAnalytics/logAnalyticsUnprocessedDataBucketManagement:LogAnalyticsUnprocessedDataBucketManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'LogAnalyticsUnprocessedDataBucketManagement':
        """
        Get an existing LogAnalyticsUnprocessedDataBucketManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the Object Storage bucket.
        :param pulumi.Input[_builtins.bool] is_enabled: Flag that specifies if this configuration is enabled or not.
        :param pulumi.Input[_builtins.str] namespace: The Logging Analytics namespace used for the request. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The time when this record is created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The latest time when this record is updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogAnalyticsUnprocessedDataBucketManagementState.__new__(_LogAnalyticsUnprocessedDataBucketManagementState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return LogAnalyticsUnprocessedDataBucketManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Object Storage bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag that specifies if this configuration is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The Logging Analytics namespace used for the request. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time when this record is created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The latest time when this record is updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

