# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMetricDataResult',
    'AwaitableGetMetricDataResult',
    'get_metric_data',
    'get_metric_data_output',
]

@pulumi.output_type
class GetMetricDataResult:
    """
    A collection of values returned by getMetricData.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, end_time=None, filters=None, id=None, metric_datas=None, namespace=None, query=None, resolution=None, resource_group=None, start_time=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metric_datas and not isinstance(metric_datas, list):
            raise TypeError("Expected argument 'metric_datas' to be a list")
        pulumi.set(__self__, "metric_datas", metric_datas)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if query and not isinstance(query, str):
            raise TypeError("Expected argument 'query' to be a str")
        pulumi.set(__self__, "query", query)
        if resolution and not isinstance(resolution, str):
            raise TypeError("Expected argument 'resolution' to be a str")
        pulumi.set(__self__, "resolution", resolution)
        if resource_group and not isinstance(resource_group, str):
            raise TypeError("Expected argument 'resource_group' to be a str")
        pulumi.set(__self__, "resource_group", resource_group)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources that the aggregated data was returned from.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMetricDataFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="metricDatas")
    def metric_datas(self) -> Sequence['outputs.GetMetricDataMetricDataResult']:
        """
        The list of metric_data.
        """
        return pulumi.get(self, "metric_datas")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The reference provided in a metric definition to indicate the source service or application that emitted the metric.  Example: `oci_computeagent`
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter
    def resolution(self) -> Optional[_builtins.str]:
        """
        The time between calculated aggregation windows. Use with the query interval to vary the frequency for returning aggregated data points. For example, use a query interval of 5 minutes with a resolution of 1 minute to retrieve five-minute aggregations at a one-minute frequency. The resolution must be equal or less than the interval in the query. The default resolution is 1m (one minute). Supported values: `1m`-`60m`, `1h`-`24h`, `1d`.  Example: `5m`
        """
        return pulumi.get(self, "resolution")

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[_builtins.str]:
        """
        Resource group provided with the posted metric. A resource group is a custom string that you can match when retrieving custom metrics. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($).  Example: `frontend-fleet`
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "start_time")


class AwaitableGetMetricDataResult(GetMetricDataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetricDataResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            end_time=self.end_time,
            filters=self.filters,
            id=self.id,
            metric_datas=self.metric_datas,
            namespace=self.namespace,
            query=self.query,
            resolution=self.resolution,
            resource_group=self.resource_group,
            start_time=self.start_time)


def get_metric_data(compartment_id: Optional[_builtins.str] = None,
                    compartment_id_in_subtree: Optional[_builtins.bool] = None,
                    end_time: Optional[_builtins.str] = None,
                    filters: Optional[Sequence[Union['GetMetricDataFilterArgs', 'GetMetricDataFilterArgsDict']]] = None,
                    namespace: Optional[_builtins.str] = None,
                    query: Optional[_builtins.str] = None,
                    resolution: Optional[_builtins.str] = None,
                    resource_group: Optional[_builtins.str] = None,
                    start_time: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetricDataResult:
    """
    This data source provides the list of Metric Data in Oracle Cloud Infrastructure Monitoring service.

    Returns aggregated data that match the criteria specified in the request. Compartment OCID required.
    For more information, see
    [Querying Metric Data](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-landing.htm)
    and
    [Creating a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric.htm).
    For important limits information, see
    [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

    Transactions Per Second (TPS) per-tenancy limit for this operation: 10.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_metric_data = oci.Monitoring.get_metric_data(compartment_id=compartment_id,
        namespace=metric_data_namespace,
        query=metric_data_query,
        compartment_id_in_subtree=metric_data_compartment_id_in_subtree,
        end_time=metric_data_end_time,
        resolution=metric_data_resolution,
        resource_group=metric_data_resource_group,
        start_time=metric_data_start_time)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.  Example: `ocid1.compartment.oc1..exampleuniqueID`
    :param _builtins.bool compartment_id_in_subtree: When true, returns resources from all compartments and subcompartments. The parameter can only be set to true when compartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, returns resources from only the compartment specified in compartmentId. Default is false.
    :param _builtins.str end_time: The end of the time range to use when searching for metric data points. Format is defined by RFC3339. The response excludes metric data points for the endTime. Default value: the timestamp representing when the call was sent.  Example: `2023-02-01T02:02:29.600Z`
    :param _builtins.str namespace: The source service or application to use when searching for metric data points to aggregate.  Example: `oci_computeagent`
    :param _builtins.str query: The Monitoring Query Language (MQL) expression to use when searching for metric data points to aggregate. The query must specify a metric, statistic, and interval. Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. When specifying a dimension value, surround it with double quotes, and escape each double quote with a backslash (`\\`) character. Supported grouping functions: `grouping()`, `groupBy()`.
           
           Construct your query to avoid exceeding limits on returned data. See [MetricData Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/20180401/MetricData).
           
           For details about Monitoring Query Language (MQL), see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
           
           Example 1: `CpuUtilization[1m].sum()`
           
           Example 2 (escaped double quotes for value string): `CpuUtilization[1m]{resourceId = \\"<var>&lt;instance_OCID&gt;</var>\\"}.max()`
    :param _builtins.str resolution: The time between calculated aggregation windows. Use with the query interval to vary the frequency for returning aggregated data points. For example, use a query interval of 5 minutes with a resolution of 1 minute to retrieve five-minute aggregations at a one-minute frequency. The resolution must be equal or less than the interval in the query. The default resolution is 1m (one minute). Supported values: `1m`-`60m`, `1h`-`24h`, `1d`.  Example: `5m`
    :param _builtins.str resource_group: Resource group that you want to match. A null value returns only metric data that has no resource groups. The specified resource group must exist in the definition of the posted metric. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($).  Example: `frontend-fleet`
    :param _builtins.str start_time: The beginning of the time range to use when searching for metric data points. Format is defined by RFC3339. The response includes metric data points for the startTime. Default value: the timestamp 3 hours before the call was sent.  Example: `2023-02-01T01:02:29.600Z`
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['endTime'] = end_time
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    __args__['query'] = query
    __args__['resolution'] = resolution
    __args__['resourceGroup'] = resource_group
    __args__['startTime'] = start_time
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Monitoring/getMetricData:getMetricData', __args__, opts=opts, typ=GetMetricDataResult).value

    return AwaitableGetMetricDataResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        end_time=pulumi.get(__ret__, 'end_time'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        metric_datas=pulumi.get(__ret__, 'metric_datas'),
        namespace=pulumi.get(__ret__, 'namespace'),
        query=pulumi.get(__ret__, 'query'),
        resolution=pulumi.get(__ret__, 'resolution'),
        resource_group=pulumi.get(__ret__, 'resource_group'),
        start_time=pulumi.get(__ret__, 'start_time'))
def get_metric_data_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                           compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                           end_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMetricDataFilterArgs', 'GetMetricDataFilterArgsDict']]]]] = None,
                           namespace: Optional[pulumi.Input[_builtins.str]] = None,
                           query: Optional[pulumi.Input[_builtins.str]] = None,
                           resolution: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           resource_group: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           start_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMetricDataResult]:
    """
    This data source provides the list of Metric Data in Oracle Cloud Infrastructure Monitoring service.

    Returns aggregated data that match the criteria specified in the request. Compartment OCID required.
    For more information, see
    [Querying Metric Data](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-landing.htm)
    and
    [Creating a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric.htm).
    For important limits information, see
    [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

    Transactions Per Second (TPS) per-tenancy limit for this operation: 10.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_metric_data = oci.Monitoring.get_metric_data(compartment_id=compartment_id,
        namespace=metric_data_namespace,
        query=metric_data_query,
        compartment_id_in_subtree=metric_data_compartment_id_in_subtree,
        end_time=metric_data_end_time,
        resolution=metric_data_resolution,
        resource_group=metric_data_resource_group,
        start_time=metric_data_start_time)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.  Example: `ocid1.compartment.oc1..exampleuniqueID`
    :param _builtins.bool compartment_id_in_subtree: When true, returns resources from all compartments and subcompartments. The parameter can only be set to true when compartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, returns resources from only the compartment specified in compartmentId. Default is false.
    :param _builtins.str end_time: The end of the time range to use when searching for metric data points. Format is defined by RFC3339. The response excludes metric data points for the endTime. Default value: the timestamp representing when the call was sent.  Example: `2023-02-01T02:02:29.600Z`
    :param _builtins.str namespace: The source service or application to use when searching for metric data points to aggregate.  Example: `oci_computeagent`
    :param _builtins.str query: The Monitoring Query Language (MQL) expression to use when searching for metric data points to aggregate. The query must specify a metric, statistic, and interval. Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. When specifying a dimension value, surround it with double quotes, and escape each double quote with a backslash (`\\`) character. Supported grouping functions: `grouping()`, `groupBy()`.
           
           Construct your query to avoid exceeding limits on returned data. See [MetricData Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/20180401/MetricData).
           
           For details about Monitoring Query Language (MQL), see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
           
           Example 1: `CpuUtilization[1m].sum()`
           
           Example 2 (escaped double quotes for value string): `CpuUtilization[1m]{resourceId = \\"<var>&lt;instance_OCID&gt;</var>\\"}.max()`
    :param _builtins.str resolution: The time between calculated aggregation windows. Use with the query interval to vary the frequency for returning aggregated data points. For example, use a query interval of 5 minutes with a resolution of 1 minute to retrieve five-minute aggregations at a one-minute frequency. The resolution must be equal or less than the interval in the query. The default resolution is 1m (one minute). Supported values: `1m`-`60m`, `1h`-`24h`, `1d`.  Example: `5m`
    :param _builtins.str resource_group: Resource group that you want to match. A null value returns only metric data that has no resource groups. The specified resource group must exist in the definition of the posted metric. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($).  Example: `frontend-fleet`
    :param _builtins.str start_time: The beginning of the time range to use when searching for metric data points. Format is defined by RFC3339. The response includes metric data points for the startTime. Default value: the timestamp 3 hours before the call was sent.  Example: `2023-02-01T01:02:29.600Z`
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['endTime'] = end_time
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    __args__['query'] = query
    __args__['resolution'] = resolution
    __args__['resourceGroup'] = resource_group
    __args__['startTime'] = start_time
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Monitoring/getMetricData:getMetricData', __args__, opts=opts, typ=GetMetricDataResult)
    return __ret__.apply(lambda __response__: GetMetricDataResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        end_time=pulumi.get(__response__, 'end_time'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        metric_datas=pulumi.get(__response__, 'metric_datas'),
        namespace=pulumi.get(__response__, 'namespace'),
        query=pulumi.get(__response__, 'query'),
        resolution=pulumi.get(__response__, 'resolution'),
        resource_group=pulumi.get(__response__, 'resource_group'),
        start_time=pulumi.get(__response__, 'start_time')))
