# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetShapesResult',
    'AwaitableGetShapesResult',
    'get_shapes',
    'get_shapes_output',
]

@pulumi.output_type
class GetShapesResult:
    """
    A collection of values returned by getShapes.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, filters=None, id=None, is_supported_fors=None, name=None, shapes=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_supported_fors and not isinstance(is_supported_fors, list):
            raise TypeError("Expected argument 'is_supported_fors' to be a list")
        pulumi.set(__self__, "is_supported_fors", is_supported_fors)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if shapes and not isinstance(shapes, list):
            raise TypeError("Expected argument 'shapes' to be a list")
        pulumi.set(__self__, "shapes", shapes)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetShapesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSupportedFors")
    def is_supported_fors(self) -> Optional[Sequence[_builtins.str]]:
        """
        What service features the shape is supported for.
        """
        return pulumi.get(self, "is_supported_fors")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the shape used for the DB System.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def shapes(self) -> Sequence['outputs.GetShapesShapeResult']:
        """
        The list of shapes.
        """
        return pulumi.get(self, "shapes")


class AwaitableGetShapesResult(GetShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetShapesResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            is_supported_fors=self.is_supported_fors,
            name=self.name,
            shapes=self.shapes)


def get_shapes(availability_domain: Optional[_builtins.str] = None,
               compartment_id: Optional[_builtins.str] = None,
               filters: Optional[Sequence[Union['GetShapesFilterArgs', 'GetShapesFilterArgsDict']]] = None,
               is_supported_fors: Optional[Sequence[_builtins.str]] = None,
               name: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetShapesResult:
    """
    This data source provides the list of Shapes in Oracle Cloud Infrastructure MySQL Database service.

    Gets a list of the shapes you can use to create a new MySQL DB System.
    The shape determines the resources allocated to the DB System:
    CPU cores and memory for VM shapes; CPU cores, memory and
    storage for non-VM (or bare metal) shapes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_shapes = oci.Mysql.get_shapes(compartment_id=compartment_id,
        availability_domain=shape_availability_domain,
        is_supported_fors=shape_is_supported_for,
        name=shape_name)
    ```


    :param _builtins.str availability_domain: The name of the Availability Domain.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[_builtins.str] is_supported_fors: Return shapes that are supported by the service feature.
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['isSupportedFors'] = is_supported_fors
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Mysql/getShapes:getShapes', __args__, opts=opts, typ=GetShapesResult).value

    return AwaitableGetShapesResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_supported_fors=pulumi.get(__ret__, 'is_supported_fors'),
        name=pulumi.get(__ret__, 'name'),
        shapes=pulumi.get(__ret__, 'shapes'))
def get_shapes_output(availability_domain: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetShapesFilterArgs', 'GetShapesFilterArgsDict']]]]] = None,
                      is_supported_fors: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetShapesResult]:
    """
    This data source provides the list of Shapes in Oracle Cloud Infrastructure MySQL Database service.

    Gets a list of the shapes you can use to create a new MySQL DB System.
    The shape determines the resources allocated to the DB System:
    CPU cores and memory for VM shapes; CPU cores, memory and
    storage for non-VM (or bare metal) shapes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_shapes = oci.Mysql.get_shapes(compartment_id=compartment_id,
        availability_domain=shape_availability_domain,
        is_supported_fors=shape_is_supported_for,
        name=shape_name)
    ```


    :param _builtins.str availability_domain: The name of the Availability Domain.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[_builtins.str] is_supported_fors: Return shapes that are supported by the service feature.
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['isSupportedFors'] = is_supported_fors
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Mysql/getShapes:getShapes', __args__, opts=opts, typ=GetShapesResult)
    return __ret__.apply(lambda __response__: GetShapesResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_supported_fors=pulumi.get(__response__, 'is_supported_fors'),
        name=pulumi.get(__response__, 'name'),
        shapes=pulumi.get(__response__, 'shapes')))
