# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReplicaArgs', 'Replica']

@pulumi.input_type
class ReplicaArgs:
    def __init__(__self__, *,
                 db_system_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_delete_protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 replica_overrides: Optional[pulumi.Input['ReplicaReplicaOverridesArgs']] = None):
        """
        The set of arguments for constructing a Replica resource.
        :param pulumi.Input[_builtins.str] db_system_id: The OCID of the DB System the read replica is associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) User provided description of the read replica.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name for the read replica. It does not have to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_delete_protected: (Updatable) Specifies whether the read replica can be deleted. Set to true to prevent deletion, false (default) to allow. Note that if a read replica is delete protected it also prevents the entire DB System from being deleted. If the DB System is delete protected, read replicas can still be deleted individually if they are not delete  protected themselves.
        :param pulumi.Input['ReplicaReplicaOverridesArgs'] replica_overrides: (Updatable) By default a read replica inherits the MySQL version, shape, and configuration of the source DB system.  If you want to override any of these, provide values in the properties, mysqlVersion, shapeName,  and configurationId. If you set a property value to "", then the value is inherited from its  source DB system.
        """
        pulumi.set(__self__, "db_system_id", db_system_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_delete_protected is not None:
            pulumi.set(__self__, "is_delete_protected", is_delete_protected)
        if replica_overrides is not None:
            pulumi.set(__self__, "replica_overrides", replica_overrides)

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the DB System the read replica is associated with.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_system_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) User provided description of the read replica.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The user-friendly name for the read replica. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isDeleteProtected")
    def is_delete_protected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Specifies whether the read replica can be deleted. Set to true to prevent deletion, false (default) to allow. Note that if a read replica is delete protected it also prevents the entire DB System from being deleted. If the DB System is delete protected, read replicas can still be deleted individually if they are not delete  protected themselves.
        """
        return pulumi.get(self, "is_delete_protected")

    @is_delete_protected.setter
    def is_delete_protected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_delete_protected", value)

    @_builtins.property
    @pulumi.getter(name="replicaOverrides")
    def replica_overrides(self) -> Optional[pulumi.Input['ReplicaReplicaOverridesArgs']]:
        """
        (Updatable) By default a read replica inherits the MySQL version, shape, and configuration of the source DB system.  If you want to override any of these, provide values in the properties, mysqlVersion, shapeName,  and configurationId. If you set a property value to "", then the value is inherited from its  source DB system.
        """
        return pulumi.get(self, "replica_overrides")

    @replica_overrides.setter
    def replica_overrides(self, value: Optional[pulumi.Input['ReplicaReplicaOverridesArgs']]):
        pulumi.set(self, "replica_overrides", value)


@pulumi.input_type
class _ReplicaState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_datas: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicaEncryptDataArgs']]]] = None,
                 fault_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 is_delete_protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_version: Optional[pulumi.Input[_builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 port_x: Optional[pulumi.Input[_builtins.int]] = None,
                 replica_overrides: Optional[pulumi.Input['ReplicaReplicaOverridesArgs']] = None,
                 secure_connections: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicaSecureConnectionArgs']]]] = None,
                 shape_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Replica resources.
        :param pulumi.Input[_builtins.str] availability_domain: The name of the Availability Domain the read replica is located in.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment that contains the read replica.
        :param pulumi.Input[_builtins.str] configuration_id: The OCID of the Configuration to be used by the read replica.
        :param pulumi.Input[_builtins.str] db_system_id: The OCID of the DB System the read replica is associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) User provided description of the read replica.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name for the read replica. It does not have to be unique.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicaEncryptDataArgs']]] encrypt_datas: Encrypt data details.
        :param pulumi.Input[_builtins.str] fault_domain: The name of the Fault Domain the read replica is located in.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] ip_address: The IP address the read replica is configured to listen on.
        :param pulumi.Input[_builtins.bool] is_delete_protected: (Updatable) Specifies whether the read replica can be deleted. Set to true to prevent deletion, false (default) to allow. Note that if a read replica is delete protected it also prevents the entire DB System from being deleted. If the DB System is delete protected, read replicas can still be deleted individually if they are not delete  protected themselves.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the state of the read replica.
        :param pulumi.Input[_builtins.str] mysql_version: The MySQL version to be used by the read replica.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nsg_ids: Network Security Group OCIDs used for the VNIC attachment.
        :param pulumi.Input[_builtins.int] port: The port the read replica is configured to listen on.
        :param pulumi.Input[_builtins.int] port_x: The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        :param pulumi.Input['ReplicaReplicaOverridesArgs'] replica_overrides: (Updatable) By default a read replica inherits the MySQL version, shape, and configuration of the source DB system.  If you want to override any of these, provide values in the properties, mysqlVersion, shapeName,  and configurationId. If you set a property value to "", then the value is inherited from its  source DB system.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicaSecureConnectionArgs']]] secure_connections: Secure connection configuration details.
        :param pulumi.Input[_builtins.str] shape_name: The shape currently in use by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        :param pulumi.Input[_builtins.str] state: The state of the read replica.
        :param pulumi.Input[_builtins.str] time_created: The date and time the read replica was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The time the read replica was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encrypt_datas is not None:
            pulumi.set(__self__, "encrypt_datas", encrypt_datas)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_delete_protected is not None:
            pulumi.set(__self__, "is_delete_protected", is_delete_protected)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if mysql_version is not None:
            pulumi.set(__self__, "mysql_version", mysql_version)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_x is not None:
            pulumi.set(__self__, "port_x", port_x)
        if replica_overrides is not None:
            pulumi.set(__self__, "replica_overrides", replica_overrides)
        if secure_connections is not None:
            pulumi.set(__self__, "secure_connections", secure_connections)
        if shape_name is not None:
            pulumi.set(__self__, "shape_name", shape_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Availability Domain the read replica is located in.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compartment that contains the read replica.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the Configuration to be used by the read replica.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the DB System the read replica is associated with.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) User provided description of the read replica.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The user-friendly name for the read replica. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="encryptDatas")
    def encrypt_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicaEncryptDataArgs']]]]:
        """
        Encrypt data details.
        """
        return pulumi.get(self, "encrypt_datas")

    @encrypt_datas.setter
    def encrypt_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicaEncryptDataArgs']]]]):
        pulumi.set(self, "encrypt_datas", value)

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Fault Domain the read replica is located in.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fault_domain", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address the read replica is configured to listen on.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="isDeleteProtected")
    def is_delete_protected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Specifies whether the read replica can be deleted. Set to true to prevent deletion, false (default) to allow. Note that if a read replica is delete protected it also prevents the entire DB System from being deleted. If the DB System is delete protected, read replicas can still be deleted individually if they are not delete  protected themselves.
        """
        return pulumi.get(self, "is_delete_protected")

    @is_delete_protected.setter
    def is_delete_protected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_delete_protected", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the state of the read replica.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MySQL version to be used by the read replica.
        """
        return pulumi.get(self, "mysql_version")

    @mysql_version.setter
    def mysql_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mysql_version", value)

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Network Security Group OCIDs used for the VNIC attachment.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port the read replica is configured to listen on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="portX")
    def port_x(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @port_x.setter
    def port_x(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port_x", value)

    @_builtins.property
    @pulumi.getter(name="replicaOverrides")
    def replica_overrides(self) -> Optional[pulumi.Input['ReplicaReplicaOverridesArgs']]:
        """
        (Updatable) By default a read replica inherits the MySQL version, shape, and configuration of the source DB system.  If you want to override any of these, provide values in the properties, mysqlVersion, shapeName,  and configurationId. If you set a property value to "", then the value is inherited from its  source DB system.
        """
        return pulumi.get(self, "replica_overrides")

    @replica_overrides.setter
    def replica_overrides(self, value: Optional[pulumi.Input['ReplicaReplicaOverridesArgs']]):
        pulumi.set(self, "replica_overrides", value)

    @_builtins.property
    @pulumi.getter(name="secureConnections")
    def secure_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicaSecureConnectionArgs']]]]:
        """
        Secure connection configuration details.
        """
        return pulumi.get(self, "secure_connections")

    @secure_connections.setter
    def secure_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicaSecureConnectionArgs']]]]):
        pulumi.set(self, "secure_connections", value)

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shape currently in use by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape_name", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the read replica.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the read replica was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the read replica was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:Mysql/replica:Replica")
class Replica(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_delete_protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 replica_overrides: Optional[pulumi.Input[Union['ReplicaReplicaOverridesArgs', 'ReplicaReplicaOverridesArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Replica resource in Oracle Cloud Infrastructure MySQL Database service.

        Creates a DB System read replica.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_replica = oci.mysql.Replica("test_replica",
            db_system_id=test_mysql_db_system["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=replica_description,
            display_name=replica_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            is_delete_protected=replica_is_delete_protected,
            replica_overrides={
                "configuration_id": test_mysql_configuration["id"],
                "mysql_version": replica_replica_overrides_mysql_version,
                "nsg_ids": replica_replica_overrides_nsg_ids,
                "shape_name": test_shape["name"],
            })
        ```

        ## Import

        Replicas can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Mysql/replica:Replica test_replica "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_system_id: The OCID of the DB System the read replica is associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) User provided description of the read replica.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name for the read replica. It does not have to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_delete_protected: (Updatable) Specifies whether the read replica can be deleted. Set to true to prevent deletion, false (default) to allow. Note that if a read replica is delete protected it also prevents the entire DB System from being deleted. If the DB System is delete protected, read replicas can still be deleted individually if they are not delete  protected themselves.
        :param pulumi.Input[Union['ReplicaReplicaOverridesArgs', 'ReplicaReplicaOverridesArgsDict']] replica_overrides: (Updatable) By default a read replica inherits the MySQL version, shape, and configuration of the source DB system.  If you want to override any of these, provide values in the properties, mysqlVersion, shapeName,  and configurationId. If you set a property value to "", then the value is inherited from its  source DB system.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Replica resource in Oracle Cloud Infrastructure MySQL Database service.

        Creates a DB System read replica.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_replica = oci.mysql.Replica("test_replica",
            db_system_id=test_mysql_db_system["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=replica_description,
            display_name=replica_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            is_delete_protected=replica_is_delete_protected,
            replica_overrides={
                "configuration_id": test_mysql_configuration["id"],
                "mysql_version": replica_replica_overrides_mysql_version,
                "nsg_ids": replica_replica_overrides_nsg_ids,
                "shape_name": test_shape["name"],
            })
        ```

        ## Import

        Replicas can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Mysql/replica:Replica test_replica "id"
        ```

        :param str resource_name: The name of the resource.
        :param ReplicaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_delete_protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 replica_overrides: Optional[pulumi.Input[Union['ReplicaReplicaOverridesArgs', 'ReplicaReplicaOverridesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicaArgs.__new__(ReplicaArgs)

            if db_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_system_id'")
            __props__.__dict__["db_system_id"] = db_system_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_delete_protected"] = is_delete_protected
            __props__.__dict__["replica_overrides"] = replica_overrides
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["configuration_id"] = None
            __props__.__dict__["encrypt_datas"] = None
            __props__.__dict__["fault_domain"] = None
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["mysql_version"] = None
            __props__.__dict__["nsg_ids"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["port_x"] = None
            __props__.__dict__["secure_connections"] = None
            __props__.__dict__["shape_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Replica, __self__).__init__(
            'oci:Mysql/replica:Replica',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            encrypt_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicaEncryptDataArgs', 'ReplicaEncryptDataArgsDict']]]]] = None,
            fault_domain: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            is_delete_protected: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            mysql_version: Optional[pulumi.Input[_builtins.str]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            port_x: Optional[pulumi.Input[_builtins.int]] = None,
            replica_overrides: Optional[pulumi.Input[Union['ReplicaReplicaOverridesArgs', 'ReplicaReplicaOverridesArgsDict']]] = None,
            secure_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicaSecureConnectionArgs', 'ReplicaSecureConnectionArgsDict']]]]] = None,
            shape_name: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'Replica':
        """
        Get an existing Replica resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The name of the Availability Domain the read replica is located in.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment that contains the read replica.
        :param pulumi.Input[_builtins.str] configuration_id: The OCID of the Configuration to be used by the read replica.
        :param pulumi.Input[_builtins.str] db_system_id: The OCID of the DB System the read replica is associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) User provided description of the read replica.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name for the read replica. It does not have to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicaEncryptDataArgs', 'ReplicaEncryptDataArgsDict']]]] encrypt_datas: Encrypt data details.
        :param pulumi.Input[_builtins.str] fault_domain: The name of the Fault Domain the read replica is located in.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] ip_address: The IP address the read replica is configured to listen on.
        :param pulumi.Input[_builtins.bool] is_delete_protected: (Updatable) Specifies whether the read replica can be deleted. Set to true to prevent deletion, false (default) to allow. Note that if a read replica is delete protected it also prevents the entire DB System from being deleted. If the DB System is delete protected, read replicas can still be deleted individually if they are not delete  protected themselves.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the state of the read replica.
        :param pulumi.Input[_builtins.str] mysql_version: The MySQL version to be used by the read replica.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nsg_ids: Network Security Group OCIDs used for the VNIC attachment.
        :param pulumi.Input[_builtins.int] port: The port the read replica is configured to listen on.
        :param pulumi.Input[_builtins.int] port_x: The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        :param pulumi.Input[Union['ReplicaReplicaOverridesArgs', 'ReplicaReplicaOverridesArgsDict']] replica_overrides: (Updatable) By default a read replica inherits the MySQL version, shape, and configuration of the source DB system.  If you want to override any of these, provide values in the properties, mysqlVersion, shapeName,  and configurationId. If you set a property value to "", then the value is inherited from its  source DB system.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicaSecureConnectionArgs', 'ReplicaSecureConnectionArgsDict']]]] secure_connections: Secure connection configuration details.
        :param pulumi.Input[_builtins.str] shape_name: The shape currently in use by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        :param pulumi.Input[_builtins.str] state: The state of the read replica.
        :param pulumi.Input[_builtins.str] time_created: The date and time the read replica was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The time the read replica was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReplicaState.__new__(_ReplicaState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["configuration_id"] = configuration_id
        __props__.__dict__["db_system_id"] = db_system_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["encrypt_datas"] = encrypt_datas
        __props__.__dict__["fault_domain"] = fault_domain
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["is_delete_protected"] = is_delete_protected
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["mysql_version"] = mysql_version
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["port"] = port
        __props__.__dict__["port_x"] = port_x
        __props__.__dict__["replica_overrides"] = replica_overrides
        __props__.__dict__["secure_connections"] = secure_connections
        __props__.__dict__["shape_name"] = shape_name
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return Replica(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Availability Domain the read replica is located in.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the compartment that contains the read replica.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the Configuration to be used by the read replica.
        """
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the DB System the read replica is associated with.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) User provided description of the read replica.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The user-friendly name for the read replica. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="encryptDatas")
    def encrypt_datas(self) -> pulumi.Output[Sequence['outputs.ReplicaEncryptData']]:
        """
        Encrypt data details.
        """
        return pulumi.get(self, "encrypt_datas")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Fault Domain the read replica is located in.
        """
        return pulumi.get(self, "fault_domain")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address the read replica is configured to listen on.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="isDeleteProtected")
    def is_delete_protected(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Specifies whether the read replica can be deleted. Set to true to prevent deletion, false (default) to allow. Note that if a read replica is delete protected it also prevents the entire DB System from being deleted. If the DB System is delete protected, read replicas can still be deleted individually if they are not delete  protected themselves.
        """
        return pulumi.get(self, "is_delete_protected")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the state of the read replica.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> pulumi.Output[_builtins.str]:
        """
        The MySQL version to be used by the read replica.
        """
        return pulumi.get(self, "mysql_version")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Network Security Group OCIDs used for the VNIC attachment.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The port the read replica is configured to listen on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portX")
    def port_x(self) -> pulumi.Output[_builtins.int]:
        """
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @_builtins.property
    @pulumi.getter(name="replicaOverrides")
    def replica_overrides(self) -> pulumi.Output['outputs.ReplicaReplicaOverrides']:
        """
        (Updatable) By default a read replica inherits the MySQL version, shape, and configuration of the source DB system.  If you want to override any of these, provide values in the properties, mysqlVersion, shapeName,  and configurationId. If you set a property value to "", then the value is inherited from its  source DB system.
        """
        return pulumi.get(self, "replica_overrides")

    @_builtins.property
    @pulumi.getter(name="secureConnections")
    def secure_connections(self) -> pulumi.Output[Sequence['outputs.ReplicaSecureConnection']]:
        """
        Secure connection configuration details.
        """
        return pulumi.get(self, "secure_connections")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Output[_builtins.str]:
        """
        The shape currently in use by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the read replica.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the read replica was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the read replica was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

