# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkFirewallPolicyServiceArgs', 'NetworkFirewallPolicyService']

@pulumi.input_type
class NetworkFirewallPolicyServiceArgs:
    def __init__(__self__, *,
                 network_firewall_policy_id: pulumi.Input[_builtins.str],
                 port_ranges: pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyServicePortRangeArgs']]],
                 type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkFirewallPolicyService resource.
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyServicePortRangeArgs']]] port_ranges: (Updatable) List of port-ranges to be used.
        :param pulumi.Input[_builtins.str] type: Describes the type of Service. The accepted values are 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] name: Name of the service
        """
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        pulumi.set(__self__, "port_ranges", port_ranges)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyServicePortRangeArgs']]]:
        """
        (Updatable) List of port-ranges to be used.
        """
        return pulumi.get(self, "port_ranges")

    @port_ranges.setter
    def port_ranges(self, value: pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyServicePortRangeArgs']]]):
        pulumi.set(self, "port_ranges", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Describes the type of Service. The accepted values are 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the service
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkFirewallPolicyServiceState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyServicePortRangeArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkFirewallPolicyService resources.
        :param pulumi.Input[_builtins.str] name: Name of the service
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[_builtins.str] parent_resource_id: OCID of the Network Firewall Policy this service belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyServicePortRangeArgs']]] port_ranges: (Updatable) List of port-ranges to be used.
        :param pulumi.Input[_builtins.str] type: Describes the type of Service. The accepted values are 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_firewall_policy_id is not None:
            pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id is not None:
            pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if port_ranges is not None:
            pulumi.set(__self__, "port_ranges", port_ranges)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the service
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the Network Firewall Policy this service belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @parent_resource_id.setter
    def parent_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyServicePortRangeArgs']]]]:
        """
        (Updatable) List of port-ranges to be used.
        """
        return pulumi.get(self, "port_ranges")

    @port_ranges.setter
    def port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyServicePortRangeArgs']]]]):
        pulumi.set(self, "port_ranges", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the type of Service. The accepted values are 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:NetworkFirewall/networkFirewallPolicyService:NetworkFirewallPolicyService")
class NetworkFirewallPolicyService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkFirewallPolicyServicePortRangeArgs', 'NetworkFirewallPolicyServicePortRangeArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Network Firewall Policy Service resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new Service for the Network Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_service = oci.networkfirewall.NetworkFirewallPolicyService("test_network_firewall_policy_service",
            name=network_firewall_policy_service_name,
            network_firewall_policy_id=test_network_firewall_policy["id"],
            port_ranges=[{
                "minimum_port": network_firewall_policy_service_port_ranges_minimum_port,
                "maximum_port": network_firewall_policy_service_port_ranges_maximum_port,
            }],
            type=network_firewall_policy_service_type)
        ```

        ## Import

        NetworkFirewallPolicyServices can be imported using the `name`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyService:NetworkFirewallPolicyService test_network_firewall_policy_service "networkFirewallPolicies/{networkFirewallPolicyId}/services/{serviceName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the service
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkFirewallPolicyServicePortRangeArgs', 'NetworkFirewallPolicyServicePortRangeArgsDict']]]] port_ranges: (Updatable) List of port-ranges to be used.
        :param pulumi.Input[_builtins.str] type: Describes the type of Service. The accepted values are 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkFirewallPolicyServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Network Firewall Policy Service resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new Service for the Network Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_service = oci.networkfirewall.NetworkFirewallPolicyService("test_network_firewall_policy_service",
            name=network_firewall_policy_service_name,
            network_firewall_policy_id=test_network_firewall_policy["id"],
            port_ranges=[{
                "minimum_port": network_firewall_policy_service_port_ranges_minimum_port,
                "maximum_port": network_firewall_policy_service_port_ranges_maximum_port,
            }],
            type=network_firewall_policy_service_type)
        ```

        ## Import

        NetworkFirewallPolicyServices can be imported using the `name`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyService:NetworkFirewallPolicyService test_network_firewall_policy_service "networkFirewallPolicies/{networkFirewallPolicyId}/services/{serviceName}"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkFirewallPolicyServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkFirewallPolicyServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkFirewallPolicyServicePortRangeArgs', 'NetworkFirewallPolicyServicePortRangeArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkFirewallPolicyServiceArgs.__new__(NetworkFirewallPolicyServiceArgs)

            __props__.__dict__["name"] = name
            if network_firewall_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_firewall_policy_id'")
            __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
            if port_ranges is None and not opts.urn:
                raise TypeError("Missing required property 'port_ranges'")
            __props__.__dict__["port_ranges"] = port_ranges
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["parent_resource_id"] = None
        super(NetworkFirewallPolicyService, __self__).__init__(
            'oci:NetworkFirewall/networkFirewallPolicyService:NetworkFirewallPolicyService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkFirewallPolicyServicePortRangeArgs', 'NetworkFirewallPolicyServicePortRangeArgsDict']]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkFirewallPolicyService':
        """
        Get an existing NetworkFirewallPolicyService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the service
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[_builtins.str] parent_resource_id: OCID of the Network Firewall Policy this service belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkFirewallPolicyServicePortRangeArgs', 'NetworkFirewallPolicyServicePortRangeArgsDict']]]] port_ranges: (Updatable) List of port-ranges to be used.
        :param pulumi.Input[_builtins.str] type: Describes the type of Service. The accepted values are 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkFirewallPolicyServiceState.__new__(_NetworkFirewallPolicyServiceState)

        __props__.__dict__["name"] = name
        __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
        __props__.__dict__["parent_resource_id"] = parent_resource_id
        __props__.__dict__["port_ranges"] = port_ranges
        __props__.__dict__["type"] = type
        return NetworkFirewallPolicyService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the service
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @_builtins.property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCID of the Network Firewall Policy this service belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> pulumi.Output[Sequence['outputs.NetworkFirewallPolicyServicePortRange']]:
        """
        (Updatable) List of port-ranges to be used.
        """
        return pulumi.get(self, "port_ranges")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Describes the type of Service. The accepted values are 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

