# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDbmulticloudOracleDbGcpKeyResult',
    'AwaitableGetDbmulticloudOracleDbGcpKeyResult',
    'get_dbmulticloud_oracle_db_gcp_key',
    'get_dbmulticloud_oracle_db_gcp_key_output',
]

@pulumi.output_type
class GetDbmulticloudOracleDbGcpKeyResult:
    """
    A collection of values returned by getDbmulticloudOracleDbGcpKey.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, gcp_key_id=None, gcp_key_properties=None, id=None, lifecycle_state_details=None, oracle_db_gcp_key_id=None, oracle_db_gcp_key_ring_id=None, resource_type=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gcp_key_id and not isinstance(gcp_key_id, str):
            raise TypeError("Expected argument 'gcp_key_id' to be a str")
        pulumi.set(__self__, "gcp_key_id", gcp_key_id)
        if gcp_key_properties and not isinstance(gcp_key_properties, dict):
            raise TypeError("Expected argument 'gcp_key_properties' to be a dict")
        pulumi.set(__self__, "gcp_key_properties", gcp_key_properties)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_state_details and not isinstance(lifecycle_state_details, str):
            raise TypeError("Expected argument 'lifecycle_state_details' to be a str")
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if oracle_db_gcp_key_id and not isinstance(oracle_db_gcp_key_id, str):
            raise TypeError("Expected argument 'oracle_db_gcp_key_id' to be a str")
        pulumi.set(__self__, "oracle_db_gcp_key_id", oracle_db_gcp_key_id)
        if oracle_db_gcp_key_ring_id and not isinstance(oracle_db_gcp_key_ring_id, str):
            raise TypeError("Expected argument 'oracle_db_gcp_key_ring_id' to be a str")
        pulumi.set(__self__, "oracle_db_gcp_key_ring_id", oracle_db_gcp_key_ring_id)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains Oracle DB Google Key resource.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Display name of Oracle DB Google Key resource.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="gcpKeyId")
    def gcp_key_id(self) -> _builtins.str:
        """
        TThe Google Cloud Key ID and Key URL associated with the Google Key under the specified Key Ring resource.
        """
        return pulumi.get(self, "gcp_key_id")

    @_builtins.property
    @pulumi.getter(name="gcpKeyProperties")
    def gcp_key_properties(self) -> Mapping[str, _builtins.str]:
        """
        Gcp Key properties
        """
        return pulumi.get(self, "gcp_key_properties")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> _builtins.str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @_builtins.property
    @pulumi.getter(name="oracleDbGcpKeyId")
    def oracle_db_gcp_key_id(self) -> _builtins.str:
        return pulumi.get(self, "oracle_db_gcp_key_id")

    @_builtins.property
    @pulumi.getter(name="oracleDbGcpKeyRingId")
    def oracle_db_gcp_key_ring_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Google Cloud Key-Ring resource.
        """
        return pulumi.get(self, "oracle_db_gcp_key_ring_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        Key resource type.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the Oracle DB Google Key resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time when the Oracle DB Google Key resource was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time when the Oracle DB Google Key resource was last modified, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDbmulticloudOracleDbGcpKeyResult(GetDbmulticloudOracleDbGcpKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbmulticloudOracleDbGcpKeyResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            gcp_key_id=self.gcp_key_id,
            gcp_key_properties=self.gcp_key_properties,
            id=self.id,
            lifecycle_state_details=self.lifecycle_state_details,
            oracle_db_gcp_key_id=self.oracle_db_gcp_key_id,
            oracle_db_gcp_key_ring_id=self.oracle_db_gcp_key_ring_id,
            resource_type=self.resource_type,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_dbmulticloud_oracle_db_gcp_key(oracle_db_gcp_key_id: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbmulticloudOracleDbGcpKeyResult:
    """
    This data source provides details about a specific Oracle Db Gcp Key resource in Oracle Cloud Infrastructure Dbmulticloud service.

    Retrieves Oracle DB Google Cloud Key details using a specific resource [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_gcp_key = oci.oci.get_dbmulticloud_oracle_db_gcp_key(oracle_db_gcp_key_id=test_oracle_db_gcp_key_oci_dbmulticloud_oracle_db_gcp_key["id"])
    ```


    :param _builtins.str oracle_db_gcp_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Google Cloud Key resource.
    """
    __args__ = dict()
    __args__['oracleDbGcpKeyId'] = oracle_db_gcp_key_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getDbmulticloudOracleDbGcpKey:getDbmulticloudOracleDbGcpKey', __args__, opts=opts, typ=GetDbmulticloudOracleDbGcpKeyResult).value

    return AwaitableGetDbmulticloudOracleDbGcpKeyResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        gcp_key_id=pulumi.get(__ret__, 'gcp_key_id'),
        gcp_key_properties=pulumi.get(__ret__, 'gcp_key_properties'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_state_details=pulumi.get(__ret__, 'lifecycle_state_details'),
        oracle_db_gcp_key_id=pulumi.get(__ret__, 'oracle_db_gcp_key_id'),
        oracle_db_gcp_key_ring_id=pulumi.get(__ret__, 'oracle_db_gcp_key_ring_id'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_dbmulticloud_oracle_db_gcp_key_output(oracle_db_gcp_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbmulticloudOracleDbGcpKeyResult]:
    """
    This data source provides details about a specific Oracle Db Gcp Key resource in Oracle Cloud Infrastructure Dbmulticloud service.

    Retrieves Oracle DB Google Cloud Key details using a specific resource [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_gcp_key = oci.oci.get_dbmulticloud_oracle_db_gcp_key(oracle_db_gcp_key_id=test_oracle_db_gcp_key_oci_dbmulticloud_oracle_db_gcp_key["id"])
    ```


    :param _builtins.str oracle_db_gcp_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Google Cloud Key resource.
    """
    __args__ = dict()
    __args__['oracleDbGcpKeyId'] = oracle_db_gcp_key_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getDbmulticloudOracleDbGcpKey:getDbmulticloudOracleDbGcpKey', __args__, opts=opts, typ=GetDbmulticloudOracleDbGcpKeyResult)
    return __ret__.apply(lambda __response__: GetDbmulticloudOracleDbGcpKeyResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        gcp_key_id=pulumi.get(__response__, 'gcp_key_id'),
        gcp_key_properties=pulumi.get(__response__, 'gcp_key_properties'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_state_details=pulumi.get(__response__, 'lifecycle_state_details'),
        oracle_db_gcp_key_id=pulumi.get(__response__, 'oracle_db_gcp_key_id'),
        oracle_db_gcp_key_ring_id=pulumi.get(__response__, 'oracle_db_gcp_key_ring_id'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
