# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOpensearchClusterPipelinesResult',
    'AwaitableGetOpensearchClusterPipelinesResult',
    'get_opensearch_cluster_pipelines',
    'get_opensearch_cluster_pipelines_output',
]

@pulumi.output_type
class GetOpensearchClusterPipelinesResult:
    """
    A collection of values returned by getOpensearchClusterPipelines.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, opensearch_cluster_pipeline_collections=None, pipeline_component_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if opensearch_cluster_pipeline_collections and not isinstance(opensearch_cluster_pipeline_collections, list):
            raise TypeError("Expected argument 'opensearch_cluster_pipeline_collections' to be a list")
        pulumi.set(__self__, "opensearch_cluster_pipeline_collections", opensearch_cluster_pipeline_collections)
        if pipeline_component_id and not isinstance(pipeline_component_id, str):
            raise TypeError("Expected argument 'pipeline_component_id' to be a str")
        pulumi.set(__self__, "pipeline_component_id", pipeline_component_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment where the pipeline is located.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The name of the pipeline. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOpensearchClusterPipelinesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The OCID of the cluster pipeline.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="opensearchClusterPipelineCollections")
    def opensearch_cluster_pipeline_collections(self) -> Sequence['outputs.GetOpensearchClusterPipelinesOpensearchClusterPipelineCollectionResult']:
        """
        The list of opensearch_cluster_pipeline_collection.
        """
        return pulumi.get(self, "opensearch_cluster_pipeline_collections")

    @_builtins.property
    @pulumi.getter(name="pipelineComponentId")
    def pipeline_component_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "pipeline_component_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the cluster backup.
        """
        return pulumi.get(self, "state")


class AwaitableGetOpensearchClusterPipelinesResult(GetOpensearchClusterPipelinesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpensearchClusterPipelinesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            opensearch_cluster_pipeline_collections=self.opensearch_cluster_pipeline_collections,
            pipeline_component_id=self.pipeline_component_id,
            state=self.state)


def get_opensearch_cluster_pipelines(compartment_id: Optional[_builtins.str] = None,
                                     display_name: Optional[_builtins.str] = None,
                                     filters: Optional[Sequence[Union['GetOpensearchClusterPipelinesFilterArgs', 'GetOpensearchClusterPipelinesFilterArgsDict']]] = None,
                                     id: Optional[_builtins.str] = None,
                                     pipeline_component_id: Optional[_builtins.str] = None,
                                     state: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpensearchClusterPipelinesResult:
    """
    This data source provides the list of Opensearch Cluster Pipelines in Oracle Cloud Infrastructure Opensearch service.

    Returns a list of OpensearchClusterPipelines.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opensearch_cluster_pipelines = oci.Opensearch.get_opensearch_cluster_pipelines(compartment_id=compartment_id,
        display_name=opensearch_cluster_pipeline_display_name,
        id=opensearch_cluster_pipeline_id,
        pipeline_component_id=test_pipeline_component["id"],
        state=opensearch_cluster_pipeline_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: unique OpensearchClusterPipeline identifier
    :param _builtins.str pipeline_component_id: A filter to return pipelines whose any component has the given pipelineComponentId.
    :param _builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['pipelineComponentId'] = pipeline_component_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opensearch/getOpensearchClusterPipelines:getOpensearchClusterPipelines', __args__, opts=opts, typ=GetOpensearchClusterPipelinesResult).value

    return AwaitableGetOpensearchClusterPipelinesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        opensearch_cluster_pipeline_collections=pulumi.get(__ret__, 'opensearch_cluster_pipeline_collections'),
        pipeline_component_id=pulumi.get(__ret__, 'pipeline_component_id'),
        state=pulumi.get(__ret__, 'state'))
def get_opensearch_cluster_pipelines_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOpensearchClusterPipelinesFilterArgs', 'GetOpensearchClusterPipelinesFilterArgsDict']]]]] = None,
                                            id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            pipeline_component_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOpensearchClusterPipelinesResult]:
    """
    This data source provides the list of Opensearch Cluster Pipelines in Oracle Cloud Infrastructure Opensearch service.

    Returns a list of OpensearchClusterPipelines.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opensearch_cluster_pipelines = oci.Opensearch.get_opensearch_cluster_pipelines(compartment_id=compartment_id,
        display_name=opensearch_cluster_pipeline_display_name,
        id=opensearch_cluster_pipeline_id,
        pipeline_component_id=test_pipeline_component["id"],
        state=opensearch_cluster_pipeline_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: unique OpensearchClusterPipeline identifier
    :param _builtins.str pipeline_component_id: A filter to return pipelines whose any component has the given pipelineComponentId.
    :param _builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['pipelineComponentId'] = pipeline_component_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Opensearch/getOpensearchClusterPipelines:getOpensearchClusterPipelines', __args__, opts=opts, typ=GetOpensearchClusterPipelinesResult)
    return __ret__.apply(lambda __response__: GetOpensearchClusterPipelinesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        opensearch_cluster_pipeline_collections=pulumi.get(__response__, 'opensearch_cluster_pipeline_collections'),
        pipeline_component_id=pulumi.get(__response__, 'pipeline_component_id'),
        state=pulumi.get(__response__, 'state')))
