# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OperationsInsightsWarehouseUserArgs', 'OperationsInsightsWarehouseUser']

@pulumi.input_type
class OperationsInsightsWarehouseUserArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 connection_password: pulumi.Input[_builtins.str],
                 is_awr_data_access: pulumi.Input[_builtins.bool],
                 operations_insights_warehouse_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_em_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_opsi_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OperationsInsightsWarehouseUser resource.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] connection_password: (Updatable) User provided connection password for the AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        :param pulumi.Input[_builtins.bool] is_awr_data_access: (Updatable) Indicate whether user has access to AWR data.
        :param pulumi.Input[_builtins.str] operations_insights_warehouse_id: OPSI Warehouse OCID
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_em_data_access: (Updatable) Indicate whether user has access to EM data.
        :param pulumi.Input[_builtins.bool] is_opsi_data_access: (Updatable) Indicate whether user has access to OPSI data.
        :param pulumi.Input[_builtins.str] name: Username for schema which would have access to AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "connection_password", connection_password)
        pulumi.set(__self__, "is_awr_data_access", is_awr_data_access)
        pulumi.set(__self__, "operations_insights_warehouse_id", operations_insights_warehouse_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_em_data_access is not None:
            pulumi.set(__self__, "is_em_data_access", is_em_data_access)
        if is_opsi_data_access is not None:
            pulumi.set(__self__, "is_opsi_data_access", is_opsi_data_access)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionPassword")
    def connection_password(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) User provided connection password for the AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        """
        return pulumi.get(self, "connection_password")

    @connection_password.setter
    def connection_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_password", value)

    @_builtins.property
    @pulumi.getter(name="isAwrDataAccess")
    def is_awr_data_access(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) Indicate whether user has access to AWR data.
        """
        return pulumi.get(self, "is_awr_data_access")

    @is_awr_data_access.setter
    def is_awr_data_access(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_awr_data_access", value)

    @_builtins.property
    @pulumi.getter(name="operationsInsightsWarehouseId")
    def operations_insights_warehouse_id(self) -> pulumi.Input[_builtins.str]:
        """
        OPSI Warehouse OCID


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "operations_insights_warehouse_id")

    @operations_insights_warehouse_id.setter
    def operations_insights_warehouse_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "operations_insights_warehouse_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isEmDataAccess")
    def is_em_data_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicate whether user has access to EM data.
        """
        return pulumi.get(self, "is_em_data_access")

    @is_em_data_access.setter
    def is_em_data_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_em_data_access", value)

    @_builtins.property
    @pulumi.getter(name="isOpsiDataAccess")
    def is_opsi_data_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicate whether user has access to OPSI data.
        """
        return pulumi.get(self, "is_opsi_data_access")

    @is_opsi_data_access.setter
    def is_opsi_data_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_opsi_data_access", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username for schema which would have access to AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _OperationsInsightsWarehouseUserState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_password: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_awr_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_em_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_opsi_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operations_insights_warehouse_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OperationsInsightsWarehouseUser resources.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] connection_password: (Updatable) User provided connection password for the AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_awr_data_access: (Updatable) Indicate whether user has access to AWR data.
        :param pulumi.Input[_builtins.bool] is_em_data_access: (Updatable) Indicate whether user has access to EM data.
        :param pulumi.Input[_builtins.bool] is_opsi_data_access: (Updatable) Indicate whether user has access to OPSI data.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] name: Username for schema which would have access to AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        :param pulumi.Input[_builtins.str] operations_insights_warehouse_id: OPSI Warehouse OCID
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: Possible lifecycle states
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time at which the resource was first created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_updated: The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_password is not None:
            pulumi.set(__self__, "connection_password", connection_password)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_awr_data_access is not None:
            pulumi.set(__self__, "is_awr_data_access", is_awr_data_access)
        if is_em_data_access is not None:
            pulumi.set(__self__, "is_em_data_access", is_em_data_access)
        if is_opsi_data_access is not None:
            pulumi.set(__self__, "is_opsi_data_access", is_opsi_data_access)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operations_insights_warehouse_id is not None:
            pulumi.set(__self__, "operations_insights_warehouse_id", operations_insights_warehouse_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionPassword")
    def connection_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) User provided connection password for the AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        """
        return pulumi.get(self, "connection_password")

    @connection_password.setter
    def connection_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_password", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isAwrDataAccess")
    def is_awr_data_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicate whether user has access to AWR data.
        """
        return pulumi.get(self, "is_awr_data_access")

    @is_awr_data_access.setter
    def is_awr_data_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_awr_data_access", value)

    @_builtins.property
    @pulumi.getter(name="isEmDataAccess")
    def is_em_data_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicate whether user has access to EM data.
        """
        return pulumi.get(self, "is_em_data_access")

    @is_em_data_access.setter
    def is_em_data_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_em_data_access", value)

    @_builtins.property
    @pulumi.getter(name="isOpsiDataAccess")
    def is_opsi_data_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicate whether user has access to OPSI data.
        """
        return pulumi.get(self, "is_opsi_data_access")

    @is_opsi_data_access.setter
    def is_opsi_data_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_opsi_data_access", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username for schema which would have access to AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="operationsInsightsWarehouseId")
    def operations_insights_warehouse_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OPSI Warehouse OCID


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "operations_insights_warehouse_id")

    @operations_insights_warehouse_id.setter
    def operations_insights_warehouse_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operations_insights_warehouse_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible lifecycle states
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the resource was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:Opsi/operationsInsightsWarehouseUser:OperationsInsightsWarehouseUser")
class OperationsInsightsWarehouseUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_password: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_awr_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_em_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_opsi_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operations_insights_warehouse_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Operations Insights Warehouse User resource in Oracle Cloud Infrastructure Opsi service.

        Create a Operations Insights Warehouse user resource for the tenant in Operations Insights.
        This resource will be created in root compartment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_operations_insights_warehouse_user = oci.opsi.OperationsInsightsWarehouseUser("test_operations_insights_warehouse_user",
            compartment_id=compartment_id,
            connection_password=operations_insights_warehouse_user_connection_password,
            is_awr_data_access=operations_insights_warehouse_user_is_awr_data_access,
            name=operations_insights_warehouse_user_name,
            operations_insights_warehouse_id=test_operations_insights_warehouse["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            is_em_data_access=operations_insights_warehouse_user_is_em_data_access,
            is_opsi_data_access=operations_insights_warehouse_user_is_opsi_data_access)
        ```

        ## Import

        OperationsInsightsWarehouseUsers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opsi/operationsInsightsWarehouseUser:OperationsInsightsWarehouseUser test_operations_insights_warehouse_user "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] connection_password: (Updatable) User provided connection password for the AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_awr_data_access: (Updatable) Indicate whether user has access to AWR data.
        :param pulumi.Input[_builtins.bool] is_em_data_access: (Updatable) Indicate whether user has access to EM data.
        :param pulumi.Input[_builtins.bool] is_opsi_data_access: (Updatable) Indicate whether user has access to OPSI data.
        :param pulumi.Input[_builtins.str] name: Username for schema which would have access to AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        :param pulumi.Input[_builtins.str] operations_insights_warehouse_id: OPSI Warehouse OCID
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OperationsInsightsWarehouseUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Operations Insights Warehouse User resource in Oracle Cloud Infrastructure Opsi service.

        Create a Operations Insights Warehouse user resource for the tenant in Operations Insights.
        This resource will be created in root compartment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_operations_insights_warehouse_user = oci.opsi.OperationsInsightsWarehouseUser("test_operations_insights_warehouse_user",
            compartment_id=compartment_id,
            connection_password=operations_insights_warehouse_user_connection_password,
            is_awr_data_access=operations_insights_warehouse_user_is_awr_data_access,
            name=operations_insights_warehouse_user_name,
            operations_insights_warehouse_id=test_operations_insights_warehouse["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            is_em_data_access=operations_insights_warehouse_user_is_em_data_access,
            is_opsi_data_access=operations_insights_warehouse_user_is_opsi_data_access)
        ```

        ## Import

        OperationsInsightsWarehouseUsers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opsi/operationsInsightsWarehouseUser:OperationsInsightsWarehouseUser test_operations_insights_warehouse_user "id"
        ```

        :param str resource_name: The name of the resource.
        :param OperationsInsightsWarehouseUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OperationsInsightsWarehouseUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_password: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_awr_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_em_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_opsi_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operations_insights_warehouse_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OperationsInsightsWarehouseUserArgs.__new__(OperationsInsightsWarehouseUserArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if connection_password is None and not opts.urn:
                raise TypeError("Missing required property 'connection_password'")
            __props__.__dict__["connection_password"] = None if connection_password is None else pulumi.Output.secret(connection_password)
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            if is_awr_data_access is None and not opts.urn:
                raise TypeError("Missing required property 'is_awr_data_access'")
            __props__.__dict__["is_awr_data_access"] = is_awr_data_access
            __props__.__dict__["is_em_data_access"] = is_em_data_access
            __props__.__dict__["is_opsi_data_access"] = is_opsi_data_access
            __props__.__dict__["name"] = name
            if operations_insights_warehouse_id is None and not opts.urn:
                raise TypeError("Missing required property 'operations_insights_warehouse_id'")
            __props__.__dict__["operations_insights_warehouse_id"] = operations_insights_warehouse_id
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["connectionPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OperationsInsightsWarehouseUser, __self__).__init__(
            'oci:Opsi/operationsInsightsWarehouseUser:OperationsInsightsWarehouseUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            connection_password: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_awr_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
            is_em_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
            is_opsi_data_access: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            operations_insights_warehouse_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'OperationsInsightsWarehouseUser':
        """
        Get an existing OperationsInsightsWarehouseUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] connection_password: (Updatable) User provided connection password for the AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_awr_data_access: (Updatable) Indicate whether user has access to AWR data.
        :param pulumi.Input[_builtins.bool] is_em_data_access: (Updatable) Indicate whether user has access to EM data.
        :param pulumi.Input[_builtins.bool] is_opsi_data_access: (Updatable) Indicate whether user has access to OPSI data.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] name: Username for schema which would have access to AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        :param pulumi.Input[_builtins.str] operations_insights_warehouse_id: OPSI Warehouse OCID
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: Possible lifecycle states
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time at which the resource was first created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_updated: The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OperationsInsightsWarehouseUserState.__new__(_OperationsInsightsWarehouseUserState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_password"] = connection_password
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_awr_data_access"] = is_awr_data_access
        __props__.__dict__["is_em_data_access"] = is_em_data_access
        __props__.__dict__["is_opsi_data_access"] = is_opsi_data_access
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["name"] = name
        __props__.__dict__["operations_insights_warehouse_id"] = operations_insights_warehouse_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return OperationsInsightsWarehouseUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectionPassword")
    def connection_password(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) User provided connection password for the AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        """
        return pulumi.get(self, "connection_password")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isAwrDataAccess")
    def is_awr_data_access(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicate whether user has access to AWR data.
        """
        return pulumi.get(self, "is_awr_data_access")

    @_builtins.property
    @pulumi.getter(name="isEmDataAccess")
    def is_em_data_access(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicate whether user has access to EM data.
        """
        return pulumi.get(self, "is_em_data_access")

    @_builtins.property
    @pulumi.getter(name="isOpsiDataAccess")
    def is_opsi_data_access(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicate whether user has access to OPSI data.
        """
        return pulumi.get(self, "is_opsi_data_access")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Username for schema which would have access to AWR Data,  Enterprise Manager Data and Ops Insights OPSI Hub.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="operationsInsightsWarehouseId")
    def operations_insights_warehouse_id(self) -> pulumi.Output[_builtins.str]:
        """
        OPSI Warehouse OCID


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "operations_insights_warehouse_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Possible lifecycle states
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the resource was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

