# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProfileVersionResult',
    'AwaitableGetProfileVersionResult',
    'get_profile_version',
    'get_profile_version_output',
]

@pulumi.output_type
class GetProfileVersionResult:
    """
    A collection of values returned by getProfileVersion.
    """
    def __init__(__self__, arch_type=None, compartment_id=None, description=None, display_name=None, id=None, is_default_profile=None, is_service_provided_profile=None, lifecycle_environments=None, lifecycle_stages=None, managed_instance_groups=None, management_station_id=None, os_family=None, profile_id=None, profile_type=None, profile_version=None, registration_type=None, software_sources=None, state=None, time_created=None, time_modified=None, vendor_name=None):
        if arch_type and not isinstance(arch_type, str):
            raise TypeError("Expected argument 'arch_type' to be a str")
        pulumi.set(__self__, "arch_type", arch_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default_profile and not isinstance(is_default_profile, bool):
            raise TypeError("Expected argument 'is_default_profile' to be a bool")
        pulumi.set(__self__, "is_default_profile", is_default_profile)
        if is_service_provided_profile and not isinstance(is_service_provided_profile, bool):
            raise TypeError("Expected argument 'is_service_provided_profile' to be a bool")
        pulumi.set(__self__, "is_service_provided_profile", is_service_provided_profile)
        if lifecycle_environments and not isinstance(lifecycle_environments, list):
            raise TypeError("Expected argument 'lifecycle_environments' to be a list")
        pulumi.set(__self__, "lifecycle_environments", lifecycle_environments)
        if lifecycle_stages and not isinstance(lifecycle_stages, list):
            raise TypeError("Expected argument 'lifecycle_stages' to be a list")
        pulumi.set(__self__, "lifecycle_stages", lifecycle_stages)
        if managed_instance_groups and not isinstance(managed_instance_groups, list):
            raise TypeError("Expected argument 'managed_instance_groups' to be a list")
        pulumi.set(__self__, "managed_instance_groups", managed_instance_groups)
        if management_station_id and not isinstance(management_station_id, str):
            raise TypeError("Expected argument 'management_station_id' to be a str")
        pulumi.set(__self__, "management_station_id", management_station_id)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if profile_id and not isinstance(profile_id, str):
            raise TypeError("Expected argument 'profile_id' to be a str")
        pulumi.set(__self__, "profile_id", profile_id)
        if profile_type and not isinstance(profile_type, str):
            raise TypeError("Expected argument 'profile_type' to be a str")
        pulumi.set(__self__, "profile_type", profile_type)
        if profile_version and not isinstance(profile_version, str):
            raise TypeError("Expected argument 'profile_version' to be a str")
        pulumi.set(__self__, "profile_version", profile_version)
        if registration_type and not isinstance(registration_type, str):
            raise TypeError("Expected argument 'registration_type' to be a str")
        pulumi.set(__self__, "registration_type", registration_type)
        if software_sources and not isinstance(software_sources, list):
            raise TypeError("Expected argument 'software_sources' to be a list")
        pulumi.set(__self__, "software_sources", software_sources)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_modified and not isinstance(time_modified, str):
            raise TypeError("Expected argument 'time_modified' to be a str")
        pulumi.set(__self__, "time_modified", time_modified)
        if vendor_name and not isinstance(vendor_name, str):
            raise TypeError("Expected argument 'vendor_name' to be a str")
        pulumi.set(__self__, "vendor_name", vendor_name)

    @_builtins.property
    @pulumi.getter(name="archType")
    def arch_type(self) -> _builtins.str:
        """
        The architecture type.
        """
        return pulumi.get(self, "arch_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the registration profile.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Software source description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Software source name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefaultProfile")
    def is_default_profile(self) -> _builtins.bool:
        """
        Indicates if the profile is set as the default. There is exactly one default profile for a specified architecture, OS family, registration type, and vendor. When registering an instance with the corresonding characteristics, the default profile is used, unless another profile is specified.
        """
        return pulumi.get(self, "is_default_profile")

    @_builtins.property
    @pulumi.getter(name="isServiceProvidedProfile")
    def is_service_provided_profile(self) -> _builtins.bool:
        """
        Indicates if the profile was created by the service. OS Management Hub provides a limited set of standardized profiles that can be used to register Autonomous Linux or Windows instances.
        """
        return pulumi.get(self, "is_service_provided_profile")

    @_builtins.property
    @pulumi.getter(name="lifecycleEnvironments")
    def lifecycle_environments(self) -> Sequence['outputs.GetProfileVersionLifecycleEnvironmentResult']:
        """
        Provides identifying information for the specified lifecycle environment.
        """
        return pulumi.get(self, "lifecycle_environments")

    @_builtins.property
    @pulumi.getter(name="lifecycleStages")
    def lifecycle_stages(self) -> Sequence['outputs.GetProfileVersionLifecycleStageResult']:
        """
        Provides identifying information for the specified lifecycle stage.
        """
        return pulumi.get(self, "lifecycle_stages")

    @_builtins.property
    @pulumi.getter(name="managedInstanceGroups")
    def managed_instance_groups(self) -> Sequence['outputs.GetProfileVersionManagedInstanceGroupResult']:
        """
        Provides identifying information for the specified managed instance group.
        """
        return pulumi.get(self, "managed_instance_groups")

    @_builtins.property
    @pulumi.getter(name="managementStationId")
    def management_station_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station to associate with an  instance once registered. Management stations are only used with non-OCI instances.
        """
        return pulumi.get(self, "management_station_id")

    @_builtins.property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> _builtins.str:
        """
        The operating system family.
        """
        return pulumi.get(self, "os_family")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> _builtins.str:
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter(name="profileType")
    def profile_type(self) -> _builtins.str:
        """
        The type of profile.
        """
        return pulumi.get(self, "profile_type")

    @_builtins.property
    @pulumi.getter(name="profileVersion")
    def profile_version(self) -> _builtins.str:
        """
        The version of the profile.
        """
        return pulumi.get(self, "profile_version")

    @_builtins.property
    @pulumi.getter(name="registrationType")
    def registration_type(self) -> _builtins.str:
        """
        The type of instance to register.
        """
        return pulumi.get(self, "registration_type")

    @_builtins.property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> Sequence['outputs.GetProfileVersionSoftwareSourceResult']:
        """
        The list of software sources that the registration profile will use.
        """
        return pulumi.get(self, "software_sources")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the registration profile.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the registration profile was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> _builtins.str:
        """
        The time the registration profile was last modified (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_modified")

    @_builtins.property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> _builtins.str:
        """
        The vendor of the operating system for the instance.
        """
        return pulumi.get(self, "vendor_name")


class AwaitableGetProfileVersionResult(GetProfileVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProfileVersionResult(
            arch_type=self.arch_type,
            compartment_id=self.compartment_id,
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            is_default_profile=self.is_default_profile,
            is_service_provided_profile=self.is_service_provided_profile,
            lifecycle_environments=self.lifecycle_environments,
            lifecycle_stages=self.lifecycle_stages,
            managed_instance_groups=self.managed_instance_groups,
            management_station_id=self.management_station_id,
            os_family=self.os_family,
            profile_id=self.profile_id,
            profile_type=self.profile_type,
            profile_version=self.profile_version,
            registration_type=self.registration_type,
            software_sources=self.software_sources,
            state=self.state,
            time_created=self.time_created,
            time_modified=self.time_modified,
            vendor_name=self.vendor_name)


def get_profile_version(profile_id: Optional[_builtins.str] = None,
                        profile_version: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProfileVersionResult:
    """
    This data source provides details about a specific Profile Version resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns information about the version of the specified registration profile.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_profile_version = oci.OsManagementHub.get_profile_version(profile_id=test_profile["id"],
        profile_version=profile_version_profile_version)
    ```


    :param _builtins.str profile_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile.
    :param _builtins.str profile_version: The version of the registration profile.
    """
    __args__ = dict()
    __args__['profileId'] = profile_id
    __args__['profileVersion'] = profile_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getProfileVersion:getProfileVersion', __args__, opts=opts, typ=GetProfileVersionResult).value

    return AwaitableGetProfileVersionResult(
        arch_type=pulumi.get(__ret__, 'arch_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        is_default_profile=pulumi.get(__ret__, 'is_default_profile'),
        is_service_provided_profile=pulumi.get(__ret__, 'is_service_provided_profile'),
        lifecycle_environments=pulumi.get(__ret__, 'lifecycle_environments'),
        lifecycle_stages=pulumi.get(__ret__, 'lifecycle_stages'),
        managed_instance_groups=pulumi.get(__ret__, 'managed_instance_groups'),
        management_station_id=pulumi.get(__ret__, 'management_station_id'),
        os_family=pulumi.get(__ret__, 'os_family'),
        profile_id=pulumi.get(__ret__, 'profile_id'),
        profile_type=pulumi.get(__ret__, 'profile_type'),
        profile_version=pulumi.get(__ret__, 'profile_version'),
        registration_type=pulumi.get(__ret__, 'registration_type'),
        software_sources=pulumi.get(__ret__, 'software_sources'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_modified=pulumi.get(__ret__, 'time_modified'),
        vendor_name=pulumi.get(__ret__, 'vendor_name'))
def get_profile_version_output(profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                               profile_version: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProfileVersionResult]:
    """
    This data source provides details about a specific Profile Version resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns information about the version of the specified registration profile.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_profile_version = oci.OsManagementHub.get_profile_version(profile_id=test_profile["id"],
        profile_version=profile_version_profile_version)
    ```


    :param _builtins.str profile_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile.
    :param _builtins.str profile_version: The version of the registration profile.
    """
    __args__ = dict()
    __args__['profileId'] = profile_id
    __args__['profileVersion'] = profile_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getProfileVersion:getProfileVersion', __args__, opts=opts, typ=GetProfileVersionResult)
    return __ret__.apply(lambda __response__: GetProfileVersionResult(
        arch_type=pulumi.get(__response__, 'arch_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        is_default_profile=pulumi.get(__response__, 'is_default_profile'),
        is_service_provided_profile=pulumi.get(__response__, 'is_service_provided_profile'),
        lifecycle_environments=pulumi.get(__response__, 'lifecycle_environments'),
        lifecycle_stages=pulumi.get(__response__, 'lifecycle_stages'),
        managed_instance_groups=pulumi.get(__response__, 'managed_instance_groups'),
        management_station_id=pulumi.get(__response__, 'management_station_id'),
        os_family=pulumi.get(__response__, 'os_family'),
        profile_id=pulumi.get(__response__, 'profile_id'),
        profile_type=pulumi.get(__response__, 'profile_type'),
        profile_version=pulumi.get(__response__, 'profile_version'),
        registration_type=pulumi.get(__response__, 'registration_type'),
        software_sources=pulumi.get(__response__, 'software_sources'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_modified=pulumi.get(__response__, 'time_modified'),
        vendor_name=pulumi.get(__response__, 'vendor_name')))
