# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceGroupRemovePackagesManagementArgs', 'ManagedInstanceGroupRemovePackagesManagement']

@pulumi.input_type
class ManagedInstanceGroupRemovePackagesManagementArgs:
    def __init__(__self__, *,
                 managed_instance_group_id: pulumi.Input[_builtins.str],
                 package_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 work_request_details: Optional[pulumi.Input['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs']] = None):
        """
        The set of arguments for constructing a ManagedInstanceGroupRemovePackagesManagement resource.
        :param pulumi.Input[_builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] package_names: The list of package names.
        :param pulumi.Input['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        pulumi.set(__self__, "package_names", package_names)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @_builtins.property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "managed_instance_group_id", value)

    @_builtins.property
    @pulumi.getter(name="packageNames")
    def package_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of package names.
        """
        return pulumi.get(self, "package_names")

    @package_names.setter
    def package_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "package_names", value)

    @_builtins.property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.input_type
class _ManagedInstanceGroupRemovePackagesManagementState:
    def __init__(__self__, *,
                 managed_instance_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 package_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceGroupRemovePackagesManagement resources.
        :param pulumi.Input[_builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] package_names: The list of package names.
        :param pulumi.Input['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        if managed_instance_group_id is not None:
            pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if package_names is not None:
            pulumi.set(__self__, "package_names", package_names)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @_builtins.property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_instance_group_id", value)

    @_builtins.property
    @pulumi.getter(name="packageNames")
    def package_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of package names.
        """
        return pulumi.get(self, "package_names")

    @package_names.setter
    def package_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "package_names", value)

    @_builtins.property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.type_token("oci:OsManagementHub/managedInstanceGroupRemovePackagesManagement:ManagedInstanceGroupRemovePackagesManagement")
class ManagedInstanceGroupRemovePackagesManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 package_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance Group Remove Packages Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Removes the specified packages from each managed instance in a managed instance group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_remove_packages_management = oci.osmanagementhub.ManagedInstanceGroupRemovePackagesManagement("test_managed_instance_group_remove_packages_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            package_names=managed_instance_group_remove_packages_management_package_names,
            work_request_details={
                "description": managed_instance_group_remove_packages_management_work_request_details_description,
                "display_name": managed_instance_group_remove_packages_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceGroupRemovePackagesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupRemovePackagesManagement:ManagedInstanceGroupRemovePackagesManagement test_managed_instance_group_remove_packages_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] package_names: The list of package names.
        :param pulumi.Input[Union['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceGroupRemovePackagesManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance Group Remove Packages Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Removes the specified packages from each managed instance in a managed instance group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_remove_packages_management = oci.osmanagementhub.ManagedInstanceGroupRemovePackagesManagement("test_managed_instance_group_remove_packages_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            package_names=managed_instance_group_remove_packages_management_package_names,
            work_request_details={
                "description": managed_instance_group_remove_packages_management_work_request_details_description,
                "display_name": managed_instance_group_remove_packages_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceGroupRemovePackagesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupRemovePackagesManagement:ManagedInstanceGroupRemovePackagesManagement test_managed_instance_group_remove_packages_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceGroupRemovePackagesManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceGroupRemovePackagesManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 package_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceGroupRemovePackagesManagementArgs.__new__(ManagedInstanceGroupRemovePackagesManagementArgs)

            if managed_instance_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_group_id'")
            __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
            if package_names is None and not opts.urn:
                raise TypeError("Missing required property 'package_names'")
            __props__.__dict__["package_names"] = package_names
            __props__.__dict__["work_request_details"] = work_request_details
        super(ManagedInstanceGroupRemovePackagesManagement, __self__).__init__(
            'oci:OsManagementHub/managedInstanceGroupRemovePackagesManagement:ManagedInstanceGroupRemovePackagesManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            managed_instance_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            package_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgsDict']]] = None) -> 'ManagedInstanceGroupRemovePackagesManagement':
        """
        Get an existing ManagedInstanceGroupRemovePackagesManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] package_names: The list of package names.
        :param pulumi.Input[Union['ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupRemovePackagesManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceGroupRemovePackagesManagementState.__new__(_ManagedInstanceGroupRemovePackagesManagementState)

        __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
        __props__.__dict__["package_names"] = package_names
        __props__.__dict__["work_request_details"] = work_request_details
        return ManagedInstanceGroupRemovePackagesManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @_builtins.property
    @pulumi.getter(name="packageNames")
    def package_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of package names.
        """
        return pulumi.get(self, "package_names")

    @_builtins.property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> pulumi.Output['outputs.ManagedInstanceGroupRemovePackagesManagementWorkRequestDetails']:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

