# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDefaultConfigurationsResult',
    'AwaitableGetDefaultConfigurationsResult',
    'get_default_configurations',
    'get_default_configurations_output',
]

@pulumi.output_type
class GetDefaultConfigurationsResult:
    """
    A collection of values returned by getDefaultConfigurations.
    """
    def __init__(__self__, configuration_id=None, db_version=None, default_configuration_collections=None, display_name=None, filters=None, id=None, instance_memory_size_in_gbs=None, instance_ocpu_count=None, shape=None, state=None):
        if configuration_id and not isinstance(configuration_id, str):
            raise TypeError("Expected argument 'configuration_id' to be a str")
        pulumi.set(__self__, "configuration_id", configuration_id)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if default_configuration_collections and not isinstance(default_configuration_collections, list):
            raise TypeError("Expected argument 'default_configuration_collections' to be a list")
        pulumi.set(__self__, "default_configuration_collections", default_configuration_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_memory_size_in_gbs and not isinstance(instance_memory_size_in_gbs, int):
            raise TypeError("Expected argument 'instance_memory_size_in_gbs' to be a int")
        pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        if instance_ocpu_count and not isinstance(instance_ocpu_count, int):
            raise TypeError("Expected argument 'instance_ocpu_count' to be a int")
        pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[_builtins.str]:
        """
        Version of the PostgreSQL database.
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter(name="defaultConfigurationCollections")
    def default_configuration_collections(self) -> Sequence['outputs.GetDefaultConfigurationsDefaultConfigurationCollectionResult']:
        """
        The list of default_configuration_collection.
        """
        return pulumi.get(self, "default_configuration_collections")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly display name for the configuration.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDefaultConfigurationsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> Optional[_builtins.int]:
        """
        Memory size in gigabytes with 1GB increment.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> Optional[_builtins.int]:
        """
        CPU core count.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> _builtins.str:
        """
        The name of the shape for the configuration.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the configuration.
        """
        return pulumi.get(self, "state")


class AwaitableGetDefaultConfigurationsResult(GetDefaultConfigurationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDefaultConfigurationsResult(
            configuration_id=self.configuration_id,
            db_version=self.db_version,
            default_configuration_collections=self.default_configuration_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            instance_memory_size_in_gbs=self.instance_memory_size_in_gbs,
            instance_ocpu_count=self.instance_ocpu_count,
            shape=self.shape,
            state=self.state)


def get_default_configurations(configuration_id: Optional[_builtins.str] = None,
                               db_version: Optional[_builtins.str] = None,
                               display_name: Optional[_builtins.str] = None,
                               filters: Optional[Sequence[Union['GetDefaultConfigurationsFilterArgs', 'GetDefaultConfigurationsFilterArgsDict']]] = None,
                               instance_memory_size_in_gbs: Optional[_builtins.int] = None,
                               instance_ocpu_count: Optional[_builtins.int] = None,
                               shape: Optional[_builtins.str] = None,
                               state: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDefaultConfigurationsResult:
    """
    This data source provides the list of Default Configurations in Oracle Cloud Infrastructure Psql service.

    Returns a list of default configurations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_default_configurations = oci.Psql.get_default_configurations(configuration_id=test_configuration["id"],
        db_version=default_configuration_db_version,
        display_name=default_configuration_display_name,
        instance_memory_size_in_gbs=default_configuration_instance_memory_size_in_gbs,
        instance_ocpu_count=default_configuration_instance_ocpu_count,
        shape=default_configuration_shape,
        state=default_configuration_state)
    ```


    :param _builtins.str configuration_id: A unique identifier for the configuration.
    :param _builtins.str db_version: Version of the PostgreSQL database, such as 14.9.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.int instance_memory_size_in_gbs: The instance memory size in GBs for the configuration.
    :param _builtins.int instance_ocpu_count: The instance ocpu count for the configuration.
    :param _builtins.str shape: The compute name of the shape for the configuration.
    :param _builtins.str state: A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
    """
    __args__ = dict()
    __args__['configurationId'] = configuration_id
    __args__['dbVersion'] = db_version
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['instanceMemorySizeInGbs'] = instance_memory_size_in_gbs
    __args__['instanceOcpuCount'] = instance_ocpu_count
    __args__['shape'] = shape
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Psql/getDefaultConfigurations:getDefaultConfigurations', __args__, opts=opts, typ=GetDefaultConfigurationsResult).value

    return AwaitableGetDefaultConfigurationsResult(
        configuration_id=pulumi.get(__ret__, 'configuration_id'),
        db_version=pulumi.get(__ret__, 'db_version'),
        default_configuration_collections=pulumi.get(__ret__, 'default_configuration_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instance_memory_size_in_gbs=pulumi.get(__ret__, 'instance_memory_size_in_gbs'),
        instance_ocpu_count=pulumi.get(__ret__, 'instance_ocpu_count'),
        shape=pulumi.get(__ret__, 'shape'),
        state=pulumi.get(__ret__, 'state'))
def get_default_configurations_output(configuration_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      db_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDefaultConfigurationsFilterArgs', 'GetDefaultConfigurationsFilterArgsDict']]]]] = None,
                                      instance_memory_size_in_gbs: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                      instance_ocpu_count: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                      shape: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDefaultConfigurationsResult]:
    """
    This data source provides the list of Default Configurations in Oracle Cloud Infrastructure Psql service.

    Returns a list of default configurations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_default_configurations = oci.Psql.get_default_configurations(configuration_id=test_configuration["id"],
        db_version=default_configuration_db_version,
        display_name=default_configuration_display_name,
        instance_memory_size_in_gbs=default_configuration_instance_memory_size_in_gbs,
        instance_ocpu_count=default_configuration_instance_ocpu_count,
        shape=default_configuration_shape,
        state=default_configuration_state)
    ```


    :param _builtins.str configuration_id: A unique identifier for the configuration.
    :param _builtins.str db_version: Version of the PostgreSQL database, such as 14.9.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.int instance_memory_size_in_gbs: The instance memory size in GBs for the configuration.
    :param _builtins.int instance_ocpu_count: The instance ocpu count for the configuration.
    :param _builtins.str shape: The compute name of the shape for the configuration.
    :param _builtins.str state: A filter to return only resources if their `lifecycleState` matches the given `lifecycleState`.
    """
    __args__ = dict()
    __args__['configurationId'] = configuration_id
    __args__['dbVersion'] = db_version
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['instanceMemorySizeInGbs'] = instance_memory_size_in_gbs
    __args__['instanceOcpuCount'] = instance_ocpu_count
    __args__['shape'] = shape
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Psql/getDefaultConfigurations:getDefaultConfigurations', __args__, opts=opts, typ=GetDefaultConfigurationsResult)
    return __ret__.apply(lambda __response__: GetDefaultConfigurationsResult(
        configuration_id=pulumi.get(__response__, 'configuration_id'),
        db_version=pulumi.get(__response__, 'db_version'),
        default_configuration_collections=pulumi.get(__response__, 'default_configuration_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        instance_memory_size_in_gbs=pulumi.get(__response__, 'instance_memory_size_in_gbs'),
        instance_ocpu_count=pulumi.get(__response__, 'instance_ocpu_count'),
        shape=pulumi.get(__response__, 'shape'),
        state=pulumi.get(__response__, 'state')))
