# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOciCacheUserResult',
    'AwaitableGetOciCacheUserResult',
    'get_oci_cache_user',
    'get_oci_cache_user_output',
]

@pulumi.output_type
class GetOciCacheUserResult:
    """
    A collection of values returned by getOciCacheUser.
    """
    def __init__(__self__, acl_string=None, authentication_modes=None, compartment_id=None, defined_tags=None, description=None, freeform_tags=None, id=None, name=None, oci_cache_user_id=None, state=None, status=None, system_tags=None, time_created=None, time_updated=None):
        if acl_string and not isinstance(acl_string, str):
            raise TypeError("Expected argument 'acl_string' to be a str")
        pulumi.set(__self__, "acl_string", acl_string)
        if authentication_modes and not isinstance(authentication_modes, list):
            raise TypeError("Expected argument 'authentication_modes' to be a list")
        pulumi.set(__self__, "authentication_modes", authentication_modes)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if oci_cache_user_id and not isinstance(oci_cache_user_id, str):
            raise TypeError("Expected argument 'oci_cache_user_id' to be a str")
        pulumi.set(__self__, "oci_cache_user_id", oci_cache_user_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="aclString")
    def acl_string(self) -> _builtins.str:
        """
        ACL string of Oracle Cloud Infrastructure cache user.
        """
        return pulumi.get(self, "acl_string")

    @_builtins.property
    @pulumi.getter(name="authenticationModes")
    def authentication_modes(self) -> Sequence['outputs.GetOciCacheUserAuthenticationModeResult']:
        """
        These are the Authentication details of an Oracle Cloud Infrastructure cache user.
        """
        return pulumi.get(self, "authentication_modes")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Oracle Cloud Infrastructure Cache user compartment ID.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of Oracle Cloud Infrastructure cache user.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Oracle Cloud Infrastructure Cache user unique ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Oracle Cloud Infrastructure Cache user name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ociCacheUserId")
    def oci_cache_user_id(self) -> _builtins.str:
        return pulumi.get(self, "oci_cache_user_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Oracle Cloud Infrastructure Cache user lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Oracle Cloud Infrastructure Cache user status. ON enables and OFF disables the Oracle Cloud Infrastructure cache user to login to the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time, when the Oracle Cloud Infrastructure cache user was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time, when the Oracle Cloud Infrastructure cache user was updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetOciCacheUserResult(GetOciCacheUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOciCacheUserResult(
            acl_string=self.acl_string,
            authentication_modes=self.authentication_modes,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            name=self.name,
            oci_cache_user_id=self.oci_cache_user_id,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_oci_cache_user(oci_cache_user_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOciCacheUserResult:
    """
    This data source provides details about a specific Oci Cache User resource in Oracle Cloud Infrastructure Redis service.

    Get an existing Oracle Cloud Infrastructure Cache users based on the ID (OCID).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oci_cache_user = oci.Redis.get_oci_cache_user(oci_cache_user_id=test_oci_cache_user_oci_redis_oci_cache_user["id"])
    ```


    :param _builtins.str oci_cache_user_id: A filter to return only resources, that match with the given Oracle Cloud Infrastructure cache user ID (OCID).
    """
    __args__ = dict()
    __args__['ociCacheUserId'] = oci_cache_user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Redis/getOciCacheUser:getOciCacheUser', __args__, opts=opts, typ=GetOciCacheUserResult).value

    return AwaitableGetOciCacheUserResult(
        acl_string=pulumi.get(__ret__, 'acl_string'),
        authentication_modes=pulumi.get(__ret__, 'authentication_modes'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        oci_cache_user_id=pulumi.get(__ret__, 'oci_cache_user_id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_oci_cache_user_output(oci_cache_user_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOciCacheUserResult]:
    """
    This data source provides details about a specific Oci Cache User resource in Oracle Cloud Infrastructure Redis service.

    Get an existing Oracle Cloud Infrastructure Cache users based on the ID (OCID).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oci_cache_user = oci.Redis.get_oci_cache_user(oci_cache_user_id=test_oci_cache_user_oci_redis_oci_cache_user["id"])
    ```


    :param _builtins.str oci_cache_user_id: A filter to return only resources, that match with the given Oracle Cloud Infrastructure cache user ID (OCID).
    """
    __args__ = dict()
    __args__['ociCacheUserId'] = oci_cache_user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Redis/getOciCacheUser:getOciCacheUser', __args__, opts=opts, typ=GetOciCacheUserResult)
    return __ret__.apply(lambda __response__: GetOciCacheUserResult(
        acl_string=pulumi.get(__response__, 'acl_string'),
        authentication_modes=pulumi.get(__response__, 'authentication_modes'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        oci_cache_user_id=pulumi.get(__response__, 'oci_cache_user_id'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
