# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDefinedMonitoringTemplatesResult',
    'AwaitableGetDefinedMonitoringTemplatesResult',
    'get_defined_monitoring_templates',
    'get_defined_monitoring_templates_output',
]

@pulumi.output_type
class GetDefinedMonitoringTemplatesResult:
    """
    A collection of values returned by getDefinedMonitoringTemplates.
    """
    def __init__(__self__, compartment_id=None, defined_monitoring_template_collections=None, display_name=None, filters=None, id=None, resource_types=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_monitoring_template_collections and not isinstance(defined_monitoring_template_collections, list):
            raise TypeError("Expected argument 'defined_monitoring_template_collections' to be a list")
        pulumi.set(__self__, "defined_monitoring_template_collections", defined_monitoring_template_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_types and not isinstance(resource_types, list):
            raise TypeError("Expected argument 'resource_types' to be a list")
        pulumi.set(__self__, "resource_types", resource_types)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedMonitoringTemplateCollections")
    def defined_monitoring_template_collections(self) -> Sequence['outputs.GetDefinedMonitoringTemplatesDefinedMonitoringTemplateCollectionResult']:
        """
        The list of defined_monitoring_template_collection.
        """
        return pulumi.get(self, "defined_monitoring_template_collections")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The name of the definedMonitoringTemplate.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDefinedMonitoringTemplatesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "resource_types")


class AwaitableGetDefinedMonitoringTemplatesResult(GetDefinedMonitoringTemplatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDefinedMonitoringTemplatesResult(
            compartment_id=self.compartment_id,
            defined_monitoring_template_collections=self.defined_monitoring_template_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            resource_types=self.resource_types)


def get_defined_monitoring_templates(compartment_id: Optional[_builtins.str] = None,
                                     display_name: Optional[_builtins.str] = None,
                                     filters: Optional[Sequence[Union['GetDefinedMonitoringTemplatesFilterArgs', 'GetDefinedMonitoringTemplatesFilterArgsDict']]] = None,
                                     resource_types: Optional[Sequence[_builtins.str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDefinedMonitoringTemplatesResult:
    """
    This data source provides the list of Defined Monitoring Templates in Oracle Cloud Infrastructure Stack Monitoring service.

    List Defined Monitoring Templates.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_defined_monitoring_templates = oci.StackMonitoring.get_defined_monitoring_templates(compartment_id=compartment_id,
        display_name=defined_monitoring_template_display_name,
        resource_types=defined_monitoring_template_resource_types)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy(root) for which  defined monitored templates should be listed.
    :param _builtins.str display_name: A filter to return monitoring template based on name.
    :param Sequence[_builtins.str] resource_types: Multiple resource types filter.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceTypes'] = resource_types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getDefinedMonitoringTemplates:getDefinedMonitoringTemplates', __args__, opts=opts, typ=GetDefinedMonitoringTemplatesResult).value

    return AwaitableGetDefinedMonitoringTemplatesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_monitoring_template_collections=pulumi.get(__ret__, 'defined_monitoring_template_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resource_types=pulumi.get(__ret__, 'resource_types'))
def get_defined_monitoring_templates_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDefinedMonitoringTemplatesFilterArgs', 'GetDefinedMonitoringTemplatesFilterArgsDict']]]]] = None,
                                            resource_types: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDefinedMonitoringTemplatesResult]:
    """
    This data source provides the list of Defined Monitoring Templates in Oracle Cloud Infrastructure Stack Monitoring service.

    List Defined Monitoring Templates.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_defined_monitoring_templates = oci.StackMonitoring.get_defined_monitoring_templates(compartment_id=compartment_id,
        display_name=defined_monitoring_template_display_name,
        resource_types=defined_monitoring_template_resource_types)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy(root) for which  defined monitored templates should be listed.
    :param _builtins.str display_name: A filter to return monitoring template based on name.
    :param Sequence[_builtins.str] resource_types: Multiple resource types filter.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceTypes'] = resource_types
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getDefinedMonitoringTemplates:getDefinedMonitoringTemplates', __args__, opts=opts, typ=GetDefinedMonitoringTemplatesResult)
    return __ret__.apply(lambda __response__: GetDefinedMonitoringTemplatesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_monitoring_template_collections=pulumi.get(__response__, 'defined_monitoring_template_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        resource_types=pulumi.get(__response__, 'resource_types')))
