# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSubscriptionRedeemableUserResult',
    'AwaitableGetSubscriptionRedeemableUserResult',
    'get_subscription_redeemable_user',
    'get_subscription_redeemable_user_output',
]

@pulumi.output_type
class GetSubscriptionRedeemableUserResult:
    """
    A collection of values returned by getSubscriptionRedeemableUser.
    """
    def __init__(__self__, id=None, items=None, subscription_id=None, tenancy_id=None, user_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if tenancy_id and not isinstance(tenancy_id, str):
            raise TypeError("Expected argument 'tenancy_id' to be a str")
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedeemableUserItemResult']:
        """
        The list of user summary that can redeem rewards.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> _builtins.str:
        return pulumi.get(self, "tenancy_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        return pulumi.get(self, "user_id")


class AwaitableGetSubscriptionRedeemableUserResult(GetSubscriptionRedeemableUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionRedeemableUserResult(
            id=self.id,
            items=self.items,
            subscription_id=self.subscription_id,
            tenancy_id=self.tenancy_id,
            user_id=self.user_id)


def get_subscription_redeemable_user(subscription_id: Optional[_builtins.str] = None,
                                     tenancy_id: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionRedeemableUserResult:
    """
    This data source provides details about a specific Subscription Redeemable User resource in Oracle Cloud Infrastructure Usage Proxy service.

    Provides the list of user summary that can redeem rewards for the given subscription ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription_redeemable_user = oci.UsageProxy.get_subscription_redeemable_user(subscription_id=test_subscription["id"],
        tenancy_id=test_tenancy["id"])
    ```


    :param _builtins.str subscription_id: The subscription ID for which rewards information is requested for.
    :param _builtins.str tenancy_id: The OCID of the tenancy.
    """
    __args__ = dict()
    __args__['subscriptionId'] = subscription_id
    __args__['tenancyId'] = tenancy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:UsageProxy/getSubscriptionRedeemableUser:getSubscriptionRedeemableUser', __args__, opts=opts, typ=GetSubscriptionRedeemableUserResult).value

    return AwaitableGetSubscriptionRedeemableUserResult(
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        tenancy_id=pulumi.get(__ret__, 'tenancy_id'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_subscription_redeemable_user_output(subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            tenancy_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubscriptionRedeemableUserResult]:
    """
    This data source provides details about a specific Subscription Redeemable User resource in Oracle Cloud Infrastructure Usage Proxy service.

    Provides the list of user summary that can redeem rewards for the given subscription ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription_redeemable_user = oci.UsageProxy.get_subscription_redeemable_user(subscription_id=test_subscription["id"],
        tenancy_id=test_tenancy["id"])
    ```


    :param _builtins.str subscription_id: The subscription ID for which rewards information is requested for.
    :param _builtins.str tenancy_id: The OCID of the tenancy.
    """
    __args__ = dict()
    __args__['subscriptionId'] = subscription_id
    __args__['tenancyId'] = tenancy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:UsageProxy/getSubscriptionRedeemableUser:getSubscriptionRedeemableUser', __args__, opts=opts, typ=GetSubscriptionRedeemableUserResult)
    return __ret__.apply(lambda __response__: GetSubscriptionRedeemableUserResult(
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        tenancy_id=pulumi.get(__response__, 'tenancy_id'),
        user_id=pulumi.get(__response__, 'user_id')))
