# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecretArgs', 'Secret']

@pulumi.input_type
class SecretArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 key_id: pulumi.Input[_builtins.str],
                 secret_name: pulumi.Input[_builtins.str],
                 vault_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_auto_generation: Optional[pulumi.Input[_builtins.bool]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 replication_config: Optional[pulumi.Input['SecretReplicationConfigArgs']] = None,
                 rotation_config: Optional[pulumi.Input['SecretRotationConfigArgs']] = None,
                 secret_content: Optional[pulumi.Input['SecretSecretContentArgs']] = None,
                 secret_generation_context: Optional[pulumi.Input['SecretSecretGenerationContextArgs']] = None,
                 secret_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SecretSecretRuleArgs']]]] = None):
        """
        The set of arguments for constructing a Secret resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create the secret.
        :param pulumi.Input[_builtins.str] key_id: The OCID of the master encryption key that is used to encrypt the secret. You must specify a symmetric key to encrypt the secret during import to the vault. You cannot encrypt secrets with asymmetric keys. Furthermore, the key must exist in the vault that you specify.
        :param pulumi.Input[_builtins.str] secret_name: A user-friendly name for the secret. Secret names should be unique within a vault. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        :param pulumi.Input[_builtins.str] vault_id: The OCID of the vault where you want to create the secret.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A brief description of the secret. Avoid entering confidential information.
        :param pulumi.Input[_builtins.bool] enable_auto_generation: (Updatable) The value of this flag determines whether or not secret content will be generated automatically. If not set, it defaults to false.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: (Updatable) Additional metadata that you can use to provide context about how to use the secret during rotation or other administrative tasks. For example, for a secret that you use to connect to a database, the additional metadata might specify the connection endpoint and the connection string. Provide additional metadata as key-value pairs.
        :param pulumi.Input['SecretReplicationConfigArgs'] replication_config: (Updatable) Defines the configuration that enables cross-region secret replication.
        :param pulumi.Input['SecretRotationConfigArgs'] rotation_config: (Updatable) Defines the frequency of the rotation and the information about the target system
        :param pulumi.Input['SecretSecretContentArgs'] secret_content: (Updatable) The content of the secret and metadata to help identify it.
        :param pulumi.Input['SecretSecretGenerationContextArgs'] secret_generation_context: (Updatable) Captures a configurable set of secret generation rules such as length, base characters, additional characters, and so on.
        :param pulumi.Input[Sequence[pulumi.Input['SecretSecretRuleArgs']]] secret_rules: (Updatable) A list of rules to control how the secret is used and managed.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "vault_id", vault_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_auto_generation is not None:
            pulumi.set(__self__, "enable_auto_generation", enable_auto_generation)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if replication_config is not None:
            pulumi.set(__self__, "replication_config", replication_config)
        if rotation_config is not None:
            pulumi.set(__self__, "rotation_config", rotation_config)
        if secret_content is not None:
            pulumi.set(__self__, "secret_content", secret_content)
        if secret_generation_context is not None:
            pulumi.set(__self__, "secret_generation_context", secret_generation_context)
        if secret_rules is not None:
            pulumi.set(__self__, "secret_rules", secret_rules)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where you want to create the secret.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the master encryption key that is used to encrypt the secret. You must specify a symmetric key to encrypt the secret during import to the vault. You cannot encrypt secrets with asymmetric keys. Furthermore, the key must exist in the vault that you specify.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[_builtins.str]:
        """
        A user-friendly name for the secret. Secret names should be unique within a vault. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the vault where you want to create the secret.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A brief description of the secret. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableAutoGeneration")
    def enable_auto_generation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) The value of this flag determines whether or not secret content will be generated automatically. If not set, it defaults to false.
        """
        return pulumi.get(self, "enable_auto_generation")

    @enable_auto_generation.setter
    def enable_auto_generation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_auto_generation", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Additional metadata that you can use to provide context about how to use the secret during rotation or other administrative tasks. For example, for a secret that you use to connect to a database, the additional metadata might specify the connection endpoint and the connection string. Provide additional metadata as key-value pairs.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="replicationConfig")
    def replication_config(self) -> Optional[pulumi.Input['SecretReplicationConfigArgs']]:
        """
        (Updatable) Defines the configuration that enables cross-region secret replication.
        """
        return pulumi.get(self, "replication_config")

    @replication_config.setter
    def replication_config(self, value: Optional[pulumi.Input['SecretReplicationConfigArgs']]):
        pulumi.set(self, "replication_config", value)

    @_builtins.property
    @pulumi.getter(name="rotationConfig")
    def rotation_config(self) -> Optional[pulumi.Input['SecretRotationConfigArgs']]:
        """
        (Updatable) Defines the frequency of the rotation and the information about the target system
        """
        return pulumi.get(self, "rotation_config")

    @rotation_config.setter
    def rotation_config(self, value: Optional[pulumi.Input['SecretRotationConfigArgs']]):
        pulumi.set(self, "rotation_config", value)

    @_builtins.property
    @pulumi.getter(name="secretContent")
    def secret_content(self) -> Optional[pulumi.Input['SecretSecretContentArgs']]:
        """
        (Updatable) The content of the secret and metadata to help identify it.
        """
        return pulumi.get(self, "secret_content")

    @secret_content.setter
    def secret_content(self, value: Optional[pulumi.Input['SecretSecretContentArgs']]):
        pulumi.set(self, "secret_content", value)

    @_builtins.property
    @pulumi.getter(name="secretGenerationContext")
    def secret_generation_context(self) -> Optional[pulumi.Input['SecretSecretGenerationContextArgs']]:
        """
        (Updatable) Captures a configurable set of secret generation rules such as length, base characters, additional characters, and so on.
        """
        return pulumi.get(self, "secret_generation_context")

    @secret_generation_context.setter
    def secret_generation_context(self, value: Optional[pulumi.Input['SecretSecretGenerationContextArgs']]):
        pulumi.set(self, "secret_generation_context", value)

    @_builtins.property
    @pulumi.getter(name="secretRules")
    def secret_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretSecretRuleArgs']]]]:
        """
        (Updatable) A list of rules to control how the secret is used and managed.
        """
        return pulumi.get(self, "secret_rules")

    @secret_rules.setter
    def secret_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretSecretRuleArgs']]]]):
        pulumi.set(self, "secret_rules", value)


@pulumi.input_type
class _SecretState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 current_version_number: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_auto_generation: Optional[pulumi.Input[_builtins.bool]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_auto_generation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_replica: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_rotation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 next_rotation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_config: Optional[pulumi.Input['SecretReplicationConfigArgs']] = None,
                 rotation_config: Optional[pulumi.Input['SecretRotationConfigArgs']] = None,
                 rotation_status: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_content: Optional[pulumi.Input['SecretSecretContentArgs']] = None,
                 secret_generation_context: Optional[pulumi.Input['SecretSecretGenerationContextArgs']] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SecretSecretRuleArgs']]]] = None,
                 source_region_informations: Optional[pulumi.Input[Sequence[pulumi.Input['SecretSourceRegionInformationArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_of_current_version_expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Secret resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create the secret.
        :param pulumi.Input[_builtins.str] current_version_number: The version number of the secret version that's currently in use.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A brief description of the secret. Avoid entering confidential information.
        :param pulumi.Input[_builtins.bool] enable_auto_generation: (Updatable) The value of this flag determines whether or not secret content will be generated automatically. If not set, it defaults to false.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_auto_generation_enabled: The value of this flag determines whether or not secret content will be generated automatically.
        :param pulumi.Input[_builtins.bool] is_replica: A Boolean value that indicates whether the secret is a source or replica secret.
        :param pulumi.Input[_builtins.str] key_id: The OCID of the master encryption key that is used to encrypt the secret. You must specify a symmetric key to encrypt the secret during import to the vault. You cannot encrypt secrets with asymmetric keys. Furthermore, the key must exist in the vault that you specify.
        :param pulumi.Input[_builtins.str] last_rotation_time: A property indicating when the secret was last rotated successfully, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state of the secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: (Updatable) Additional metadata that you can use to provide context about how to use the secret during rotation or other administrative tasks. For example, for a secret that you use to connect to a database, the additional metadata might specify the connection endpoint and the connection string. Provide additional metadata as key-value pairs.
        :param pulumi.Input[_builtins.str] next_rotation_time: A property indicating when the secret is scheduled to be rotated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input['SecretReplicationConfigArgs'] replication_config: (Updatable) Defines the configuration that enables cross-region secret replication.
        :param pulumi.Input['SecretRotationConfigArgs'] rotation_config: (Updatable) Defines the frequency of the rotation and the information about the target system
        :param pulumi.Input[_builtins.str] rotation_status: Additional information about the status of the secret rotation
        :param pulumi.Input['SecretSecretContentArgs'] secret_content: (Updatable) The content of the secret and metadata to help identify it.
        :param pulumi.Input['SecretSecretGenerationContextArgs'] secret_generation_context: (Updatable) Captures a configurable set of secret generation rules such as length, base characters, additional characters, and so on.
        :param pulumi.Input[_builtins.str] secret_name: A user-friendly name for the secret. Secret names should be unique within a vault. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        :param pulumi.Input[Sequence[pulumi.Input['SecretSecretRuleArgs']]] secret_rules: (Updatable) A list of rules to control how the secret is used and managed.
        :param pulumi.Input[Sequence[pulumi.Input['SecretSourceRegionInformationArgs']]] source_region_informations: Details for the source that the source secret has.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the secret.
        :param pulumi.Input[_builtins.str] time_created: A property indicating when the secret was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_of_current_version_expiry: An optional property indicating when the current secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_of_deletion: An optional property indicating when to delete the secret, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] vault_id: The OCID of the vault where you want to create the secret.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if current_version_number is not None:
            pulumi.set(__self__, "current_version_number", current_version_number)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_auto_generation is not None:
            pulumi.set(__self__, "enable_auto_generation", enable_auto_generation)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_generation_enabled is not None:
            pulumi.set(__self__, "is_auto_generation_enabled", is_auto_generation_enabled)
        if is_replica is not None:
            pulumi.set(__self__, "is_replica", is_replica)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if last_rotation_time is not None:
            pulumi.set(__self__, "last_rotation_time", last_rotation_time)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if next_rotation_time is not None:
            pulumi.set(__self__, "next_rotation_time", next_rotation_time)
        if replication_config is not None:
            pulumi.set(__self__, "replication_config", replication_config)
        if rotation_config is not None:
            pulumi.set(__self__, "rotation_config", rotation_config)
        if rotation_status is not None:
            pulumi.set(__self__, "rotation_status", rotation_status)
        if secret_content is not None:
            pulumi.set(__self__, "secret_content", secret_content)
        if secret_generation_context is not None:
            pulumi.set(__self__, "secret_generation_context", secret_generation_context)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if secret_rules is not None:
            pulumi.set(__self__, "secret_rules", secret_rules)
        if source_region_informations is not None:
            pulumi.set(__self__, "source_region_informations", source_region_informations)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_of_current_version_expiry is not None:
            pulumi.set(__self__, "time_of_current_version_expiry", time_of_current_version_expiry)
        if time_of_deletion is not None:
            pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment where you want to create the secret.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="currentVersionNumber")
    def current_version_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version number of the secret version that's currently in use.
        """
        return pulumi.get(self, "current_version_number")

    @current_version_number.setter
    def current_version_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_version_number", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A brief description of the secret. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableAutoGeneration")
    def enable_auto_generation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) The value of this flag determines whether or not secret content will be generated automatically. If not set, it defaults to false.
        """
        return pulumi.get(self, "enable_auto_generation")

    @enable_auto_generation.setter
    def enable_auto_generation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_auto_generation", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isAutoGenerationEnabled")
    def is_auto_generation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The value of this flag determines whether or not secret content will be generated automatically.
        """
        return pulumi.get(self, "is_auto_generation_enabled")

    @is_auto_generation_enabled.setter
    def is_auto_generation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_generation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isReplica")
    def is_replica(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A Boolean value that indicates whether the secret is a source or replica secret.
        """
        return pulumi.get(self, "is_replica")

    @is_replica.setter
    def is_replica(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_replica", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the master encryption key that is used to encrypt the secret. You must specify a symmetric key to encrypt the secret during import to the vault. You cannot encrypt secrets with asymmetric keys. Furthermore, the key must exist in the vault that you specify.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="lastRotationTime")
    def last_rotation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A property indicating when the secret was last rotated successfully, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "last_rotation_time")

    @last_rotation_time.setter
    def last_rotation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_rotation_time", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current lifecycle state of the secret.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Additional metadata that you can use to provide context about how to use the secret during rotation or other administrative tasks. For example, for a secret that you use to connect to a database, the additional metadata might specify the connection endpoint and the connection string. Provide additional metadata as key-value pairs.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="nextRotationTime")
    def next_rotation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A property indicating when the secret is scheduled to be rotated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "next_rotation_time")

    @next_rotation_time.setter
    def next_rotation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_rotation_time", value)

    @_builtins.property
    @pulumi.getter(name="replicationConfig")
    def replication_config(self) -> Optional[pulumi.Input['SecretReplicationConfigArgs']]:
        """
        (Updatable) Defines the configuration that enables cross-region secret replication.
        """
        return pulumi.get(self, "replication_config")

    @replication_config.setter
    def replication_config(self, value: Optional[pulumi.Input['SecretReplicationConfigArgs']]):
        pulumi.set(self, "replication_config", value)

    @_builtins.property
    @pulumi.getter(name="rotationConfig")
    def rotation_config(self) -> Optional[pulumi.Input['SecretRotationConfigArgs']]:
        """
        (Updatable) Defines the frequency of the rotation and the information about the target system
        """
        return pulumi.get(self, "rotation_config")

    @rotation_config.setter
    def rotation_config(self, value: Optional[pulumi.Input['SecretRotationConfigArgs']]):
        pulumi.set(self, "rotation_config", value)

    @_builtins.property
    @pulumi.getter(name="rotationStatus")
    def rotation_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the status of the secret rotation
        """
        return pulumi.get(self, "rotation_status")

    @rotation_status.setter
    def rotation_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_status", value)

    @_builtins.property
    @pulumi.getter(name="secretContent")
    def secret_content(self) -> Optional[pulumi.Input['SecretSecretContentArgs']]:
        """
        (Updatable) The content of the secret and metadata to help identify it.
        """
        return pulumi.get(self, "secret_content")

    @secret_content.setter
    def secret_content(self, value: Optional[pulumi.Input['SecretSecretContentArgs']]):
        pulumi.set(self, "secret_content", value)

    @_builtins.property
    @pulumi.getter(name="secretGenerationContext")
    def secret_generation_context(self) -> Optional[pulumi.Input['SecretSecretGenerationContextArgs']]:
        """
        (Updatable) Captures a configurable set of secret generation rules such as length, base characters, additional characters, and so on.
        """
        return pulumi.get(self, "secret_generation_context")

    @secret_generation_context.setter
    def secret_generation_context(self, value: Optional[pulumi.Input['SecretSecretGenerationContextArgs']]):
        pulumi.set(self, "secret_generation_context", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name for the secret. Secret names should be unique within a vault. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="secretRules")
    def secret_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretSecretRuleArgs']]]]:
        """
        (Updatable) A list of rules to control how the secret is used and managed.
        """
        return pulumi.get(self, "secret_rules")

    @secret_rules.setter
    def secret_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretSecretRuleArgs']]]]):
        pulumi.set(self, "secret_rules", value)

    @_builtins.property
    @pulumi.getter(name="sourceRegionInformations")
    def source_region_informations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretSourceRegionInformationArgs']]]]:
        """
        Details for the source that the source secret has.
        """
        return pulumi.get(self, "source_region_informations")

    @source_region_informations.setter
    def source_region_informations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretSourceRegionInformationArgs']]]]):
        pulumi.set(self, "source_region_informations", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the secret.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A property indicating when the secret was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeOfCurrentVersionExpiry")
    def time_of_current_version_expiry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional property indicating when the current secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_current_version_expiry")

    @time_of_current_version_expiry.setter
    def time_of_current_version_expiry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_current_version_expiry", value)

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional property indicating when to delete the secret, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @time_of_deletion.setter
    def time_of_deletion(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_deletion", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the vault where you want to create the secret.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("oci:Vault/secret:Secret")
class Secret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_auto_generation: Optional[pulumi.Input[_builtins.bool]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 replication_config: Optional[pulumi.Input[Union['SecretReplicationConfigArgs', 'SecretReplicationConfigArgsDict']]] = None,
                 rotation_config: Optional[pulumi.Input[Union['SecretRotationConfigArgs', 'SecretRotationConfigArgsDict']]] = None,
                 secret_content: Optional[pulumi.Input[Union['SecretSecretContentArgs', 'SecretSecretContentArgsDict']]] = None,
                 secret_generation_context: Optional[pulumi.Input[Union['SecretSecretGenerationContextArgs', 'SecretSecretGenerationContextArgsDict']]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretSecretRuleArgs', 'SecretSecretRuleArgsDict']]]]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Secret resource in Oracle Cloud Infrastructure Vault service.

        Creates a new secret according to the details of the request.

        ## Import

        Secrets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Vault/secret:Secret test_secret "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create the secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A brief description of the secret. Avoid entering confidential information.
        :param pulumi.Input[_builtins.bool] enable_auto_generation: (Updatable) The value of this flag determines whether or not secret content will be generated automatically. If not set, it defaults to false.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] key_id: The OCID of the master encryption key that is used to encrypt the secret. You must specify a symmetric key to encrypt the secret during import to the vault. You cannot encrypt secrets with asymmetric keys. Furthermore, the key must exist in the vault that you specify.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: (Updatable) Additional metadata that you can use to provide context about how to use the secret during rotation or other administrative tasks. For example, for a secret that you use to connect to a database, the additional metadata might specify the connection endpoint and the connection string. Provide additional metadata as key-value pairs.
        :param pulumi.Input[Union['SecretReplicationConfigArgs', 'SecretReplicationConfigArgsDict']] replication_config: (Updatable) Defines the configuration that enables cross-region secret replication.
        :param pulumi.Input[Union['SecretRotationConfigArgs', 'SecretRotationConfigArgsDict']] rotation_config: (Updatable) Defines the frequency of the rotation and the information about the target system
        :param pulumi.Input[Union['SecretSecretContentArgs', 'SecretSecretContentArgsDict']] secret_content: (Updatable) The content of the secret and metadata to help identify it.
        :param pulumi.Input[Union['SecretSecretGenerationContextArgs', 'SecretSecretGenerationContextArgsDict']] secret_generation_context: (Updatable) Captures a configurable set of secret generation rules such as length, base characters, additional characters, and so on.
        :param pulumi.Input[_builtins.str] secret_name: A user-friendly name for the secret. Secret names should be unique within a vault. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretSecretRuleArgs', 'SecretSecretRuleArgsDict']]]] secret_rules: (Updatable) A list of rules to control how the secret is used and managed.
        :param pulumi.Input[_builtins.str] vault_id: The OCID of the vault where you want to create the secret.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Secret resource in Oracle Cloud Infrastructure Vault service.

        Creates a new secret according to the details of the request.

        ## Import

        Secrets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Vault/secret:Secret test_secret "id"
        ```

        :param str resource_name: The name of the resource.
        :param SecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_auto_generation: Optional[pulumi.Input[_builtins.bool]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 replication_config: Optional[pulumi.Input[Union['SecretReplicationConfigArgs', 'SecretReplicationConfigArgsDict']]] = None,
                 rotation_config: Optional[pulumi.Input[Union['SecretRotationConfigArgs', 'SecretRotationConfigArgsDict']]] = None,
                 secret_content: Optional[pulumi.Input[Union['SecretSecretContentArgs', 'SecretSecretContentArgsDict']]] = None,
                 secret_generation_context: Optional[pulumi.Input[Union['SecretSecretGenerationContextArgs', 'SecretSecretGenerationContextArgsDict']]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretSecretRuleArgs', 'SecretSecretRuleArgsDict']]]]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretArgs.__new__(SecretArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_auto_generation"] = enable_auto_generation
            __props__.__dict__["freeform_tags"] = freeform_tags
            if key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_id'")
            __props__.__dict__["key_id"] = key_id
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["replication_config"] = replication_config
            __props__.__dict__["rotation_config"] = rotation_config
            __props__.__dict__["secret_content"] = secret_content
            __props__.__dict__["secret_generation_context"] = secret_generation_context
            if secret_name is None and not opts.urn:
                raise TypeError("Missing required property 'secret_name'")
            __props__.__dict__["secret_name"] = secret_name
            __props__.__dict__["secret_rules"] = secret_rules
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
            __props__.__dict__["current_version_number"] = None
            __props__.__dict__["is_auto_generation_enabled"] = None
            __props__.__dict__["is_replica"] = None
            __props__.__dict__["last_rotation_time"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["next_rotation_time"] = None
            __props__.__dict__["rotation_status"] = None
            __props__.__dict__["source_region_informations"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_of_current_version_expiry"] = None
            __props__.__dict__["time_of_deletion"] = None
        super(Secret, __self__).__init__(
            'oci:Vault/secret:Secret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            current_version_number: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_auto_generation: Optional[pulumi.Input[_builtins.bool]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_auto_generation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_replica: Optional[pulumi.Input[_builtins.bool]] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_rotation_time: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            next_rotation_time: Optional[pulumi.Input[_builtins.str]] = None,
            replication_config: Optional[pulumi.Input[Union['SecretReplicationConfigArgs', 'SecretReplicationConfigArgsDict']]] = None,
            rotation_config: Optional[pulumi.Input[Union['SecretRotationConfigArgs', 'SecretRotationConfigArgsDict']]] = None,
            rotation_status: Optional[pulumi.Input[_builtins.str]] = None,
            secret_content: Optional[pulumi.Input[Union['SecretSecretContentArgs', 'SecretSecretContentArgsDict']]] = None,
            secret_generation_context: Optional[pulumi.Input[Union['SecretSecretGenerationContextArgs', 'SecretSecretGenerationContextArgsDict']]] = None,
            secret_name: Optional[pulumi.Input[_builtins.str]] = None,
            secret_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretSecretRuleArgs', 'SecretSecretRuleArgsDict']]]]] = None,
            source_region_informations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretSourceRegionInformationArgs', 'SecretSourceRegionInformationArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_of_current_version_expiry: Optional[pulumi.Input[_builtins.str]] = None,
            time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Secret':
        """
        Get an existing Secret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where you want to create the secret.
        :param pulumi.Input[_builtins.str] current_version_number: The version number of the secret version that's currently in use.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A brief description of the secret. Avoid entering confidential information.
        :param pulumi.Input[_builtins.bool] enable_auto_generation: (Updatable) The value of this flag determines whether or not secret content will be generated automatically. If not set, it defaults to false.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_auto_generation_enabled: The value of this flag determines whether or not secret content will be generated automatically.
        :param pulumi.Input[_builtins.bool] is_replica: A Boolean value that indicates whether the secret is a source or replica secret.
        :param pulumi.Input[_builtins.str] key_id: The OCID of the master encryption key that is used to encrypt the secret. You must specify a symmetric key to encrypt the secret during import to the vault. You cannot encrypt secrets with asymmetric keys. Furthermore, the key must exist in the vault that you specify.
        :param pulumi.Input[_builtins.str] last_rotation_time: A property indicating when the secret was last rotated successfully, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state of the secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: (Updatable) Additional metadata that you can use to provide context about how to use the secret during rotation or other administrative tasks. For example, for a secret that you use to connect to a database, the additional metadata might specify the connection endpoint and the connection string. Provide additional metadata as key-value pairs.
        :param pulumi.Input[_builtins.str] next_rotation_time: A property indicating when the secret is scheduled to be rotated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[Union['SecretReplicationConfigArgs', 'SecretReplicationConfigArgsDict']] replication_config: (Updatable) Defines the configuration that enables cross-region secret replication.
        :param pulumi.Input[Union['SecretRotationConfigArgs', 'SecretRotationConfigArgsDict']] rotation_config: (Updatable) Defines the frequency of the rotation and the information about the target system
        :param pulumi.Input[_builtins.str] rotation_status: Additional information about the status of the secret rotation
        :param pulumi.Input[Union['SecretSecretContentArgs', 'SecretSecretContentArgsDict']] secret_content: (Updatable) The content of the secret and metadata to help identify it.
        :param pulumi.Input[Union['SecretSecretGenerationContextArgs', 'SecretSecretGenerationContextArgsDict']] secret_generation_context: (Updatable) Captures a configurable set of secret generation rules such as length, base characters, additional characters, and so on.
        :param pulumi.Input[_builtins.str] secret_name: A user-friendly name for the secret. Secret names should be unique within a vault. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretSecretRuleArgs', 'SecretSecretRuleArgsDict']]]] secret_rules: (Updatable) A list of rules to control how the secret is used and managed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretSourceRegionInformationArgs', 'SecretSourceRegionInformationArgsDict']]]] source_region_informations: Details for the source that the source secret has.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the secret.
        :param pulumi.Input[_builtins.str] time_created: A property indicating when the secret was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_of_current_version_expiry: An optional property indicating when the current secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_of_deletion: An optional property indicating when to delete the secret, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] vault_id: The OCID of the vault where you want to create the secret.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretState.__new__(_SecretState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["current_version_number"] = current_version_number
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_auto_generation"] = enable_auto_generation
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_auto_generation_enabled"] = is_auto_generation_enabled
        __props__.__dict__["is_replica"] = is_replica
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["last_rotation_time"] = last_rotation_time
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["next_rotation_time"] = next_rotation_time
        __props__.__dict__["replication_config"] = replication_config
        __props__.__dict__["rotation_config"] = rotation_config
        __props__.__dict__["rotation_status"] = rotation_status
        __props__.__dict__["secret_content"] = secret_content
        __props__.__dict__["secret_generation_context"] = secret_generation_context
        __props__.__dict__["secret_name"] = secret_name
        __props__.__dict__["secret_rules"] = secret_rules
        __props__.__dict__["source_region_informations"] = source_region_informations
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_of_current_version_expiry"] = time_of_current_version_expiry
        __props__.__dict__["time_of_deletion"] = time_of_deletion
        __props__.__dict__["vault_id"] = vault_id
        return Secret(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where you want to create the secret.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="currentVersionNumber")
    def current_version_number(self) -> pulumi.Output[_builtins.str]:
        """
        The version number of the secret version that's currently in use.
        """
        return pulumi.get(self, "current_version_number")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A brief description of the secret. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableAutoGeneration")
    def enable_auto_generation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Updatable) The value of this flag determines whether or not secret content will be generated automatically. If not set, it defaults to false.
        """
        return pulumi.get(self, "enable_auto_generation")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isAutoGenerationEnabled")
    def is_auto_generation_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        The value of this flag determines whether or not secret content will be generated automatically.
        """
        return pulumi.get(self, "is_auto_generation_enabled")

    @_builtins.property
    @pulumi.getter(name="isReplica")
    def is_replica(self) -> pulumi.Output[_builtins.bool]:
        """
        A Boolean value that indicates whether the secret is a source or replica secret.
        """
        return pulumi.get(self, "is_replica")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the master encryption key that is used to encrypt the secret. You must specify a symmetric key to encrypt the secret during import to the vault. You cannot encrypt secrets with asymmetric keys. Furthermore, the key must exist in the vault that you specify.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="lastRotationTime")
    def last_rotation_time(self) -> pulumi.Output[_builtins.str]:
        """
        A property indicating when the secret was last rotated successfully, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "last_rotation_time")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current lifecycle state of the secret.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Additional metadata that you can use to provide context about how to use the secret during rotation or other administrative tasks. For example, for a secret that you use to connect to a database, the additional metadata might specify the connection endpoint and the connection string. Provide additional metadata as key-value pairs.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="nextRotationTime")
    def next_rotation_time(self) -> pulumi.Output[_builtins.str]:
        """
        A property indicating when the secret is scheduled to be rotated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "next_rotation_time")

    @_builtins.property
    @pulumi.getter(name="replicationConfig")
    def replication_config(self) -> pulumi.Output[Optional['outputs.SecretReplicationConfig']]:
        """
        (Updatable) Defines the configuration that enables cross-region secret replication.
        """
        return pulumi.get(self, "replication_config")

    @_builtins.property
    @pulumi.getter(name="rotationConfig")
    def rotation_config(self) -> pulumi.Output['outputs.SecretRotationConfig']:
        """
        (Updatable) Defines the frequency of the rotation and the information about the target system
        """
        return pulumi.get(self, "rotation_config")

    @_builtins.property
    @pulumi.getter(name="rotationStatus")
    def rotation_status(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the status of the secret rotation
        """
        return pulumi.get(self, "rotation_status")

    @_builtins.property
    @pulumi.getter(name="secretContent")
    def secret_content(self) -> pulumi.Output['outputs.SecretSecretContent']:
        """
        (Updatable) The content of the secret and metadata to help identify it.
        """
        return pulumi.get(self, "secret_content")

    @_builtins.property
    @pulumi.getter(name="secretGenerationContext")
    def secret_generation_context(self) -> pulumi.Output['outputs.SecretSecretGenerationContext']:
        """
        (Updatable) Captures a configurable set of secret generation rules such as length, base characters, additional characters, and so on.
        """
        return pulumi.get(self, "secret_generation_context")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Output[_builtins.str]:
        """
        A user-friendly name for the secret. Secret names should be unique within a vault. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="secretRules")
    def secret_rules(self) -> pulumi.Output[Sequence['outputs.SecretSecretRule']]:
        """
        (Updatable) A list of rules to control how the secret is used and managed.
        """
        return pulumi.get(self, "secret_rules")

    @_builtins.property
    @pulumi.getter(name="sourceRegionInformations")
    def source_region_informations(self) -> pulumi.Output[Sequence['outputs.SecretSourceRegionInformation']]:
        """
        Details for the source that the source secret has.
        """
        return pulumi.get(self, "source_region_informations")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the secret.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        A property indicating when the secret was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfCurrentVersionExpiry")
    def time_of_current_version_expiry(self) -> pulumi.Output[_builtins.str]:
        """
        An optional property indicating when the current secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_current_version_expiry")

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> pulumi.Output[_builtins.str]:
        """
        An optional property indicating when to delete the secret, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the vault where you want to create the secret.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vault_id")

