"""Shell command indicators for context-based detection."""

# POSIX shell built-ins and utilities - comprehensive list from The POSIX Shell And Utilities
# See: https://shellhaters.org
SHELL_COMMAND_INDICATORS = {
    # POSIX shell built-ins
    ":",
    ".",
    "alias",
    "bg",
    "break",
    "cd",
    "command",
    "continue",
    "eval",
    "exec",
    "exit",
    "export",
    "false",
    "fg",
    "getopts",
    "hash",
    "help",
    "history",
    "jobs",
    "kill",
    "let",
    "local",
    "pwd",
    "read",
    "readonly",
    "return",
    "set",
    "shift",
    "test",
    "times",
    "trap",
    "true",
    "type",
    "ulimit",
    "umask",
    "unalias",
    "unset",
    "wait",
    # Programming utilities
    "bc",
    "date",
    "env",
    "expr",
    "fc",
    "id",
    "locale",
    "localedef",
    "logger",
    "logname",
    "newgrp",
    "pathchk",
    "sh",
    "sleep",
    "time",
    "tput",
    "uname",
    "write",
    "xargs",
    # Text processing
    "awk",
    "cat",
    "cksum",
    "cmp",
    "comm",
    "csplit",
    "cut",
    "echo",
    "ed",
    "ex",
    "expand",
    "fold",
    "grep",
    "head",
    "join",
    "more",
    "nl",
    "od",
    "paste",
    "printf",
    "sed",
    "sort",
    "split",
    "tail",
    "tr",
    "tsort",
    "unexpand",
    "uniq",
    "wc",
    # File operations
    "basename",
    "cal",
    "chgrp",
    "chmod",
    "chown",
    "cp",
    "dd",
    "df",
    "dirname",
    "du",
    "file",
    "find",
    "fuser",
    "link",
    "ln",
    "ls",
    "mkdir",
    "mkfifo",
    "mv",
    "rm",
    "rmdir",
    "tee",
    "touch",
    "unlink",
    # Process management
    "nice",
    "nohup",
    "ps",
    "renice",
    # Job control
    "at",
    "batch",
    # Development tools
    "ar",
    "asa",
    "c99",
    "cflow",
    "ctags",
    "cxref",
    "diff",
    "fort77",
    "gencat",
    "iconv",
    "lex",
    "m4",
    "make",
    "man",
    "nm",
    "patch",
    "strings",
    "strip",
    "vi",
    "yacc",
    # System administration
    "crontab",
    "getconf",
    "who",
    # Terminal control
    "stty",
    "tabs",
    "tty",
    # Communication
    "mailx",
    "mesg",
    "talk",
    "uucp",
    "uudecode",
    "uuencode",
    "uustat",
    "uux",
    # Compression
    "compress",
    "pax",
    "uncompress",
    "zcat",
}
