import json

xray_nomenclature_conversion_dict = {
    'KA1' : 'Ka1',
    'KA2' : 'Ka2',
    'KB1' : 'Kb1',
    'KB2' : 'Kb2',
    'KB3' : 'Kb3',
    'KB4' : 'Kb4',
    'KB5' : 'Kb5',
    'L3-N2' : '',
    'L3-N3' : '',
    'L3-O2' : '',
    'L3-O3' : '',
    'L3-P1' : '',
    'LA1-M5' : 'La1',
    'LA2-M4' : 'La2',
    'LB15-N4' : 'Lb15',
    'LB2-N5' : 'Lb2',
    'LB5-O4_O5' : 'Lb5',
    'LB6-N1' : 'Lb6',
    'LB7-O1' : 'Lb7',
    'Ll-M1' : 'Ll',
    'Ls-M3' : 'Ls',
    'Lt-M2' : 'Lt',
    'Lu-N4_N7' : 'Lu',
    'L2-M2' : '',
    'L2-M5' : '',
    'L2-N2' : '',
    'L2-N3' : '',
    'L2-N5' : '',
    'L2-O2' : '',
    'L2-O3' : '',
    'L2-P2' : '',
    'LB1-M4' : 'Lb1',
    'LB17-M3' : 'Lb17',
    'LG1-N4' : 'Lg1',
    'LG5-N1' : 'Lg5',
    'LG6-O4' : 'Lg6',
    'LG8-O1' : 'Lg8',
    'Ln' : 'Ln',
    'Lv-N6' : 'Lv',
    'L1-M1' : '',
    'L1-N1' : '',
    'L1-N4' : '',
    'L1-O1' : '',
    'L1-O4' : '',
    'LB10-M4' : 'Lb10',
    'LB3-M3' : 'Lb3',
    'LB4-M2' : 'Lb4',
    'LB9-M5' : 'Lb9',
    'LG2-N2' : 'Lg2',
    'LG11-N5' : 'Lg11',
    'LG3-N3' : 'Lg3',
    'LG4-O3' : 'Lg4',
    'LG4`-O2' : 'Lg4i',
    'M1-N2' : '',
    'M1-N3' : '',
    'M2-M4' : '',
    'M2-N1' : '',
    'M2-N4' : '',
    'M2-O4' : '',
    'M3-M4' : '',
    'M3-M5' : '',
    'M3-N1' : '',
    'M3-N4' : '',
    'M3-O1' : '',
    'M3-O4' : '',
    'M3-O5' : '',
    'MG-N5' : 'Mg',
    'M4-N3' : '',
    'M4-O2' : '',
    'MB-N6' : 'Mb',
    'MZ2-N2' : 'Mz2',
    'M5-O3' : '',
    'MA1-N7' : 'Ma1',
    'MA2-N6' : 'Ma2',
    'MZ1-N3' : 'Mz1',
    'N4-N6' : 'N4N6',
    'N5-N6' : 'N5N6'
    }

# Remove dashes, as they are not accepted as prefixes by lmfit
for key, value in xray_nomenclature_conversion_dict.items():
    if value == '':
        xray_nomenclature_conversion_dict[key] = key.replace('-','')
    
with open('lines_nomenclature_conversion.json', 'w') as file:
    json.dump(xray_nomenclature_conversion_dict, file)