# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictInt, constr, validator

from typing import Optional

from lusid.models.bucketed_cash_flow_response import BucketedCashFlowResponse
from lusid.models.query_applicable_instrument_events_request import QueryApplicableInstrumentEventsRequest
from lusid.models.query_bucketed_cash_flows_request import QueryBucketedCashFlowsRequest
from lusid.models.query_cash_flows_request import QueryCashFlowsRequest
from lusid.models.query_instrument_events_request import QueryInstrumentEventsRequest
from lusid.models.query_trade_tickets_request import QueryTradeTicketsRequest
from lusid.models.resource_list_of_applicable_instrument_event import ResourceListOfApplicableInstrumentEvent
from lusid.models.resource_list_of_instrument_cash_flow import ResourceListOfInstrumentCashFlow
from lusid.models.resource_list_of_instrument_event_holder import ResourceListOfInstrumentEventHolder
from lusid.models.resource_list_of_portfolio_trade_ticket import ResourceListOfPortfolioTradeTicket

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class InstrumentEventsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def query_applicable_instrument_events(self, as_at : Annotated[Optional[datetime], Field(description="The as at time to use.")] = None, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 100 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this")] = None, query_applicable_instrument_events_request : Annotated[Optional[QueryApplicableInstrumentEventsRequest], Field(description="The filter parameters used to retrieve applicable instrument events.")] = None, **kwargs) -> ResourceListOfApplicableInstrumentEvent:  # noqa: E501
        ...

    @overload
    def query_applicable_instrument_events(self, as_at : Annotated[Optional[datetime], Field(description="The as at time to use.")] = None, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 100 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this")] = None, query_applicable_instrument_events_request : Annotated[Optional[QueryApplicableInstrumentEventsRequest], Field(description="The filter parameters used to retrieve applicable instrument events.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfApplicableInstrumentEvent:  # noqa: E501
        ...

    @validate_arguments
    def query_applicable_instrument_events(self, as_at : Annotated[Optional[datetime], Field(description="The as at time to use.")] = None, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 100 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this")] = None, query_applicable_instrument_events_request : Annotated[Optional[QueryApplicableInstrumentEventsRequest], Field(description="The filter parameters used to retrieve applicable instrument events.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfApplicableInstrumentEvent, Awaitable[ResourceListOfApplicableInstrumentEvent]]:  # noqa: E501
        """QueryApplicableInstrumentEvents: Returns a list of applicable instrument events based on the holdings of the portfolios and date range specified in the query.  # noqa: E501

        Returns a list of applicable instrument events based on the holdings of the portfolios and date range specified in the query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_applicable_instrument_events(as_at, limit, page, query_applicable_instrument_events_request, async_req=True)
        >>> result = thread.get()

        :param as_at: The as at time to use.
        :type as_at: datetime
        :param limit: Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 100 is used.
        :type limit: int
        :param page: Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this
        :type page: str
        :param query_applicable_instrument_events_request: The filter parameters used to retrieve applicable instrument events.
        :type query_applicable_instrument_events_request: QueryApplicableInstrumentEventsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfApplicableInstrumentEvent
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the query_applicable_instrument_events_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.query_applicable_instrument_events_with_http_info(as_at, limit, page, query_applicable_instrument_events_request, **kwargs)  # noqa: E501

    @validate_arguments
    def query_applicable_instrument_events_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The as at time to use.")] = None, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 100 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this")] = None, query_applicable_instrument_events_request : Annotated[Optional[QueryApplicableInstrumentEventsRequest], Field(description="The filter parameters used to retrieve applicable instrument events.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """QueryApplicableInstrumentEvents: Returns a list of applicable instrument events based on the holdings of the portfolios and date range specified in the query.  # noqa: E501

        Returns a list of applicable instrument events based on the holdings of the portfolios and date range specified in the query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_applicable_instrument_events_with_http_info(as_at, limit, page, query_applicable_instrument_events_request, async_req=True)
        >>> result = thread.get()

        :param as_at: The as at time to use.
        :type as_at: datetime
        :param limit: Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 100 is used.
        :type limit: int
        :param page: Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this
        :type page: str
        :param query_applicable_instrument_events_request: The filter parameters used to retrieve applicable instrument events.
        :type query_applicable_instrument_events_request: QueryApplicableInstrumentEventsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfApplicableInstrumentEvent, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'limit',
            'page',
            'query_applicable_instrument_events_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_applicable_instrument_events" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['query_applicable_instrument_events_request'] is not None:
            _body_params = _params['query_applicable_instrument_events_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfApplicableInstrumentEvent",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instrumentevents/$queryApplicableInstrumentEvents', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def query_bucketed_cash_flows(self, query_bucketed_cash_flows_request : Annotated[Optional[QueryBucketedCashFlowsRequest], Field(description="The Query Information.")] = None, **kwargs) -> BucketedCashFlowResponse:  # noqa: E501
        ...

    @overload
    def query_bucketed_cash_flows(self, query_bucketed_cash_flows_request : Annotated[Optional[QueryBucketedCashFlowsRequest], Field(description="The Query Information.")] = None, async_req: Optional[bool]=True, **kwargs) -> BucketedCashFlowResponse:  # noqa: E501
        ...

    @validate_arguments
    def query_bucketed_cash_flows(self, query_bucketed_cash_flows_request : Annotated[Optional[QueryBucketedCashFlowsRequest], Field(description="The Query Information.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[BucketedCashFlowResponse, Awaitable[BucketedCashFlowResponse]]:  # noqa: E501
        """QueryBucketedCashFlows: Returns bucketed cashflows based on the holdings of the portfolios and date range specified in the query.  # noqa: E501

        Returns bucketed cashflows based on the holdings of the portfolios and date range specified in the query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_bucketed_cash_flows(query_bucketed_cash_flows_request, async_req=True)
        >>> result = thread.get()

        :param query_bucketed_cash_flows_request: The Query Information.
        :type query_bucketed_cash_flows_request: QueryBucketedCashFlowsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BucketedCashFlowResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the query_bucketed_cash_flows_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.query_bucketed_cash_flows_with_http_info(query_bucketed_cash_flows_request, **kwargs)  # noqa: E501

    @validate_arguments
    def query_bucketed_cash_flows_with_http_info(self, query_bucketed_cash_flows_request : Annotated[Optional[QueryBucketedCashFlowsRequest], Field(description="The Query Information.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """QueryBucketedCashFlows: Returns bucketed cashflows based on the holdings of the portfolios and date range specified in the query.  # noqa: E501

        Returns bucketed cashflows based on the holdings of the portfolios and date range specified in the query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_bucketed_cash_flows_with_http_info(query_bucketed_cash_flows_request, async_req=True)
        >>> result = thread.get()

        :param query_bucketed_cash_flows_request: The Query Information.
        :type query_bucketed_cash_flows_request: QueryBucketedCashFlowsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BucketedCashFlowResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query_bucketed_cash_flows_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_bucketed_cash_flows" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['query_bucketed_cash_flows_request'] is not None:
            _body_params = _params['query_bucketed_cash_flows_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "BucketedCashFlowResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instrumentevents/$queryBucketedCashFlows', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def query_cash_flows(self, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.")] = None, query_cash_flows_request : Annotated[Optional[QueryCashFlowsRequest], Field(description="The filter parameters used to retrieve instrument events.")] = None, **kwargs) -> ResourceListOfInstrumentCashFlow:  # noqa: E501
        ...

    @overload
    def query_cash_flows(self, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.")] = None, query_cash_flows_request : Annotated[Optional[QueryCashFlowsRequest], Field(description="The filter parameters used to retrieve instrument events.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfInstrumentCashFlow:  # noqa: E501
        ...

    @validate_arguments
    def query_cash_flows(self, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.")] = None, query_cash_flows_request : Annotated[Optional[QueryCashFlowsRequest], Field(description="The filter parameters used to retrieve instrument events.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfInstrumentCashFlow, Awaitable[ResourceListOfInstrumentCashFlow]]:  # noqa: E501
        """QueryCashFlows: Returns a list of cashflows based on the holdings of the portfolios and date range specified in the query.  # noqa: E501

        Returns a list of cashflows based on the holdings of the portfolios and date range specified in the query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_cash_flows(limit, page, query_cash_flows_request, async_req=True)
        >>> result = thread.get()

        :param limit: Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.
        :type limit: int
        :param page: Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.
        :type page: str
        :param query_cash_flows_request: The filter parameters used to retrieve instrument events.
        :type query_cash_flows_request: QueryCashFlowsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfInstrumentCashFlow
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the query_cash_flows_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.query_cash_flows_with_http_info(limit, page, query_cash_flows_request, **kwargs)  # noqa: E501

    @validate_arguments
    def query_cash_flows_with_http_info(self, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.")] = None, query_cash_flows_request : Annotated[Optional[QueryCashFlowsRequest], Field(description="The filter parameters used to retrieve instrument events.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """QueryCashFlows: Returns a list of cashflows based on the holdings of the portfolios and date range specified in the query.  # noqa: E501

        Returns a list of cashflows based on the holdings of the portfolios and date range specified in the query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_cash_flows_with_http_info(limit, page, query_cash_flows_request, async_req=True)
        >>> result = thread.get()

        :param limit: Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.
        :type limit: int
        :param page: Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.
        :type page: str
        :param query_cash_flows_request: The filter parameters used to retrieve instrument events.
        :type query_cash_flows_request: QueryCashFlowsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfInstrumentCashFlow, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'page',
            'query_cash_flows_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_cash_flows" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['query_cash_flows_request'] is not None:
            _body_params = _params['query_cash_flows_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfInstrumentCashFlow",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instrumentevents/$queryCashFlows', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def query_instrument_events(self, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.")] = None, query_instrument_events_request : Annotated[Optional[QueryInstrumentEventsRequest], Field(description="The filter parameters used to retrieve instrument events.")] = None, **kwargs) -> ResourceListOfInstrumentEventHolder:  # noqa: E501
        ...

    @overload
    def query_instrument_events(self, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.")] = None, query_instrument_events_request : Annotated[Optional[QueryInstrumentEventsRequest], Field(description="The filter parameters used to retrieve instrument events.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfInstrumentEventHolder:  # noqa: E501
        ...

    @validate_arguments
    def query_instrument_events(self, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.")] = None, query_instrument_events_request : Annotated[Optional[QueryInstrumentEventsRequest], Field(description="The filter parameters used to retrieve instrument events.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfInstrumentEventHolder, Awaitable[ResourceListOfInstrumentEventHolder]]:  # noqa: E501
        """QueryInstrumentEvents: Returns a list of instrument events based on the holdings of the portfolios and date range specified in the query.  # noqa: E501

        Returns a list of instrument events based on the holdings of the portfolios and date range specified in the query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_instrument_events(limit, page, query_instrument_events_request, async_req=True)
        >>> result = thread.get()

        :param limit: Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.
        :type limit: int
        :param page: Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.
        :type page: str
        :param query_instrument_events_request: The filter parameters used to retrieve instrument events.
        :type query_instrument_events_request: QueryInstrumentEventsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfInstrumentEventHolder
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the query_instrument_events_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.query_instrument_events_with_http_info(limit, page, query_instrument_events_request, **kwargs)  # noqa: E501

    @validate_arguments
    def query_instrument_events_with_http_info(self, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.")] = None, query_instrument_events_request : Annotated[Optional[QueryInstrumentEventsRequest], Field(description="The filter parameters used to retrieve instrument events.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """QueryInstrumentEvents: Returns a list of instrument events based on the holdings of the portfolios and date range specified in the query.  # noqa: E501

        Returns a list of instrument events based on the holdings of the portfolios and date range specified in the query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_instrument_events_with_http_info(limit, page, query_instrument_events_request, async_req=True)
        >>> result = thread.get()

        :param limit: Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.
        :type limit: int
        :param page: Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.
        :type page: str
        :param query_instrument_events_request: The filter parameters used to retrieve instrument events.
        :type query_instrument_events_request: QueryInstrumentEventsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfInstrumentEventHolder, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'page',
            'query_instrument_events_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_instrument_events" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['query_instrument_events_request'] is not None:
            _body_params = _params['query_instrument_events_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfInstrumentEventHolder",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instrumentevents/$query', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def query_trade_tickets(self, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.")] = None, query_trade_tickets_request : Annotated[Optional[QueryTradeTicketsRequest], Field(description="The filter parameters used to retrieve instrument events.")] = None, **kwargs) -> ResourceListOfPortfolioTradeTicket:  # noqa: E501
        ...

    @overload
    def query_trade_tickets(self, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.")] = None, query_trade_tickets_request : Annotated[Optional[QueryTradeTicketsRequest], Field(description="The filter parameters used to retrieve instrument events.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfPortfolioTradeTicket:  # noqa: E501
        ...

    @validate_arguments
    def query_trade_tickets(self, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.")] = None, query_trade_tickets_request : Annotated[Optional[QueryTradeTicketsRequest], Field(description="The filter parameters used to retrieve instrument events.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfPortfolioTradeTicket, Awaitable[ResourceListOfPortfolioTradeTicket]]:  # noqa: E501
        """QueryTradeTickets: Returns a list of trade tickets based on the holdings of the portfolios and date range specified in the query.  # noqa: E501

        Returns a list of trade tickets based on the holdings of the portfolios and date range specified in the query.    These trade tickets are derived from events that involve transition of instrument states, such as transitions  on exercise or default of an instrument. The trade tickets are to allow the new position to be created given the  existing portfolio configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_trade_tickets(limit, page, query_trade_tickets_request, async_req=True)
        >>> result = thread.get()

        :param limit: Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.
        :type limit: int
        :param page: Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.
        :type page: str
        :param query_trade_tickets_request: The filter parameters used to retrieve instrument events.
        :type query_trade_tickets_request: QueryTradeTicketsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfPortfolioTradeTicket
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the query_trade_tickets_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.query_trade_tickets_with_http_info(limit, page, query_trade_tickets_request, **kwargs)  # noqa: E501

    @validate_arguments
    def query_trade_tickets_with_http_info(self, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.")] = None, query_trade_tickets_request : Annotated[Optional[QueryTradeTicketsRequest], Field(description="The filter parameters used to retrieve instrument events.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """QueryTradeTickets: Returns a list of trade tickets based on the holdings of the portfolios and date range specified in the query.  # noqa: E501

        Returns a list of trade tickets based on the holdings of the portfolios and date range specified in the query.    These trade tickets are derived from events that involve transition of instrument states, such as transitions  on exercise or default of an instrument. The trade tickets are to allow the new position to be created given the  existing portfolio configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_trade_tickets_with_http_info(limit, page, query_trade_tickets_request, async_req=True)
        >>> result = thread.get()

        :param limit: Optional. When paginating, limit the number of returned results to this many. If not specified, a default  of 1000 is used.
        :type limit: int
        :param page: Optional. The pagination token to use to continue listing items from a previous call. Page values are  return from list calls, and must be supplied exactly as returned. Additionally, when specifying this  value, queryBody, and limit must not  be modified.
        :type page: str
        :param query_trade_tickets_request: The filter parameters used to retrieve instrument events.
        :type query_trade_tickets_request: QueryTradeTicketsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfPortfolioTradeTicket, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'page',
            'query_trade_tickets_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_trade_tickets" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['query_trade_tickets_request'] is not None:
            _body_params = _params['query_trade_tickets_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfPortfolioTradeTicket",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instrumentevents/$queryTradeTickets', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
