# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictInt, StrictStr, constr, validator

from typing import Dict, Optional

from lusid.models.annul_quotes_response import AnnulQuotesResponse
from lusid.models.get_quotes_response import GetQuotesResponse
from lusid.models.quote_access_metadata_rule import QuoteAccessMetadataRule
from lusid.models.quote_id import QuoteId
from lusid.models.quote_series_id import QuoteSeriesId
from lusid.models.resource_list_of_quote import ResourceListOfQuote
from lusid.models.resource_list_of_quote_access_metadata_rule import ResourceListOfQuoteAccessMetadataRule
from lusid.models.upsert_quote_access_metadata_rule_request import UpsertQuoteAccessMetadataRuleRequest
from lusid.models.upsert_quote_request import UpsertQuoteRequest
from lusid.models.upsert_quotes_response import UpsertQuotesResponse

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class QuotesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def delete_quote_access_metadata_rule(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Quote Access Metadata Rule to retrieve.")], provider : Annotated[Optional[StrictStr], Field( description="The Provider of the rule")] = None, price_source : Annotated[Optional[StrictStr], Field( description="The PriceSource of the rule")] = None, instrument_id_type : Annotated[Optional[StrictStr], Field( description="The InstrumentIdType of the rule")] = None, instrument_id : Annotated[Optional[StrictStr], Field( description="The InstrumentId of the rule")] = None, quote_type : Annotated[Optional[StrictStr], Field( description="The QuoteType of the rule")] = None, field : Annotated[Optional[StrictStr], Field( description="The Field of the rule")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective date to delete at, if this is not supplied, it will delete all data found")] = None, **kwargs) -> QuoteAccessMetadataRule:  # noqa: E501
        ...

    @overload
    def delete_quote_access_metadata_rule(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Quote Access Metadata Rule to retrieve.")], provider : Annotated[Optional[StrictStr], Field( description="The Provider of the rule")] = None, price_source : Annotated[Optional[StrictStr], Field( description="The PriceSource of the rule")] = None, instrument_id_type : Annotated[Optional[StrictStr], Field( description="The InstrumentIdType of the rule")] = None, instrument_id : Annotated[Optional[StrictStr], Field( description="The InstrumentId of the rule")] = None, quote_type : Annotated[Optional[StrictStr], Field( description="The QuoteType of the rule")] = None, field : Annotated[Optional[StrictStr], Field( description="The Field of the rule")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective date to delete at, if this is not supplied, it will delete all data found")] = None, async_req: Optional[bool]=True, **kwargs) -> QuoteAccessMetadataRule:  # noqa: E501
        ...

    @validate_arguments
    def delete_quote_access_metadata_rule(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Quote Access Metadata Rule to retrieve.")], provider : Annotated[Optional[StrictStr], Field( description="The Provider of the rule")] = None, price_source : Annotated[Optional[StrictStr], Field( description="The PriceSource of the rule")] = None, instrument_id_type : Annotated[Optional[StrictStr], Field( description="The InstrumentIdType of the rule")] = None, instrument_id : Annotated[Optional[StrictStr], Field( description="The InstrumentId of the rule")] = None, quote_type : Annotated[Optional[StrictStr], Field( description="The QuoteType of the rule")] = None, field : Annotated[Optional[StrictStr], Field( description="The Field of the rule")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective date to delete at, if this is not supplied, it will delete all data found")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[QuoteAccessMetadataRule, Awaitable[QuoteAccessMetadataRule]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteQuoteAccessMetadataRule: Delete a Quote Access Metadata Rule  # noqa: E501

        Delete the Quote Access Metadata Rule that exactly matches the provided identifier parts  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_quote_access_metadata_rule(scope, provider, price_source, instrument_id_type, instrument_id, quote_type, field, effective_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Quote Access Metadata Rule to retrieve. (required)
        :type scope: str
        :param provider: The Provider of the rule
        :type provider: str
        :param price_source: The PriceSource of the rule
        :type price_source: str
        :param instrument_id_type: The InstrumentIdType of the rule
        :type instrument_id_type: str
        :param instrument_id: The InstrumentId of the rule
        :type instrument_id: str
        :param quote_type: The QuoteType of the rule
        :type quote_type: str
        :param field: The Field of the rule
        :type field: str
        :param effective_at: The effective date to delete at, if this is not supplied, it will delete all data found
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: QuoteAccessMetadataRule
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_quote_access_metadata_rule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_quote_access_metadata_rule_with_http_info(scope, provider, price_source, instrument_id_type, instrument_id, quote_type, field, effective_at, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_quote_access_metadata_rule_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Quote Access Metadata Rule to retrieve.")], provider : Annotated[Optional[StrictStr], Field( description="The Provider of the rule")] = None, price_source : Annotated[Optional[StrictStr], Field( description="The PriceSource of the rule")] = None, instrument_id_type : Annotated[Optional[StrictStr], Field( description="The InstrumentIdType of the rule")] = None, instrument_id : Annotated[Optional[StrictStr], Field( description="The InstrumentId of the rule")] = None, quote_type : Annotated[Optional[StrictStr], Field( description="The QuoteType of the rule")] = None, field : Annotated[Optional[StrictStr], Field( description="The Field of the rule")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective date to delete at, if this is not supplied, it will delete all data found")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteQuoteAccessMetadataRule: Delete a Quote Access Metadata Rule  # noqa: E501

        Delete the Quote Access Metadata Rule that exactly matches the provided identifier parts  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_quote_access_metadata_rule_with_http_info(scope, provider, price_source, instrument_id_type, instrument_id, quote_type, field, effective_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Quote Access Metadata Rule to retrieve. (required)
        :type scope: str
        :param provider: The Provider of the rule
        :type provider: str
        :param price_source: The PriceSource of the rule
        :type price_source: str
        :param instrument_id_type: The InstrumentIdType of the rule
        :type instrument_id_type: str
        :param instrument_id: The InstrumentId of the rule
        :type instrument_id: str
        :param quote_type: The QuoteType of the rule
        :type quote_type: str
        :param field: The Field of the rule
        :type field: str
        :param effective_at: The effective date to delete at, if this is not supplied, it will delete all data found
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(QuoteAccessMetadataRule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'provider',
            'price_source',
            'instrument_id_type',
            'instrument_id',
            'quote_type',
            'field',
            'effective_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quote_access_metadata_rule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('provider') is not None:  # noqa: E501
            _query_params.append(('provider', _params['provider']))

        if _params.get('price_source') is not None:  # noqa: E501
            _query_params.append(('priceSource', _params['price_source']))

        if _params.get('instrument_id_type') is not None:  # noqa: E501
            _query_params.append(('instrumentIdType', _params['instrument_id_type']))

        if _params.get('instrument_id') is not None:  # noqa: E501
            _query_params.append(('instrumentId', _params['instrument_id']))

        if _params.get('quote_type') is not None:  # noqa: E501
            _query_params.append(('quoteType', _params['quote_type']))

        if _params.get('field') is not None:  # noqa: E501
            _query_params.append(('field', _params['field']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "QuoteAccessMetadataRule",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/metadata/quotes/rules/{scope}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_quotes(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to delete.")], request_body : Annotated[Optional[Dict[str, QuoteId]], Field(description="The quotes to delete keyed by a unique correlation id.")] = None, **kwargs) -> AnnulQuotesResponse:  # noqa: E501
        ...

    @overload
    def delete_quotes(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to delete.")], request_body : Annotated[Optional[Dict[str, QuoteId]], Field(description="The quotes to delete keyed by a unique correlation id.")] = None, async_req: Optional[bool]=True, **kwargs) -> AnnulQuotesResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_quotes(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to delete.")], request_body : Annotated[Optional[Dict[str, QuoteId]], Field(description="The quotes to delete keyed by a unique correlation id.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[AnnulQuotesResponse, Awaitable[AnnulQuotesResponse]]:  # noqa: E501
        """DeleteQuotes: Delete quotes  # noqa: E501

        Delete one or more specified quotes from a single scope. A quote is identified by its unique id which includes information about  the type of quote as well as the exact effective datetime (to the microsecond) from which it became valid.                In the request each quote must be keyed by a unique correlation id. This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each quote in the response.                The response will return both the collection of successfully deleted quotes, as well as those that failed.  For the failures a reason will be provided explaining why the quote could not be deleted.                It is important to always check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_quotes(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the quotes to delete. (required)
        :type scope: str
        :param request_body: The quotes to delete keyed by a unique correlation id.
        :type request_body: Dict[str, QuoteId]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AnnulQuotesResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_quotes_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_quotes_with_http_info(scope, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_quotes_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to delete.")], request_body : Annotated[Optional[Dict[str, QuoteId]], Field(description="The quotes to delete keyed by a unique correlation id.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteQuotes: Delete quotes  # noqa: E501

        Delete one or more specified quotes from a single scope. A quote is identified by its unique id which includes information about  the type of quote as well as the exact effective datetime (to the microsecond) from which it became valid.                In the request each quote must be keyed by a unique correlation id. This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each quote in the response.                The response will return both the collection of successfully deleted quotes, as well as those that failed.  For the failures a reason will be provided explaining why the quote could not be deleted.                It is important to always check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_quotes_with_http_info(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the quotes to delete. (required)
        :type scope: str
        :param request_body: The quotes to delete keyed by a unique correlation id.
        :type request_body: Dict[str, QuoteId]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AnnulQuotesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quotes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AnnulQuotesResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/quotes/{scope}/$delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_quotes(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to retrieve.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the quotes. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the quotes. Defaults to return the latest version of each quote if not specified.")] = None, max_age : Annotated[Optional[StrictStr], Field( description="The duration of the look back window in an ISO8601 time interval format e.g. P1Y2M3DT4H30M (1 year, 2 months, 3 days, 4 hours and 30 minutes).               This is subtracted from the provided effectiveAt datetime or cut label to generate a effective datetime window inside which a quote must exist to be retrieved.")] = None, request_body : Annotated[Optional[Dict[str, QuoteSeriesId]], Field(description="The time invariant quote series ids of the quotes to retrieve. These need to be               keyed by a unique correlation id allowing the retrieved quote to be identified in the response.")] = None, **kwargs) -> GetQuotesResponse:  # noqa: E501
        ...

    @overload
    def get_quotes(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to retrieve.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the quotes. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the quotes. Defaults to return the latest version of each quote if not specified.")] = None, max_age : Annotated[Optional[StrictStr], Field( description="The duration of the look back window in an ISO8601 time interval format e.g. P1Y2M3DT4H30M (1 year, 2 months, 3 days, 4 hours and 30 minutes).               This is subtracted from the provided effectiveAt datetime or cut label to generate a effective datetime window inside which a quote must exist to be retrieved.")] = None, request_body : Annotated[Optional[Dict[str, QuoteSeriesId]], Field(description="The time invariant quote series ids of the quotes to retrieve. These need to be               keyed by a unique correlation id allowing the retrieved quote to be identified in the response.")] = None, async_req: Optional[bool]=True, **kwargs) -> GetQuotesResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_quotes(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to retrieve.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the quotes. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the quotes. Defaults to return the latest version of each quote if not specified.")] = None, max_age : Annotated[Optional[StrictStr], Field( description="The duration of the look back window in an ISO8601 time interval format e.g. P1Y2M3DT4H30M (1 year, 2 months, 3 days, 4 hours and 30 minutes).               This is subtracted from the provided effectiveAt datetime or cut label to generate a effective datetime window inside which a quote must exist to be retrieved.")] = None, request_body : Annotated[Optional[Dict[str, QuoteSeriesId]], Field(description="The time invariant quote series ids of the quotes to retrieve. These need to be               keyed by a unique correlation id allowing the retrieved quote to be identified in the response.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[GetQuotesResponse, Awaitable[GetQuotesResponse]]:  # noqa: E501
        """GetQuotes: Get quotes  # noqa: E501

        Get one or more quotes from a single scope.                Each quote can be identified by its time invariant quote series id.                For each quote series id LUSID will return the most recent quote with respect to the provided (or default) effective datetime.                 An optional maximum age range window can be specified which defines how far back to look back for a quote from the specified effective datetime.  LUSID will return the most recent quote within this window.                In the request each quote series id must be keyed by a unique correlation id. This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each quote in the response.                The response will return three collections. One, the successfully retrieved quotes. Two, those that had a  valid quote series id but could not be found. Three, those that failed because LUSID could not construct a valid quote series id from the request.    For the quotes that failed or could not be found a reason will be provided explaining why the quote could not be retrieved.                It is important to always check the failed and not found sets for any unsuccessful results.  The maximum number of quotes that this method can get per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_quotes(scope, effective_at, as_at, max_age, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the quotes to retrieve. (required)
        :type scope: str
        :param effective_at: The effective datetime or cut label at which to retrieve the quotes. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the quotes. Defaults to return the latest version of each quote if not specified.
        :type as_at: datetime
        :param max_age: The duration of the look back window in an ISO8601 time interval format e.g. P1Y2M3DT4H30M (1 year, 2 months, 3 days, 4 hours and 30 minutes).               This is subtracted from the provided effectiveAt datetime or cut label to generate a effective datetime window inside which a quote must exist to be retrieved.
        :type max_age: str
        :param request_body: The time invariant quote series ids of the quotes to retrieve. These need to be               keyed by a unique correlation id allowing the retrieved quote to be identified in the response.
        :type request_body: Dict[str, QuoteSeriesId]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetQuotesResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_quotes_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_quotes_with_http_info(scope, effective_at, as_at, max_age, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def get_quotes_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to retrieve.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the quotes. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the quotes. Defaults to return the latest version of each quote if not specified.")] = None, max_age : Annotated[Optional[StrictStr], Field( description="The duration of the look back window in an ISO8601 time interval format e.g. P1Y2M3DT4H30M (1 year, 2 months, 3 days, 4 hours and 30 minutes).               This is subtracted from the provided effectiveAt datetime or cut label to generate a effective datetime window inside which a quote must exist to be retrieved.")] = None, request_body : Annotated[Optional[Dict[str, QuoteSeriesId]], Field(description="The time invariant quote series ids of the quotes to retrieve. These need to be               keyed by a unique correlation id allowing the retrieved quote to be identified in the response.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetQuotes: Get quotes  # noqa: E501

        Get one or more quotes from a single scope.                Each quote can be identified by its time invariant quote series id.                For each quote series id LUSID will return the most recent quote with respect to the provided (or default) effective datetime.                 An optional maximum age range window can be specified which defines how far back to look back for a quote from the specified effective datetime.  LUSID will return the most recent quote within this window.                In the request each quote series id must be keyed by a unique correlation id. This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each quote in the response.                The response will return three collections. One, the successfully retrieved quotes. Two, those that had a  valid quote series id but could not be found. Three, those that failed because LUSID could not construct a valid quote series id from the request.    For the quotes that failed or could not be found a reason will be provided explaining why the quote could not be retrieved.                It is important to always check the failed and not found sets for any unsuccessful results.  The maximum number of quotes that this method can get per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_quotes_with_http_info(scope, effective_at, as_at, max_age, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the quotes to retrieve. (required)
        :type scope: str
        :param effective_at: The effective datetime or cut label at which to retrieve the quotes. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the quotes. Defaults to return the latest version of each quote if not specified.
        :type as_at: datetime
        :param max_age: The duration of the look back window in an ISO8601 time interval format e.g. P1Y2M3DT4H30M (1 year, 2 months, 3 days, 4 hours and 30 minutes).               This is subtracted from the provided effectiveAt datetime or cut label to generate a effective datetime window inside which a quote must exist to be retrieved.
        :type max_age: str
        :param request_body: The time invariant quote series ids of the quotes to retrieve. These need to be               keyed by a unique correlation id allowing the retrieved quote to be identified in the response.
        :type request_body: Dict[str, QuoteSeriesId]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetQuotesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'effective_at',
            'as_at',
            'max_age',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quotes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('max_age') is not None:  # noqa: E501
            _query_params.append(('maxAge', _params['max_age']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "GetQuotesResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/quotes/{scope}/$get', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_quotes_access_metadata_rule(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Quote Access Metadata Rule to retrieve.")], provider : Annotated[Optional[StrictStr], Field( description="The Provider of the rule")] = None, price_source : Annotated[Optional[StrictStr], Field( description="The PriceSource of the rule")] = None, instrument_id_type : Annotated[Optional[StrictStr], Field( description="The InstrumentIdType of the rule")] = None, instrument_id : Annotated[Optional[StrictStr], Field( description="The InstrumentId of the rule")] = None, quote_type : Annotated[Optional[StrictStr], Field( description="The QuoteType of the rule")] = None, field : Annotated[Optional[StrictStr], Field( description="The Field of the rule")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective date of the rule")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the access metadata rule. Defaults to return the latest version if not specified.")] = None, **kwargs) -> QuoteAccessMetadataRule:  # noqa: E501
        ...

    @overload
    def get_quotes_access_metadata_rule(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Quote Access Metadata Rule to retrieve.")], provider : Annotated[Optional[StrictStr], Field( description="The Provider of the rule")] = None, price_source : Annotated[Optional[StrictStr], Field( description="The PriceSource of the rule")] = None, instrument_id_type : Annotated[Optional[StrictStr], Field( description="The InstrumentIdType of the rule")] = None, instrument_id : Annotated[Optional[StrictStr], Field( description="The InstrumentId of the rule")] = None, quote_type : Annotated[Optional[StrictStr], Field( description="The QuoteType of the rule")] = None, field : Annotated[Optional[StrictStr], Field( description="The Field of the rule")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective date of the rule")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the access metadata rule. Defaults to return the latest version if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> QuoteAccessMetadataRule:  # noqa: E501
        ...

    @validate_arguments
    def get_quotes_access_metadata_rule(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Quote Access Metadata Rule to retrieve.")], provider : Annotated[Optional[StrictStr], Field( description="The Provider of the rule")] = None, price_source : Annotated[Optional[StrictStr], Field( description="The PriceSource of the rule")] = None, instrument_id_type : Annotated[Optional[StrictStr], Field( description="The InstrumentIdType of the rule")] = None, instrument_id : Annotated[Optional[StrictStr], Field( description="The InstrumentId of the rule")] = None, quote_type : Annotated[Optional[StrictStr], Field( description="The QuoteType of the rule")] = None, field : Annotated[Optional[StrictStr], Field( description="The Field of the rule")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective date of the rule")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the access metadata rule. Defaults to return the latest version if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[QuoteAccessMetadataRule, Awaitable[QuoteAccessMetadataRule]]:  # noqa: E501
        """[EXPERIMENTAL] GetQuotesAccessMetadataRule: Get a quote access metadata rule  # noqa: E501

        Get a specific quote access metadata rule by specifying the corresponding identifier parts                No matching will be performed through this endpoint. To retrieve a rule, it is necessary to specify, exactly, the identifier of the rule  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_quotes_access_metadata_rule(scope, provider, price_source, instrument_id_type, instrument_id, quote_type, field, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Quote Access Metadata Rule to retrieve. (required)
        :type scope: str
        :param provider: The Provider of the rule
        :type provider: str
        :param price_source: The PriceSource of the rule
        :type price_source: str
        :param instrument_id_type: The InstrumentIdType of the rule
        :type instrument_id_type: str
        :param instrument_id: The InstrumentId of the rule
        :type instrument_id: str
        :param quote_type: The QuoteType of the rule
        :type quote_type: str
        :param field: The Field of the rule
        :type field: str
        :param effective_at: The effective date of the rule
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the access metadata rule. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: QuoteAccessMetadataRule
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_quotes_access_metadata_rule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_quotes_access_metadata_rule_with_http_info(scope, provider, price_source, instrument_id_type, instrument_id, quote_type, field, effective_at, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_quotes_access_metadata_rule_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Quote Access Metadata Rule to retrieve.")], provider : Annotated[Optional[StrictStr], Field( description="The Provider of the rule")] = None, price_source : Annotated[Optional[StrictStr], Field( description="The PriceSource of the rule")] = None, instrument_id_type : Annotated[Optional[StrictStr], Field( description="The InstrumentIdType of the rule")] = None, instrument_id : Annotated[Optional[StrictStr], Field( description="The InstrumentId of the rule")] = None, quote_type : Annotated[Optional[StrictStr], Field( description="The QuoteType of the rule")] = None, field : Annotated[Optional[StrictStr], Field( description="The Field of the rule")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective date of the rule")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the access metadata rule. Defaults to return the latest version if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetQuotesAccessMetadataRule: Get a quote access metadata rule  # noqa: E501

        Get a specific quote access metadata rule by specifying the corresponding identifier parts                No matching will be performed through this endpoint. To retrieve a rule, it is necessary to specify, exactly, the identifier of the rule  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_quotes_access_metadata_rule_with_http_info(scope, provider, price_source, instrument_id_type, instrument_id, quote_type, field, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Quote Access Metadata Rule to retrieve. (required)
        :type scope: str
        :param provider: The Provider of the rule
        :type provider: str
        :param price_source: The PriceSource of the rule
        :type price_source: str
        :param instrument_id_type: The InstrumentIdType of the rule
        :type instrument_id_type: str
        :param instrument_id: The InstrumentId of the rule
        :type instrument_id: str
        :param quote_type: The QuoteType of the rule
        :type quote_type: str
        :param field: The Field of the rule
        :type field: str
        :param effective_at: The effective date of the rule
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the access metadata rule. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(QuoteAccessMetadataRule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'provider',
            'price_source',
            'instrument_id_type',
            'instrument_id',
            'quote_type',
            'field',
            'effective_at',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quotes_access_metadata_rule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        if _params.get('provider') is not None:  # noqa: E501
            _query_params.append(('provider', _params['provider']))

        if _params.get('price_source') is not None:  # noqa: E501
            _query_params.append(('priceSource', _params['price_source']))

        if _params.get('instrument_id_type') is not None:  # noqa: E501
            _query_params.append(('instrumentIdType', _params['instrument_id_type']))

        if _params.get('instrument_id') is not None:  # noqa: E501
            _query_params.append(('instrumentId', _params['instrument_id']))

        if _params.get('quote_type') is not None:  # noqa: E501
            _query_params.append(('quoteType', _params['quote_type']))

        if _params.get('field') is not None:  # noqa: E501
            _query_params.append(('field', _params['field']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "QuoteAccessMetadataRule",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/metadata/quotes/rules', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_quotes(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to list.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the quotes. Defaults to latest if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing quotes from a previous call to list quotes.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ResourceListOfQuote:  # noqa: E501
        ...

    @overload
    def list_quotes(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to list.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the quotes. Defaults to latest if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing quotes from a previous call to list quotes.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfQuote:  # noqa: E501
        ...

    @validate_arguments
    def list_quotes(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to list.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the quotes. Defaults to latest if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing quotes from a previous call to list quotes.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfQuote, Awaitable[ResourceListOfQuote]]:  # noqa: E501
        """[DEPRECATED] ListQuotes: List quotes  # noqa: E501

        List all the quotes from a single scope at the specified date/time  Please use ListQuotesForScope - the signature and behaviour of this endpoint will be changing to omit scope  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_quotes(scope, as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the quotes to list. (required)
        :type scope: str
        :param as_at: The asAt datetime at which to list the quotes. Defaults to latest if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing quotes from a previous call to list quotes.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set.              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfQuote
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_quotes_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_quotes_with_http_info(scope, as_at, page, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_quotes_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to list.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the quotes. Defaults to latest if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing quotes from a previous call to list quotes.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[DEPRECATED] ListQuotes: List quotes  # noqa: E501

        List all the quotes from a single scope at the specified date/time  Please use ListQuotesForScope - the signature and behaviour of this endpoint will be changing to omit scope  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_quotes_with_http_info(scope, as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the quotes to list. (required)
        :type scope: str
        :param as_at: The asAt datetime at which to list the quotes. Defaults to latest if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing quotes from a previous call to list quotes.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set.              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfQuote, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'as_at',
            'page',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_quotes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfQuote",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/quotes/{scope}/$deprecated', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_quotes_access_metadata_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Quote Access Metadata Rule to retrieve.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the access metadata rule. Defaults to return the latest version if not specified.")] = None, **kwargs) -> ResourceListOfQuoteAccessMetadataRule:  # noqa: E501
        ...

    @overload
    def list_quotes_access_metadata_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Quote Access Metadata Rule to retrieve.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the access metadata rule. Defaults to return the latest version if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfQuoteAccessMetadataRule:  # noqa: E501
        ...

    @validate_arguments
    def list_quotes_access_metadata_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Quote Access Metadata Rule to retrieve.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the access metadata rule. Defaults to return the latest version if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfQuoteAccessMetadataRule, Awaitable[ResourceListOfQuoteAccessMetadataRule]]:  # noqa: E501
        """[EXPERIMENTAL] ListQuotesAccessMetadataRules: List all quote access metadata rules in a scope  # noqa: E501

        Get all the quote access metadata rules in the specified scope  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_quotes_access_metadata_rules(scope, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Quote Access Metadata Rule to retrieve. (required)
        :type scope: str
        :param as_at: The asAt datetime at which to retrieve the access metadata rule. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfQuoteAccessMetadataRule
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_quotes_access_metadata_rules_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_quotes_access_metadata_rules_with_http_info(scope, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def list_quotes_access_metadata_rules_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Quote Access Metadata Rule to retrieve.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the access metadata rule. Defaults to return the latest version if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListQuotesAccessMetadataRules: List all quote access metadata rules in a scope  # noqa: E501

        Get all the quote access metadata rules in the specified scope  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_quotes_access_metadata_rules_with_http_info(scope, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Quote Access Metadata Rule to retrieve. (required)
        :type scope: str
        :param as_at: The asAt datetime at which to retrieve the access metadata rule. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfQuoteAccessMetadataRule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_quotes_access_metadata_rules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfQuoteAccessMetadataRule",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/metadata/quotes/rules/{scope}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_quotes_for_scope(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to list.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the quotes. Defaults to latest if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing quotes from a previous call to list quotes.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ResourceListOfQuote:  # noqa: E501
        ...

    @overload
    def list_quotes_for_scope(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to list.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the quotes. Defaults to latest if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing quotes from a previous call to list quotes.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfQuote:  # noqa: E501
        ...

    @validate_arguments
    def list_quotes_for_scope(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to list.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the quotes. Defaults to latest if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing quotes from a previous call to list quotes.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfQuote, Awaitable[ResourceListOfQuote]]:  # noqa: E501
        """ListQuotesForScope: List quotes for scope  # noqa: E501

        List all the quotes from a single scope at the specified date/time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_quotes_for_scope(scope, as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the quotes to list. (required)
        :type scope: str
        :param as_at: The asAt datetime at which to list the quotes. Defaults to latest if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing quotes from a previous call to list quotes.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set.              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfQuote
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_quotes_for_scope_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_quotes_for_scope_with_http_info(scope, as_at, page, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_quotes_for_scope_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the quotes to list.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the quotes. Defaults to latest if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing quotes from a previous call to list quotes.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListQuotesForScope: List quotes for scope  # noqa: E501

        List all the quotes from a single scope at the specified date/time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_quotes_for_scope_with_http_info(scope, as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the quotes to list. (required)
        :type scope: str
        :param as_at: The asAt datetime at which to list the quotes. Defaults to latest if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing quotes from a previous call to list quotes.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set.              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfQuote, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'as_at',
            'page',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_quotes_for_scope" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfQuote",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/quotes/{scope}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_quote_access_metadata_rule(self, scope : Annotated[StrictStr, Field(..., description="The scope to use when updating or inserting the Quote Access Metadata Rule.")], upsert_quote_access_metadata_rule_request : Annotated[UpsertQuoteAccessMetadataRuleRequest, Field(..., description="The Quote Access Metadata Rule to update or insert")], effective_at : Annotated[Optional[StrictStr], Field( description="The date this rule will effective from")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective date until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata")] = None, **kwargs) -> QuoteAccessMetadataRule:  # noqa: E501
        ...

    @overload
    def upsert_quote_access_metadata_rule(self, scope : Annotated[StrictStr, Field(..., description="The scope to use when updating or inserting the Quote Access Metadata Rule.")], upsert_quote_access_metadata_rule_request : Annotated[UpsertQuoteAccessMetadataRuleRequest, Field(..., description="The Quote Access Metadata Rule to update or insert")], effective_at : Annotated[Optional[StrictStr], Field( description="The date this rule will effective from")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective date until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata")] = None, async_req: Optional[bool]=True, **kwargs) -> QuoteAccessMetadataRule:  # noqa: E501
        ...

    @validate_arguments
    def upsert_quote_access_metadata_rule(self, scope : Annotated[StrictStr, Field(..., description="The scope to use when updating or inserting the Quote Access Metadata Rule.")], upsert_quote_access_metadata_rule_request : Annotated[UpsertQuoteAccessMetadataRuleRequest, Field(..., description="The Quote Access Metadata Rule to update or insert")], effective_at : Annotated[Optional[StrictStr], Field( description="The date this rule will effective from")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective date until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[QuoteAccessMetadataRule, Awaitable[QuoteAccessMetadataRule]]:  # noqa: E501
        """[EXPERIMENTAL] UpsertQuoteAccessMetadataRule: Upsert a Quote Access Metadata Rule. This creates or updates the data in LUSID.  # noqa: E501

        Update or insert one Quote Access Metadata Rule in a single scope. An item will be updated if it already exists  and inserted if it does not.    The response will return the successfully updated or inserted Quote Access Metadata Rule or failure message if unsuccessful    It is important to always check to verify success (or failure).                Multiple rules for a key can exists with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_quote_access_metadata_rule(scope, upsert_quote_access_metadata_rule_request, effective_at, effective_until, async_req=True)
        >>> result = thread.get()

        :param scope: The scope to use when updating or inserting the Quote Access Metadata Rule. (required)
        :type scope: str
        :param upsert_quote_access_metadata_rule_request: The Quote Access Metadata Rule to update or insert (required)
        :type upsert_quote_access_metadata_rule_request: UpsertQuoteAccessMetadataRuleRequest
        :param effective_at: The date this rule will effective from
        :type effective_at: str
        :param effective_until: The effective date until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: QuoteAccessMetadataRule
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_quote_access_metadata_rule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_quote_access_metadata_rule_with_http_info(scope, upsert_quote_access_metadata_rule_request, effective_at, effective_until, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_quote_access_metadata_rule_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope to use when updating or inserting the Quote Access Metadata Rule.")], upsert_quote_access_metadata_rule_request : Annotated[UpsertQuoteAccessMetadataRuleRequest, Field(..., description="The Quote Access Metadata Rule to update or insert")], effective_at : Annotated[Optional[StrictStr], Field( description="The date this rule will effective from")] = None, effective_until : Annotated[Optional[datetime], Field(description="The effective date until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpsertQuoteAccessMetadataRule: Upsert a Quote Access Metadata Rule. This creates or updates the data in LUSID.  # noqa: E501

        Update or insert one Quote Access Metadata Rule in a single scope. An item will be updated if it already exists  and inserted if it does not.    The response will return the successfully updated or inserted Quote Access Metadata Rule or failure message if unsuccessful    It is important to always check to verify success (or failure).                Multiple rules for a key can exists with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_quote_access_metadata_rule_with_http_info(scope, upsert_quote_access_metadata_rule_request, effective_at, effective_until, async_req=True)
        >>> result = thread.get()

        :param scope: The scope to use when updating or inserting the Quote Access Metadata Rule. (required)
        :type scope: str
        :param upsert_quote_access_metadata_rule_request: The Quote Access Metadata Rule to update or insert (required)
        :type upsert_quote_access_metadata_rule_request: UpsertQuoteAccessMetadataRuleRequest
        :param effective_at: The date this rule will effective from
        :type effective_at: str
        :param effective_until: The effective date until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' date of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(QuoteAccessMetadataRule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'upsert_quote_access_metadata_rule_request',
            'effective_at',
            'effective_until'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_quote_access_metadata_rule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('effective_until') is not None:  # noqa: E501
            if isinstance(_params['effective_until'], datetime):
                _query_params.append(('effectiveUntil', _params['effective_until'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('effectiveUntil', _params['effective_until']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_quote_access_metadata_rule_request'] is not None:
            _body_params = _params['upsert_quote_access_metadata_rule_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "QuoteAccessMetadataRule",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/metadata/quotes/rules/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_quotes(self, scope : Annotated[StrictStr, Field(..., description="The scope to use when updating or inserting the quotes.")], request_body : Annotated[Optional[Dict[str, UpsertQuoteRequest]], Field(description="The quotes to update or insert keyed by a unique correlation id.")] = None, **kwargs) -> UpsertQuotesResponse:  # noqa: E501
        ...

    @overload
    def upsert_quotes(self, scope : Annotated[StrictStr, Field(..., description="The scope to use when updating or inserting the quotes.")], request_body : Annotated[Optional[Dict[str, UpsertQuoteRequest]], Field(description="The quotes to update or insert keyed by a unique correlation id.")] = None, async_req: Optional[bool]=True, **kwargs) -> UpsertQuotesResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_quotes(self, scope : Annotated[StrictStr, Field(..., description="The scope to use when updating or inserting the quotes.")], request_body : Annotated[Optional[Dict[str, UpsertQuoteRequest]], Field(description="The quotes to update or insert keyed by a unique correlation id.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[UpsertQuotesResponse, Awaitable[UpsertQuotesResponse]]:  # noqa: E501
        """UpsertQuotes: Upsert quotes  # noqa: E501

        Update or insert one or more quotes in a single scope. A quote will be updated if it already exists  and inserted if it does not.                In the request each quote must be keyed by a unique correlation id. This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each quote in the response.                The response will return both the collection of successfully updated or inserted quotes, as well as those that failed.  For the failures a reason will be provided explaining why the quote could not be updated or inserted.                It is important to always check the failed set for any unsuccessful results.  The maximum number of quotes that this method can upsert per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_quotes(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope to use when updating or inserting the quotes. (required)
        :type scope: str
        :param request_body: The quotes to update or insert keyed by a unique correlation id.
        :type request_body: Dict[str, UpsertQuoteRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertQuotesResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_quotes_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_quotes_with_http_info(scope, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_quotes_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope to use when updating or inserting the quotes.")], request_body : Annotated[Optional[Dict[str, UpsertQuoteRequest]], Field(description="The quotes to update or insert keyed by a unique correlation id.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """UpsertQuotes: Upsert quotes  # noqa: E501

        Update or insert one or more quotes in a single scope. A quote will be updated if it already exists  and inserted if it does not.                In the request each quote must be keyed by a unique correlation id. This id is ephemeral and is not stored by LUSID.  It serves only as a way to easily identify each quote in the response.                The response will return both the collection of successfully updated or inserted quotes, as well as those that failed.  For the failures a reason will be provided explaining why the quote could not be updated or inserted.                It is important to always check the failed set for any unsuccessful results.  The maximum number of quotes that this method can upsert per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_quotes_with_http_info(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope to use when updating or inserting the quotes. (required)
        :type scope: str
        :param request_body: The quotes to update or insert keyed by a unique correlation id.
        :type request_body: Dict[str, UpsertQuoteRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertQuotesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_quotes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpsertQuotesResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/quotes/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
