# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, conlist, constr, validator 

class CreateCorporateActionSourceRequest(BaseModel):
    """
    CreateCorporateActionSourceRequest
    """
    scope:  StrictStr = Field(...,alias="scope", description="The scope of the corporate action source") 
    code:  StrictStr = Field(...,alias="code", description="The code of the corporate action source") 
    display_name:  StrictStr = Field(...,alias="displayName", description="The name of the corporate action source") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="The description of the corporate action source") 
    instrument_scopes: Optional[conlist(StrictStr)] = Field(None, alias="instrumentScopes", description="The list of instrument scopes used as the scope resolution strategy when resolving instruments of upserted corporate actions.")
    __properties = ["scope", "code", "displayName", "description", "instrumentScopes"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateCorporateActionSourceRequest:
        """Create an instance of CreateCorporateActionSourceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if instrument_scopes (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_scopes is None and "instrument_scopes" in self.__fields_set__:
            _dict['instrumentScopes'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateCorporateActionSourceRequest:
        """Create an instance of CreateCorporateActionSourceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateCorporateActionSourceRequest.parse_obj(obj)

        _obj = CreateCorporateActionSourceRequest.parse_obj({
            "scope": obj.get("scope"),
            "code": obj.get("code"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "instrument_scopes": obj.get("instrumentScopes")
        })
        return _obj
