# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr 

class DescribedAddressKey(BaseModel):
    """
    An address key with additional data describing what this key is for.  # noqa: E501
    """
    address_key:  Optional[StrictStr] = Field(None,alias="addressKey", description="Address key of some underlying object e.g. Valuation/PV, Instrument/Features") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="Description of the address key.") 
    __properties = ["addressKey", "description"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DescribedAddressKey:
        """Create an instance of DescribedAddressKey from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if address_key (nullable) is None
        # and __fields_set__ contains the field
        if self.address_key is None and "address_key" in self.__fields_set__:
            _dict['addressKey'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DescribedAddressKey:
        """Create an instance of DescribedAddressKey from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DescribedAddressKey.parse_obj(obj)

        _obj = DescribedAddressKey.parse_obj({
            "address_key": obj.get("addressKey"),
            "description": obj.get("description")
        })
        return _obj
