# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool, constr 
from lusid.models.resource_id import ResourceId

class RelationalDatasetFieldDefinition(BaseModel):
    """
    RelationalDatasetFieldDefinition
    """
    field_name:  StrictStr = Field(...,alias="fieldName", description="The unique identifier for the field within the dataset.") 
    display_name:  Optional[StrictStr] = Field(None,alias="displayName", description="A user-friendly display name for the field.") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="A detailed description of the field and its purpose.") 
    data_type_id: ResourceId = Field(..., alias="dataTypeId")
    required: Optional[StrictBool] = Field(None, description="Whether this field is mandatory in the dataset.")
    category:  StrictStr = Field(...,alias="category", description="The intended category of the field (SeriesIdentifier, Value, or Metadata).") 
    __properties = ["fieldName", "displayName", "description", "dataTypeId", "required", "category"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RelationalDatasetFieldDefinition:
        """Create an instance of RelationalDatasetFieldDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of data_type_id
        if self.data_type_id:
            _dict['dataTypeId'] = self.data_type_id.to_dict()
        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RelationalDatasetFieldDefinition:
        """Create an instance of RelationalDatasetFieldDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RelationalDatasetFieldDefinition.parse_obj(obj)

        _obj = RelationalDatasetFieldDefinition.parse_obj({
            "field_name": obj.get("fieldName"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "data_type_id": ResourceId.from_dict(obj.get("dataTypeId")) if obj.get("dataTypeId") is not None else None,
            "required": obj.get("required"),
            "category": obj.get("category")
        })
        return _obj
