# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, conlist 
from lusid.models.link import Link
from lusid.models.property_value import PropertyValue
from lusid.models.staged_modification_effective_range import StagedModificationEffectiveRange

class StagedModificationsRequestedChangeInterval(BaseModel):
    """
    StagedModificationsRequestedChangeInterval
    """
    attribute_name:  Optional[StrictStr] = Field(None,alias="attributeName", description="Name of the property the change applies to.") 
    effective_range: Optional[StagedModificationEffectiveRange] = Field(None, alias="effectiveRange")
    previous_value: Optional[PropertyValue] = Field(None, alias="previousValue")
    new_value: Optional[PropertyValue] = Field(None, alias="newValue")
    as_at_basis:  Optional[StrictStr] = Field(None,alias="asAtBasis", description="Whether the change represents the modification when the request was made or the modification as it would be at the latest time.") 
    links: Optional[conlist(Link)] = None
    __properties = ["attributeName", "effectiveRange", "previousValue", "newValue", "asAtBasis", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StagedModificationsRequestedChangeInterval:
        """Create an instance of StagedModificationsRequestedChangeInterval from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of effective_range
        if self.effective_range:
            _dict['effectiveRange'] = self.effective_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of previous_value
        if self.previous_value:
            _dict['previousValue'] = self.previous_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of new_value
        if self.new_value:
            _dict['newValue'] = self.new_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if attribute_name (nullable) is None
        # and __fields_set__ contains the field
        if self.attribute_name is None and "attribute_name" in self.__fields_set__:
            _dict['attributeName'] = None

        # set to None if as_at_basis (nullable) is None
        # and __fields_set__ contains the field
        if self.as_at_basis is None and "as_at_basis" in self.__fields_set__:
            _dict['asAtBasis'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StagedModificationsRequestedChangeInterval:
        """Create an instance of StagedModificationsRequestedChangeInterval from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StagedModificationsRequestedChangeInterval.parse_obj(obj)

        _obj = StagedModificationsRequestedChangeInterval.parse_obj({
            "attribute_name": obj.get("attributeName"),
            "effective_range": StagedModificationEffectiveRange.from_dict(obj.get("effectiveRange")) if obj.get("effectiveRange") is not None else None,
            "previous_value": PropertyValue.from_dict(obj.get("previousValue")) if obj.get("previousValue") is not None else None,
            "new_value": PropertyValue.from_dict(obj.get("newValue")) if obj.get("newValue") is not None else None,
            "as_at_basis": obj.get("asAtBasis"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
