# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr, validator 

class TimeZoneConventions(BaseModel):
    """
    Provides information on the primary time zone of an instrument and optional cut labels  for defining times to be used by instrument events.  # noqa: E501
    """
    primary_time_zone:  StrictStr = Field(...,alias="primaryTimeZone", description="The IANA time zone code for the instrument.") 
    start_of_day:  Optional[StrictStr] = Field(None,alias="startOfDay", description="A LUSID Cut Label code used for generating instrument events at a time other than local midnight.") 
    primary_market_open:  Optional[StrictStr] = Field(None,alias="primaryMarketOpen", description="A LUSID Cut Label code used for delaying the transaction time of certain instrument events until market open.") 
    __properties = ["primaryTimeZone", "startOfDay", "primaryMarketOpen"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TimeZoneConventions:
        """Create an instance of TimeZoneConventions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if start_of_day (nullable) is None
        # and __fields_set__ contains the field
        if self.start_of_day is None and "start_of_day" in self.__fields_set__:
            _dict['startOfDay'] = None

        # set to None if primary_market_open (nullable) is None
        # and __fields_set__ contains the field
        if self.primary_market_open is None and "primary_market_open" in self.__fields_set__:
            _dict['primaryMarketOpen'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TimeZoneConventions:
        """Create an instance of TimeZoneConventions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TimeZoneConventions.parse_obj(obj)

        _obj = TimeZoneConventions.parse_obj({
            "primary_time_zone": obj.get("primaryTimeZone"),
            "start_of_day": obj.get("startOfDay"),
            "primary_market_open": obj.get("primaryMarketOpen")
        })
        return _obj
