# Contributing to pyGSTi

Thanks for taking the time to contribute to pyGSTi! Open-source
projects like ours couldn't exist without contributors like you.

This document contains a set of guidelines for contributing to pyGSTi
and related packages hosted under the SandiaLabs organization. We ask
that contributors make an earnest effort to follow these guidelines,
but no one's keeping score here -- just use your best judgement, and
by all means, feel free to propose changes to these guidelines in a
pull request.

### Reporting Bugs

Found a bug in pyGSTi? We'd appreciate letting us know!

* First, **see if the bug has already been reported** by searching on
  Github under [Issues][issues]. Make sure to check for issues that
  are closed but have the *fixed-but-not-in-release* tag also - these
  mean they are fixed in our `develop` branch, so you can try that to
  see if it fixes your issue.

* If you can't find an open issue about the problem,
  [open a new one][issues:bug]! Be sure to include a **title**, a
  **clear description** of what went wrong, and **as much relevant
  information as possible.** If you can, try to include detailed steps
  to reproduce the problem.

* Once you open an issue, please **keep an eye on it** -- you may be
  asked to provide more details.

### Suggesting Features & Enhancements

Want to add a new feature or change an existing one?

* First, **see if the feature or enhancement has already been
  suggested** by searching on Github under [Issues][issues].

* If you can't find a similar suggestion in the issue tracker,
  [open a new issue][issues:feature] for your feature suggestion.

### Making a Contribution

Want to fix a bug, add a feature, or change an existing feature?

Because pyGSTi is a project of the Quantum Performance Lab at Sandia
National Labs, the process of contributing to pyGSTi is different for
contributors working at Sandia.

#### For non-Sandians

If you're interested in making contributions please let us know by email at
[pygsti@sandia.gov][email] so we can get you a Contributor License Agreement
(CLA). This needs to be signed and through our system before you can contribute.

#### For Sandians

* **Join the SandiaLabs organization**.

* **Contact the authors** at [pygsti@sandia.gov][email] to
  request an invite to the [repository][pygsti].

[email]: mailto:pygsti@sandia.gov
[issues:bug]: https://github.com/sandialabs/pyGSTi/issues/new?labels=bug&template=bug_report.md
[issues:feature]: https://github.com/sandialabs/pyGSTi/issues/new?labels=enhancement&template=feature_request.md
[issues:new]: https://github.com/sandialabs/pyGSTi/issues/new
[issues]: https://github.com/sandialabs/pyGSTi/issues
[pygsti]: https://github.com/sandialabs/pyGSTi
