"""
A standard multi-qubit gate set module.

Variables for working with the 2-qubit model containing the gates
I*I, I*X(pi/2), I*Y(pi/2), X(pi/2)*I, Y(pi/2)*I, X(pi/2)*X(pi/2),
Y(pi/2)*Y(pi/2), X(pi/2)*Y(pi/2), and Y(pi/2)*X(pi/2) gates.
"""
#***************************************************************************************************
# Copyright 2015, 2019, 2025 National Technology & Engineering Solutions of Sandia, LLC (NTESS).
# Under the terms of Contract DE-NA0003525 with NTESS, the U.S. Government retains certain rights
# in this software.
# Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
# in compliance with the License.  You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0 or in the LICENSE file in the root pyGSTi directory.
#***************************************************************************************************

from collections import OrderedDict

from pygsti.modelpacks._modelpack import GSTModelPack, RBModelPack


class _Module(GSTModelPack, RBModelPack):
    description = ("I*I, I*X(pi/2), I*Y(pi/2), X(pi/2)*I, Y(pi/2)*I, X(pi/2)*X(pi/2), "
                   "Y(pi/2)*Y(pi/2), X(pi/2)*Y(pi/2), and Y(pi/2)*X(pi/2) gates")

    gates = [(), ('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)),
             (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))]

    _sslbls = (0, 1)

    _germs = [((), ), (('Gxpi2', 0), ), (('Gypi2', 0), ), (('Gxpi2', 1), ), (('Gypi2', 1), ), ((('Gxpi2', 0), ('Gxpi2', 1)), ), ((('Gxpi2', 0), ('Gypi2', 1)), ),
              ((('Gxpi2', 0), ('Gypi2', 1)), ), ((('Gypi2', 0), ('Gypi2', 1)), ), (('Gxpi2', 0), ('Gypi2', 0)), (('Gxpi2', 1), ('Gypi2', 1)),
              (('Gypi2', 1), ('Gypi2', 0)), (('Gxpi2', 1), ('Gxpi2', 0)), (('Gxpi2', 1), ('Gypi2', 0)), (('Gypi2', 1), ('Gxpi2', 0)),
              ((), ('Gxpi2', 1)), ((), ('Gypi2', 1)), ((), ('Gypi2', 0)), (('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1))), (('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1))),
              ((('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              ((('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1))), (('Gxpi2', 1), (('Gypi2', 0), ('Gypi2', 1))),
              (('Gypi2', 0), (('Gxpi2', 0), ('Gypi2', 1))), (('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0)), (('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1)),
              ((('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))),
              ((('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), (('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0)),
              (('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1)), (('Gypi2', 1), ('Gxpi2', 0), ('Gxpi2', 0)), (('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 0)),
              (('Gxpi2', 1), ('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 1), ('Gypi2', 0), ('Gxpi2', 0)), (('Gxpi2', 1), ('Gypi2', 0), ('Gypi2', 1)),
              (('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 0)), (('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 0)), (('Gypi2', 1), ('Gypi2', 0), ('Gxpi2', 0)),
              (('Gxpi2', 0), ('Gypi2', 0), ()), (('Gxpi2', 0), (), ('Gypi2', 0)), (('Gxpi2', 0), (), ()), (('Gypi2', 0), (), ()),
              (('Gxpi2', 1), ('Gypi2', 1), ()), (('Gxpi2', 1), (), ('Gypi2', 1)), (('Gxpi2', 1), (), ()), (('Gypi2', 1), (), ()),
              ((), ('Gxpi2', 1), ('Gypi2', 0)), ((), ('Gypi2', 1), ('Gypi2', 0)), ((), ('Gypi2', 0), ('Gxpi2', 1)),
              (('Gxpi2', 0), ('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1))), (('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))),
              (('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))), (('Gypi2', 1), ('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1))),
              (('Gxpi2', 1), ('Gxpi2', 1), (('Gxpi2', 0), ('Gxpi2', 1))), (('Gxpi2', 1), ('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1))),
              (('Gxpi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0)), ((), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))),
              (('Gxpi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1)), (('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0)),
              (('Gxpi2', 0), ('Gxpi2', 0), (('Gxpi2', 0), ('Gxpi2', 1))), (('Gxpi2', 0), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))),
              (('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), (('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              (('Gypi2', 0), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))), (('Gypi2', 1), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              (('Gxpi2', 1), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), (('Gypi2', 0), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              ((('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), (('Gypi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))),
              (('Gypi2', 0), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), (('Gypi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              ((('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))), ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              (('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))), (('Gxpi2', 0), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))), ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              (('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              (('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0)), (('Gxpi2', 0), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))),
              ((('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), (('Gypi2', 0), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))),
              (('Gypi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))), (('Gxpi2', 0), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))),
              ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1))), (('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              (('Gypi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), (('Gxpi2', 0), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))),
              (('Gypi2', 0), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), (('Gypi2', 0), ('Gypi2', 0), (('Gypi2', 0), ('Gypi2', 1))),
              (('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), ((('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0)),
              (('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 0)),
              (('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0)),
              (('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 1), ('Gypi2', 0)), (('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)),
              (('Gxpi2', 0), ('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()),
              (('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()), (('Gypi2', 1), ('Gxpi2', 0), (), ()), (('Gxpi2', 1), (), (), ('Gxpi2', 0)),
              ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0)), (('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gypi2', 1)),
              ((('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))),
              ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              (('Gypi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 0)),
              (('Gxpi2', 0), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))),
              (('Gypi2', 1), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 1)),
              (('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 1), ('Gypi2', 0), ('Gypi2', 1)),
              (('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 0), ('Gxpi2', 1), ('Gxpi2', 0)),
              (('Gypi2', 0), ('Gypi2', 1), ('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 1)),
              (('Gypi2', 1), ('Gxpi2', 0), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 0)),
              (('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 0), ('Gxpi2', 0)),
              (('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1)),
              ((), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))),
              ((('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))),
              (('Gxpi2', 0), ('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 1), ('Gypi2', 0)),
              (('Gxpi2', 0), ('Gypi2', 1), ('Gxpi2', 1), ('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 1)),
              ((('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1)),
              (('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0)),
              (('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1)),
              (('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gxpi2', 1)),
              (('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 1), ('Gxpi2', 0), ('Gxpi2', 1), ('Gypi2', 1)),
              (('Gxpi2', 0), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 0)),
              (('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 0), ('Gxpi2', 0)),
              (('Gypi2', 0), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1)),
              (('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 1), ('Gypi2', 0), ('Gxpi2', 1)),
              (('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 1), ('Gxpi2', 1), ('Gypi2', 1)),
              (('Gypi2', 0), ('Gxpi2', 0), ('Gypi2', 1), ('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0)),
              (('Gypi2', 1), ('Gxpi2', 1), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 0), ('Gypi2', 1)),
              ((), ('Gypi2', 0), ('Gxpi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (('Gxpi2', 0), ('Gxpi2', 1))),
              ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 1), (), ('Gypi2', 1)),
              (('Gypi2', 0), ('Gxpi2', 0), ('Gypi2', 1), ('Gxpi2', 0), ('Gxpi2', 1), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 1)),
              (('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 0), ('Gxpi2', 0), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 1), ('Gypi2', 0))]

    _germs_lite = [((), ), (('Gxpi2', 0), ), (('Gypi2', 0), ), (('Gxpi2', 1), ), (('Gypi2', 1), ), ((('Gxpi2', 0), ('Gxpi2', 1)), ),
                   ((('Gxpi2', 0), ('Gypi2', 1)), ), ((('Gxpi2', 0), ('Gypi2', 1)), ), ((('Gypi2', 0), ('Gypi2', 1)), ), (('Gxpi2', 0), ('Gypi2', 0)),
                   (('Gxpi2', 1), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0)), (('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1)),
                   ((('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))),
                   ((('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))), ((('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0)),
                   ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 0)),
                   (('Gxpi2', 0), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))),
                   (('Gxpi2', 0), ('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 1), ('Gypi2', 0)),
                   (('Gxpi2', 0), ('Gypi2', 1), ('Gxpi2', 1), ('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 1)),
                   ((('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1)),
                   (('Gypi2', 0), ('Gxpi2', 0), ('Gypi2', 1), ('Gxpi2', 0), ('Gxpi2', 1), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 1))]

    _fiducials = [(), (('Gxpi2', 1), ), (('Gypi2', 1), ), (('Gxpi2', 1), ('Gxpi2', 1)), (('Gxpi2', 0), ), (('Gxpi2', 0), ('Gxpi2', 1)),
                  (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1), ('Gxpi2', 1)), (('Gypi2', 0), ), (('Gypi2', 0), ('Gxpi2', 1)),
                  (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 0)),
                  (('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 1)),
                  (('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 1), ('Gxpi2', 1))]

    _prepfiducials = [(), (('Gxpi2', 1), ), (('Gypi2', 1), ), (('Gxpi2', 1), ('Gxpi2', 1)), (('Gxpi2', 0), ), (('Gxpi2', 0), ('Gxpi2', 1)),
                 (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1), ('Gxpi2', 1)), (('Gypi2', 0), ), (('Gypi2', 0), ('Gxpi2', 1)),
                 (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 0)),
                 (('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 1)),
                 (('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 1), ('Gxpi2', 1))]

    _measfiducials = [(), (('Gxpi2', 1), ), (('Gypi2', 1), ), (('Gxpi2', 1), ('Gxpi2', 1)), (('Gxpi2', 0), ), (('Gypi2', 0), ),
                   (('Gxpi2', 0), ('Gxpi2', 0)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1)),
                   (('Gypi2', 0), ('Gypi2', 1))]

    _clifford_compilation = OrderedDict([
        ('Gc0c0', [(), (), (), (), (), (), ()]), ('Gc0c1', [('Gypi2', 1), ('Gxpi2', 1), (), (), (), (), ()]),
        ('Gc0c2', [('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc0c3', [('Gxpi2', 1), ('Gxpi2', 1), (), (), (), (), ()]),
        ('Gc0c4', [('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc0c5', [('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc0c6', [('Gypi2', 1), ('Gypi2', 1), (), (), (), (), ()]),
        ('Gc0c7', [('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc0c8', [('Gxpi2', 1), ('Gypi2', 1), (), (), (), (), ()]),
        ('Gc0c9', [('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc0c10', [('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc0c11', [('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc0c12', [('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc0c13', [('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc0c14', [('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc0c15', [('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), (), (), ()]), ('Gc0c16', [('Gxpi2', 1), (), (), (), (), (), ()]),
        ('Gc0c17', [('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc0c18', [('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc0c19', [('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), (), (), ()]),
        ('Gc0c20', [('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc0c21', [('Gypi2', 1), (), (), (), (), (), ()]),
        ('Gc0c22', [('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), ()]),
        ('Gc0c23', [('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc1c0', [('Gypi2', 0), ('Gxpi2', 0), (), (), (), (), ()]),
        ('Gc1c1', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), (), ()]),
        ('Gc1c2', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc1c3', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), (), ()]),
        ('Gc1c4', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc1c5', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc1c6', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), (), ()]),
        ('Gc1c7', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc1c8', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), (), ()]),
        ('Gc1c9', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc1c10', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc1c11', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc1c12', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc1c13', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc1c14', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc1c15', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), (), ()]),
        ('Gc1c16', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), (), (), ()]),
        ('Gc1c17', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc1c18', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc1c19', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), (), ()]),
        ('Gc1c20', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc1c21', [(('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), (), (), ()]),
        ('Gc1c22', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), ()]),
        ('Gc1c23', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc2c0', [('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ()]),
        ('Gc2c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ()]),
        ('Gc2c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)),
                    ('Gxpi2', 1)]),
        ('Gc2c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ()]),
        ('Gc2c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ()]),
        ('Gc2c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()]),
        ('Gc2c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ()]),
        ('Gc2c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ()]),
        ('Gc3c0', [('Gxpi2', 0), ('Gxpi2', 0), (), (), (), (), ()]),
        ('Gc3c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), (), ()]),
        ('Gc3c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc3c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), (), ()]),
        ('Gc3c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc3c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc3c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), (), ()]),
        ('Gc3c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc3c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), (), ()]),
        ('Gc3c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc3c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc3c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc3c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc3c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc3c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc3c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), (), ()]),
        ('Gc3c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), (), (), (), (), ()]),
        ('Gc3c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc3c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc3c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), (), ()]),
        ('Gc3c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc3c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), (), (), ()]),
        ('Gc3c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), ()]),
        ('Gc3c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc4c0', [('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c1', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c2', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ()]),
        ('Gc4c3', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c4', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ()]),
        ('Gc4c5', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c6', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c7', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c8', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c9', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c10', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c11', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c12', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c13', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c14', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)),
                    ('Gxpi2', 1)]),
        ('Gc4c15', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c16', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c17', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c18', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ()]),
        ('Gc4c19', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c20', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ()]),
        ('Gc4c21', [(('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ()]),
        ('Gc4c22', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ()]),
        ('Gc4c23', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ()]),
        ('Gc5c0', [('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc5c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc5c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc5c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc5c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc5c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc5c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc5c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc5c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc5c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc5c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc5c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc5c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc5c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc5c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc5c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc5c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc5c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc5c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc5c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc5c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc5c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc5c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), ()]),
        ('Gc5c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc6c0', [('Gypi2', 0), ('Gypi2', 0), (), (), (), (), ()]),
        ('Gc6c1', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), (), ()]),
        ('Gc6c2', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc6c3', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), (), ()]),
        ('Gc6c4', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc6c5', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc6c6', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), (), (), ()]),
        ('Gc6c7', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc6c8', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), (), (), ()]),
        ('Gc6c9', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc6c10', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc6c11', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc6c12', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc6c13', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc6c14', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc6c15', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), (), ()]),
        ('Gc6c16', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), (), (), ()]),
        ('Gc6c17', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc6c18', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc6c19', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), (), ()]),
        ('Gc6c20', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc6c21', [(('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), (), (), ()]),
        ('Gc6c22', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), ()]),
        ('Gc6c23', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc7c0', [('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc7c1', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc7c2', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc7c3', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc7c4', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc7c5', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc7c6', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc7c7', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), ()]),
        ('Gc7c8', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc7c9', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc7c10', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), ()]),
        ('Gc7c11', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc7c12', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), ()]),
        ('Gc7c13', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), ()]),
        ('Gc7c14', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc7c15', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), ()]),
        ('Gc7c16', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc7c17', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), ()]),
        ('Gc7c18', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc7c19', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), ()]),
        ('Gc7c20', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc7c21', [(('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc7c22', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), ()]),
        ('Gc7c23', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc8c0', [('Gxpi2', 0), ('Gypi2', 0), (), (), (), (), ()]),
        ('Gc8c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), (), ()]),
        ('Gc8c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc8c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), (), ()]),
        ('Gc8c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc8c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc8c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), (), (), ()]),
        ('Gc8c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc8c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), (), (), ()]),
        ('Gc8c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc8c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc8c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc8c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc8c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc8c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc8c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), (), ()]),
        ('Gc8c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), (), (), (), (), ()]),
        ('Gc8c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc8c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc8c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), (), ()]),
        ('Gc8c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc8c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), (), (), ()]),
        ('Gc8c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), ()]),
        ('Gc8c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc9c0', [('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc9c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc9c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc9c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc9c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc9c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc9c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc9c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc9c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc9c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc9c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc9c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc9c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc9c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc9c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc9c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc9c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc9c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc9c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc9c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc9c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc9c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc9c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), ()]),
        ('Gc9c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc10c0', [('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc10c1', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc10c2', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc10c3', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc10c4', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc10c5', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc10c6', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc10c7', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), ()]),
        ('Gc10c8', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc10c9', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc10c10', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), ()]),
        ('Gc10c11', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc10c12', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), (), (), ()]),
        ('Gc10c13', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), (), (), ()]),
        ('Gc10c14', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc10c15', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), ()]),
        ('Gc10c16', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc10c17', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), (), (), ()]),
        ('Gc10c18', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc10c19', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), ()]),
        ('Gc10c20', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc10c21', [(('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), (), ()]),
        ('Gc10c22', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), ()]),
        ('Gc10c23', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc11c0', [('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc11c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc11c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc11c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc11c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc11c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc11c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc11c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc11c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc11c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc11c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc11c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), ()]),
        ('Gc11c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc11c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc11c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc11c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc11c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc11c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc11c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc11c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), ()]),
        ('Gc11c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc11c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0), (), (), ()]),
        ('Gc11c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), ()]),
        ('Gc11c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), ()]),
        ('Gc12c0', [('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc12c1', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc12c2', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc12c3', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc12c4', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc12c5', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc12c6', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc12c7', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), ()]),
        ('Gc12c8', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc12c9', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc12c10', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (), (), ()]),
        ('Gc12c11', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc12c12', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), ()]),
        ('Gc12c13', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), ()]),
        ('Gc12c14', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc12c15', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc12c16', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc12c17', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), ()]),
        ('Gc12c18', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc12c19', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc12c20', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc12c21', [(('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc12c22', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), ()]),
        ('Gc12c23', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc13c0', [('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc13c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc13c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc13c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc13c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc13c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc13c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc13c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), ()]),
        ('Gc13c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc13c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc13c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (), (), ()]),
        ('Gc13c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc13c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), ()]),
        ('Gc13c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), ()]),
        ('Gc13c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc13c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc13c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc13c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), ()]),
        ('Gc13c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc13c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc13c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc13c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc13c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), ()]),
        ('Gc13c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc14c0', [('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)),
                    ('Gxpi2', 0)]),
        ('Gc14c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)),
                    ('Gxpi2', 0)]),
        ('Gc14c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)),
                     (('Gxpi2', 0), ('Gxpi2', 1))]),
        ('Gc14c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc14c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0)]),
        ('Gc15c0', [('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), (), (), ()]),
        ('Gc15c1', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), (), ()]),
        ('Gc15c2', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc15c3', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), (), ()]),
        ('Gc15c4', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc15c5', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc15c6', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), (), ()]),
        ('Gc15c7', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), ()]),
        ('Gc15c8', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), (), ()]),
        ('Gc15c9', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc15c10', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), ()]),
        ('Gc15c11', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc15c12', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc15c13', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc15c14', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc15c15', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc15c16', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), (), (), ()]),
        ('Gc15c17', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc15c18', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc15c19', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc15c20', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc15c21', [(('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), (), (), ()]),
        ('Gc15c22', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), ()]),
        ('Gc15c23', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc16c0', [('Gxpi2', 0), (), (), (), (), (), ()]), ('Gc16c1', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), (), (), ()]),
        ('Gc16c2', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc16c3', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (), (), (), (), ()]),
        ('Gc16c4', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc16c5', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc16c6', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), (), (), ()]),
        ('Gc16c7', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc16c8', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), (), (), (), (), ()]),
        ('Gc16c9', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc16c10', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc16c11', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc16c12', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc16c13', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc16c14', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc16c15', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), (), (), ()]),
        ('Gc16c16', [(('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), (), (), ()]),
        ('Gc16c17', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc16c18', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc16c19', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), (), (), ()]),
        ('Gc16c20', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc16c21', [(('Gxpi2', 0), ('Gypi2', 1)), (), (), (), (), (), ()]),
        ('Gc16c22', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), ()]),
        ('Gc16c23', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc17c0', [('Gxpi2', 0), ('Gypi2', 0), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc17c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc17c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc17c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc17c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc17c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc17c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc17c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), ()]),
        ('Gc17c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc17c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc17c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (), (), ()]),
        ('Gc17c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc17c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), ()]),
        ('Gc17c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), ()]),
        ('Gc17c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc17c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc17c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc17c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), (), (), ()]),
        ('Gc17c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc17c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc17c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc17c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), (), (), (), ()]),
        ('Gc17c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), ()]),
        ('Gc17c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc18c0', [('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc18c1', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc18c2', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ()]),
        ('Gc18c3', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc18c4', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ()]),
        ('Gc18c5', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc18c6', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc18c7', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc18c8', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc18c9', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc18c10', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc18c11', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc18c12', [(('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc18c13', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc18c14', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc18c15', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc18c16', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc18c17', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc18c18', [(('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), ()]),
        ('Gc18c19', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc18c20', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), ()]),
        ('Gc18c21', [(('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc18c22', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), ()]),
        ('Gc18c23', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), ()]),
        ('Gc19c0', [('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), (), (), ()]),
        ('Gc19c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), (), ()]),
        ('Gc19c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc19c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), (), ()]),
        ('Gc19c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc19c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc19c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), (), ()]),
        ('Gc19c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), ()]),
        ('Gc19c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), (), (), ()]),
        ('Gc19c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc19c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), ()]),
        ('Gc19c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), ()]),
        ('Gc19c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc19c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc19c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc19c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc19c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), (), (), ()]),
        ('Gc19c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc19c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc19c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), (), (), ()]),
        ('Gc19c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc19c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), (), (), ()]),
        ('Gc19c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), ()]),
        ('Gc19c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc20c0', [('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc20c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc20c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ()]),
        ('Gc20c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc20c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ()]),
        ('Gc20c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc20c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc20c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc20c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc20c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc20c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc20c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc20c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc20c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc20c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc20c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc20c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc20c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc20c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), ()]),
        ('Gc20c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc20c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), ()]),
        ('Gc20c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc20c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), ()]),
        ('Gc20c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), ()]),
        ('Gc21c0', [('Gypi2', 0), (), (), (), (), (), ()]), ('Gc21c1', [(('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), (), (), ()]),
        ('Gc21c2', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()]),
        ('Gc21c3', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (), (), (), (), ()]),
        ('Gc21c4', [(('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ()]),
        ('Gc21c5', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc21c6', [(('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), (), (), ()]),
        ('Gc21c7', [(('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc21c8', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), (), (), (), (), ()]),
        ('Gc21c9', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc21c10', [(('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), (), ()]),
        ('Gc21c11', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1), (), (), ()]),
        ('Gc21c12', [(('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc21c13', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc21c14', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc21c15', [(('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), (), (), ()]),
        ('Gc21c16', [(('Gxpi2', 0), ('Gypi2', 1)), (), (), (), (), (), ()]),
        ('Gc21c17', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), (), (), (), ()]),
        ('Gc21c18', [(('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc21c19', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), (), (), (), ()]),
        ('Gc21c20', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc21c21', [(('Gypi2', 0), ('Gypi2', 1)), (), (), (), (), (), ()]),
        ('Gc21c22', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), (), ()]),
        ('Gc21c23', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), (), ()]),
        ('Gc22c0', [('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), ()]),
        ('Gc22c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), ()]),
        ('Gc22c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ()]),
        ('Gc22c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), ()]),
        ('Gc22c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ()]),
        ('Gc22c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), ()]),
        ('Gc22c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), ()]),
        ('Gc22c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), ()]),
        ('Gc22c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), ()]),
        ('Gc22c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), ()]),
        ('Gc22c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), ()]),
        ('Gc22c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (), ()]),
        ('Gc22c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), ()]),
        ('Gc22c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), ()]),
        ('Gc22c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc22c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), ()]),
        ('Gc22c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), ()]),
        ('Gc22c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), ()]),
        ('Gc22c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), ()]),
        ('Gc22c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gypi2', 0), (), ()]),
        ('Gc22c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), ()]),
        ('Gc22c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), (), ()]),
        ('Gc22c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (), ()]),
        ('Gc22c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), ()]),
        ('Gc23c0', [('Gxpi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc23c1', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc23c2', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 1), ()]),
        ('Gc23c3', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc23c4', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ()]),
        ('Gc23c5', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc23c6', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc23c7', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc23c8', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc23c9', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc23c10', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc23c11', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (), ()]),
        ('Gc23c12', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc23c13', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc23c14', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 1)]),
        ('Gc23c15', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc23c16', [(('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc23c17', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc23c18', [(('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), ()]),
        ('Gc23c19', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc23c20', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), ()]),
        ('Gc23c21', [(('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), (), ()]),
        ('Gc23c22', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (), ()]),
        ('Gc23c23', [(('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (), ()])
    ])

    global_fidpairs = [(0, 4), (0, 5), (1, 6), (2, 0), (2, 4), (2, 10), (3, 1), (3, 3), (3, 4), (3, 10), (4, 3), (4, 4),
                       (4, 5), (4, 6), (4, 10), (5, 2), (6, 5), (7, 1), (7, 2), (7, 5), (7, 7), (7, 8), (7, 10), (8, 6),
                       (8, 7), (8, 10), (9, 8), (10, 6), (10, 9), (10, 10), (11, 1), (11, 8), (12, 3), (13, 5), (13, 6),
                       (14, 4), (14, 7)]

    _pergerm_fidpairsdict = {
        (('Gxpi2', 1), ): [(0, 5), (1, 0), (1, 1), (2, 2), (2, 5), (2, 9), (3, 3), (3, 4), (3, 8), (4, 0), (4, 2), (4, 7),
                    (4, 8), (4, 10), (5, 0), (5, 1), (5, 2), (5, 6), (5, 8), (6, 7), (6, 8), (6, 9), (7, 0), (7, 4),
                    (8, 5), (8, 9), (9, 5), (10, 8), (10, 10), (12, 2), (12, 4), (12, 7), (13, 2), (13, 3), (13, 9),
                    (14, 0), (14, 5), (14, 6), (15, 5), (15, 8), (15, 9)],
        ((('Gypi2', 0), ('Gxpi2', 1)), ): [(0, 5), (0, 9), (1, 6), (3, 1), (3, 2), (5, 0), (5, 4), (6, 0), (6, 8), (9, 7), (10, 9), (11, 1),
                    (11, 4), (14, 4), (14, 9), (15, 5), (15, 7)],
        (('Gypi2', 0), ): [(3, 1), (4, 1), (4, 2), (5, 0), (5, 1), (5, 7), (6, 0), (6, 8), (7, 2), (7, 4), (7, 9), (8, 0),
                    (8, 7), (9, 2), (9, 3), (10, 9), (10, 10), (14, 7), (14, 9), (15, 10)],
        (('Gypi2', 1), ): [(0, 0), (0, 7), (1, 1), (3, 5), (3, 6), (4, 2), (4, 4), (4, 5), (5, 3), (5, 7), (7, 1), (7, 8),
                    (8, 5), (9, 4), (9, 5), (9, 9), (10, 5), (11, 5), (11, 6), (11, 8), (11, 10), (12, 0), (12, 3),
                    (13, 10), (14, 0), (14, 5), (14, 6), (14, 7), (15, 0), (15, 6), (15, 9)],
        ((('Gypi2', 0), ('Gypi2', 1)), ): [(0, 6), (0, 8), (0, 10), (1, 0), (1, 1), (1, 3), (2, 9), (3, 8), (4, 4), (4, 7), (5, 7), (6, 1),
                    (7, 0), (7, 8), (9, 10), (10, 5), (11, 5), (12, 5), (12, 6), (14, 0), (15, 0), (15, 6), (15, 8)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), ): [(0, 0), (1, 5), (2, 4), (3, 3), (3, 5), (5, 2), (6, 1), (6, 8), (6, 10), (8, 6), (10, 2), (10, 8),
                    (10, 10), (11, 8), (12, 1), (13, 1), (13, 4), (13, 6), (13, 10), (14, 8), (15, 3)],
        ((), ): [(0, 8), (1, 0), (1, 1), (1, 3), (1, 10), (2, 5), (2, 9), (3, 3), (3, 9), (4, 3), (4, 8), (5, 0),
                    (5, 5), (5, 7), (6, 4), (6, 6), (6, 8), (6, 10), (7, 0), (7, 2), (7, 3), (7, 4), (7, 6), (7, 10),
                    (8, 3), (8, 5), (9, 3), (9, 4), (9, 5), (9, 6), (9, 8), (9, 9), (10, 3), (10, 9), (10, 10), (11, 1),
                    (11, 5), (12, 5), (12, 7), (12, 9), (13, 0), (13, 10), (14, 0), (14, 1), (14, 2), (14, 6), (15, 0),
                    (15, 5), (15, 6), (15, 7), (15, 8)],
        ((('Gxpi2', 0), ('Gypi2', 1)), ): [(1, 1), (2, 8), (3, 0), (3, 2), (3, 6), (4, 7), (7, 2), (8, 6), (9, 1), (9, 7), (9, 9), (10, 2),
                    (10, 10), (11, 8), (12, 6), (13, 2), (13, 7), (14, 2), (15, 5)],
        (('Gxpi2', 0), ): [(0, 7), (1, 1), (1, 7), (2, 7), (3, 3), (4, 9), (5, 4), (7, 2), (7, 10), (8, 2), (9, 2), (9, 8),
                    (9, 9), (10, 1), (10, 10), (11, 2), (11, 5), (11, 6), (13, 2), (14, 7), (15, 2), (15, 3)],
        (('Gypi2', 1), ('Gypi2', 0)): [(0, 6), (0, 8), (0, 10), (1, 0), (1, 1), (1, 3), (2, 9), (3, 8), (4, 4), (4, 7), (5, 7),
                         (6, 1), (7, 0), (7, 8), (9, 10), (10, 5), (11, 5), (12, 5), (12, 6), (14, 0), (15, 0), (15, 6),
                         (15, 8)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8), (12, 2),
                         (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10), (3, 8), (5, 5), (7, 0), (9, 3),
                         (9, 9), (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), ('Gxpi2', 0)): [(1, 1), (2, 8), (3, 0), (3, 2), (3, 6), (4, 7), (7, 2), (8, 6), (9, 1), (9, 7), (9, 9),
                         (10, 2), (10, 10), (11, 8), (12, 6), (13, 2), (13, 7), (14, 2), (15, 5)],
        (('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1))): [(1, 10), (2, 10), (4, 8), (5, 5), (5, 6), (6, 10), (7, 0), (7, 5), (7, 6), (7, 8), (8, 5),
                         (12, 5), (13, 0), (13, 2), (14, 1)],
        ((), ('Gypi2', 1)): [(0, 0), (0, 7), (1, 1), (3, 5), (3, 6), (4, 2), (4, 4), (4, 5), (5, 3), (5, 7), (7, 1), (7, 8),
                         (8, 5), (9, 4), (9, 5), (9, 9), (10, 5), (11, 5), (11, 6), (11, 8), (11, 10), (12, 0), (12, 3),
                         (13, 10), (14, 0), (14, 5), (14, 6), (14, 7), (15, 0), (15, 6), (15, 9)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(1, 1), (2, 5), (4, 3), (5, 5), (6, 3), (7, 1), (10, 2), (10, 5), (11, 2), (11, 5), (12, 7),
                         (12, 10), (13, 0), (13, 4), (14, 5)],
        ((('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 9), (1, 1), (1, 9), (2, 7), (3, 4), (4, 4), (4, 10), (6, 0), (6, 3), (7, 0), (9, 4),
                         (11, 5), (12, 4), (13, 7), (14, 0)],
        (('Gxpi2', 1), ('Gypi2', 1)): [(1, 0), (1, 10), (4, 0), (4, 4), (4, 7), (4, 8), (5, 5), (7, 6), (8, 9), (9, 9), (10, 2),
                         (10, 8), (11, 10), (12, 6), (12, 9), (13, 9), (15, 1)],
        (('Gxpi2', 1), (('Gypi2', 0), ('Gypi2', 1))): [(3, 0), (4, 4), (5, 1), (5, 8), (6, 5), (7, 3), (8, 6), (8, 7), (9, 5), (10, 3), (11, 4),
                         (14, 0), (14, 6), (14, 9), (15, 5)],
        (('Gxpi2', 1), ('Gxpi2', 0)): [(0, 0), (1, 5), (2, 4), (3, 3), (3, 5), (5, 2), (6, 1), (6, 8), (6, 10), (8, 6), (10, 2),
                         (10, 8), (10, 10), (11, 8), (12, 1), (13, 1), (13, 4), (13, 6), (13, 10), (14, 8), (15, 3)],
        ((), ('Gypi2', 0)): [(3, 1), (4, 1), (4, 2), (5, 0), (5, 1), (5, 7), (6, 0), (6, 8), (7, 2), (7, 4), (7, 9), (8, 0),
                         (8, 7), (9, 2), (9, 3), (10, 9), (10, 10), (14, 7), (14, 9), (15, 10)],
        (('Gxpi2', 1), ('Gypi2', 0)): [(0, 5), (0, 9), (1, 6), (3, 1), (3, 2), (5, 0), (5, 4), (6, 0), (6, 8), (9, 7), (10, 9),
                         (11, 1), (11, 4), (14, 4), (14, 9), (15, 5), (15, 7)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(1, 10), (2, 10), (4, 8), (5, 5), (5, 6), (6, 10), (7, 0), (7, 5), (7, 6), (7, 8), (8, 5),
                         (12, 5), (13, 0), (13, 2), (14, 1)],
        (('Gypi2', 0), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 9), (1, 1), (1, 9), (2, 7), (3, 4), (4, 4), (4, 10), (6, 0), (6, 3), (7, 0), (9, 4),
                         (11, 5), (12, 4), (13, 7), (14, 0)],
        ((), ('Gxpi2', 1)): [(0, 5), (1, 0), (1, 1), (2, 2), (2, 5), (2, 9), (3, 3), (3, 4), (3, 8), (4, 0), (4, 2), (4, 7),
                         (4, 8), (4, 10), (5, 0), (5, 1), (5, 2), (5, 6), (5, 8), (6, 7), (6, 8), (6, 9), (7, 0),
                         (7, 4), (8, 5), (8, 9), (9, 5), (10, 8), (10, 10), (12, 2), (12, 4), (12, 7), (13, 2), (13, 3),
                         (13, 9), (14, 0), (14, 5), (14, 6), (15, 5), (15, 8), (15, 9)],
        (('Gxpi2', 0), ('Gypi2', 0)): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10), (3, 8), (5, 5), (7, 0), (9, 3),
                         (9, 9), (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 6), (3, 0), (5, 0), (6, 7), (7, 1), (8, 3), (9, 9), (10, 4), (10, 9), (12, 9), (13, 2),
                         (14, 5), (14, 8), (14, 10), (15, 6)],
        (('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 3), (0, 9), (2, 3), (2, 6), (3, 10), (5, 7), (6, 0), (7, 2), (7, 6), (7, 7),
                                (8, 1), (8, 5), (9, 4), (14, 10)],
        (('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 0), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), ('Gxpi2', 0), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 6), (1, 3), (1, 7), (1, 10), (2, 10), (4, 1), (5, 1), (5, 5), (7, 3), (8, 2),
                                (8, 3), (9, 8), (10, 1), (10, 6), (10, 10), (11, 7), (15, 3)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 0), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), ('Gypi2', 0), ('Gxpi2', 0)): [(1, 10), (2, 10), (4, 8), (5, 5), (5, 6), (6, 10), (7, 0), (7, 5), (7, 6), (7, 8),
                                (8, 5), (12, 5), (13, 0), (13, 2), (14, 1)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), ('Gxpi2', 0), ('Gypi2', 1)): [(0, 6), (3, 0), (5, 0), (6, 7), (7, 1), (8, 3), (9, 9), (10, 4), (10, 9), (12, 9),
                                (13, 2), (14, 5), (14, 8), (14, 10), (15, 6)],
        (('Gxpi2', 0), (('Gypi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), (), ()): [(0, 7), (1, 1), (1, 7), (2, 7), (3, 3), (4, 9), (5, 4), (7, 2), (7, 10), (8, 2), (9, 2),
                                (9, 8), (9, 9), (10, 1), (10, 10), (11, 2), (11, 5), (11, 6), (13, 2), (14, 7), (15, 2),
                                (15, 3)],
        ((), ('Gypi2', 1), ('Gypi2', 0)): [(0, 6), (0, 8), (0, 10), (1, 0), (1, 1), (1, 3), (2, 9), (3, 8), (4, 4), (4, 7), (5, 7),
                                (6, 1), (7, 0), (7, 8), (9, 10), (10, 5), (11, 5), (12, 5), (12, 6), (14, 0), (15, 0),
                                (15, 6), (15, 8)],
        (('Gypi2', 1), (('Gypi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 0), (('Gypi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 0)): [(0, 1), (4, 2), (4, 7), (6, 7), (8, 3), (9, 5), (9, 7), (10, 0), (10, 4), (10, 5),
                                (11, 2), (11, 9), (14, 6), (14, 8), (15, 3)],
        (('Gypi2', 1), (), ()): [(0, 0), (0, 7), (1, 1), (3, 5), (3, 6), (4, 2), (4, 4), (4, 5), (5, 3), (5, 7), (7, 1),
                                (7, 8), (8, 5), (9, 4), (9, 5), (9, 9), (10, 5), (11, 5), (11, 6), (11, 8), (11, 10),
                                (12, 0), (12, 3), (13, 10), (14, 0), (14, 5), (14, 6), (14, 7), (15, 0), (15, 6),
                                (15, 9)],
        (('Gypi2', 1), (('Gypi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0)): [(1, 5), (3, 3), (4, 1), (6, 1), (6, 6), (6, 8), (8, 6), (10, 10), (11, 8), (13, 1),
                                (13, 4), (13, 6), (13, 10), (14, 8), (15, 3)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), (('Gypi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 0), (), ()): [(3, 1), (4, 1), (4, 2), (5, 0), (5, 1), (5, 7), (6, 0), (6, 8), (7, 2), (7, 4), (7, 9),
                                (8, 0), (8, 7), (9, 2), (9, 3), (10, 9), (10, 10), (14, 7), (14, 9), (15, 10)],
        ((), ('Gxpi2', 1), ('Gypi2', 0)): [(0, 5), (0, 9), (1, 6), (3, 1), (3, 2), (5, 0), (5, 4), (6, 0), (6, 8), (9, 7), (10, 9),
                                (11, 1), (11, 4), (14, 4), (14, 9), (15, 5), (15, 7)],
        (('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), ('Gypi2', 0)): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10), (3, 8), (5, 5), (7, 0), (9, 3),
                                (9, 9), (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1)): [(0, 3), (1, 0), (1, 4), (3, 10), (4, 3), (5, 7), (7, 2), (7, 4), (7, 7), (7, 8), (8, 1),
                                (8, 5), (8, 7), (8, 9), (9, 2), (9, 6), (10, 3), (14, 10), (15, 4)],
        (('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), ('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), ('Gypi2', 0), ('Gypi2', 1)): [(3, 0), (4, 4), (5, 1), (5, 8), (6, 5), (7, 3), (8, 6), (8, 7), (9, 5), (10, 3),
                                (11, 4), (14, 0), (14, 6), (14, 9), (15, 5)],
        (('Gypi2', 1), ('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10), (3, 8), (5, 5), (7, 0), (9, 3),
                                (9, 9), (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), (), ('Gypi2', 0)): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10), (3, 8), (5, 5), (7, 0), (9, 3),
                                (9, 9), (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), ('Gxpi2', 0), ('Gxpi2', 0)): [(1, 7), (2, 2), (4, 8), (7, 2), (7, 10), (8, 6), (9, 8), (9, 9), (10, 1), (11, 4),
                                (11, 9), (12, 8), (12, 9), (13, 0), (13, 1), (13, 9)],
        (('Gxpi2', 0), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 2), (1, 0), (1, 4), (1, 9), (2, 4), (2, 10), (4, 3), (7, 4), (7, 8), (8, 7), (8, 9),
                                (9, 2), (9, 6), (10, 3), (15, 4)],
        (('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1)): [(0, 4), (0, 5), (0, 7), (1, 1), (1, 6), (2, 3), (4, 10), (5, 4), (6, 8),
                                (7, 4), (7, 10), (8, 8), (8, 9), (10, 5), (11, 5), (11, 6), (11, 9), (13, 10), (14, 1),
                                (14, 9)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), ('Gypi2', 0), ()): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10), (3, 8), (5, 5), (7, 0), (9, 3),
                                (9, 9), (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1)): [(0, 0), (0, 6), (1, 0), (1, 10), (4, 0), (4, 4), (4, 7), (4, 8), (5, 5), (6, 7), (7, 6),
                                (8, 9), (9, 9), (10, 2), (10, 8), (11, 10), (12, 6), (12, 9), (13, 1), (13, 9),
                                (15, 1)],
        (('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))): [(1, 5), (3, 3), (4, 1), (6, 1), (6, 6), (6, 8), (8, 6), (10, 10), (11, 8), (13, 1),
                                (13, 4), (13, 6), (13, 10), (14, 8), (15, 3)],
        (('Gypi2', 0), ('Gypi2', 0), (('Gypi2', 0), ('Gypi2', 1))): [(0, 2), (1, 1), (1, 4), (2, 1), (2, 10), (3, 10), (4, 0), (5, 3), (5, 7), (6, 4),
                                (6, 10), (8, 2), (8, 3), (9, 0), (10, 8), (11, 1), (11, 7), (13, 1), (13, 8)],
        (('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 0)): [(0, 9), (1, 1), (1, 9), (2, 7), (3, 4), (4, 4), (4, 10), (6, 0), (6, 3), (7, 0), (9, 4),
                                (11, 5), (12, 4), (13, 7), (14, 0)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), ('Gypi2', 0), ('Gxpi2', 0)): [(0, 9), (1, 1), (1, 9), (2, 7), (3, 4), (4, 4), (4, 10), (6, 0), (6, 3), (7, 0), (9, 4),
                                (11, 5), (12, 4), (13, 7), (14, 0)],
        ((), ('Gypi2', 0), ('Gxpi2', 1)): [(0, 5), (0, 9), (1, 6), (3, 1), (3, 2), (5, 0), (5, 4), (6, 0), (6, 8), (9, 7), (10, 9),
                                (11, 1), (11, 4), (14, 4), (14, 9), (15, 5), (15, 7)],
        (('Gypi2', 1), (('Gypi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 0)): [(0, 6), (3, 0), (5, 0), (6, 7), (7, 1), (8, 3), (9, 9), (10, 4), (10, 9), (12, 9),
                                (13, 2), (14, 5), (14, 8), (14, 10), (15, 6)],
        (('Gxpi2', 1), ('Gxpi2', 1), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 0), (1, 5), (2, 4), (3, 3), (3, 5), (5, 2), (6, 1), (6, 8), (6, 10), (8, 6),
                                (10, 2), (10, 8), (10, 10), (11, 8), (12, 1), (13, 1), (13, 4), (13, 6), (13, 10),
                                (14, 8), (15, 3)],
        (('Gxpi2', 0), ('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 0), (('Gypi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 2), (1, 0), (1, 4), (1, 9), (2, 4), (2, 10), (4, 3), (7, 4), (7, 8), (8, 7), (8, 9),
                                (9, 2), (9, 6), (10, 3), (15, 4)],
        (('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), ('Gypi2', 1), ()): [(1, 0), (1, 10), (4, 0), (4, 4), (4, 7), (4, 8), (5, 5), (7, 6), (8, 9), (9, 9),
                                (10, 2), (10, 8), (11, 10), (12, 6), (12, 9), (13, 9), (15, 1)],
        ((('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), (), ('Gypi2', 1)): [(1, 0), (1, 10), (4, 0), (4, 4), (4, 7), (4, 8), (5, 5), (7, 6), (8, 9), (9, 9),
                                (10, 2), (10, 8), (11, 10), (12, 6), (12, 9), (13, 9), (15, 1)],
        (('Gxpi2', 1), (), ()): [(0, 5), (1, 0), (1, 1), (2, 2), (2, 5), (2, 9), (3, 3), (3, 4), (3, 8), (4, 0), (4, 2),
                                (4, 7), (4, 8), (4, 10), (5, 0), (5, 1), (5, 2), (5, 6), (5, 8), (6, 7), (6, 8), (6, 9),
                                (7, 0), (7, 4), (8, 5), (8, 9), (9, 5), (10, 8), (10, 10), (12, 2), (12, 4), (12, 7),
                                (13, 2), (13, 3), (13, 9), (14, 0), (14, 5), (14, 6), (15, 5), (15, 8), (15, 9)],
        (('Gypi2', 0), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), (('Gypi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                       (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 0), ('Gypi2', 1)): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10), (3, 8), (5, 5), (7, 0),
                                       (9, 3), (9, 9), (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), (), (), ('Gxpi2', 0)): [(0, 0), (1, 5), (2, 4), (3, 3), (3, 5), (5, 2), (6, 1), (6, 8), (6, 10), (8, 6),
                                       (10, 2), (10, 8), (10, 10), (11, 8), (12, 1), (13, 1), (13, 4), (13, 6),
                                       (13, 10), (14, 8), (15, 3)],
        (('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 0)): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10), (3, 8), (5, 5), (7, 0),
                                       (9, 3), (9, 9), (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))): [(1, 10), (2, 10), (4, 8), (5, 5), (5, 6), (6, 10), (7, 0), (7, 5), (7, 6),
                                       (7, 8), (8, 5), (12, 5), (13, 0), (13, 2), (14, 1)],
        (('Gypi2', 1), ('Gxpi2', 0), (), ()): [(1, 1), (2, 8), (3, 0), (3, 2), (3, 6), (4, 7), (7, 2), (8, 6), (9, 1), (9, 7),
                                       (9, 9), (10, 2), (10, 10), (11, 8), (12, 6), (13, 2), (13, 7), (14, 2), (15, 5)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0), ('Gypi2', 0)): [(0, 1), (0, 3), (0, 9), (2, 3), (2, 6), (3, 10), (5, 7), (6, 0), (7, 2), (7, 6),
                                       (7, 7), (8, 1), (8, 5), (9, 4), (14, 10)],
        (('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1)): [(0, 5), (0, 9), (1, 6), (3, 1), (3, 2), (5, 0), (5, 4), (6, 0), (6, 8), (9, 7),
                                       (10, 9), (11, 1), (11, 4), (14, 4), (14, 9), (15, 5), (15, 7)],
        (('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 1), ('Gypi2', 0)): [(0, 2), (1, 1), (1, 4), (2, 1), (2, 10), (3, 10), (4, 0), (5, 3), (5, 7), (6, 4),
                                       (6, 10), (8, 2), (8, 3), (9, 0), (10, 8), (11, 1), (11, 7), (13, 1), (13, 8)],
        ((('Gypi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gxpi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [(1, 10), (2, 10), (4, 8), (5, 5), (5, 6), (6, 10), (7, 0), (7, 5), (7, 6),
                                       (7, 8), (8, 5), (12, 5), (13, 0), (13, 2), (14, 1)],
        (('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ()): [(0, 4), (0, 5), (0, 7), (1, 1), (1, 6), (2, 3), (4, 10), (5, 4), (6, 8), (7, 4),
                                       (7, 10), (8, 8), (8, 9), (10, 5), (11, 5), (11, 6), (11, 9), (13, 10), (14, 1),
                                       (14, 9)],
        (('Gxpi2', 0), ('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 1)): [(1, 10), (2, 10), (4, 8), (5, 5), (5, 6), (6, 10), (7, 0), (7, 5), (7, 6),
                                       (7, 8), (8, 5), (12, 5), (13, 0), (13, 2), (14, 1)],
        ((('Gypi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                       (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0)): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10), (3, 8), (5, 5), (7, 0),
                                       (9, 3), (9, 9), (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gypi2', 1)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                       (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), ('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1)): [(1, 0), (1, 10), (4, 0), (4, 4), (4, 7), (4, 8), (5, 5), (7, 6), (8, 9), (9, 9),
                                       (10, 2), (10, 8), (11, 10), (12, 6), (12, 9), (13, 9), (15, 1)],
        (('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0), ()): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                       (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10),
                                              (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((), (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10),
                                              (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 0), ('Gxpi2', 0)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10),
                                              (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gypi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [(3, 0), (4, 4), (5, 1), (5, 8), (6, 5), (7, 3), (8, 6), (8, 7), (9, 5),
                                              (10, 3), (11, 4), (14, 0), (14, 6), (14, 9), (15, 5)],
        (('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 1)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10),
                                              (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 0), ('Gypi2', 1), ('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 1)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10),
                                              (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), ('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 1)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10),
                                              (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 1), ('Gypi2', 0), ('Gypi2', 1)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10),
                                              (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 0)): [(1, 5), (3, 3), (4, 1), (6, 1), (6, 6), (6, 8), (8, 6), (10, 10), (11, 8),
                                              (13, 1), (13, 4), (13, 6), (13, 10), (14, 8), (15, 3)],
        (('Gypi2', 1), ('Gxpi2', 0), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 0)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10),
                                              (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 0), ('Gxpi2', 1), ('Gxpi2', 0)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10),
                                              (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gxpi2', 0), ('Gxpi2', 0)): [(1, 1), (2, 5), (4, 3), (5, 5), (6, 3), (7, 1), (10, 2), (10, 5),
                                                     (11, 2), (11, 5), (12, 7), (12, 10), (13, 0), (13, 4), (14, 5)],
        (('Gypi2', 0), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 1), ('Gypi2', 1), ('Gypi2', 1)): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10), (3, 8),
                                                     (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8), (12, 2), (12, 6),
                                                     (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), ('Gypi2', 1), ('Gxpi2', 1), ('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 1)): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10), (3, 8),
                                                     (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8), (12, 2), (12, 6),
                                                     (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), ('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 1), ('Gypi2', 0)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9),
                                                     (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 0)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9),
                                                     (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9),
                                                     (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 1), ('Gxpi2', 1), ('Gypi2', 1)): [(0, 4), (0, 6), (1, 1), (2, 2), (4, 1), (4, 3), (5, 1), (5, 3),
                                                     (6, 10), (8, 2), (8, 8), (9, 4), (10, 7), (12, 1), (13, 2),
                                                     (15, 6), (15, 9)],
        (('Gypi2', 0), ('Gxpi2', 0), ('Gypi2', 1), ('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gypi2', 0)): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10), (3, 8),
                                                     (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8), (12, 2), (12, 6),
                                                     (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gxpi2', 1)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9),
                                                     (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 0)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9),
                                                     (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 0), ('Gypi2', 1), ('Gypi2', 0), ('Gxpi2', 1)): [(0, 3), (1, 0), (1, 4), (3, 10), (4, 3), (5, 7), (7, 2), (7, 4),
                                                     (7, 7), (7, 8), (8, 1), (8, 5), (8, 7), (8, 9), (9, 2), (9, 6),
                                                     (10, 3), (14, 10), (15, 4)],
        (('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 1), ('Gypi2', 1), ('Gypi2', 1)): [(1, 0), (1, 10), (4, 0), (4, 4), (4, 7), (4, 8), (5, 5), (7, 6),
                                                     (8, 9), (9, 9), (10, 2), (10, 8), (11, 10), (12, 6), (12, 9),
                                                     (13, 9), (15, 1)],
        (('Gypi2', 0), ('Gxpi2', 0), ('Gxpi2', 1), ('Gxpi2', 0), ('Gxpi2', 1), ('Gypi2', 1)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3), (9, 9),
                                                     (9, 10), (10, 8), (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 0), ('Gxpi2', 1), (), ('Gypi2', 1)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3),
                                                            (9, 9), (9, 10), (10, 8), (12, 2), (12, 6), (14, 6),
                                                            (15, 0), (15, 5)],
        ((), ('Gypi2', 0), ('Gxpi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), (('Gxpi2', 0), ('Gxpi2', 1))): [(0, 1), (0, 2), (0, 5), (1, 3), (1, 9), (2, 4), (2, 10),
                                                            (3, 8), (5, 5), (7, 0), (9, 3), (9, 9), (9, 10), (10, 8),
                                                            (12, 2), (12, 6), (14, 6), (15, 0), (15, 5)],
        (('Gypi2', 1), ('Gxpi2', 1), ('Gypi2', 0), ('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 0), ('Gypi2', 1)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0), (9, 3),
                                                            (9, 9), (9, 10), (10, 8), (12, 2), (12, 6), (14, 6),
                                                            (15, 0), (15, 5)],
        (('Gypi2', 0), ('Gxpi2', 0), ('Gypi2', 1), ('Gxpi2', 0), ('Gxpi2', 1), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 1)): [(0, 1), (0, 5), (1, 3), (3, 8), (5, 5), (7, 0),
                                                                   (9, 3), (9, 9), (9, 10), (10, 8), (12, 2), (12, 6),
                                                                   (14, 6), (15, 0), (15, 5)],
        (('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 0), ('Gxpi2', 0), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 1), ('Gypi2', 0)): [(1, 1), (2, 5), (4, 3), (5, 5), (6, 3), (7, 1),
                                                                   (10, 2), (10, 5), (11, 2), (11, 5), (12, 7),
                                                                   (12, 10), (13, 0), (13, 4), (14, 5)]
    }

    global_fidpairs_lite = None

    _pergerm_fidpairsdict_lite = {
      ((),): [
            (0, 3), (0, 4), (0, 6), (0, 7), (0, 8), (0, 9), (1, 1), 
            (1, 4), (1, 5), (1, 9), (2, 1), (2, 3), (2, 4), (2, 6), 
            (2, 7), (3, 5), (3, 7), (4, 0), (4, 2), (4, 4), (4, 9), 
            (5, 0), (5, 2), (5, 7), (5, 9), (5, 10), (6, 0), (6, 1), 
            (6, 2), (6, 3), (6, 4), (6, 8), (6, 9), (7, 6), (7, 7), 
            (8, 0), (8, 2), (8, 6), (8, 7), (8, 10), (9, 2), (9, 8), 
            (9, 9), (9, 10), (10, 4), (10, 7), (10, 8), (10, 9), 
            (10, 10), (11, 3), (11, 5), (11, 8), (11, 10), (12, 8), 
            (13, 2), (13, 7), (13, 9), (13, 10), (14, 1), (14, 2), 
            (14, 7), (14, 8), (14, 10), (15, 4), (15, 8)],
      (('Gxpi2', 0),): [
            (0, 8), (1, 2), (1, 7), (2, 4), (2, 6), (2, 7), (3, 3), 
            (3, 5), (3, 8), (4, 8), (5, 0), (5, 4), (5, 5), (5, 7), 
            (6, 8), (7, 9), (8, 3), (8, 5), (9, 0), (9, 2), (9, 9), 
            (10, 2), (10, 8), (10, 10), (11, 7), (11, 10), (12, 10), 
            (13, 1), (13, 2), (13, 6), (13, 9), (14, 0), (14, 5), 
            (14, 8), (15, 10)],
      (('Gypi2', 0),): [
            (1, 0), (1, 1), (1, 3), (1, 4), (2, 1), (2, 4), (3, 1), 
            (3, 2), (3, 8), (4, 3), (4, 5), (5, 7), (6, 0), (6, 1), 
            (6, 2), (6, 4), (6, 8), (7, 4), (7, 7), (8, 1), (9, 4), 
            (10, 2), (10, 7), (11, 2), (11, 6), (11, 7), (11, 10), 
            (12, 2), (12, 3), (12, 8), (13, 9), (13, 10), (15, 6), 
            (15, 9)],
      (('Gxpi2', 1),): [
            (0, 4), (0, 9), (1, 5), (1, 8), (1, 9), (1, 10), (2, 2), 
            (2, 6), (2, 7), (3, 5), (4, 1), (4, 7), (5, 0), (5, 2), 
            (5, 5), (5, 6), (5, 7), (5, 8), (6, 6), (6, 8), (7, 1), 
            (7, 5), (7, 9), (7, 10), (8, 5), (8, 6), (9, 0), (9, 4), 
            (9, 5), (9, 7), (10, 2), (10, 10), (12, 1), (12, 3), 
            (12, 9), (13, 4), (13, 7), (13, 8), (14, 2), (14, 6), 
            (14, 8), (15, 5)],
      (('Gypi2', 1),): [
            (0, 3), (2, 7), (3, 2), (3, 3), (3, 6), (4, 6), (4, 8), 
            (5, 7), (5, 10), (6, 8), (8, 0), (8, 4), (8, 10), (9, 9), 
            (10, 6), (12, 1), (12, 3), (12, 8), (13, 0), (13, 1), 
            (13, 6), (13, 10), (14, 0), (14, 1), (15, 0), (15, 5), 
            (15, 8)],
      ((('Gxpi2', 0), ('Gxpi2', 1)),): [
            (1, 1), (1, 4), (3, 0), (3, 2), (3, 4), (3, 6), (3, 9), 
            (4, 0), (4, 8), (7, 0), (7, 8), (8, 2), (8, 4), (9, 8), 
            (10, 10), (11, 6), (11, 10), (12, 4), (12, 8), (13, 6), 
            (14, 5)],
      ((('Gxpi2', 0), ('Gypi2', 1)),): [
            (0, 10), (1, 1), (2, 1), (2, 6), (2, 7), (3, 1), (5, 1), 
            (5, 4), (5, 8), (7, 4), (8, 1), (9, 0), (9, 9), (10, 0), 
            (12, 2), (12, 6), (13, 1), (13, 5), (14, 0), (14, 4), 
            (14, 9), (15, 5)],
      ((('Gypi2', 0), ('Gypi2', 1)),): [
            (0, 5), (0, 10), (1, 7), (2, 6), (2, 9), (3, 10), (4, 0), 
            (4, 1), (4, 9), (5, 7), (6, 8), (8, 6), (9, 1), (9, 2), 
            (9, 6), (9, 8), (10, 0), (10, 5), (13, 2), (13, 3), (14, 2)],
      (('Gxpi2', 0), ('Gypi2', 0)): [
            (0, 1), (0, 4), (0, 7), (0, 8), (1, 10), (2, 1), (2, 3), 
            (2, 7), (5, 5), (8, 0), (8, 2), (10, 2), (13, 6), (15, 0), 
            (15, 6)],
      (('Gxpi2', 1), ('Gypi2', 1)): [
            (1, 3), (2, 0), (3, 6), (5, 3), (5, 7), (5, 8), (6, 6), 
            (6, 7), (7, 10), (8, 9), (8, 10), (11, 5), (12, 0), (12, 5), 
            (12, 6), (12, 10), (13, 6), (13, 9), (14, 1), (14, 2), 
            (15, 4)],
      (('Gxpi2', 0), ('Gxpi2', 0), ('Gypi2', 0)): [
            (0, 1), (0, 4), (0, 7), (0, 8), (1, 10), (2, 1), (2, 3), 
            (2, 7), (5, 5), (8, 0), (8, 2), (10, 2), (13, 6), (15, 0), 
            (15, 6)],
      (('Gxpi2', 1), ('Gxpi2', 1), ('Gypi2', 1)): [
            (0, 0), (0, 2), (0, 3), (1, 2), (2, 4), (3, 8), (4, 5), 
            (4, 7), (5, 7), (6, 4), (6, 9), (8, 5), (8, 7), (8, 9), 
            (9, 1), (10, 3), (10, 4), (11, 8), (11, 10), (12, 4), 
            (12, 10), (14, 9), (15, 5), (15, 8)],
      ((('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1))): [
            (0, 10), (3, 6), (4, 1), (6, 3), (6, 4), (6, 10), (7, 1), 
            (8, 1), (8, 10), (9, 7), (10, 6), (10, 8), (11, 5), (13, 1), 
            (15, 4)],
      ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gypi2', 1))): [
            (0, 1), (0, 4), (0, 7), (0, 8), (1, 10), (2, 1), (2, 3), 
            (2, 7), (5, 5), (8, 0), (8, 2), (10, 2), (13, 6), (15, 0), 
            (15, 6)],
      ((('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 0)): [
            (1, 0), (1, 5), (1, 6), (2, 0), (6, 3), (7, 0), (8, 2), 
            (10, 9), (11, 2), (11, 10), (12, 10), (13, 5), (13, 10), 
            (15, 0), (15, 7)],
      ((('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1), ('Gxpi2', 0)): [
            (1, 0), (2, 9), (3, 10), (4, 3), (6, 4), (6, 9), (7, 10), 
            (9, 7), (10, 2), (10, 9), (10, 10), (11, 0), (12, 0), 
            (13, 6), (13, 9)],
      (('Gxpi2', 0), (('Gypi2', 0), ('Gypi2', 1)), ('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)), (('Gxpi2', 0), ('Gxpi2', 1))): [
            (0, 1), (0, 4), (0, 7), (0, 8), (1, 10), (2, 1), (2, 3), 
            (2, 7), (5, 5), (8, 0), (8, 2), (10, 2), (13, 6), (15, 0), 
            (15, 6)],
      (('Gxpi2', 0), ('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 1), ('Gypi2', 0)): [
            (0, 1), (0, 4), (0, 7), (0, 8), (1, 10), (2, 1), (2, 3), 
            (2, 7), (5, 5), (8, 0), (8, 2), (10, 2), (13, 6), (15, 0), 
            (15, 6)],
      (('Gxpi2', 0), ('Gypi2', 1), ('Gxpi2', 1), ('Gypi2', 0), ('Gxpi2', 1), ('Gxpi2', 1)): [
            (0, 1), (0, 3), (0, 4), (0, 7), (0, 8), (1, 10), (2, 1), 
            (2, 3), (2, 7), (3, 5), (4, 2), (5, 5), (8, 0), (8, 2), 
            (10, 2), (10, 8), (11, 2), (13, 6), (14, 3), (14, 5), 
            (15, 0), (15, 7), (15, 9)],
      ((('Gxpi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), ('Gxpi2', 1), ('Gypi2', 1), (('Gxpi2', 0), ('Gxpi2', 1)), ('Gxpi2', 1)): [
            (0, 2), (1, 5), (1, 7), (1, 8), (2, 10), (6, 1), (7, 7), 
            (10, 5), (11, 2), (11, 10), (14, 0), (14, 2), (14, 3), 
            (14, 9), (14, 10)],
      (('Gypi2', 0), ('Gxpi2', 0), ('Gypi2', 1), ('Gxpi2', 0), ('Gxpi2', 1), ('Gxpi2', 0), ('Gypi2', 0), ('Gypi2', 1)): [
            (0, 1), (0, 4), (0, 7), (0, 8), (1, 10), (2, 1), (2, 3), 
            (2, 7), (5, 5), (8, 0), (8, 2), (10, 2), (13, 6), (15, 0), 
            (15, 6)],
    }

    def _target_model(self, sslbls, **kwargs):
        return self._build_explicit_target_model(
            sslbls,
            [(), ('Gxpi2', 1), ('Gypi2', 1), ('Gxpi2', 0), ('Gypi2', 0), (('Gxpi2', 0), ('Gxpi2', 1)),
             (('Gypi2', 0), ('Gypi2', 1)), (('Gxpi2', 0), ('Gypi2', 1)), (('Gypi2', 0), ('Gxpi2', 1))],
            ['I({0}):I({1})', 'I({0}):X(pi/2,{1})', 'I({0}):Y(pi/2,{1})', 'X(pi/2,{0}):I({1})', 'Y(pi/2,{0}):I({1})',
             'X(pi/2,{0}):X(pi/2,{1})', 'Y(pi/2,{0}):Y(pi/2,{1})',
             'X(pi/2,{0}):Y(pi/2,{1})', 'Y(pi/2,{0}):X(pi/2,{1})'],
            effect_labels=['00', '01', '10', '11'],
            effect_expressions=['0', '1', '2', '3'], **kwargs)


import sys
sys.modules[__name__] = _Module()
