# Generated by Django 4.1.7 on 2023-05-17 11:28

from django.db import migrations
from django.db.migrations import RunPython
from tqdm import tqdm


def delete_superfluous_ae_classifiers(apps, schema_editor):
    ae_initial_classifier_ids = set(
        obj.ae_classification_id for obj in apps.get_model("effect_ae.aeinitial").objects.all()
    )
    print("\nUsed AE Initial classifiers: ", ae_initial_classifier_ids)

    ae_tmg_classifier_ids = set(
        obj.investigator_ae_classification_id
        for obj in apps.get_model("effect_ae.aetmg").objects.all()
    )
    print("Used AE TMG classifiers: ", ae_tmg_classifier_ids)

    used_classifier_ids = ae_initial_classifier_ids | ae_tmg_classifier_ids
    print("Used classifiers: ", used_classifier_ids)

    print("\nChecking for superfluous AE classifiers ...")
    superfluous_ae_classifiers = [
        "cm",
        "cm_relapse_iris",
        "diarrhoea",
        "hypokalaemia",
        "respiratory_distress",
    ]
    list_model_cls = apps.get_model("edc_adverse_event.aeclassification")
    total = list_model_cls.objects.count()
    for obj in tqdm(list_model_cls.objects.all(), total=total):
        if obj.name in superfluous_ae_classifiers and obj.id not in used_classifier_ids:
            print(" * Deleting (superfluous):", obj.name, obj.id)
            obj.delete()
        elif obj.name in superfluous_ae_classifiers:
            print(
                " * Skipping (superfluous, but classifier already in use):", obj.name, obj.id
            )
        else:
            print(" * Skipping (not superfluous):", obj.name, obj.id)
    print(" Done checking for superfluous AE classifiers.")


class Migration(migrations.Migration):
    dependencies = [
        ("effect_ae", "0013_alter_deathreporttmg_cause_of_death_agreed_and_more"),
    ]

    operations = [RunPython(delete_superfluous_ae_classifiers)]
