# Generated by Django 4.2.10 on 2024-02-28 15:39

import django.contrib.sites.managers
from django.db import migrations, models
import django.db.models.manager


class Migration(migrations.Migration):

    dependencies = [
        ("effect_consent", "0014_alter_subjectconsent_unique_together_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="SubjectConsentUpdateV2",
            fields=[],
            options={
                "verbose_name": "Consent Version 2 (Update)",
                "verbose_name_plural": "Consent Version 2 (Update)",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("effect_consent.subjectconsent",),
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="SubjectConsentV1",
            fields=[],
            options={
                "verbose_name": "Consent Version 1",
                "verbose_name_plural": "Consent Version 1",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("effect_consent.subjectconsent",),
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="SubjectConsentV2",
            fields=[],
            options={
                "verbose_name": "Consent Version 2",
                "verbose_name_plural": "Consent Version 2",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("effect_consent.subjectconsent",),
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", django.db.models.manager.Manager()),
            ],
        ),
        migrations.RemoveConstraint(
            model_name="subjectconsent",
            name="effect_consent_subjectconsent_version_uniq",
        ),
        migrations.RenameField(
            model_name="historicalsubjectconsent",
            old_name="updates_versions",
            new_name="update_versions",
        ),
        migrations.RenameField(
            model_name="subjectconsent",
            old_name="updates_versions",
            new_name="update_versions",
        ),
        migrations.AddField(
            model_name="historicalsubjectconsent",
            name="consent_definition_name",
            field=models.CharField(
                editable=False, max_length=50, null=True, verbose_name="Consent definition"
            ),
        ),
        migrations.AddField(
            model_name="subjectconsent",
            name="consent_definition_name",
            field=models.CharField(
                editable=False, max_length=50, null=True, verbose_name="Consent definition"
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectconsent",
            name="screening_identifier",
            field=models.CharField(max_length=50, verbose_name="Screening identifier"),
        ),
        migrations.AlterField(
            model_name="historicalsubjectconsent",
            name="version",
            field=models.CharField(
                editable=False,
                help_text="See 'consent definition' for consent versions by period.",
                max_length=10,
                verbose_name="Consent version",
            ),
        ),
        migrations.AlterField(
            model_name="subjectconsent",
            name="screening_identifier",
            field=models.CharField(max_length=50, verbose_name="Screening identifier"),
        ),
        migrations.AlterField(
            model_name="subjectconsent",
            name="version",
            field=models.CharField(
                editable=False,
                help_text="See 'consent definition' for consent versions by period.",
                max_length=10,
                verbose_name="Consent version",
            ),
        ),
        migrations.AddConstraint(
            model_name="subjectconsent",
            constraint=models.UniqueConstraint(
                fields=("version", "screening_identifier", "subject_identifier"),
                name="effect_consent_subjectconsent_version_uniq",
            ),
        ),
    ]
