from edc_consent.constants import CONSENT_WITHDRAWAL
from edc_constants.constants import (
    DEAD,
    HEADACHE,
    NORMAL,
    NOT_APPLICABLE,
    OTHER,
    OTHER_PLEASE_SPECIFY_TEXT,
    PER_PROTOCOL,
    STEROIDS,
    TOXICITY,
    UNKNOWN,
    VISUAL_LOSS,
)
from edc_constants.disease_constants import (
    BACTERAEMIA,
    BACTERIAL_PNEUMONIA,
    CN_PALSY_LEFT_OTHER,
    CN_PALSY_RIGHT_OTHER,
    CRYPTOCOCCAL_MENINGITIS,
    DIARRHOEA,
    DIARRHOEAL_WASTING,
    FOCAL_NEUROLOGIC_DEFICIT_OTHER,
    TB_EXTRAPULMONARY,
    TB_PULMONARY,
)
from edc_ltfu.constants import LOST_TO_FOLLOWUP
from edc_offstudy.constants import COMPLETED_FOLLOWUP, INVALID_ENROLMENT, LATE_EXCLUSION
from edc_transfer.constants import TRANSFERRED

list_data = {
    "effect_lists.nonadherencereasons": [
        ("forget_to_take", "I sometimes forget to take my pills"),
        ("dont_like_taking", "I don't like taking my pills"),
        ("make_me_ill", "My pills sometimes make me feel sick"),
        ("misplaced_pills", "I sometimes misplace my pills"),
        ("dont_believe_pills_help", "I don't believe my pills are helping me"),
        ("dont_believe_pills_needed", "I don't believe I need to take my pills"),
        ("not_feeling_well", "I have not been feeling well"),
        (OTHER, OTHER_PLEASE_SPECIFY_TEXT),
    ],
    "effect_lists.antibiotics": [
        ("amoxicillin", "Amoxicillin"),
        ("ampicillin", "Ampicillin"),
        ("flucloxacillin", "Flucloxacillin"),
        ("doxycycline", "Doxycycline"),
        ("ceftriaxone", "Ceftriaxone"),
        (
            "ciprofloxacin",
            "Ciprofloxacin (NB avoid on concomitant high dose fluconazole)",
        ),
        ("coamoxiclav", "Coamoxiclav (amoxicillin/clavulanate)"),
        (
            "erythromycin",
            "Erythromycin (NB contra-indicated on concomitant high dose fluconazole)",
        ),
        ("gentamicin", "Gentamicin"),
        (
            OTHER,
            (
                "Other antibiotic, (NB avoid with concomitant high dose fluconazole), "
                "please specify below ..."
            ),
        ),
    ],
    "effect_lists.arvregimens": [
        (NOT_APPLICABLE, "--Not applicable"),
        ("ABC_3TC/FTC", "ABC + 3TC/FTC"),
        ("ABC_3TC_ATV_r", "ABC + 3TC + ATV/r"),
        ("ABC_3TC_DTG", "ABC + 3TC + DTG"),
        ("ABC_3TC_EFV", "ABC + 3TC + EFV"),
        ("ABC_3TC_LPV_r", "ABC + 3TC + LPV/r"),
        ("AZT_3TC_ATV_r", "AZT + 3TC + ATV/r"),
        ("AZT_3TC_DTG", "AZT + 3TC + DTG"),
        ("AZT_3TC_EFV", "AZT + 3TC + EFV"),
        ("AZT_3TC_LPV_r", "AZT + 3TC + LPV/r"),
        ("AZT_3TC_NVP", "AZT + 3TC + NVP"),
        ("AZT_FTC/3TC", "AZT + FTC/3TC"),
        ("D4T_3TC_NVP", "D4T + 3TC + NVP"),
        ("DTG_ABC/3TC_ATV_r", "DTG + (ABC/3TC) + ATV/r"),
        ("TDF_3TC_ATV_r", "TDF + 3TC + ATV/r"),
        ("TDF_3TC_DTG", "TDF + 3TC + DTG"),
        ("TDF_3TC_EFV", "TDF + 3TC + EFV"),
        ("TDF_3TC_LPV_r", "TDF + 3TC + LPV/r"),
        ("TDF_3TC_NVP", "TDF + 3TC + NVP"),
        ("TDF_FTC/3TC", "TDF + FTC/3TC"),
        ("TDF_FTC_ATV_r", "TDF + FTC + ATV/r"),
        ("TDF_FTC_DTG", "TDF + FTC + DTG"),
        ("TDF_FTC_EFV", "TDF + FTC + EFV"),
        ("TDF_FTC_LPV_r", "TDF + FTC + LPV/r"),
        ("TDF_FTC_NVP", "TDF + FTC + NVP"),
        ("ZDV_3TC_EFV", "ZDV + 3TC + EFV"),
        ("ZDV_3TC_NVP", "ZDV + 3TC + NVP"),
        ("ZDV_LPV_NVP", "ZDV + LPV + NVP"),
        ("EFV", "EFV"),
        ("NVP", "NVP"),
        ("DTG", "DTG"),
        ("ATZ_r", "ATZ/r"),
        ("DRV_r", "DRV/r"),
        ("lopinavir_r", "Lopinavir/r"),
        ("abacavir", "Abacavir"),
        (UNKNOWN, "Unknown"),
        (OTHER, OTHER_PLEASE_SPECIFY_TEXT),
    ],
    "effect_lists.dosemodificationreasons": [
        (PER_PROTOCOL, "Per protocol"),
        ("renal_adjustment", "Renal adjustment"),
        (TOXICITY, "Toxicity"),
        (OTHER, OTHER_PLEASE_SPECIFY_TEXT),
    ],
    "effect_lists.drugs": [
        ("k", "K"),
        ("mg", "Mg"),
        ("sodium", "Sodium"),
        ("vitamins", "Vitamins"),
        ("anticonvulsants", "Anticonvulsants"),
        ("antimalarials", "Antimalarials"),
        (OTHER, "Other drug/intervention, please specify below ..."),
    ],
    "effect_lists.dx": [
        (NOT_APPLICABLE, "--Not applicable"),
        (BACTERAEMIA, "Bacteraemia"),
        (BACTERIAL_PNEUMONIA, "Bacterial pneumonia"),
        (CRYPTOCOCCAL_MENINGITIS, "Cryptococcal meningitis"),
        (DIARRHOEAL_WASTING, "Diarrhoeal wasting"),
        ("kaposi_sarcoma", "Kaposi's sarcoma"),
        ("malaria", "Malaria"),
        (TB_EXTRAPULMONARY, "TB extrapulmonary"),
        (TB_PULMONARY, "TB pulmonary"),
        (OTHER, OTHER_PLEASE_SPECIFY_TEXT),
    ],
    "effect_lists.lateexclusioncriteria": [
        ("g4_low_plt_d1", "DAIDS grade 4 low platelets (<25 x10^9/L) on day 1"),
        ("g4_low_anc_d1", "DAIDS grade 4 low neutrophils (<400 x10^6/L) on day 1"),
        ("g4_elevated_cr_d1", "DAIDS grade 4 elevated creatinine (≥400 μmol/L) on day 1"),
        ("cm_evidence_screening_csf", "Microbiological evidence of CM on screening CSF"),
    ],
    "effect_lists.medication": [
        (NOT_APPLICABLE, "--Not applicable"),
        ("TMP-SMX", "TMP-SMX"),
        (STEROIDS, "Steroids, please specify type and dose below ..."),
        ("actrapid", "Actrapid"),
        ("actrophane", "Actrophane"),
        ("allopurinol", "Allopurinol"),
        ("amitriptyline", "Amitriptyline"),
        ("amlodipine", "Amlodipine"),
        ("atenalol", "Atenalol"),
        ("atorvastatin", "Atorvastatin"),
        ("budesonide", "Budesonide"),
        ("budesonide_formoterol", "Budesonide/Formoterol (Symbicord)"),
        ("carbamazepine", "Carbamazepine"),
        ("carvedilol", "Carvedilol"),
        ("cetirizine", "Cetirizine (Texa)"),
        ("chlorpheniramine", "Chlorpheniramine (Allergex)"),
        ("chlorpromazine", "Chlorpromazine"),
        ("citalopram", "Citalopram"),
        ("clozapine", "Clozapine"),
        ("colchecine", "Colchecine"),
        ("diclofenac", "Diclofenac (Voltaren)"),
        ("doxazosin", "Doxazosin (Cardura)"),
        ("enalapril", "Enalapril"),
        ("fluanxil", "Fluanxil"),
        ("fluoxetine", "Fluoxetine (Prozac)"),
        ("follic_acid", "Follic Acid"),
        ("furosemide", "Furosemide (Lasix)"),
        ("glimepiride", "Glimepiride"),
        ("hctz", "HCTZ (Ridaq)"),
        ("humalog", "Humalog"),
        ("ibuprofen", "Ibuprofen"),
        ("iron", "Iron (FeSO4/ FeGluconate)"),
        ("lamotrigine", "Lamotrigine"),
        ("lansoprazole", "Lansoprazole"),
        ("loperamide", "Loperamide (Imodium)"),
        ("losartan", "Losartan"),
        ("metformin", "Metformin"),
        ("montelukaust", "Montelukaust"),
        ("nystatin", "Nystatin"),
        ("olanzapine", "Olanzapine"),
        ("omeprazole", "Omeprazole"),
        ("pantoprazole", "Pantoprazole"),
        ("paracetamol", "Paracetamol"),
        ("phenytoin", "Phenytoin"),
        ("pioglitazone", "Pioglitazone"),
        ("prednisone", "Prednisone"),
        ("protophane", "Protophane"),
        ("pyridoxine", "Pyridoxine"),
        ("quetiapine", "Quetiapine"),
        ("ranitidine", "Ranitidine"),
        ("risperidone", "Risperidone"),
        ("salbutamol", "Salbutamol"),
        ("salmeterol_fluticasone", "Salmeterol/Fluticasone (Foxair/Sereflo)"),
        ("simvastatin", "Simvastatin"),
        ("spirinolactone", "Spirinolactone"),
        ("tramadol", "Tramadol"),
        ("valproate", "Valproate (Epilim)"),
        ("venlafaxine", "Venlafaxine"),
        ("vitamin_c", "Vitamin C"),
        (OTHER, "Other medication, please specify below ..."),
    ],
    "effect_lists.offstudyreasons": [
        (COMPLETED_FOLLOWUP, "Completed 6 month follow-up"),
        (DEAD, "Participant died"),
        (LOST_TO_FOLLOWUP, "Lost to follow-up"),
        (CONSENT_WITHDRAWAL, "Withdrew consent to participate further"),
        (LATE_EXCLUSION, "Participant fulfilled late exclusion criteria"),
        (TRANSFERRED, "Participant has been transferred to another health centre"),
        (
            INVALID_ENROLMENT,
            "Included in error (i.e. violation of inclusion/exclusion criteria) ",
        ),
        (OTHER, "Other reason, please specify below ..."),
    ],
    "effect_lists.sisx": [
        (NOT_APPLICABLE, "--Not applicable"),
        ("abdominal_cramps", "Abdominal cramps"),
        ("abdominal_distention", "Abdominal distention"),
        ("abdominal_pain", "Abdominal pain"),
        ("back_pain_lp_site", "Back pain at LP site"),
        ("backache", "Backache"),
        ("behaviour_change", "Behaviour change"),
        ("confusion", "Confusion"),
        ("constipation", "Constipation"),
        ("cough", "Cough"),
        (DIARRHOEA, "Diarrhoea"),
        ("dizziness", "Dizziness"),
        ("double_vision", "Double vision"),
        ("drowsiness", "Drowsiness"),
        ("dry_mouth", "Dry mouth"),
        ("dry_skin", "Dry skin"),
        ("fatigue_malaise", "Fatigue/malaise"),
        ("fever", "Fever"),
        ("focal_weakness", "Focal weakness"),
        ("general_weakness", "General weakness"),
        (HEADACHE, "Headache"),
        ("hearing_loss", "Hearing loss"),
        ("increased_appetite", "Increased appetite"),
        ("insomnia", "Insomnia"),
        ("itching", "Itching"),
        ("itchy_eyes", "Itchy eyes"),
        ("jaundice", "Jaundice"),
        ("loss_appetite", "Loss of appetite"),
        ("luts", "Lower urinary tract symptoms (LUTS)"),
        ("nausea", "Nausea"),
        ("night_sweats", "Night sweats"),
        ("CN_VI_palsy_left", "Neuro - Cranial Nerve VI palsy (left)"),
        ("CN_VI_palsy_right", "Neuro - Cranial Nerve VI palsy (right)"),
        ("CN_VII_palsy_left", "Neuro - Cranial Nerve VII palsy (left)"),
        ("CN_VII_palsy_right", "Neuro - Cranial Nerve VII palsy (right)"),
        (
            CN_PALSY_LEFT_OTHER,
            "Neuro - Other cranial nerve palsy (left), please specify below ...",
        ),
        (
            CN_PALSY_RIGHT_OTHER,
            "Neuro - Other cranial nerve palsy (right), please specify below ...",
        ),
        ("focal_seizures_left", "Neuro - Focal seizures (left)"),
        ("focal_seizures_right", "Neuro - Focal seizures (right)"),
        ("hemiplegia_left", "Neuro - Hemiplegia (left)"),
        ("hemiplegia_right", "Neuro - Hemiplegia (right)"),
        ("meningism", "Neuro - Meningism"),
        ("papilloedema", "Neuro - Papilloedema"),
        ("visual_field_disturbance", "Neuro - Visual field disturbance"),
        (
            FOCAL_NEUROLOGIC_DEFICIT_OTHER,
            "Neuro - Other focal neurologic deficit, please specify below ...",
        ),
        ("neuromuscular_weakness", "Neuromuscular weakness"),
        ("palpitations", "Palpitations"),
        ("peripheral_neuropathy", "Peripheral neuropathy"),
        ("pleuritic_chest_pain", "Pleuritic chest pain"),
        ("rash", "Rash"),
        ("rhinorrhoea", "Rhinorrhoea (runny nose)"),
        ("shortness_of_breath", "Shortness of breath"),
        ("skin_lesions", "Skin lesions"),
        (VISUAL_LOSS, "Visual loss"),
        ("vomiting", "Vomiting"),
        ("weight_loss", "Weight loss"),
        (OTHER, "Other sign(s)/symptom(s), please specify below ..."),
    ],
    "effect_lists.sisxmeningitis": [
        ("double_vision", "Double vision"),
        ("drowsiness", "Drowsiness"),
        ("fever", "Fever"),
        ("focal_weakness", "Focal weakness"),
        (HEADACHE, "Headache"),
        ("hearing_loss", "Hearing loss"),
        ("nausea", "Nausea"),
        (
            CN_PALSY_LEFT_OTHER,
            "Neuro - Other cranial nerve palsy (left), please specify below ...",
        ),
        (
            CN_PALSY_RIGHT_OTHER,
            "Neuro - Other cranial nerve palsy (right), please specify below ...",
        ),
        ("focal_seizures_left", "Neuro - Focal seizures (left)"),
        ("focal_seizures_right", "Neuro - Focal seizures (right)"),
        ("hemiplegia_left", "Neuro - Hemiplegia (left)"),
        ("hemiplegia_right", "Neuro - Hemiplegia (right)"),
        ("meningism", "Neuro - Meningism"),
        ("papilloedema", "Neuro - Papilloedema"),
        ("visual_field_disturbance", "Neuro - Visual field disturbance"),
        (
            FOCAL_NEUROLOGIC_DEFICIT_OTHER,
            "Neuro - Other focal neurologic deficit, please specify below ...",
        ),
        ("shortness_of_breath", "Shortness of breath"),
        (VISUAL_LOSS, "Visual loss"),
        ("vomiting", "Vomiting"),
        ("weight_loss", "Weight loss"),
        (OTHER, "Other SSX symptomatic of meningitis ..."),
    ],
    "effect_lists.subjectvisitmissedreasons": [
        ("forgot", "Forgot / Can't remember being told about appointment"),
        ("family_emergency", "Family emergency (e.g. funeral) and was away"),
        ("travelling", "Away travelling/visiting"),
        ("working_schooling", "Away working/schooling"),
        ("too_sick", "Too sick or weak to come to the centre"),
        ("lack_of_transport", "Transportation difficulty"),
        (
            OTHER,
            "Other reason, please specify below ...",
        ),
    ],
    "effect_lists.tbtreatments": [
        ("AM", "Am - Amikacin"),
        ("BDQ", "BDQ - Bedaquiline"),
        ("CFZ", "CFZ - Clofazimine"),
        ("DLM", "DLM - Delamanid"),
        ("E", "E - Ethambutol"),
        ("H", "H - Isoniazid"),
        ("HR", "HR - Isoniazid + Rifampicin"),
        ("HRZE", "HRZE - Isoniazid + Rifampicin + Pyrazinamide + Ethambutol"),
        ("LFX", "LFX - Levofloxacin"),
        ("LZD", "LZD - Linezolid"),
        ("MPM", "Mpm - Meropenem"),
        ("PAS", "PAS - Para-aminosalicylic acid"),
        ("PTO", "PTO - Prothionamide"),
        ("S", "S - Streptomycin"),
        ("TRD", "TRD - Terizidone"),
        ("Z", "Z - Pyrazinamide"),
        (OTHER, OTHER_PLEASE_SPECIFY_TEXT),
    ],
    "effect_lists.xrayresults": [
        (NORMAL, "Normal"),
        ("lymphadenopathy", "Lymphadenopathy"),
        ("consolidation", "Consolidation"),
        ("miliary_tb", "Miliary TB"),
        ("infiltrates", "Infiltrates"),
        (OTHER, OTHER_PLEASE_SPECIFY_TEXT),
    ],
    "effect_lists.transport": [
        ("bus", "Bus"),
        ("train", "Train"),
        ("ambulance", "Ambulance"),
        ("private_taxi", "Private taxi"),
        ("own_bicycle", "Own bicycle"),
        ("own_car", "Own car"),
        ("own_motorbike", "Own motorbike"),
        ("hired_bicycle", "Hired bicycle"),
        ("hired_motorbike", "Hired motorbike"),
        ("foot_walking", "Foot/walking"),
        (OTHER, OTHER_PLEASE_SPECIFY_TEXT),
    ],
    "edc_refusal.refusalreasons": [
        ("unwilling_to_say", "I am unwilling to say"),
        ("dont_have_time", "I don't have time"),
        ("stigma", "I am worried about stigma"),
        ("must_consult_spouse", "I need to consult my spouse"),
        ("dont_want_medication", "I don't want to take any more medication"),
        ("dont_want_to_join", "I don't want to take part"),
        ("no_clinic_time", "I don't want to spend a lot of time at the clinic"),
        ("need_to_think_about_it", "I haven't had a chance to think about it"),
        ("moving", "I am moving to another area"),
        (OTHER, "Other, please specify"),
    ],
}
