# Generated by Django 5.1.3 on 2024-12-17 15:42

import _socket
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.uuid_auto_field
import django_revision.revision_field
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("effect_reports", "0009_alter_historicalserumcragdatenote_options_and_more"),
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.CreateModel(
            name="BaselineVlAll",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50, unique=True)),
                ("crf_id", models.UUIDField(null=True)),
                ("has_viral_load_result", models.CharField(max_length=5, null=True)),
                ("viral_load_result", models.IntegerField(null=True)),
                ("viral_load_date", models.DateField(null=True)),
                ("viral_load_date_estimated", models.CharField(max_length=50, null=True)),
                ("user_created", models.CharField(max_length=50, null=True)),
                ("user_modified", models.CharField(max_length=50, null=True)),
                ("created", models.DateTimeField(null=True)),
                ("modified", models.DateTimeField(null=True)),
                (
                    "report_model",
                    models.CharField(default="effect_reports.baselinevlall", max_length=50),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING, to="sites.site"
                    ),
                ),
            ],
            options={
                "verbose_name": "Redmine #658.1 - Baseline Viral Load (All)",
                "verbose_name_plural": "Redmine #658.1 - Baseline Viral Loads (All)",
                "db_table": "effect_reports_baselinevlall",
                "abstract": False,
                "default_permissions": ("view", "export", "viewallsites"),
                "indexes": [
                    models.Index(
                        fields=["subject_identifier", "site"],
                        name="effect_repo_subject_75b254_idx",
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="BaselineVlDiscrepancy",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50, unique=True)),
                ("crf_id", models.UUIDField(null=True)),
                ("has_viral_load_result", models.CharField(max_length=5, null=True)),
                ("viral_load_result", models.IntegerField(null=True)),
                ("viral_load_date", models.DateField(null=True)),
                ("viral_load_date_estimated", models.CharField(max_length=50, null=True)),
                ("user_created", models.CharField(max_length=50, null=True)),
                ("user_modified", models.CharField(max_length=50, null=True)),
                ("created", models.DateTimeField(null=True)),
                ("modified", models.DateTimeField(null=True)),
                (
                    "report_model",
                    models.CharField(
                        default="effect_reports.baselinevldiscrepancy", max_length=50
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING, to="sites.site"
                    ),
                ),
            ],
            options={
                "verbose_name": "Redmine #658.2 - Baseline Viral Load (Discrepancy)",
                "verbose_name_plural": "Redmine #658.2 - Baseline Viral Loads (Discrepancies)",
                "db_table": "effect_reports_baselinevldiscrepancy",
                "abstract": False,
                "default_permissions": ("view", "export", "viewallsites"),
                "indexes": [
                    models.Index(
                        fields=["subject_identifier", "site"],
                        name="effect_repo_subject_3b39a4_idx",
                    )
                ],
            },
        ),
    ]
