# Generated by Django 3.2 on 2022-08-26 13:49

from django.db import migrations, models
import edc_model.validators.date


class Migration(migrations.Migration):
    dependencies = [
        ("effect_lists", "0011_auto_20220725_1324"),
        ("effect_subject", "0087_auto_20220824_1919"),
    ]

    operations = [
        migrations.AlterField(
            model_name="adherence",
            name="diary_issued",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was an adherence diary issued to the participant?",
            ),
        ),
        migrations.AlterField(
            model_name="adherence",
            name="diary_match_medication",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Did the participant adherence diary match the medication reconciliation?",
            ),
        ),
        migrations.AlterField(
            model_name="adherence",
            name="diary_returned",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was participant adherence diary received and stored in patient records?",
            ),
        ),
        migrations.AlterField(
            model_name="adherence",
            name="linked_local_clinic",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Has the participant linked up with their local clinic?",
            ),
        ),
        migrations.AlterField(
            model_name="adherence",
            name="on_arv",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Is the participant receiving ARVs?",
            ),
        ),
        migrations.AlterField(
            model_name="adherence",
            name="on_flucon",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Is the participant receiving Fluconazole?",
            ),
        ),
        migrations.AlterField(
            model_name="adherence",
            name="opinion_arv_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the participant 90% adherent to ART?",
            ),
        ),
        migrations.AlterField(
            model_name="adherence",
            name="opinion_flucon_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the participant 90% adherent to fluconazole?",
            ),
        ),
        migrations.AlterField(
            model_name="arvhistory",
            name="ever_on_art",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=5,
                verbose_name="Was the participant on ART <u>prior</u> to CrAg test?",
            ),
        ),
        migrations.AlterField(
            model_name="arvhistory",
            name="has_defaulted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="Defaulted means no ART for at least one month.",
                max_length=5,
                verbose_name="Has the participant <u>now</u> defaulted from their <u>current</u> ART regimen?",
            ),
        ),
        migrations.AlterField(
            model_name="arvhistory",
            name="has_switched_art_regimen",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=5,
                verbose_name="Has the participant ever <u>switched</u> ART regimen?",
            ),
        ),
        migrations.AlterField(
            model_name="arvhistory",
            name="initial_art_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="When did the participant <u>start</u> ART for the first time?",
            ),
        ),
        migrations.AlterField(
            model_name="arvhistory",
            name="is_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=5,
                verbose_name="If the participant is currently on ART, are they <u>adherent</u> to their <u>current</u> ART regimen?",
            ),
        ),
        migrations.AlterField(
            model_name="arvhistory",
            name="on_art_at_crag",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=5,
                verbose_name="Was the participant on ART <u>at time of</u> CrAg test?",
            ),
        ),
        migrations.AlterField(
            model_name="arvtreatment",
            name="adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="In the opinion of the clinician, is the participant at least 90% adherent",
                max_length=15,
                verbose_name="If YES, on an ART regimen, has the participant adhered to this ART regimen?",
            ),
        ),
        migrations.AlterField(
            model_name="arvtreatment",
            name="arv_regimen_changed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Has the participant's ART regimen changed since the last study assessment",
            ),
        ),
        migrations.AlterField(
            model_name="arvtreatment",
            name="on_arv_regimen",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If ART regimen is on hold, answer yes and clarify below",
                max_length=15,
                verbose_name="Is the participant currently on an ART regimen?",
            ),
        ),
        migrations.AlterField(
            model_name="diagnoses",
            name="gi_side_effects",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If YES, complete SAE report where appropriate",
                max_length=15,
                verbose_name="Has the participant experienced any gastrointestinal side effects?",
            ),
        ),
        migrations.AlterField(
            model_name="diagnoses",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If YES, complete Hospitalization and AE Initial reports.",
                max_length=15,
                verbose_name="Has the participant been admitted due to any of these diagnoses?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherence",
            name="diary_issued",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was an adherence diary issued to the participant?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherence",
            name="diary_match_medication",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Did the participant adherence diary match the medication reconciliation?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherence",
            name="diary_returned",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was participant adherence diary received and stored in patient records?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherence",
            name="linked_local_clinic",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Has the participant linked up with their local clinic?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherence",
            name="on_arv",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Is the participant receiving ARVs?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherence",
            name="on_flucon",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Is the participant receiving Fluconazole?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherence",
            name="opinion_arv_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the participant 90% adherent to ART?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherence",
            name="opinion_flucon_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the participant 90% adherent to fluconazole?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagefour",
            name="diary_issued",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was an adherence diary issued to the participant?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagefour",
            name="diary_match_medication",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Did the participant adherence diary match the medication reconciliation?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagefour",
            name="diary_returned",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was participant adherence diary received and stored in patient records?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagefour",
            name="linked_local_clinic",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Has the participant linked up with their local clinic?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagefour",
            name="on_arv",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Is the participant receiving ARVs?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagefour",
            name="on_flucon",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Is the participant receiving Fluconazole?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagefour",
            name="opinion_arv_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the participant 90% adherent to ART?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagefour",
            name="opinion_flucon_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the participant 90% adherent to fluconazole?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestageone",
            name="diary_issued",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was an adherence diary issued to the participant?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestageone",
            name="diary_match_medication",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Did the participant adherence diary match the medication reconciliation?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestageone",
            name="diary_returned",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was participant adherence diary received and stored in patient records?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestageone",
            name="linked_local_clinic",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Has the participant linked up with their local clinic?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestageone",
            name="on_arv",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Is the participant receiving ARVs?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestageone",
            name="on_flucon",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Is the participant receiving Fluconazole?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestageone",
            name="opinion_arv_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the participant 90% adherent to ART?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestageone",
            name="opinion_flucon_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the participant 90% adherent to fluconazole?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagethree",
            name="diary_issued",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was an adherence diary issued to the participant?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagethree",
            name="diary_match_medication",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Did the participant adherence diary match the medication reconciliation?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagethree",
            name="diary_returned",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was participant adherence diary received and stored in patient records?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagethree",
            name="linked_local_clinic",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Has the participant linked up with their local clinic?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagethree",
            name="on_arv",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Is the participant receiving ARVs?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagethree",
            name="on_flucon",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Is the participant receiving Fluconazole?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagethree",
            name="opinion_arv_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the participant 90% adherent to ART?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagethree",
            name="opinion_flucon_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the participant 90% adherent to fluconazole?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagetwo",
            name="diary_issued",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was an adherence diary issued to the participant?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagetwo",
            name="diary_match_medication",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Did the participant adherence diary match the medication reconciliation?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagetwo",
            name="diary_returned",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was participant adherence diary received and stored in patient records?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagetwo",
            name="linked_local_clinic",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Has the participant linked up with their local clinic?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagetwo",
            name="on_arv",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Is the participant receiving ARVs?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagetwo",
            name="on_flucon",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Is the participant receiving Fluconazole?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagetwo",
            name="opinion_arv_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the participant 90% adherent to ART?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaladherencestagetwo",
            name="opinion_flucon_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the participant 90% adherent to fluconazole?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvhistory",
            name="ever_on_art",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=5,
                verbose_name="Was the participant on ART <u>prior</u> to CrAg test?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvhistory",
            name="has_defaulted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="Defaulted means no ART for at least one month.",
                max_length=5,
                verbose_name="Has the participant <u>now</u> defaulted from their <u>current</u> ART regimen?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvhistory",
            name="has_switched_art_regimen",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=5,
                verbose_name="Has the participant ever <u>switched</u> ART regimen?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvhistory",
            name="initial_art_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="When did the participant <u>start</u> ART for the first time?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvhistory",
            name="is_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=5,
                verbose_name="If the participant is currently on ART, are they <u>adherent</u> to their <u>current</u> ART regimen?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvhistory",
            name="on_art_at_crag",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=5,
                verbose_name="Was the participant on ART <u>at time of</u> CrAg test?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvtreatment",
            name="adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="In the opinion of the clinician, is the participant at least 90% adherent",
                max_length=15,
                verbose_name="If YES, on an ART regimen, has the participant adhered to this ART regimen?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvtreatment",
            name="arv_regimen_changed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Has the participant's ART regimen changed since the last study assessment",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvtreatment",
            name="on_arv_regimen",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If ART regimen is on hold, answer yes and clarify below",
                max_length=15,
                verbose_name="Is the participant currently on an ART regimen?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldiagnoses",
            name="gi_side_effects",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If YES, complete SAE report where appropriate",
                max_length=15,
                verbose_name="Has the participant experienced any gastrointestinal side effects?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldiagnoses",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If YES, complete Hospitalization and AE Initial reports.",
                max_length=15,
                verbose_name="Has the participant been admitted due to any of these diagnoses?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalmentalstatus",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If YES, complete Hospitalization and AE Initial reports.",
                max_length=15,
                verbose_name="Has the participant been admitted due to these symptoms?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalpatienttreatment",
            name="on_antibiotics",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                verbose_name="Has the participant been prescribed antibiotics?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalpatienttreatment",
            name="on_co_trimoxazole",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                verbose_name="Has the participant been prescribed co-trimoxazole?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalpatienttreatment",
            name="on_other_drugs",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                verbose_name="Has the participant been prescribed any other drugs/interventions?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalpatienttreatment",
            name="on_steroids",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                verbose_name="Were steroids administered to the participant?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalpatienttreatment",
            name="on_tb_tx",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                verbose_name="Has the participant been put on TB preventive therapy?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsignsandsymptoms",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If YES, complete Hospitalization and AE Initial reports.",
                max_length=15,
                verbose_name="Has the participant been admitted due to any of these signs or symptoms?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectvisit",
            name="assessment_who",
            field=models.CharField(
                choices=[
                    ("patient", "Participant"),
                    ("next_of_kin", "Next of kin"),
                    ("N/A", "Not applicable (if missed)"),
                    ("OTHER", "Other, please specify below ..."),
                ],
                max_length=15,
                verbose_name="Who did you speak to?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectvisit",
            name="hospitalized",
            field=models.CharField(
                choices=[
                    ("Yes", "Yes"),
                    ("No", "No"),
                    ("unknown", "Unknown"),
                    ("N/A", "Not applicable (if missed)"),
                ],
                default="N/A",
                help_text="If YES, complete Hospitalization and AE Initial reports.",
                max_length=15,
                verbose_name="Has the participant been hospitalized since the last assessment?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectvisit",
            name="info_source",
            field=models.CharField(
                choices=[
                    ("patient", "Participant"),
                    (
                        "patient_representative",
                        "Participant representative (e.g., next of kin, relative, guardian)",
                    ),
                    ("hospital_notes", "Hospital notes"),
                    ("outpatient_cards", "Outpatient cards"),
                    ("N/A", "Not applicable (if missed)"),
                    ("OTHER", "Other"),
                ],
                max_length=25,
                verbose_name="What is the MAIN source of this information?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectvisit",
            name="reason_unscheduled",
            field=models.CharField(
                choices=[
                    ("patient_unwell_outpatient", "Participant unwell (outpatient)"),
                    ("patient_hospitalised", "Participant hospitalised"),
                    ("routine_non_study", "Routine appointment (non-study)"),
                    ("recurrence_symptoms", "Recurrence of symptoms"),
                    ("OTHER", "Other"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=25,
                verbose_name="If 'unscheduled', provide reason for the unscheduled visit",
            ),
        ),
        migrations.AlterField(
            model_name="historicalvitalsigns",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If YES, complete Hospitalization and AE Initial reports.",
                max_length=15,
                verbose_name="Has the participant been admitted due to any of the above?",
            ),
        ),
        migrations.AlterField(
            model_name="mentalstatus",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If YES, complete Hospitalization and AE Initial reports.",
                max_length=15,
                verbose_name="Has the participant been admitted due to these symptoms?",
            ),
        ),
        migrations.AlterField(
            model_name="patienttreatment",
            name="on_antibiotics",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                verbose_name="Has the participant been prescribed antibiotics?",
            ),
        ),
        migrations.AlterField(
            model_name="patienttreatment",
            name="on_co_trimoxazole",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                verbose_name="Has the participant been prescribed co-trimoxazole?",
            ),
        ),
        migrations.AlterField(
            model_name="patienttreatment",
            name="on_other_drugs",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                verbose_name="Has the participant been prescribed any other drugs/interventions?",
            ),
        ),
        migrations.AlterField(
            model_name="patienttreatment",
            name="on_steroids",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                verbose_name="Were steroids administered to the participant?",
            ),
        ),
        migrations.AlterField(
            model_name="patienttreatment",
            name="on_tb_tx",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                verbose_name="Has the participant been put on TB preventive therapy?",
            ),
        ),
        migrations.AlterField(
            model_name="signsandsymptoms",
            name="current_sx",
            field=models.ManyToManyField(
                related_name="sx",
                to="effect_lists.SiSx",
                verbose_name="Is participant currently experiencing any of the following signs/symptoms?",
            ),
        ),
        migrations.AlterField(
            model_name="signsandsymptoms",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If YES, complete Hospitalization and AE Initial reports.",
                max_length=15,
                verbose_name="Has the participant been admitted due to any of these signs or symptoms?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectvisit",
            name="assessment_who",
            field=models.CharField(
                choices=[
                    ("patient", "Participant"),
                    ("next_of_kin", "Next of kin"),
                    ("N/A", "Not applicable (if missed)"),
                    ("OTHER", "Other, please specify below ..."),
                ],
                max_length=15,
                verbose_name="Who did you speak to?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectvisit",
            name="hospitalized",
            field=models.CharField(
                choices=[
                    ("Yes", "Yes"),
                    ("No", "No"),
                    ("unknown", "Unknown"),
                    ("N/A", "Not applicable (if missed)"),
                ],
                default="N/A",
                help_text="If YES, complete Hospitalization and AE Initial reports.",
                max_length=15,
                verbose_name="Has the participant been hospitalized since the last assessment?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectvisit",
            name="info_source",
            field=models.CharField(
                choices=[
                    ("patient", "Participant"),
                    (
                        "patient_representative",
                        "Participant representative (e.g., next of kin, relative, guardian)",
                    ),
                    ("hospital_notes", "Hospital notes"),
                    ("outpatient_cards", "Outpatient cards"),
                    ("N/A", "Not applicable (if missed)"),
                    ("OTHER", "Other"),
                ],
                max_length=25,
                verbose_name="What is the MAIN source of this information?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectvisit",
            name="reason_unscheduled",
            field=models.CharField(
                choices=[
                    ("patient_unwell_outpatient", "Participant unwell (outpatient)"),
                    ("patient_hospitalised", "Participant hospitalised"),
                    ("routine_non_study", "Routine appointment (non-study)"),
                    ("recurrence_symptoms", "Recurrence of symptoms"),
                    ("OTHER", "Other"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=25,
                verbose_name="If 'unscheduled', provide reason for the unscheduled visit",
            ),
        ),
        migrations.AlterField(
            model_name="vitalsigns",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If YES, complete Hospitalization and AE Initial reports.",
                max_length=15,
                verbose_name="Has the participant been admitted due to any of the above?",
            ),
        ),
    ]
