# Generated by Django 5.0 on 2023-12-21 03:18

import django.core.validators
import django.db.models.manager
import edc_sites.managers
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        (
            "edc_action_item",
            "0035_alter_actionitem_options_alter_actiontype_options_and_more",
        ),
        ("edc_lab", "0033_remove_panel_edc_lab_pan_lab_pro_2a0c6d_idx_and_more"),
        (
            "effect_lists",
            "0015_alter_antibiotics_options_alter_arvregimens_options_and_more",
        ),
        (
            "effect_subject",
            "0110_alter_historicalsubjectvisit_assessment_type_other_and_more",
        ),
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="adherence",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Adherence",
                "verbose_name_plural": "Adherence",
            },
        ),
        migrations.AlterModelOptions(
            name="arvhistory",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "ARV History",
                "verbose_name_plural": "ARV History",
            },
        ),
        migrations.AlterModelOptions(
            name="arvtreatment",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "ARV Treatment",
                "verbose_name_plural": "ARV Treatment",
            },
        ),
        migrations.AlterModelOptions(
            name="bloodculture",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Blood culture",
                "verbose_name_plural": "Blood culture",
            },
        ),
        migrations.AlterModelOptions(
            name="bloodresultschem",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Blood Result: Chemistry",
                "verbose_name_plural": "Blood Results: Chemistry",
            },
        ),
        migrations.AlterModelOptions(
            name="bloodresultsfbc",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Blood Result: FBC",
                "verbose_name_plural": "Blood Results: FBC",
            },
        ),
        migrations.AlterModelOptions(
            name="chestxray",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Chest X-ray",
                "verbose_name_plural": "Chest X-rays",
            },
        ),
        migrations.AlterModelOptions(
            name="clinicalnote",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Clinical Note",
                "verbose_name_plural": "Clinical Note",
            },
        ),
        migrations.AlterModelOptions(
            name="diagnoses",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Significant Diagnoses",
                "verbose_name_plural": "Significant Diagnoses",
            },
        ),
        migrations.AlterModelOptions(
            name="fluconmisseddoses",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Fluconazole Missed Dose",
                "verbose_name_plural": "Fluconazole Missed Doses",
            },
        ),
        migrations.AlterModelOptions(
            name="flucytmisseddoses",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Flucytosine Missed Dose",
                "verbose_name_plural": "Flucytosine Missed Doses",
            },
        ),
        migrations.AlterModelOptions(
            name="healtheconomics",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Health Economics",
                "verbose_name_plural": "Health Economics",
            },
        ),
        migrations.AlterModelOptions(
            name="healtheconomicsevent",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Health Economics: Health Event",
                "verbose_name_plural": "Health Economics: Health Event",
            },
        ),
        migrations.AlterModelOptions(
            name="histopathology",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Histopathology",
                "verbose_name_plural": "Histopathology",
            },
        ),
        migrations.AlterModelOptions(
            name="lpcsf",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Lumbar Puncture/CSF",
                "verbose_name_plural": "Lumbar Puncture/CSF",
            },
        ),
        migrations.AlterModelOptions(
            name="medicationadherence",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Medication Adherence",
                "verbose_name_plural": "Medication Adherence",
            },
        ),
        migrations.AlterModelOptions(
            name="mentalstatus",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Mental Status",
                "verbose_name_plural": "Mental Status",
            },
        ),
        migrations.AlterModelOptions(
            name="participanthistory",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Participant History",
                "verbose_name_plural": "Participant History",
            },
        ),
        migrations.AlterModelOptions(
            name="participanttreatment",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Participant Treatment",
                "verbose_name_plural": "Participant Treatment",
            },
        ),
        migrations.AlterModelOptions(
            name="signsandsymptoms",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Signs and Symptoms",
                "verbose_name_plural": "Signs and Symptoms",
            },
        ),
        migrations.AlterModelOptions(
            name="studymedication",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Study medication",
                "verbose_name_plural": "Study medication",
            },
        ),
        migrations.AlterModelOptions(
            name="subjectrequisition",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
            },
        ),
        migrations.AlterModelOptions(
            name="subjectvisit",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
            },
        ),
        migrations.AlterModelOptions(
            name="subjectvisitmissed",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Missed Visit Report",
                "verbose_name_plural": "Missed Visit Report",
            },
        ),
        migrations.AlterModelOptions(
            name="tbdiagnostics",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "TB Diagnostics",
                "verbose_name_plural": "TB Diagnostics",
            },
        ),
        migrations.AlterModelOptions(
            name="urinalysis",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Urinalysis",
                "verbose_name_plural": "Urinalysis",
            },
        ),
        migrations.AlterModelOptions(
            name="vitalsigns",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Vital Signs",
                "verbose_name_plural": "Vital Signs",
            },
        ),
        migrations.AlterModelManagers(
            name="fluconmisseddoses",
            managers=[
                ("objects", django.db.models.manager.Manager()),
                ("on_site", edc_sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.AlterModelManagers(
            name="flucytmisseddoses",
            managers=[
                ("objects", django.db.models.manager.Manager()),
                ("on_site", edc_sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.RemoveIndex(
            model_name="adherence",
            name="effect_subj_subject_d79350_idx",
        ),
        migrations.RemoveIndex(
            model_name="arvhistory",
            name="effect_subj_subject_1087ec_idx",
        ),
        migrations.RemoveIndex(
            model_name="arvtreatment",
            name="effect_subj_subject_8953bc_idx",
        ),
        migrations.RemoveIndex(
            model_name="bloodculture",
            name="effect_subj_subject_404a7c_idx",
        ),
        migrations.RemoveIndex(
            model_name="bloodresultschem",
            name="effect_subj_subject_f0ab29_idx",
        ),
        migrations.RemoveIndex(
            model_name="bloodresultsfbc",
            name="effect_subj_subject_b87d19_idx",
        ),
        migrations.RemoveIndex(
            model_name="chestxray",
            name="effect_subj_subject_85bfb1_idx",
        ),
        migrations.RemoveIndex(
            model_name="clinicalnote",
            name="effect_subj_subject_8b519f_idx",
        ),
        migrations.RemoveIndex(
            model_name="diagnoses",
            name="effect_subj_subject_b0c15d_idx",
        ),
        migrations.RemoveIndex(
            model_name="healtheconomics",
            name="effect_subj_subject_f66097_idx",
        ),
        migrations.RemoveIndex(
            model_name="healtheconomicsevent",
            name="effect_subj_subject_fa6edc_idx",
        ),
        migrations.RemoveIndex(
            model_name="histopathology",
            name="effect_subj_subject_511a8a_idx",
        ),
        migrations.RemoveIndex(
            model_name="lpcsf",
            name="effect_subj_subject_b9f353_idx",
        ),
        migrations.RemoveIndex(
            model_name="medicationadherence",
            name="effect_subj_subject_53f67a_idx",
        ),
        migrations.RemoveIndex(
            model_name="mentalstatus",
            name="effect_subj_subject_8477f6_idx",
        ),
        migrations.RemoveIndex(
            model_name="participanthistory",
            name="effect_subj_subject_9e5f19_idx",
        ),
        migrations.RemoveIndex(
            model_name="participanttreatment",
            name="effect_subj_subject_ed4677_idx",
        ),
        migrations.RemoveIndex(
            model_name="signsandsymptoms",
            name="effect_subj_subject_9edf0f_idx",
        ),
        migrations.RemoveIndex(
            model_name="studymedication",
            name="effect_subj_subject_216701_idx",
        ),
        migrations.RemoveIndex(
            model_name="subjectrequisition",
            name="effect_subj_subject_401c00_idx",
        ),
        migrations.RemoveIndex(
            model_name="subjectvisitmissed",
            name="effect_subj_subject_1e9ef7_idx",
        ),
        migrations.RemoveIndex(
            model_name="tbdiagnostics",
            name="effect_subj_subject_edc9eb_idx",
        ),
        migrations.RemoveIndex(
            model_name="urinalysis",
            name="effect_subj_subject_dd71f9_idx",
        ),
        migrations.RemoveIndex(
            model_name="vitalsigns",
            name="effect_subj_subject_93a0c7_idx",
        ),
        migrations.AlterUniqueTogether(
            name="subjectrequisition",
            unique_together=set(),
        ),
        migrations.AddField(
            model_name="adherence",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="arvtreatment",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="arvtreatment",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="bloodculture",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="bloodculture",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultsfbc",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultsfbc",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="chestxray",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="chestxray",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="clinicalnote",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="clinicalnote",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="diagnoses",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="diagnoses",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="fluconmisseddoses",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="fluconmisseddoses",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="flucytmisseddoses",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="flucytmisseddoses",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomicsevent",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomicsevent",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="histopathology",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="histopathology",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherencestagefour",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherencestagefour",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherencestageone",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherencestageone",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherencestagethree",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherencestagethree",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherencestagetwo",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherencestagetwo",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvtreatment",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvtreatment",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodculture",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodculture",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultsfbc",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultsfbc",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalchestxray",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalchestxray",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalclinicalnote",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalclinicalnote",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicaldiagnoses",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicaldiagnoses",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalfluconmisseddoses",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalfluconmisseddoses",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalflucytmisseddoses",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalflucytmisseddoses",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomicsevent",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomicsevent",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalhistopathology",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalhistopathology",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicallpcsf",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicallpcsf",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalmedicationadherence",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalmedicationadherence",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalmentalstatus",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalmentalstatus",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalparticipanthistory",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalparticipanthistory",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalparticipanttreatment",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalparticipanttreatment",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedication",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedication",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationbaseline",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationbaseline",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationfollowup",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationfollowup",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectrequisition",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectrequisition",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectvisit",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectvisit",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectvisitmissed",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectvisitmissed",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicaltbdiagnostics",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicaltbdiagnostics",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalurinalysis",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalurinalysis",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalvitalsigns",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalvitalsigns",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="lpcsf",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="lpcsf",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="medicationadherence",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="medicationadherence",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="mentalstatus",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="mentalstatus",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="participanthistory",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="participanthistory",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="participanttreatment",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="participanttreatment",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="subjectrequisition",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="subjectrequisition",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="subjectvisit",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="subjectvisit",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="subjectvisitmissed",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="subjectvisitmissed",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="tbdiagnostics",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="tbdiagnostics",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="urinalysis",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="urinalysis",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="vitalsigns",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="vitalsigns",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="bloodresultschem",
            name="ast_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=0,
                max_digits=8,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(9999),
                ],
                verbose_name="AST",
            ),
        ),
        migrations.AlterField(
            model_name="bloodresultschem",
            name="ggt_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=0,
                max_digits=8,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(9999),
                ],
                verbose_name="GGT",
            ),
        ),
        migrations.AlterField(
            model_name="bloodresultsfbc",
            name="platelets_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=0,
                max_digits=8,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(9999),
                ],
                verbose_name="Platelets",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbloodresultschem",
            name="ast_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=0,
                max_digits=8,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(9999),
                ],
                verbose_name="AST",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbloodresultschem",
            name="ggt_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=0,
                max_digits=8,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(9999),
                ],
                verbose_name="GGT",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbloodresultsfbc",
            name="platelets_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=0,
                max_digits=8,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(9999),
                ],
                verbose_name="Platelets",
            ),
        ),
        migrations.AddIndex(
            model_name="adherence",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_10789b_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="arvhistory",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_999c5b_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="arvtreatment",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_78cce1_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="bloodculture",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_ada209_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="bloodresultschem",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_974ddb_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="bloodresultsfbc",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_6f75a7_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="chestxray",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_bbb1bd_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="clinicalnote",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_99029c_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="diagnoses",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_0a7fe6_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="fluconmisseddoses",
            index=models.Index(
                fields=["modified", "created"], name="effect_subj_modifie_ca7396_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="fluconmisseddoses",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="effect_subj_user_mo_8292c6_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="flucytmisseddoses",
            index=models.Index(
                fields=["modified", "created"], name="effect_subj_modifie_eae407_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="flucytmisseddoses",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="effect_subj_user_mo_23f05d_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="healtheconomics",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_c3e77e_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="healtheconomicsevent",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_c58558_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="histopathology",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_80bc01_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="lpcsf",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_beebde_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="medicationadherence",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_25061c_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="mentalstatus",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_c4e729_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="participanthistory",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_4bd2c6_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="participanttreatment",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_f11473_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="signsandsymptoms",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_836a53_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="studymedication",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_6d9baa_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="subjectrequisition",
            index=models.Index(
                fields=["subject_identifier"], name="effect_subj_subject_44b629_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="subjectrequisition",
            index=models.Index(
                fields=["subject_visit", "site", "panel"],
                name="effect_subj_subject_157606_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="subjectrequisition",
            index=models.Index(
                fields=["subject_visit", "panel"], name="effect_subj_subject_5a76ce_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="subjectvisitmissed",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_e6e561_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="tbdiagnostics",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_51dd43_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="urinalysis",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_0c85f5_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="vitalsigns",
            index=models.Index(
                fields=["subject_visit", "site"], name="effect_subj_subject_321a8a_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="subjectrequisition",
            constraint=models.UniqueConstraint(
                fields=("panel", "subject_visit"),
                name="effect_subject_subjectrequisition_panel_uniq",
            ),
        ),
    ]
