# Generated by Django 5.1.3 on 2025-01-10 16:46

from django.db import migrations
from edc_constants.constants import NO, NOT_APPLICABLE
from edc_utils import get_utcnow, truncate_string
from simple_history.utils import update_change_reason
from tqdm import tqdm

from effect_subject.models import ArvHistory
from effect_subject.utils import get_max_field_len


def set_vl_quantifier_na_if_na(apps, schema_editor):
    # Prepare qs
    # model_cls = apps.get_model("effect_subject.arvhistory")
    model_cls = ArvHistory
    qs = model_cls.objects.filter(
        has_viral_load_result=NO,
        viral_load_result=None,
        retired_viral_load_result=None,
        viral_load_date=None,
        viral_load_date_estimated=NOT_APPLICABLE,
    )
    total = qs.count()

    # Prepare history
    user_modified = truncate_string(
        string=__name__,
        max_length=get_max_field_len(model_cls, "user_modified"),
    )
    change_reason = truncate_string(
        string=f"Set `viral_load_quantifier to `N/A`. See: {__name__}",
        max_length=get_max_field_len(model_cls.history.model, "history_change_reason"),
    )

    # Perform data migration
    print(
        f"\nSetting `viral_load_quantifier` to `N/A` for {total} Arv History "
        "instances without vl result ..."
    )
    for obj in tqdm(qs, total=total):
        obj.viral_load_quantifier = NOT_APPLICABLE
        obj.modified = get_utcnow()
        obj.user_modified = user_modified
        obj.save()
        update_change_reason(instance=obj, reason=change_reason)
        print(f"Set `viral_load_quantifier` for {obj} to `N/A`")
    print("Done migrating")


class Migration(migrations.Migration):
    """Note: Migrations effect_subject/migrations/0119-0123 are all
    related, and expected to be run together.  See also ticket #658.
    """

    dependencies = [
        ("effect_subject", "0121_migrate_arv_history_vl_result_to_integer"),
    ]

    operations = [
        migrations.RunPython(set_vl_quantifier_na_if_na),
    ]
