# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from fabric_cm.credmgr.swagger_server.models.base_model_ import Model
from fabric_cm.credmgr.swagger_server import util


class JwksKeys(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, kty: str=None, e: str=None, n: str=None, use: str=None, alg: str=None, kid: str=None):  # noqa: E501
        """JwksKeys - a model defined in Swagger

        :param kty: The kty of this JwksKeys.  # noqa: E501
        :type kty: str
        :param e: The e of this JwksKeys.  # noqa: E501
        :type e: str
        :param n: The n of this JwksKeys.  # noqa: E501
        :type n: str
        :param use: The use of this JwksKeys.  # noqa: E501
        :type use: str
        :param alg: The alg of this JwksKeys.  # noqa: E501
        :type alg: str
        :param kid: The kid of this JwksKeys.  # noqa: E501
        :type kid: str
        """
        self.swagger_types = {
            'kty': str,
            'e': str,
            'n': str,
            'use': str,
            'alg': str,
            'kid': str
        }

        self.attribute_map = {
            'kty': 'kty',
            'e': 'e',
            'n': 'n',
            'use': 'use',
            'alg': 'alg',
            'kid': 'kid'
        }
        self._kty = kty
        self._e = e
        self._n = n
        self._use = use
        self._alg = alg
        self._kid = kid

    @classmethod
    def from_dict(cls, dikt) -> 'JwksKeys':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The jwks_keys of this JwksKeys.  # noqa: E501
        :rtype: JwksKeys
        """
        return util.deserialize_model(dikt, cls)

    @property
    def kty(self) -> str:
        """Gets the kty of this JwksKeys.

        Key Type  # noqa: E501

        :return: The kty of this JwksKeys.
        :rtype: str
        """
        return self._kty

    @kty.setter
    def kty(self, kty: str):
        """Sets the kty of this JwksKeys.

        Key Type  # noqa: E501

        :param kty: The kty of this JwksKeys.
        :type kty: str
        """

        self._kty = kty

    @property
    def e(self) -> str:
        """Gets the e of this JwksKeys.

        Exponent Parameter  # noqa: E501

        :return: The e of this JwksKeys.
        :rtype: str
        """
        return self._e

    @e.setter
    def e(self, e: str):
        """Sets the e of this JwksKeys.

        Exponent Parameter  # noqa: E501

        :param e: The e of this JwksKeys.
        :type e: str
        """

        self._e = e

    @property
    def n(self) -> str:
        """Gets the n of this JwksKeys.

        Modulus Parameter  # noqa: E501

        :return: The n of this JwksKeys.
        :rtype: str
        """
        return self._n

    @n.setter
    def n(self, n: str):
        """Sets the n of this JwksKeys.

        Modulus Parameter  # noqa: E501

        :param n: The n of this JwksKeys.
        :type n: str
        """

        self._n = n

    @property
    def use(self) -> str:
        """Gets the use of this JwksKeys.

        Public Key Use Parameter  # noqa: E501

        :return: The use of this JwksKeys.
        :rtype: str
        """
        return self._use

    @use.setter
    def use(self, use: str):
        """Sets the use of this JwksKeys.

        Public Key Use Parameter  # noqa: E501

        :param use: The use of this JwksKeys.
        :type use: str
        """

        self._use = use

    @property
    def alg(self) -> str:
        """Gets the alg of this JwksKeys.

        Algorithm Parameter  # noqa: E501

        :return: The alg of this JwksKeys.
        :rtype: str
        """
        return self._alg

    @alg.setter
    def alg(self, alg: str):
        """Sets the alg of this JwksKeys.

        Algorithm Parameter  # noqa: E501

        :param alg: The alg of this JwksKeys.
        :type alg: str
        """

        self._alg = alg

    @property
    def kid(self) -> str:
        """Gets the kid of this JwksKeys.

        Key Id Header Parameter  # noqa: E501

        :return: The kid of this JwksKeys.
        :rtype: str
        """
        return self._kid

    @kid.setter
    def kid(self, kid: str):
        """Sets the kid of this JwksKeys.

        Key Id Header Parameter  # noqa: E501

        :param kid: The kid of this JwksKeys.
        :type kid: str
        """

        self._kid = kid
