# Generated by Django 5.0 on 2023-12-24 21:38

import uuid
from django.db import migrations, models


def gen_shared_uid(apps, schema_editor):
    ClubMemberGroup = apps.get_model("teamized", "ClubMemberGroup")
    for row in ClubMemberGroup.objects.all():
        row.shared_uid = uuid.uuid4()
        row.save(update_fields=["shared_uid"])


class Migration(migrations.Migration):
    dependencies = [
        (
            "teamized",
            "0005_user_max_owned_teams_override_alter_user_auth_user_and_more",
        ),
    ]

    operations = [
        migrations.AddField(
            model_name="clubmembergroup",
            name="shared_uid",
            field=models.UUIDField(default=uuid.uuid4, null=True),
        ),
        migrations.RunPython(gen_shared_uid, reverse_code=migrations.RunPython.noop),
        migrations.AlterField(
            model_name="clubmembergroup",
            name="shared_uid",
            field=models.UUIDField(default=uuid.uuid4, unique=True),
        ),
    ]
