# Generated by Django 5.2.4 on 2025-07-15 22:29

import django.db.models.deletion
import uuid
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("teamized", "0007_remove_clubmembermagiclink_logged_in_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="ClubAttendanceEvent",
            fields=[
                (
                    "uid",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        verbose_name="UID",
                    ),
                ),
                ("title", models.CharField(max_length=50, verbose_name="Titel")),
                ("description", models.TextField(blank=True, verbose_name="Beschreibung")),
                (
                    "participating_by_default",
                    models.BooleanField(
                        default=True,
                        help_text="Wenn gesetzt, sind zugewiesene Mitglieder standardmäßig für die Teilnahme eingetragen.",
                        verbose_name="Teilnahme standardmäßig",
                    ),
                ),
                ("dt_start", models.DateTimeField(verbose_name="Beginn")),
                ("dt_end", models.DateTimeField(verbose_name="Ende")),
                (
                    "points",
                    models.PositiveIntegerField(
                        default=1,
                        help_text="Punkte, die für die Teilnahme vergeben werden.",
                        verbose_name="Punkte",
                    ),
                ),
                (
                    "locked",
                    models.BooleanField(
                        default=False,
                        help_text="Wenn gesetzt, können Teilnahmen nicht mehr geändert werden.",
                        verbose_name="Gesperrt?",
                    ),
                ),
                (
                    "date_created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Erstellt am"),
                ),
                (
                    "date_modified",
                    models.DateTimeField(auto_now=True, verbose_name="Zuletzt geändert am"),
                ),
                (
                    "club",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attendance_events",
                        to="teamized.club",
                        verbose_name="Verein",
                    ),
                ),
            ],
            options={
                "verbose_name": "Anwesenheitsereignis",
                "verbose_name_plural": "Anwesenheitsereignisse",
            },
        ),
        migrations.CreateModel(
            name="ClubAttendanceEventParticipation",
            fields=[
                (
                    "uid",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        verbose_name="UID",
                    ),
                ),
                (
                    "member_response",
                    models.CharField(
                        choices=[
                            ("yes", "Ja"),
                            ("no", "Nein"),
                            ("maybe", "Vielleicht"),
                            ("unknown", "Unbekannt"),
                        ],
                        default="unknown",
                        max_length=10,
                        verbose_name="Antwort des Mitglieds",
                    ),
                ),
                (
                    "member_notes",
                    models.TextField(
                        blank=True, default="", verbose_name="Grund der An-/Abmeldung"
                    ),
                ),
                (
                    "has_attended",
                    models.BooleanField(
                        default=None, null=True, verbose_name="Am Event teilgenommen?"
                    ),
                ),
                (
                    "admin_notes",
                    models.TextField(blank=True, default="", verbose_name="Admin-Notizen"),
                ),
                (
                    "date_created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Erstellt am"),
                ),
                (
                    "date_modified",
                    models.DateTimeField(auto_now=True, verbose_name="Zuletzt geändert am"),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="participations",
                        to="teamized.clubattendanceevent",
                        verbose_name="Anwesenheitsereignis",
                    ),
                ),
                (
                    "member",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attendance_event_participations",
                        to="teamized.clubmember",
                        verbose_name="Mitglied",
                    ),
                ),
            ],
            options={
                "verbose_name": "Anwesenheitsteilnahme",
                "verbose_name_plural": "Anwesenheitsteilnahmen",
                "unique_together": {("event", "member")},
            },
        ),
    ]
