TOPICS_REAL = [
    "Socotra Island's dragon blood trees",
    "Movile Cave's isolated ecosystem (Romania)",
    "Danakil Depression's acid pools (Ethiopia)",
    "Waitomo Glowworm Caves (New Zealand)",
    "Lençóis Maranhenses sand dunes (Brazil)",
    "Chocolate Hills formation (Philippines)",
    "Spotted Lake mineral deposits (Canada)",
    "Fly Geyser microbial colors (Nevada)",
    "Tianzi Mountain sandstone pillars (China)",
    "Giant's Causeway basalt columns (Ireland)",
    "Mantis shrimp's polarized vision",
    "Lyrebird vocal mimicry mechanisms",
    "Tardigrade cryptobiosis process",
    "Archerfish water-shooting accuracy",
    "Pistol shrimp shockwave hunting",
    "Bombardier beetle chemical defense",
    "Axolotl limb regeneration",
    "Narwhal tusk sensory capabilities",
    "Platypus electroreception",
    "Neutron star glitches",
    "Solar prominence dynamics",
    "Enceladus' cryovolcanic plumes",
    "Pāhoehoe lava formations",
    "Magnetar magnetic field strength",
    "Cosmic neutrino background",
    "Quantum foam fluctuations",
    "Spaghettification near black holes",
    "Solar sail navigation",
    "Dark matter halo structures",
    "Antikythera Mechanism functions",
    "Nazca Lines construction methods",
    "Moai transportation (Easter Island)",
    "Baghdad Battery controversy",
    "Roman concrete seawater hardening",
    "Viking sunstone navigation",
    "Saqqara Bird aerodynamics",
    "Göbekli Tepe carvings",
    "Voynich Manuscript analysis",
    "Olmec colossal heads",
    "Tensegrity bridge designs",
    "Aerogel insulation properties",
    "MEMS gyroscope manufacturing",
    "Hydrophobic surface engineering",
    "Metamaterial cloaking principles",
    "4D printing shape memory",
    "Piezoelectric shoe charging",
    "Self-healing concrete bacteria",
    "Quantum dot solar cells",
    "Starlink satellite avoidance",
    "Ainu bear ceremonies (Japan)",
    "Whistled language of La Gomera",
    "Mongolian throat singing",
    "Venetian glass bead making",
    "Sami reindeer herding",
    "Bhutanese archery traditions",
    "Navajo sandpainting",
    "Balinese water temples",
    "Maasai warrior jumps",
    "Korean hanji paper",
    "Cloud forests epiphyte networks",
    "Cenote freshwater layers (Mexico)",
    "Sargasso Sea floating ecosystem",
    "Hydrothermal vent communities",
    "Pantanal wetland seasons (Brazil)",
    "Peat bog preservation",
    "Atacama Desert lichens",
    "Waitoreke wetlands (New Zealand)",
    "Bioluminescent dinoflagellates",
    "Fire rainbow formation",
    "Halobacterium salt metabolism",
    "Gallium liquid properties",
    "Supercooled water stability",
    "Nitinol shape memory",
    "Chlorine trifluoride reactivity",
    "Ferrofluid manipulation",
    "Supercritical CO2 extraction",
    "Synesthesia neural pathways",
    "Blood-brain barrier",
    "Gut microbiome diversity",
    "Rapid eye movement sleep",
    "Hiccups evolutionary purpose",
    "Goosebumps mechanism",
    "Phantom limb sensations",
    "Taste bud regeneration",
    "Hypoxic training",
    "Blushing physiology",
    "Graphene conductivity",
    "Metallic glass formation",
    "Self-cleaning surfaces",
    "Carbon nanotube strength",
    "Ferrocrete durability",
    "Transparent aluminum",
    "Memory metal alloys",
    "Conductive polymers",
    "Glass frog transparency",
    "Mangrove salt filtration",
    "Sundarbans tiger adaptation",
    "Baobab water storage",
    "Carnivorous plant traps",
    "Electric eel discharge",
    "Leafcutter ant farming",
    "Spider web engineering",
    "Fire tornado dynamics",
    "Light pillars formation",
    "Morning glory clouds",
    "Volcanic lightning",
    "Snow roller formation",
    "Frost flowers growth",
    "Catatumbo lightning",
    "Sun dog phenomena",
    "Fire rainbow optics",
    "Virga precipitation",
    "Roman hypocaust heating",
    "Chinese seismograph",
    "Inca quipu records",
    "Persian qanat systems",
    "Egyptian faience",
    "Mayan astronomy",
    "Polynesian navigation",
    "Aboriginal firestick",
    "Memory palace technique",
    "Mnemonic major system",
    "Method acting",
    "Shadow puppetry",
    "Sand mandalas",
    "Kintsugi repair",
    "Wabi-sabi",
    "Ikebana principles",
    "Tea ceremony",
    "Origami mathematics",
    "Coral spawning events",
    "Jellyfish locomotion",
    "Cephalopod camouflage",
    "Spider silk production",
    "Ant colony algorithms",
    "Bee waggle dance",
    "Bat echolocation",
    "Elephant infrasound",
    "Whale fall ecosystems",
    "Quantum entanglement",
    "Superfluid helium",
    "Bose-Einstein condensate",
    "Quantum tunneling",
    "Casimir effect",
    "Sonoluminescence",
    "Triboluminescence",
    "Plasma crystals",
    "Optical tweezers",
    "CRISPR gene editing",
    "mRNA vaccine tech",
    "CAR-T cell therapy",
    "Synthetic biology",
    "Optogenetics",
    "Brain organoids",
    "Lab-grown meat",
    "Vertical farming",
    "Phytoremediation",
    "Mycoremediation",
    "Blockchain immutability",
    "Neural networks",
    "GAN image creation",
    "Quantum computing",
    "LiDAR mapping",
    "Hyperspectral imaging",
    "Synthetic aperture radar",
    "Photogrammetry",
    "Lidar archaeology",
    "Sonar mapping",
    "Perovskite solar",
    "Fusion reactor designs",
    "Tidal lagoon power",
    "Geothermal plants",
    "Piezoelectric roads",
    "Algae biofuels",
    "Hydrogen storage",
    "Carbon capture",
    "Wave energy",
    "Artificial photosynthesis",
    "Quokka smiling behavior (Australia)",
    "Pangolin scale composition",
    "Okapi stripe patterns",
    "Saiga antelope nasal structure",
    "Maned wolf communication",
    "Proboscis monkey nose function",
    "Aye-aye foraging techniques",
    "Sunda flying lemur gliding",
    "Thorny devil water collection",
    "Star-nosed mole sensory organs",
    "Mimic octopus impersonation",
    "Peacock spider mating dance",
    "Decorator crab camouflage",
    "Vampire squid bioluminescence",
    "Hagfish slime defense",
    "Nudibranch chemical warfare",
    "Sea butterfly swimming",
    "Velvet worm slime jets",
    "Water bear desiccation",
    "Trap-jaw ant mandibles",
    # Space & Astronomy
    "Neutron star mergers creating heavy elements",
    "Oumuamua interstellar object trajectory",
    "Kuiper Belt object composition",
    "Solar prominence magnetic dynamics",
    "Exoplanet atmospheric spectroscopy",
    "Dark energy's effect on universe expansion",
    "Pulsar navigation systems",
    "Space elevator material requirements",
    "Lunar lava tube habitats",
    "Mars regolith farming challenges",
    # Technology & Engineering
    "Metamaterial acoustic cloaking",
    "Self-healing asphalt microbial integration",
    "4D printed shape-memory polymers",
    "Neuromorphic computing chips",
    "Wireless power transmission efficiency",
    "Biohybrid robot muscle actuation",
    "Quantum radar principles",
    "Haptic feedback virtual reality gloves",
    "Transparent solar window tech",
    "Aerodynamic hyperloop pod designs",

    # Unique Biology
    "Axolotl limb regeneration genetics",
    "Tardigrade radiation resistance proteins",
    "Venus flytrap action potential mechanisms",
    "Platypus electroreception biology",
    "Naked mole-rat cancer immunity",
    "Lyrebird vocal mimicry neurology",
    "Chameleon color change nanostructures",
    "Electric eel voltage generation",
    "Ant mill death spiral behavior",
    "Slime mold problem-solving patterns",

    # Ancient History
    "Roman concrete seawater crystallization",
    "Inca quipu accounting system",
    "Viking sunstone navigation",
    "Egyptian faience production",
    "Chinese seismograph design",
    "Persian qanat irrigation",
    "Mayan astronomical codices",
    "Polynesian star navigation",
    "Native American controlled burns",
    "Indus Valley urban planning",

    # Art & Culture
    "Japanese kintsugi philosophy",
    "Aboriginal dot painting symbology",
    "Flamenco compás rhythmic patterns",
    "Balinese gamelan metallurgy",
    "Korean hanji papermaking",
    "Indian kolam rice art",
    "Celtic knotwork mathematics",
    "Sufi whirling meditation",
    "Hawaiian hula chant meaning",
    "Russian icon painting techniques",

    # Physics Phenomena
    "Superfluid helium quantum effects",
    "Magnetohydrodynamic wave propulsion",
    "Sonoluminescence bubble collapse",
    "Quantum locking in superconductors",
    "Ferrofluid spike formation",
    "Plasma filament formation",
    "Optical tweezers manipulation",
    "Casimir effect vacuum energy",
    "Ball lightning theories",
    "Non-Newtonian fluid behavior",

    # Geology & Earth Science
    "Antelope Canyon erosion patterns",
    "Danakil Depression extremophiles",
    "Bioluminescent cave ecosystems",
    "Penitente snow formations",
    "Lava lake convection currents",
    "Sailing stone movement",
    "Mineral fluorescence causes",
    "Petrified wood formation",
    "Desert varnish creation",
    "Thunder egg geode growth",

    # Medical Marvels
    "CRISPR gene editing accuracy",
    "mRNA vaccine development",
    "Prosthetic neural integration",
    "Organoid intelligence development",
    "Synthetic antibody production",
    "Telomere extension therapies",
    "Nanobot drug delivery",
    "Bionic eye resolution",
    "Phantom limb mapping",
    "Stem cell differentiation",

    # Plant Kingdom
    "Corpse flower pollination",
    "Strangler fig growth patterns",
    "Dragon's blood tree sap",
    "Bamboo flowering cycles",
    "Carnivorous pitcher plant",
    "Welwitschia leaf longevity",
    "Baobab water storage",
    "Resurrection plant revival",
    "Mimosa pudica movement",
    "Ghost plant chlorophyll",

    # Materials Science
    "Graphene conductivity",
    "Aerogel insulation",
    "Self-cleaning surfaces",
    "Memory metal alloys",
    "Transparent aluminum",
    "Hydrogel wound healing",
    "Carbon nanotube strength",
    "Bioactive glass regeneration",
    "Phase-change materials",
    "Photochromic lenses",

    # Animal Behavior
    "Bee waggle dance",
    "Octopus camouflage",
    "Wolf pack hierarchy",
    "Elephant infrasound",
    "Dolphin signature whistles",
    "Bird magnetic sensing",
    "Primate tool use",
    "Spider web engineering",
    "Firefly synchronization",
    "Penguin huddling",

    # Chemistry Wonders
    "Supercritical CO₂ extraction",
    "Triboluminescent sparks",
    "Liquid crystal phases",
    "Metallic hydrogen creation",
    "Photocatalytic water splitting",
    "Enzyme catalytic power",
    "Polymorph crystal forms",
    "Self-assembling molecules",
    "Stoichiometric ratios",
    "Catalytic converter",

    # Food Science
    "Maillard reaction",
    "Sourdough microbiome",
    "Chocolate tempering",
    "Umami taste receptors",
    "Molecular gastronomy",
    "Aged cheese crystallization",
    "Coffee roasting profiles",
    "Fermentation cultures",
    "Food dehydration",
    "Spice preservation",

    # Weather Phenomena
    "Morning glory clouds",
    "Derecho storm systems",
    "Diamond dust formation",
    "Fire whirl creation",
    "Virga precipitation",
    "Sundog refraction",
    "Haboob dust walls",
    "Mammatus cloud",
    "Heat lightning",
    "Thundersnow",

    # Ancient Engineering
    "Egyptian pyramid alignment",
    "Roman aqueduct gradients",
    "Chinese earthquake detector",
    "Incan suspension bridges",
    "Persian windcatchers",
    "Mayan water filtration",
    "Greek fire composition",
    "Indian stepwells",
    "Native American earthworks",
    "Viking shipbuilding",

    # Forensic Science
    "Entomological timelines",
    "DNA phenotyping",
    "Gunshot residue",
    "Blood spatter",
    "Fingerprint lifting",
    "Toxicology screening",
    "Document authentication",
    "Facial reconstruction",
    "Soil analysis",
    "Tool mark",

    # Energy Tech
    "Fusion plasma",
    "Tidal generators",
    "Geothermal plants",
    "Biofuel algae",
    "Piezoelectric roads",
    "Hydrogen storage",
    "Thorium reactors",
    "Solar paint",
    "Wave energy",
    "Gravity storage",

    # Neuroscience
    "Neuroplasticity",
    "Mirror neurons",
    "Brain mapping",
    "Memory consolidation",
    "Synaptic pruning",
    "Pain perception",
    "Consciousness theories",
    "Sleep cycles",
    "Déjà vu",
    "Phantom smells",

    # Paleontology
    "Feathered dinosaurs",
    "Amber preservation",
    "Trace fossils",
    "Mass extinction",
    "DNA recovery",
    "Coprolite analysis",
    "Evolutionary missing links",
    "Cambrian explosion",
    "Fossil dating",
    "Paleoclimate",

    # Architecture
    "Biomimetic design",
    "Earthquake retrofitting",
    "Green roofs",
    "Tensegrity structures",
    "Passive heating",
    "Acoustic engineering",
    "3D-printed buildings",
    "Feng shui principles",
    "Gothic vaulting",
    "Bamboo construction"
]


def system_real(num_examples: int):
    return f"""
    You are a Memory Reinforcement Learning dataset generator for a Reactive Transformer model.
    Output must be a Python list of tuples containing initial query-answer pairs and list of follow-up interactions, without any code, explanation, or metadata.
    You are used to generate list of exactly {num_examples} tuples with three elements: question, answer and list of follow-up interactions, based on real world knowledge in form of simple stories
    """

def task_description_real(follow_ups_format: str, steps: int, num_examples: int, prior_steps: int, mode: str = 'multi'):
    return f"""
    # Memory Reinforcement Learning Data Generation - {steps} Step(s)
    
    ## TASK DESCRIPTION
    Generate {num_examples} examples of interconnected interactions testing multi-step memory retention. They will be
    used to train reactive models, that works in real-time processing mode - processing only the single messages (interactions),
    and keeps conversation history in short-term memory.
    
    Each example must:
    
    1. Start with initial factual QA (geography/science/history) - query and answer
    2. Contain {steps} follow-up QAs progressively referencing prior answers - list of queries and answers
    3. Each answer introduces 3-4 new facts while repeating 3+ previous facts
    4. Final interaction requires synthesizing info from {prior_steps}+ prior steps
    ## FORMAT REQUIREMENTS
    ```python
    [
        (
            ("[Initial Question]", "[Initial Answer]"),
            {follow_ups_format}
        ),
        # {num_examples} total entries
    ]
    ```
    """ if mode == 'multi' else f"""
    # Memory Reinforcement Learning Data Generation - {steps} Step(s) - Long-Range Strategy
    
    ## TASK DESCRIPTION
    Generate {num_examples} examples of interconnected interactions testing long-range and multi-step memory retention. They
    will be used to train reactive models, that works in real-time processing mode - processing only the single messages (interactions),
    and keeps conversation history in short-term memory.
    
    In Long-Range strategy each generated example should contain two completely different message **topics**:
    - first topic is used only in first and last interaction
    - second topic is used in all interactions between first and last
    
    Each example must:
    
    1. Start with initial factual QA (geography/science/history/others) - query and answer - for the first **topic**
    2. Contain {steps} follow-up QAs list of queries and answers
    3. First query in follow-up QAs (interactions) is changing **topic** into second one - not connected to first QA, and answer is also for new **topic**
    4. All next follow-up interactions, except the last one, have to continue the second **topic**:
        - Each answer introduces 3-4 new facts while repeating 3+ previous facts
    4. Final, last interaction is going back to first **topic** - asking a question about data from first QA pair (interaction) and the answer is containing most facts from first interaction
    ## FORMAT REQUIREMENTS
    ```python
    [
        (
            ("[Initial Question: **topic one**]", "[Initial Answer: **topic one**]"),
            {follow_ups_format}
        ),
        # {num_examples} total entries
    ]
    ```
    """

def critical_rules_real(steps: int, prior_steps: int, num_tokens: int, mode: str = 'multi', example_multiplier: int = 4):
    if mode == 'multi':
        return f"""
    ## CRITICAL RULES
    1. Factual Consistency:
      - All geographical/scientific facts must be accurate
      - No fictional elements - only real-world entities
      - Real-world knowledge, but only a basic facts like in examples
      - Simple facts from real-world information
    2. Language:
      - Model is pre-trained on wikipedia - it should be compatible
      - While dataset includes real world facts, they should be served in dialogue format
    3. Referential Integrity:
      - Each follow-up references 3+ facts from previous answers
      - Final answer must combine facts from {prior_steps} previous steps
    4. Progressive Retention:
      - Each answer is on the same topic
      - Knowledge is accumulated in answers
      - Queries reference previous answers
    5. Do not repeat examples
      - each item should be unique - do not use the same examples as provided
      - please do not generate same examples as in FEW SHOTS items should be new
      - don't generate examples in same topics as in FEW SHOT EXAMPLES, like Mount Everest, Nile description, Amazon forest, Grand Canyon, Coral Reef, Sequoia Trees or Great Wall
      - be creative for topics
      - try a lot different topics
    6. Interaction length
      - each interaction - query + answer - should have about {num_tokens} tokens length
      - length should about {example_multiplier}x longer than in examples
    """
    else:
        return f"""
    ## CRITICAL RULES
    1. Factual Consistency:
      - All geographical/scientific facts must be accurate
      - No fictional elements - only real-world entities
      - Real-world knowledge, but only a basic facts like in examples
      - Simple facts  from real-world information
    2. Language:
      - Model is pre-trained on wikipedia - it should be compatible
      - While dataset includes real world facts, they should be served in dialogue format
    3. Referential Integrity:
      - Each middle follow-up for **topic two** references 3+ facts from previous answers and trying to combine facts from {prior_steps} previous steps (except first step)
      - Final answer must change back to **topic one** and reference 3+ facts from initial QA pair/interaction
    4. Progressive Retention:
      - Each answer from the middle of sequence (except initial and last follow-up) is on the same topic (**topic two**)
      - Knowledge is accumulated in answers
      - Queries reference previous answers of the same **topic**
    5. Do not repeat examples
      - each item should be unique - do not use the same examples as provided
      - please do not generate same examples as in FEW SHOTS items should be new
      - don't generate examples in same topics as in FEW SHOT EXAMPLES, like Mount Everest, Nile description, Amazon forest, Grand Canyon, Coral Reef, Sequoia Trees or Great Wall
      - be creative for topics
      - try a lot different topics
    7. Interaction length
      - each interaction - query + answer - should have about {num_tokens} tokens length
      - length should about {example_multiplier}x longer than in examples
    8. **CRUCIAL/CRITICAL** !! - Long-Range Strategy
      - first, initial QA pair is connected to **topic one**
      - ensure that there is exactly {steps} follow-up QAs/interactions with two different **topics**
      - first {steps - 1} follow-ups are all exploring **topic two**
      - ensure that exactly the last, {steps} QA pair (interaction) is going back to **topic one**
      - ensure that the last {steps} interaction is not connected to **topic two**
    """

def final_instructions_real(steps: int, num_examples: int, mode: str = 'multi'):
    instructions = f"""
    ## GENERATION INSTRUCTIONS
    1. Start each sequence with geographical/scientific fact
    2. Design {steps} follow-ups requiring cumulative understanding
    3. Ensure final answer combines numerical, temporal, and spatial data
    4. Validate all  factual accuracy
    ## OUTPUT VALIDATION
    - No placeholder text ("...")
    - All facts consistent
    - {steps} follow-ups per entry
    - Final answer combines 3+ prior facts
    - Output only the final list - without wrapping it with '```python' and '```'
    - Output is a single list of tuples in same format as examples
    - Output contains {num_examples} elements with the same format as examples
    - Do not generate separate list for each example, only single list of tuples
    - Each tuple should end with closing `)` and each list should end with closing `]`
    
    Generate {num_examples} entries following EXACTLY this structure.
    """ if mode == 'multi' else f"""
    ## GENERATION INSTRUCTIONS
    1. Start each sequence with geographical/scientific fact with **topic one**
    2. Design {steps - 1} follow-ups requiring cumulative understanding for **topic two**
    3. Ensure final query is switching back to **topic one** and final answer is including data from initial QA pair
    4. Validate all factual accuracy
    5. All follow-ups should have {steps} elements: {steps - 1} for **topic two** and last 1 for switching back to **topic one**
    ## OUTPUT VALIDATION
    - No placeholder text ("...")
    - All facts consistent
    - exactly {steps} follow-ups per entry: {steps - 1} for **topic two** and last 1 for **topic one**
    - Final answer combines 3-4+ facts from first initial interaction
    - Output only the final list - without wrapping it with '```python' and '```'
    - Output is a single list of tuples in same format as examples
    - Output contains {num_examples} elements with the same format as examples
    - Do not generate separate list for each example, only single list of tuples
    - Each tuple should end with closing `)` and each list should end with closing `]`
    - Ensure, that after {steps - 1} follow-up QAs (interactions) for **topic two**, there's also final {steps} (last) query and answer for **topic one**
    
    Generate {num_examples} entries following EXACTLY this structure.
    """

    return instructions

ALL_PROMPTS_REAL = (system_real, task_description_real, critical_rules_real, final_instructions_real)

TOPICS_STORIES = [
    "The little frog who wanted to sing", "A magic cloud that rains candy", "The shy star who hid during the day",
    "Bella the bear's berry hunt", "The talking teapot in granny's kitchen", "Sammy squirrel's lost acorn",
    "The tiny turtle's big race", "A moon that smiled at bedtime", "The day flowers started dancing",
    "Pip the mouse's cheese adventure", "The rainbow bridge to cloud land", "Lily ladybug's polka dot party",
    "The friendly ghost in the attic", "Bubbles that wouldn't pop", "The carrot that grew too big",
    "Oscar owl's night school", "A seashell that whispered secrets", "The banana that went for a walk",
    "Fuzzy caterpillar's coat change", "The sock that escaped laundry day", "Daisy duck's double rainbow",
    "The pencil that drew by itself", "A snowflake that didn't melt", "Timmy turtle's upside-down day",
    "The giggling gingerbread man", "Wally worm's tunnel map", "The moon cheese picnic",
    "Buttons that came alive at night", "Sally snail's speedy dream", "The talking tree in the park",
    "Buzzy bee's honey hunt", "A book that changed its story", "The shy shadow who made friends",
    "Polly penguin's ice slide", "The runaway cookie jar", "Stars that played hide-and-seek",
    "Floppy bunny's magic ears", "A raindrop's journey home", "The ticklish teddy bear",
    "Misty mountain's morning song", "The sock puppet circus", "Coco chick's first peck",
    "The sleepy sundial", "Bubbles that carried wishes", "Pebble the rock's rolling adventure",
    "The friendly scarecrow dance", "Dewdrop's diamond necklace", "The hat that changed colors",
    "Silly sunflower's face contest", "The whispering willow tree", "Nutsy squirrel's treasure map",
    "The cloud shaped like a sheep", "Dizzy dragonfly's loop-de-loops", "The friendly neighborhood spider",
    "Mud puddle jumping contest", "The spoon that ran away", "Twilight firefly light show",
    "The leaf that wouldn't fall", "Snappy crab's sideways walk", "The marshmallow pillow fort",
    "Dandelion's flying seeds", "The hiccuping hedgehog", "Moonbeam's midnight picnic",
    "The giggle berries in the forest", "Sandy seashell's ocean song", "The shy mushroom in the rain",
    "Bouncy rabbit's cloud jump", "The forgetful garden gnome", "Sparkly fish's underwater disco",
    "The sleepy valley's yawn", "Peppermint stick's candy cane lane", "The lonely lightning bug",
    "Puddle's reflection friends", "The hiccuping teakettle", "Fuzzy slippers' midnight dance",
    "The rainbow fish scales", "Dewy spiderweb necklace", "The sneezing volcano",
    "Cookie's chocolate chip freckles", "The cloud pillow fight", "Squeaky mouse's cheese moon",
    "The whispering book pages", "Giggling creek's ticklish stones", "The shy cactus bloom",
    "Bubbly brook's pebble song", "The runaway rolling pin", "Starlight's bedtime lullaby",
    "The friendly dust bunny", "Mossy rock's soft blanket", "The dancing dish towels",
    "Sniffles the rabbit's cold day", "The giggling garden hose", "Moonpie's crumbly adventure",
    "The sleepy sunflower seed", "Pebble's skipping stone dream", "The hiccuping jack-in-the-box",
    "Fuzzy blanket fort adventure", "The whispering wind chimes", "Soggy waffle's syrup river",
    "The cloud that wore pajamas", "Twinkle the star's sparkle shine", "The runaway alarm clock",
    "Cinnamon stick's spicy day", "The sneezing pepper shaker", "Gummy bear's bouncy walk",
    "The shy toadstool umbrella", "Dandelion fluff's flying school", "The hiccuping watering can",
    "Marshmallow's campfire song", "The sleepy valley's dreams", "Puddle jumper's rainy day",
    "The giggling cookie jar", "Starry night's lullaby hum", "The runaway ice cube",
    "Snuggly sock's missing pair", "The whispering wheat field", "Bouncy ball's escape plan",
    "The cloud that lost its fluff", "Dewdrop's morning mirror", "The sneezing feather pillow",
    "Cookie dough's raw adventure", "The hiccuping rubber duck", "Fuzzy peach's summer fuzz",
    "The sleepy caterpillar's nap", "Rainbow's color mixing day", "The runaway jellybean",
    "Squeaky floorboard mystery", "The whispering library books", "Giggling soda bubbles",
    "The shy clam in the sand", "Moonbeam's silver path", "The runaway tea bag",
    "Pebble beach's rock concert", "The cloud that rained glitter", "Dandelion's wish parade",
    "The hiccuping accordion", "Sniffles the bear's honey hunt", "The friendly dust mite",
    "Bubbles' floating kingdom", "The sneezing pepper mill", "Gummy worm's garden tour",
    "The shy icicle's drip", "Starlight's wish collection", "The runaway meatball",
    "Soggy cereal's milk lake", "The whispering cave echoes", "Twinkle toes' ballet class",
    "The cloud that ate sunshine", "Dewy grass's ticklish feet", "The hiccuping kazoo",
    "Marshmallow's squishy day", "The sleepy hollow log", "Raindrop's window art",
    "The runaway eraser", "Fuzzy slipper's adventure", "The giggling popcorn",
    "Moonpie's crumb trail", "The shy ladybug spots", "Bubbly soda's fizz race",
    "The sneezing flower pollen", "Cinnamon roll's curly day", "The runaway noodle",
    "Squeaky gate's rusty song", "The whispering forest path", "Gummy bear's sticky hug",
    "The cloud that wore sunglasses", "Dandelion's parachute jump", "The hiccuping balloon",
    "Snuggly quilt's patchwork", "The shy snail's trail", "Starry night's wink",
    "The runaway grape", "Pebble's skipping contest", "The giggling rubber band",
    "Moonbeam's silver slide", "The sleepy valley's fog", "Rainbow's color swap",
    "The whispering seashell", "Bubbly bath's foam mountain", "The sneezing feather duster",
    "Cookie's crumb pathway", "The hiccuping whoopee cushion", "Fuzzy blanket's warm hug",
    "The runaway button", "Dewy morning's sparkle", "The shy firefly flash",
    "Starlight's nightlight glow", "The cloud that dreamed of sheep", "Giggling jelly's wobble",
    "The hiccuping straw", "Sniffles the mouse's cheese quest", "The friendly lint roller",
    "Bubbles' iridescent shine", "The sneezing cinnamon", "Gummy shark's fruit snack",
    "The shy blossom bud", "Moonpie's cream filling", "The runaway raisin",
    "Soggy toast's butter pond", "The whispering waterfall", "Twinkle toes' tap dance",
    "The cloud that wore a hat", "Dandelion fluff's flight plan", "The hiccuping harmonica",
    "Marshmallow's toasty day", "The sleepy rock's nap", "Raindrop's puddle art",
    "The runaway paperclip", "Fuzzy caterpillar's coat", "The giggling soda can",
    "Starry night's constellation", "The shy tadpole change", "Bubbly stream's babble",
    "The sneezing pepper", "Cinnamon swirl's bakery", "The runaway pea",
    "Squeaky swing's song", "The whispering canyon", "Gummy bear's jungle gym",
    "The cloud that cried raindrops", "Dewy web's morning jewels", "The hiccuping kazoo",
    "Snuggly pillow fort", "The shy fern uncurl", "Moonbeam's silver path",
    "The runaway blueberry", "Pebble beach's stone art", "The giggling pasta pot",
    "Rainbow's arch bridge", "The sleepy willow weep", "The whispering reed",
    "Bubbly brook's journey", "The sneezing flour sack", "Cookie dough's chocolate chunk",
    "The hiccuping balloon animal", "Fuzzy slipper's journey", "The runaway corn kernel",
    "Dewy grass's sparkle", "The shy moth dance", "Starlight's shooting streak",
    "The cloud that wore mittens", "Dandelion's wish flight", "The hiccuping whoopie cushion",
    "Marshmallow's campfire roast", "The sleepy mushroom cap", "Raindrop's window trail",
    "The runaway dice", "Fuzzy blanket's dream", "The giggling soda bottle",
    "Moonpie's lunar crumbs", "The shy bud bloom", "Bubbly lemonade's fizz",
    "The sneezing powder", "Cinnamon stick's stir", "The runaway green bean",
    "Squeaky door's creak", "The whispering dune", "Gummy worm's dirt tunnel",
    "The cloud that sneezed snow", "Dewdrop's sunrise prism", "The hiccuping party horn",
    "Snuggly teddy's hug", "The shy seed sprout", "Starry night's glitter",
    "The runaway cherry", "Pebble's ripple jump", "The giggling spaghetti",
    "Rainbow's color wheel", "The sleepy fern uncurl", "The whispering brook",
    "Bubbly creek's journey", "The sneezing salt shaker", "Cookie's chip eyes",
    "The hiccuping inflatable", "Fuzzy peach's fuzz", "The runaway popcorn kernel",
    "Dewy web's design", "The shy butterfly land", "Moonbeam's silver pool",
    "The cloud that wore boots", "Dandelion's parachute", "The hiccuping squeeze toy",
    "Marshmallow's squish", "The sleepy stone moss", "Raindrop's leaf slide",
    "The runaway bean", "Fuzzy sock's adventure", "The giggling root beer",
    "Starlight's twinkle", "The shy tadpole leg", "Bubbly soda's pop",
    "The sneezing sneeze", "Cinnamon bun's swirl", "The runaway blue pea",
    "Squeaky wheel's song", "The whispering glen", "Gummy bear's bounce",
    "The cloud that hiccuped rain", "Dewy petal's jewels", "The hiccuping duck call",
    "Snuggly quilt's warmth", "The shy seed pod", "Moonpie's eclipse bite",
    "The runaway cranberry", "Pebble's stone skip", "The giggling tea kettle",
    "Rainbow's promise", "The sleepy vine curl", "The whispering spring",
    "Bubbly fountain's dance", "The sneezing sugar", "Cookie's dough adventure",
    "The hiccuping bouncy castle", "Fuzzy blanket's nest", "The runaway almond",
    "Dewy dawn's glow", "The shy moth flutter", "Starlight's guide",
    "The cloud that wore a scarf", "Dandelion's clock", "The hiccuping rubber ball",
    "Marshmallow's fluff", "The sleepy lichen", "Raindrop's symphony",
    "The runaway cashew", "Fuzzy slipper's quest", "The giggling cola",
    "Moonbeam's reflection", "The shy bulb grow", "Bubbly spring's source",
    "The sneezing spice", "Cinnamon heart's beat", "The runaway lentil",
    "Squeaky hinge's story", "The whispering field", "Gummy shark's swim",
    "The cloud that laughed thunder", "Dewdrop's perfect round", "The hiccuping party favor",
    "Snuggly robe's comfort", "The shy tendril reach", "Starry night's map",
    "The runaway date", "Pebble's river ride", "The giggling percolator",
    "Rainbow's treasure", "The sleepy moss patch", "The whispering creek",
    "Bubbly geyser's surprise", "The sneezing cocoa", "Cookie's fortune paper",
    "The hiccuping beach ball", "Fuzzy sweater's lint", "The runaway pistachio",
    "Dewy morning's kiss", "The shy cocoon wiggle", "Moonbeam's guide",
    "The cloud that wore galoshes", "Dandelion's time", "The hiccuping squeak toy",
    "Marshmallow's cloud dream", "The sleepy stone river", "Raindrop's drum song",
    "The runaway fig", "Fuzzy dice's roll", "The giggling soda fountain",
    "Starlight's path", "The shy vine grip", "Bubbly stream's chuckle",
    "The sneezing cupcake", "Cinnamon tea's steam", "The runaway walnut",
    "Squeaky toy's adventure", "The whispering meadow", "Gummy octopus's arms",
    "The cloud that sang raindrops", "Dewdrop's journey", "The hiccuping flipper",
    "Snuggly cushion's support", "The shy bulb peek", "Moonpie's crescent smile",
    "The runaway prune", "Pebble's avalanche", "The giggling pressure cooker",
    "Rainbow's arch", "The sleepy ivy climb", "The whispering grove",
    "Bubbly pond's plop", "The sneezing icing sugar", "Cookie's smart chip",
    "The hiccuping pool float", "Fuzzy jacket's pocket", "The runaway pecan",
    "Dewy spider's art", "The shy larva chew", "Starlight's promise",
    "The cloud that wore earmuffs", "Dandelion's hour", "The hiccuping dog toy",
    "Marshmallow's snow friend", "The sleepy boulder", "Raindrop's tap dance",
    "The runaway apricot", "Fuzzy keychain's journey", "The giggling espresso machine",
    "Moonbeam's silver thread", "The shy root search", "Bubbly lake's splash",
    "The sneezing birthday cake", "Cinnamon apple's pie", "The runaway chestnut",
    "Squeaky clean story", "The whispering orchard", "Gummy snake's slither",
    "The cloud that whispered wind", "Dewdrop's perfect sphere", "The hiccuping swim fin",
    "Snuggly onesie's warmth", "The shy seedling stretch", "Starry night's blanket",
    "The runaway olive", "Pebble's landslide", "The giggling juicer",
    "Rainbow's end", "The sleepy mossy log", "The whispering marsh",
    "Bubbly swamp's pop", "The sneezing doughnut", "Cookie's crumb trail",
    "The hiccuping water wing", "Fuzzy earmuff's silence", "The runaway peanut",
    "Dewy dawn's first light", "The shy nymph swim", "Moonbeam's reflection",
    "The cloud that wore snowshoes", "Dandelion's minute", "The hiccuping bath toy",
    "Marshmallow's hot cocoa", "The sleepy granite", "Raindrop's melody",
    "The runaway lychee", "Fuzzy pen cap's journey", "The giggling blender",
    "Starlight's hope", "The shy root anchor", "Bubbly puddle's jump",
    "The sneezing wedding cake", "Cinnamon stick's stir", "The runaway hazelnut",
    "Squeaky marker's art", "The whispering vineyard", "Gummy lizard's climb",
    "The cloud that juggled raindrops", "Dewdrop's magnifier", "The hiccuping snorkel",
    "Snuggly sleeping bag's cocoon", "The shy shoot emerge", "Moonpie's dark side",
    "The runaway persimmon", "Pebble's erosion", "The giggling grinder",
    "Rainbow's double arc", "The sleepy vine twist", "The whispering fen",
    "Bubbly spring's birth", "The sneezing pancake", "Cookie's smartie eyes",
    "The hiccuping life jacket", "Fuzzy slipper's sole", "The runaway macadamia",
    "Dewy web's architecture", "The shy nymph flight", "Starlight's guide home"
]


def system_stories(num_examples: int):
    return f"""
    You are a Memory Reinforcement Learning dataset generator for a Reactive Transformer model.
    Output must be a Python list of tuples containing initial query-answer pairs and list of follow-up interactions, without any code, explanation, or metadata.
    You are used to generate list of exactly {num_examples} tuples with three elements: question, answer and list of follow-up interactions, based on fake data based on TinyStories dataset - simple stories
    """


def task_description_stories(follow_ups_format: str, steps: int, num_examples: int, prior_steps: int, mode: str = 'multi'):
    return f"""
    # Memory Reinforcement Learning Data Generation - {steps} Step(s)

    ## TASK DESCRIPTION
    Generate {num_examples} examples of interconnected interactions testing multi-step memory retention. They will be
    used to train reactive models, that works in real-time processing mode - processing only the single messages (interactions),
    and keeps conversation history in short-term memory.

    Dataset is based on simple synthetic TinyStories dataset. It should include a simple story in the first interaction,
    and follow-up questions and answers about details of that story.

    Each example must:

    1. Start with initial simple story QA - query and answer. Query is asking something like "Tell me a story about..." and answer is that story.
    2. Contain {steps} follow-up QAs progressively referencing prior answers - list of queries and answers, about details of the story from first interaction
    3. Each answer introduces 3-4 new facts while repeating 3+ previous facts
    4. Final interaction requires synthesizing info from {prior_steps}+ prior steps
    ## FORMAT REQUIREMENTS
    ```python
    [
        (
            ("[Initial Question]", "[Initial Answer]"),
            {follow_ups_format}
        ),
        # {num_examples} total entries
    ]
    ```
    """ if mode == 'multi' else f"""
    # Memory Reinforcement Learning Data Generation - {steps} Step(s) - Long-Range Strategy

    ## TASK DESCRIPTION
    Generate {num_examples} examples of interconnected interactions testing long-range and multi-step memory retention. They
    will be used to train reactive models, that works in real-time processing mode - processing only the single messages (interactions),
    and keeps conversation history in short-term memory.

    Dataset is based on simple synthetic TinyStories dataset. It should include a simple story in the first interaction,
    and follow-up questions and answers about details of that story.

    In Long-Range strategy each generated example should contain two completely different message **topics**:
    - first topic is used only in first and last interaction
    - second topic is used in all interactions between first and last

    Each example must:

    1. Start with initial simple story QA - query and answer. Query is asking something like "Tell me a story about..." and answer is that story. - for the first **topic**
    2. Contain {steps} follow-up QAs list of queries and answers
    3. First query in follow-up QAs (interactions) is changing **topic** into second one - not connected to first QA, and answer is also for new **topic** - it has to be a new story, similar as in first interaction
    4. All next follow-up interactions, except the last one, have to continue the second **topic**:
        - Each query is asking about story details and answer introduces 3-4 new details while repeating 3+ previous facts
    4. Final, last interaction is going back to first **topic/story** - asking a question about data from first QA pair (interaction) and the answer is containing most details about the story from first interaction
    ## FORMAT REQUIREMENTS
    ```python
    [
        (
            ("[Initial Question: **topic one**]", "[Initial Answer: **topic one**]"),
            {follow_ups_format}
        ),
        # {num_examples} total entries
    ]
    ```
    """


def critical_rules_stories(steps: int, prior_steps: int, num_tokens: int, mode: str = 'multi'):
    if mode == 'multi':
        return f"""
    ## CRITICAL RULES
    1. Based on simple stories:
      - Dataset is based on simple synthetic TinyStories dataset.
      - All elements are fictional
      - Includes only very basic facts from real world knowledge
      - It's in the form of very simple fake stories
      - Shouldn't include a lot of numbers - only basic facts
      - No calculations, etc., only the knowledge and just dialog content
    2. Non-formal language:
      - Model is pre-trained on stories with non-formal language - it should be the same
      - Dataset not includes real world facts, bot only simple fake stories and questions and answers about their details
    3. Referential Integrity:
      - Each follow-up references 3+ details from previous answers
      - Final answer must combine details from {prior_steps} previous steps
    4. Progressive Retention:
      - Each answer is on the same topic
      - Knowledge is accumulated in answers
      - Queries reference previous answers
      - First interaction includes base story and follow-up interactions include questions and answers about those story details
    5. Do not repeat examples
      - each item should be unique - do not use the same examples as provided
      - please do not generate same examples as in FEW SHOTS items should be new
      - don't generate examples in same topics as in FEW SHOT EXAMPLES
      - be creative for topics
      - try a lot different topics
    6. Interaction length
      - each interaction - query + answer - should have about {num_tokens} tokens length
      - length should be similar as in examples
    """
    else:
        return f"""
    ## CRITICAL RULES
    1. Based on simple stories:
      - Dataset is based on simple synthetic TinyStories dataset.
      - All elements are fictional
      - Includes only very basic facts from real world knowledge
      - It's in the form of very simple fake stories
      - Shouldn't include a lot of numbers - only basic facts
      - No calculations, etc., only the knowledge and just dialog content
    2. Non-formal language:
      - Model is pre-trained on stories with non-formal language - it should be the same
      - Dataset not includes real world facts, bot only simple fake stories and questions and answers about their details
    3. Referential Integrity:
      - Each middle follow-up for **topic two** references 3+ details from previous answers and trying to combine details from {prior_steps} previous steps (except first step)
      - Final answer must change back to **topic one** and reference 3+ details from initial QA pair/interaction
    4. Progressive Retention:
      - Each answer from the middle of sequence (except initial and last follow-up) is on the same topic (**topic two**)
      - Knowledge is accumulated in answers
      - Queries reference previous answers of the same **topic**
      - In Long Range mode, first interaction is base story, second interaction is a second base story, middle follow-ups are details of the second story and last interaction ask about details of first story
    5. Do not repeat examples
      - each item should be unique - do not use the same examples as provided
      - please do not generate same examples as in FEW SHOTS items should be new
      - don't generate examples in same topics as in FEW SHOT EXAMPLES
      - be creative for topics
      - try a lot different topics
    7. Interaction length
      - each interaction - query + answer - should have about {num_tokens} tokens length
      - length should be similar as in examples
    8. **CRUCIAL/CRITICAL** !! - Long-Range Strategy
      - first, initial QA pair is connected to **topic one**
      - ensure that there is exactly {steps} follow-up QAs/interactions with two different **topics**
      - first {steps - 1} follow-ups are all exploring **topic two**
      - ensure that exactly the last, {steps} QA pair (interaction) is going back to **topic one**
      - ensure that the last {steps} interaction is not connected to **topic two**
    """


def final_instructions_stories(steps: int, num_examples: int, mode: str = 'multi'):
    instructions = f"""
    ## GENERATION INSTRUCTIONS
    1. Start each sequence with simple synthetic story, based on the TinyStories dataset.
    2. Design {steps} follow-ups requiring cumulative exploration of the story details
    3. Ensure final answer combines details about story from multiple steps
    4. Validate all questions/answers details in case of memory retention
    ## OUTPUT VALIDATION
    - No placeholder text ("...")
    - All details consistent
    - {steps} follow-ups per entry
    - Final answer combines 3+ prior details
    - Output only the final list - without wrapping it with '```python' and '```'
    - Output is a single list of tuples in same format as examples
    - Output contains {num_examples} elements with the same format as examples
    - Do not generate separate list for each example, only single list of tuples
    - Each tuple should end with closing `)` and each list should end with closing `]`

    Generate {num_examples} entries following EXACTLY this structure.
    """ if mode == 'multi' else f"""
    ## GENERATION INSTRUCTIONS
    1. Start each sequence with simple synthetic story, based on the TinyStories dataset for **topic one**
    2. Then, first follow-up should include second base story, that's changing topic to **topic two**
    2. Design {steps - 1} follow-ups requiring cumulative exploration of the second story for **topic two**
    3. Ensure final query is switching back to **topic one** and final answer is including data from initial story
    4. Validate all questions/answers details in case of memory retention
    5. All follow-ups should have {steps} elements: {steps - 1} for **topic two** and last 1 for switching back to **topic one**
    ## OUTPUT VALIDATION
    - No placeholder text ("...")
    - All details consistent
    - exactly {steps} follow-ups per entry: {steps - 1} for **topic two** and last 1 for **topic one**
    - Final answer combines 3-4+ details from first initial interaction
    - Output only the final list - without wrapping it with '```python' and '```'
    - Output is a single list of tuples in same format as examples
    - Output contains {num_examples} elements with the same format as examples
    - Do not generate separate list for each example, only single list of tuples
    - Each tuple should end with closing `)` and each list should end with closing `]`
    - Ensure, that after {steps - 1} follow-up QAs (interactions) for **topic two**, there's also final {steps} (last) query and answer for **topic one**

    Generate {num_examples} entries following EXACTLY this structure.
    """

    return instructions

ALL_PROMPTS_STORIES = (system_stories, task_description_stories, critical_rules_stories, final_instructions_stories)
