from .vector import Point, Multipoint, Line, Polygon
from .crs import LonLatWGS84, NSIDCNorth

us_capitols = [Point((-112.1, 33.57), properties={"n": "Phoenix, Arizona, United States"}, crs=LonLatWGS84),
               Point((-121.5, 38.57), properties={"n": "Sacramento, California, United States"}, crs=LonLatWGS84),
               Point((-84.42, 33.76), properties={"n": "Atlanta, Georgia, United States"}, crs=LonLatWGS84),
               Point((-86.15, 39.78), properties={"n": "Indianapolis, Indiana, United States"}, crs=LonLatWGS84),
               Point((-112.0, 46.60) , properties={"n": "Helena, Montana, United States"}, crs=LonLatWGS84),
               Point((-82.99, 39.98), properties={"n": "Columbus, Ohio, United States"}, crs=LonLatWGS84),
               Point((-77.48, 37.53), properties={"n": "Richmond, Virginia, United States"}, crs=LonLatWGS84),
               Point((-95.69, 39.04), properties={"n": "Topeka, Kansas, United States"}, crs=LonLatWGS84),
               Point((-71.02, 42.33), properties={"n": "Boston, Massachusetts, United States"}, crs=LonLatWGS84),
               Point((-96.68, 40.81), properties={"n": "Lincoln, Nebraska, United States"}, crs=LonLatWGS84),
               Point((-97.51, 35.47), properties={"n": "Oklahoma City, Oklahoma, United States"}, crs=LonLatWGS84),
               Point((-134.2, 58.37), properties={"n": "Juneau, Alaska, United States"}, crs=LonLatWGS84),
               Point((-100.3, 44.38), properties={"n": "Pierre, South Dakota, United States"}, crs=LonLatWGS84),
               Point((-157.8, 21.31), properties={"n": "Honolulu, Hawaii, United States"}, crs=LonLatWGS84),
               Point((-86.27, 32.35), properties={"n": "Montgomery, Alabama, United States"}, crs=LonLatWGS84),
               Point((-92.36, 34.73), properties={"n": "Little Rock, Arkansas, United States"}, crs=LonLatWGS84),
               Point((-104.9, 39.76), properties={"n": "Denver, Colorado, United States"}, crs=LonLatWGS84),
               Point((-72.68, 41.77), properties={"n": "Hartford, Connecticut, United States"}, crs=LonLatWGS84),
               Point((-75.52, 39.16), properties={"n": "Dover, Delaware, United States"}, crs=LonLatWGS84),
               Point((-77.02, 38.90) , properties={"n": "Washington, District of Columbia, United States"}, crs=LonLatWGS84),
               Point((-84.25, 30.46), properties={"n": "Tallahassee, Florida, United States"}, crs=LonLatWGS84),
               Point((-116.2, 43.60) , properties={"n": "Boise, Idaho, United States"}, crs=LonLatWGS84),
               Point((-89.67, 39.76), properties={"n": "Springfield, Illinois, United States"}, crs=LonLatWGS84),
               Point((-93.62, 41.57), properties={"n": "Des Moines, Iowa, United States"}, crs=LonLatWGS84),
               Point((-84.87, 38.19), properties={"n": "Frankfort, Kentucky, United States"}, crs=LonLatWGS84),
               Point((-91.13, 30.45), properties={"n": "Baton Rouge, Louisiana, United States"}, crs=LonLatWGS84),
               Point((-69.73, 44.33), properties={"n": "Augusta, Maine, United States"}, crs=LonLatWGS84),
               Point((-76.51, 38.97), properties={"n": "Annapolis, Maryland, United States"}, crs=LonLatWGS84),
               Point((-84.56, 42.71), properties={"n": "Lansing, Michigan, United States"}, crs=LonLatWGS84),
               Point((-93.10, 44.95), properties={"n": "Saint Paul, Minnesota, United States"}, crs=LonLatWGS84),
               Point((-90.21, 32.32), properties={"n": "Jackson, Mississippi, United States"}, crs=LonLatWGS84),
               Point((-92.18, 38.57), properties={"n": "Jefferson City, Missouri, United States"}, crs=LonLatWGS84),
               Point((-119.7, 39.15), properties={"n": "Carson City, Nevada, United States"}, crs=LonLatWGS84),
               Point((-71.56, 43.23), properties={"n": "Concord, New Hampshire, United States"}, crs=LonLatWGS84),
               Point((-74.76, 40.22), properties={"n": "Trenton, New Jersey, United States"}, crs=LonLatWGS84),
               Point((-106.0, 35.67), properties={"n": "Santa Fe, New Mexico, United States"}, crs=LonLatWGS84),
               Point((-73.80, 42.67), properties={"n": "Albany, New York, United States"}, crs=LonLatWGS84),
               Point((-78.64, 35.83), properties={"n": "Raleigh, North Carolina, United States"}, crs=LonLatWGS84),
               Point((-100.8, 46.81), properties={"n": "Bismarck, North Dakota, United States"}, crs=LonLatWGS84),
               Point((-123.0, 44.92), properties={"n": "Salem, Oregon, United States"}, crs=LonLatWGS84),
               Point((-76.89, 40.28), properties={"n": "Harrisburg, Pennsylvania, United States"}, crs=LonLatWGS84),
               Point((-71.42, 41.82), properties={"n": "Providence, Rhode Island, United States"}, crs=LonLatWGS84),
               Point((-81.01, 34.02), properties={"n": "Columbia, South Carolina, United States"}, crs=LonLatWGS84),
               Point((-86.78, 36.17), properties={"n": "Nashville, Tennessee, United States"}, crs=LonLatWGS84),
               Point((-97.76, 30.31), properties={"n": "Austin, Texas, United States"}, crs=LonLatWGS84),
               Point((-111.9, 40.78), properties={"n": "Salt Lake City, Utah, United States"}, crs=LonLatWGS84),
               Point((-72.57, 44.27), properties={"n": "Montpelier, Vermont, United States"}, crs=LonLatWGS84),
               Point((-122.9, 47.04), properties={"n": "Olympia, Washington, United States"}, crs=LonLatWGS84),
               Point((-81.63, 38.35), properties={"n": "Charleston, West Virginia, United States"}, crs=LonLatWGS84),
               Point((-89.43, 43.09), properties={"n": "Madison, Wisconsin, United States"}, crs=LonLatWGS84),
               Point((-104.8, 41.15), properties={"n": "Cheyenne, Wyoming, United States"}, crs=LonLatWGS84)]

greenland = Polygon([(-389995.37, -2597175.12), (-389878.32, -2595747.06),
                     (-396101.06, -2594652.71), (-392148.97, -2593049.92),
                     (-392012.36, -2594458.88), (-391313.88, -2592850.44),
                     (-387460.15, -2591875.61), (-391961.45, -2591326.68),
                     (-391748.25, -2592570.06), (-395430.29, -2593563.00),
                     (-395183.92, -2592108.00), (-392449.17, -2591535.09),
                     (-394385.54, -2591178.26), (-391449.44, -2587431.66),
                     (-388680.81, -2586280.71), (-392314.11, -2587366.97),
                     (-389355.78, -2585279.11), (-390598.73, -2585084.76),
                     (-389442.72, -2583409.91), (-386931.43, -2585687.62),
                     (-388830.66, -2581792.35), (-380014.21, -2582169.88),
                     (-377846.60, -2580662.96), (-370096.41, -2580153.33),
                     (-365958.33, -2578408.93), (-375978.66, -2578166.17),
                     (-379626.49, -2580470.20), (-382501.25, -2579401.78),
                     (-390916.87, -2581215.73), (-391304.71, -2578909.05),
                     (-389557.04, -2579129.07), (-391949.38, -2576835.09),
                     (-390871.89, -2573207.05), (-392841.70, -2569043.29),
                     (-389934.79, -2563148.02), (-390936.16, -2561152.71),
                     (-389084.87, -2561210.84), (-388180.44, -2562497.63),
                     (-387712.12, -2562462.36), (-388617.51, -2560650.52),
                     (-386818.65, -2560121.59), (-388788.97, -2560226.07),
                     (-389764.22, -2557856.24), (-388549.36, -2555231.97),
                     (-386399.82, -2555610.42), (-387426.02, -2553178.12),
                     (-385495.53, -2553301.41), (-387546.45, -2552686.20),
                     (-387150.99, -2550654.34), (-384438.20, -2551849.65),
                     (-385143.64, -2549538.77), (-381716.51, -2548170.73),
                     (-381526.19, -2550686.10), (-378501.11, -2549014.14),
                     (-378023.82, -2550226.63), (-376565.16, -2551487.10),
                     (-376099.91, -2551479.31), (-377679.54, -2548928.42),
                     (-376304.81, -2548555.85), (-367514.94, -2553774.16),
                     (-375393.74, -2551120.30), (-375346.62, -2552024.70),
                     (-367319.48, -2554781.46), (-366874.16, -2556473.23),
                     (-366158.14, -2553166.63), (-361465.95, -2554312.60),
                     (-361324.87, -2553007.32), (-354583.18, -2551022.87),
                     (-355737.67, -2549622.89), (-337122.02, -2556702.80),
                     (-332735.65, -2556650.44), (-333685.18, -2555765.53),
                     (-332007.44, -2553914.64), (-333058.01, -2552888.21),
                     (-336465.92, -2554103.71), (-343035.55, -2551802.27),
                     (-350409.72, -2548630.96), (-346967.55, -2548450.70),
                     (-349032.98, -2547430.87), (-355791.36, -2547165.44),
                     (-363989.53, -2550556.98), (-367502.88, -2550047.41),
                     (-371599.83, -2547703.63), (-370524.84, -2546616.53),
                     (-377285.68, -2545302.09), (-377654.38, -2543623.52),
                     (-375169.56, -2543979.81), (-375051.00, -2541817.32),
                     (-371831.45, -2543153.21), (-373853.03, -2542005.20),
                     (-372296.23, -2542088.89), (-371295.76, -2539817.62),
                     (-379017.84, -2542024.84), (-379380.07, -2539752.72),
                     (-377703.35, -2539267.16), (-378824.57, -2536246.00),
                     (-377766.91, -2537187.05), (-377539.35, -2535892.64),
                     (-374864.96, -2535833.38), (-368152.25, -2530880.14),
                     (-365547.59, -2531191.58), (-363751.75, -2533618.00),
                     (-359538.30, -2533261.59), (-356476.23, -2535782.61),
                     (-348972.21, -2535561.64), (-345989.15, -2532896.74),
                     (-340784.25, -2536255.29), (-341538.93, -2533839.69),
                     (-337927.19, -2534488.83), (-337832.99, -2530643.34),
                     (-342366.73, -2530751.80), (-344238.15, -2529288.52),
                     (-355366.93, -2532755.95), (-362403.70, -2530806.47),
                     (-364561.73, -2527442.66), (-364102.52, -2526680.83),
                     (-363765.67, -2526514.08), (-359345.31, -2529065.26),
                     (-356641.97, -2528994.76), (-354714.71, -2526985.62),
                     (-347896.88, -2528807.20), (-345341.91, -2525807.86),
                     (-340724.62, -2525723.98), (-339202.26, -2523830.60),
                     (-339796.66, -2520056.89), (-342525.21, -2522530.95),
                     (-349148.64, -2520252.81), (-360020.39, -2526193.03),
                     (-358956.04, -2522513.21), (-356415.52, -2521395.86),
                     (-358587.64, -2519104.72), (-356226.68, -2516026.14),
                     (-354583.66, -2517034.17), (-353908.36, -2516827.86),
                     (-354059.79, -2516086.18), (-353433.61, -2515922.74),
                     (-353555.98, -2515445.79), (-353209.22, -2515453.53),
                     (-349314.13, -2518954.95), (-346827.22, -2517533.58),
                     (-349322.52, -2516757.36), (-348715.69, -2515431.93),
                     (-335233.71, -2515882.94), (-328499.77, -2519821.20),
                     (-325518.70, -2524456.87), (-320497.17, -2523834.82),
                     (-319919.47, -2521955.28), (-324679.21, -2522027.56),
                     (-327185.98, -2519729.64), (-326702.00, -2518187.93),
                     (-330846.36, -2516034.04), (-324720.52, -2514560.88),
                     (-321391.14, -2515395.21), (-323557.01, -2513975.84),
                     (-320495.08, -2511349.11), (-325564.04, -2513239.56),
                     (-330930.80, -2513041.96), (-331369.23, -2509836.28),
                     (-330226.81, -2509177.80), (-331630.05, -2508215.44),
                     (-330360.59, -2506643.36), (-327328.51, -2506185.67),
                     (-325195.51, -2504386.94), (-330677.66, -2506087.97),
                     (-332246.69, -2507483.83), (-332627.56, -2511034.73),
                     (-335637.17, -2512623.44), (-344103.98, -2513233.88),
                     (-346862.00, -2510865.33), (-356128.79, -2508417.24),
                     (-355179.65, -2506868.87), (-372067.96, -2506864.61),
                     (-372568.86, -2505607.86), (-379543.45, -2505009.84),
                     (-382554.97, -2502711.61), (-379160.38, -2501206.43),
                     (-383762.49, -2501004.57), (-385663.71, -2499230.30),
                     (-386698.81, -2495974.44), (-385042.00, -2493795.03),
                     (-377846.08, -2497662.57), (-371112.93, -2495933.22),
                     (-364732.43, -2499853.70), (-360720.41, -2499983.93),
                     (-360139.28, -2498628.13), (-366449.32, -2498060.01),
                     (-370446.70, -2494861.67), (-378007.60, -2496747.25),
                     (-385045.55, -2493027.50), (-384470.87, -2490946.42),
                     (-386289.03, -2491154.05), (-385048.85, -2488278.31),
                     (-386806.16, -2486869.49), (-380209.27, -2486908.09),
                     (-373095.56, -2489390.38), (-364425.27, -2485395.03),
                     (-367897.55, -2485510.57), (-371944.08, -2488112.10),
                     (-379164.50, -2485559.48), (-390089.49, -2486439.80),
                     (-390879.56, -2484398.39), (-388121.67, -2484063.74),
                     (-388579.55, -2482420.53), (-391454.13, -2483293.40),
                     (-386986.06, -2481349.84), (-388981.50, -2481595.11),
                     (-388080.79, -2480506.50), (-389362.31, -2480309.10),
                     (-385659.18, -2479005.30), (-387983.13, -2478548.08),
                     (-386617.16, -2476642.20), (-385152.67, -2478075.75),
                     (-384415.96, -2476100.79), (-380806.18, -2474844.20),
                     (-365309.48, -2475255.03), (-365384.26, -2475680.92),
                     (-363382.93, -2476708.13), (-365730.97, -2474340.58),
                     (-373969.66, -2472925.51), (-367698.30, -2470336.05),
                     (-366233.06, -2472656.30), (-360074.63, -2472348.19),
                     (-359745.99, -2470647.98), (-357753.97, -2470154.86),
                     (-350771.17, -2472212.09), (-347736.72, -2469833.66),
                     (-343358.75, -2470016.63), (-341029.59, -2468270.71),
                     (-330204.58, -2466338.80), (-325857.24, -2467065.62),
                     (-326207.76, -2466016.04), (-323545.09, -2465462.39),
                     (-328490.30, -2463297.70), (-352544.27, -2467998.26),
                     (-356411.81, -2466842.37), (-356328.33, -2466069.93),
                     (-352180.68, -2460617.93), (-351347.02, -2460129.11),
                     (-351135.43, -2459776.33), (-364120.83, -2469364.29),
                     (-363792.64, -2467938.42), (-372017.79, -2468275.71),
                     (-376637.11, -2472172.27), (-383293.44, -2473763.09),
                     (-380299.49, -2471252.80), (-381369.89, -2469920.51),
                     (-383331.88, -2471197.70), (-386106.59, -2469838.37),
                     (-383907.70, -2467185.56), (-385506.35, -2466720.99),
                     (-383828.06, -2464864.27), (-385802.57, -2464663.07),
                     (-383092.34, -2463686.14), (-384171.57, -2462439.58),
                     (-381139.20, -2461961.12), (-383991.11, -2462112.40),
                     (-382907.54, -2460667.52), (-384307.58, -2460370.66),
                     (-381430.75, -2459324.43), (-382974.03, -2457825.19),
                     (-381281.13, -2456361.22), (-383013.66, -2456461.72),
                     (-378846.44, -2453126.07), (-378469.46, -2451961.80),
                     (-380360.71, -2451891.12), (-378913.45, -2448694.88),
                     (-378769.11, -2450821.72), (-374262.25, -2444747.48),
                     (-373082.74, -2446928.89), (-371775.99, -2443687.80),
                     (-359239.86, -2439525.80), (-360146.55, -2438560.15),
                     (-355500.84, -2436229.69), (-345486.24, -2433959.41),
                     (-347629.11, -2432658.44), (-353925.44, -2434088.19),
                     (-334504.40, -2424017.10), (-336572.39, -2423635.54),
                     (-346761.47, -2428099.87), (-346154.55, -2425419.80),
                     (-341782.35, -2420778.46), (-338626.36, -2420713.66),
                     (-339882.61, -2419769.42), (-338960.88, -2418453.23),
                     (-338133.17, -2419977.04), (-330925.02, -2420820.19),
                     (-328411.39, -2424584.75), (-328749.70, -2422352.57),
                     (-325025.20, -2423446.94), (-324760.81, -2422059.57),
                     (-320470.46, -2420843.56), (-329760.33, -2421002.92),
                     (-329387.68, -2419684.94), (-334476.74, -2418386.70),
                     (-329582.80, -2417468.75), (-326289.35, -2419613.79),
                     (-316587.92, -2416681.51), (-312397.05, -2418270.12),
                     (-311906.55, -2420980.81), (-304483.61, -2423419.24),
                     (-306298.96, -2423918.69), (-303973.30, -2426218.12),
                     (-300508.99, -2424882.21), (-298550.36, -2426564.20),
                     (-300335.05, -2426778.76), (-293299.09, -2431513.72),
                     (-293778.93, -2434669.65), (-290777.18, -2434699.45),
                     (-290305.62, -2437061.44), (-279668.47, -2434837.51),
                     (-278598.71, -2433462.45), (-274164.50, -2435245.15),
                     (-272995.94, -2434849.42), (-273644.86, -2432787.31),
                     (-270132.39, -2432898.29), (-265969.36, -2438075.78),
                     (-263793.53, -2439084.28), (-262316.45, -2437680.22),
                     (-261229.24, -2440799.27), (-253946.35, -2444078.84),
                     (-246248.93, -2454451.45), (-241663.32, -2456752.27),
                     (-241074.45, -2454992.20), (-243115.64, -2453507.35),
                     (-242987.30, -2451728.14), (-248167.27, -2448210.16),
                     (-249006.42, -2444365.62), (-251656.54, -2443596.98),
                     (-245597.27, -2439955.70), (-242049.54, -2440009.77),
                     (-241174.85, -2439379.22), (-245005.92, -2439267.38),
                     (-250541.87, -2440824.58), (-257344.97, -2439983.67),
                     (-253553.22, -2438688.64), (-251304.60, -2435978.23),
                     (-258839.68, -2437309.30), (-265844.28, -2430173.77),
                     (-269802.23, -2429495.58), (-269379.40, -2427951.83),
                     (-266905.65, -2426133.88), (-265180.09, -2427845.55),
                     (-266319.92, -2429892.21), (-265704.03, -2430072.67),
                     (-265380.56, -2430569.20), (-259602.60, -2428087.78),
                     (-261444.67, -2429395.44), (-257204.03, -2428627.78),
                     (-255019.70, -2430099.74), (-252717.65, -2428118.18),
                     (-255012.74, -2427009.45), (-254208.45, -2426228.50),
                     (-246841.14, -2426192.96), (-244084.14, -2423305.86),
                     (-245364.98, -2422853.59), (-241586.18, -2422614.64),
                     (-240215.73, -2419726.84), (-223381.73, -2422465.84),
                     (-223196.08, -2419021.16), (-231428.00, -2417410.29),
                     (-229356.90, -2414020.21), (-230887.31, -2412503.67),
                     (-233022.34, -2412222.79), (-231588.88, -2414940.96),
                     (-233459.63, -2416405.91), (-243916.80, -2410967.19),
                     (-247094.20, -2414155.63), (-243697.76, -2413559.45),
                     (-251820.42, -2416507.20), (-246418.94, -2417488.48),
                     (-243037.82, -2414147.48), (-237901.65, -2418034.54),
                     (-241374.62, -2418941.01), (-241800.53, -2420801.71),
                     (-244100.66, -2419882.18), (-246477.86, -2421350.66),
                     (-248987.75, -2419962.37), (-248532.76, -2422088.02),
                     (-250331.02, -2423127.05), (-251920.29, -2421487.30),
                     (-254072.45, -2422185.26), (-254572.59, -2424746.63),
                     (-256187.54, -2423350.80), (-263292.95, -2425561.21),
                     (-264410.92, -2421371.20), (-261692.69, -2420098.16),
                     (-264897.67, -2419414.97), (-265155.19, -2415287.16),
                     (-270919.14, -2411358.59), (-266833.12, -2411761.03),
                     (-260792.20, -2408674.99), (-260631.70, -2410164.14),
                     (-256143.34, -2409480.94), (-253895.30, -2413354.99),
                     (-252659.76, -2413137.98), (-251337.88, -2408659.21),
                     (-254847.20, -2405664.03), (-253472.91, -2403297.16),
                     (-255288.50, -2403135.47), (-253390.63, -2400593.02),
                     (-255377.64, -2402202.44), (-261712.69, -2402891.57),
                     (-266539.06, -2407058.36), (-274870.14, -2403407.67),
                     (-275140.12, -2405139.88), (-277970.08, -2404060.51),
                     (-272856.64, -2409479.81), (-272996.60, -2412986.97),
                     (-267061.32, -2416385.74), (-267351.63, -2419271.61),
                     (-270502.62, -2421768.69), (-270945.08, -2425273.45),
                     (-276928.12, -2427775.33), (-278463.82, -2426183.66),
                     (-274015.97, -2423996.73), (-279157.95, -2425098.44),
                     (-280350.50, -2423817.40), (-281225.77, -2426627.45),
                     (-285776.43, -2430319.40), (-290597.83, -2427842.89),
                     (-288841.17, -2426123.16), (-291885.74, -2425828.92),
                     (-290855.18, -2423193.78), (-295775.52, -2423018.04),
                     (-296700.40, -2420580.01), (-302828.27, -2418728.43),
                     (-308079.92, -2418688.00), (-309564.20, -2416898.10),
                     (-308400.40, -2414653.93), (-312042.28, -2412792.84),
                     (-308866.24, -2408743.25), (-301863.42, -2405072.85),
                     (-299922.09, -2405279.50), (-302949.53, -2406458.66),
                     (-302131.04, -2407585.92), (-293161.74, -2407674.05),
                     (-285601.34, -2402804.02), (-282087.85, -2403696.14),
                     (-278734.82, -2402017.58), (-276742.12, -2403642.70),
                     (-278462.72, -2401352.86), (-276186.55, -2401391.95),
                     (-275724.81, -2400026.70), (-277749.06, -2399249.64),
                     (-281515.45, -2401563.26), (-284470.84, -2400312.75),
                     (-294379.83, -2405552.29), (-304314.46, -2403960.28),
                     (-305227.00, -2405753.16), (-313296.16, -2408586.74),
                     (-315921.86, -2412349.11), (-322366.27, -2414547.28),
                     (-332879.28, -2413475.33), (-336051.88, -2415848.62),
                     (-339694.45, -2415745.30), (-347881.39, -2422950.89),
                     (-351838.64, -2429891.79), (-368309.66, -2440522.34),
                     (-370757.30, -2441499.50), (-371313.37, -2440051.23),
                     (-371233.20, -2441621.66), (-372972.20, -2441793.47),
                     (-371209.41, -2437677.42), (-374987.70, -2438394.83),
                     (-372806.86, -2434555.97), (-374479.32, -2434517.68),
                     (-375104.95, -2430172.78), (-365948.54, -2426225.72),
                     (-365094.59, -2424391.46), (-371196.14, -2426117.49),
                     (-371861.70, -2425062.65), (-368999.92, -2425056.37),
                     (-367315.84, -2422320.15), (-363345.06, -2420873.44),
                     (-366626.79, -2421296.98), (-363497.25, -2417216.59),
                     (-365424.14, -2414205.47), (-363344.33, -2412611.68),
                     (-365412.87, -2412907.19), (-366862.54, -2408301.84),
                     (-369739.10, -2406862.86), (-363589.42, -2405017.31),
                     (-361342.03, -2402402.81), (-359284.25, -2403665.41),
                     (-358552.53, -2402242.72), (-357105.97, -2403813.99),
                     (-358043.81, -2407409.55), (-354948.06, -2407224.14),
                     (-359117.70, -2410123.12), (-354098.54, -2407778.42),
                     (-352314.05, -2409704.52), (-350139.90, -2409361.86),
                     (-349102.25, -2408044.82), (-356650.20, -2405740.46),
                     (-354657.10, -2402000.08), (-353292.80, -2402465.63),
                     (-353707.39, -2401496.44), (-358198.85, -2400837.44),
                     (-357558.46, -2398395.14), (-353020.59, -2397817.53),
                     (-352136.64, -2399788.54), (-350251.17, -2399705.80),
                     (-349896.34, -2401765.25), (-352502.16, -2403967.80),
                     (-351517.15, -2405805.67), (-350940.92, -2403413.01),
                     (-346305.09, -2400593.88), (-341440.44, -2400193.72),
                     (-340590.56, -2402754.32), (-340168.08, -2401514.30),
                     (-342935.66, -2398531.93), (-349428.16, -2401439.60),
                     (-348285.85, -2398618.75), (-351081.67, -2396439.48),
                     (-348589.32, -2397416.07), (-349085.42, -2395328.55),
                     (-344977.14, -2395915.72), (-348345.53, -2393559.49),
                     (-348316.43, -2391687.07), (-344354.25, -2392951.56),
                     (-344787.91, -2391086.63), (-342181.26, -2392608.83),
                     (-334571.05, -2391091.09), (-332208.39, -2392471.23),
                     (-333334.83, -2390329.72), (-339851.58, -2390811.20),
                     (-339600.80, -2389020.06), (-346951.84, -2389742.36),
                     (-345398.97, -2388192.07), (-346324.52, -2386071.76),
                     (-344701.79, -2386276.12), (-343464.78, -2383639.63),
                     (-340228.03, -2384132.14), (-340468.28, -2382346.05),
                     (-338206.38, -2381435.90), (-327550.38, -2393173.45),
                     (-323422.73, -2395593.91), (-321353.92, -2395137.13),
                     (-321659.81, -2395932.09), (-320269.54, -2397678.15),
                     (-320442.94, -2396604.89), (-318798.99, -2397691.77),
                     (-319130.92, -2396212.47), (-317887.57, -2396461.55),
                     (-314353.23, -2397416.91), (-312931.04, -2399503.03),
                     (-306898.64, -2398156.19), (-304154.26, -2401379.49),
                     (-297004.25, -2398748.90), (-298285.01, -2397227.78),
                     (-297402.70, -2395445.85), (-302958.20, -2399370.18),
                     (-304168.66, -2397726.46), (-312844.30, -2396799.03),
                     (-327248.14, -2391431.22), (-329680.97, -2389365.45),
                     (-328223.98, -2388426.09), (-331302.34, -2386998.07),
                     (-331377.84, -2384479.68), (-335706.37, -2381935.84),
                     (-336266.74, -2378961.89), (-335030.16, -2377666.39),
                     (-338254.42, -2378675.54), (-339822.41, -2377423.80),
                     (-338977.87, -2376015.14), (-341623.63, -2375932.08),
                     (-341875.37, -2373193.02), (-337827.52, -2373370.26),
                     (-335880.75, -2369224.62), (-339295.85, -2369865.72),
                     (-339306.27, -2368624.26), (-340306.75, -2370679.74),
                     (-338288.84, -2370694.25), (-338943.93, -2371951.77),
                     (-341384.36, -2371846.62), (-341144.99, -2370430.02),
                     (-345426.43, -2373213.98), (-346744.41, -2372061.25),
                     (-344319.01, -2371773.86), (-343617.77, -2368216.90),
                     (-347538.72, -2371672.80), (-348264.93, -2369315.06),
                     (-349370.92, -2371273.15), (-350272.60, -2369746.12),
                     (-354006.36, -2369328.50), (-352103.04, -2367198.20),
                     (-342532.10, -2366978.64), (-338345.64, -2365064.77),
                     (-339760.61, -2366152.85), (-335081.31, -2367694.78),
                     (-331554.35, -2372977.84), (-329142.12, -2371737.91),
                     (-324527.09, -2377108.91), (-317410.30, -2380958.96),
                     (-314327.50, -2380999.99), (-311460.08, -2384942.16),
                     (-309175.57, -2386513.77), (-309746.37, -2385645.20),
                     (-308498.69, -2384767.95), (-304504.52, -2386003.14),
                     (-307355.33, -2384328.28), (-310423.35, -2384418.59),
                     (-314401.92, -2379809.52), (-317298.12, -2380047.78),
                     (-314848.34, -2378319.64), (-312292.73, -2378967.84),
                     (-312348.62, -2377605.71), (-319569.75, -2377553.98),
                     (-317404.88, -2374583.55), (-321763.12, -2374203.01),
                     (-320395.88, -2370599.56), (-323923.11, -2372558.25),
                     (-326730.10, -2369689.53), (-324167.25, -2367311.36),
                     (-321260.02, -2368170.68), (-320105.78, -2370313.84),
                     (-315144.71, -2369229.92), (-312999.07, -2373440.14),
                     (-303011.54, -2380391.77), (-301385.51, -2384085.65),
                     (-296695.36, -2384469.18), (-292832.82, -2389382.69),
                     (-290247.35, -2388401.25), (-287810.67, -2390723.17),
                     (-277117.64, -2390285.64), (-272055.23, -2392349.25),
                     (-258396.96, -2391412.03), (-257856.08, -2393948.40),
                     (-252570.68, -2398832.66), (-249377.28, -2399745.74),
                     (-244677.85, -2405288.53), (-239862.63, -2405879.57),
                     (-237617.61, -2412002.41), (-233956.82, -2412875.84),
                     (-235223.18, -2410636.05), (-232268.96, -2411089.45),
                     (-230787.69, -2409338.83), (-224487.19, -2410356.94),
                     (-226084.85, -2406617.50), (-235638.47, -2405224.09),
                     (-234008.36, -2403981.10), (-233914.47, -2400600.70),
                     (-235101.88, -2401746.93), (-240937.90, -2400717.19),
                     (-239037.80, -2399791.37), (-240349.13, -2398123.79),
                     (-238942.40, -2396814.80), (-242539.41, -2397549.01),
                     (-246619.19, -2394638.97), (-249750.94, -2394787.25),
                     (-250099.97, -2391244.50), (-254109.59, -2389473.50),
                     (-250425.58, -2387824.34), (-248055.96, -2384969.78),
                     (-253094.46, -2387901.43), (-256576.65, -2387548.99),
                     (-252787.53, -2381963.38), (-259328.81, -2384375.41),
                     (-258583.88, -2381958.49), (-261907.64, -2381479.03),
                     (-264119.06, -2377972.24), (-267961.89, -2375720.02),
                     (-267326.36, -2373797.84), (-260258.33, -2374586.56),
                     (-258101.49, -2377928.69), (-253725.36, -2379095.79),
                     (-257369.39, -2370840.45), (-266235.01, -2369472.96),
                     (-260361.95, -2367093.44), (-260570.73, -2368801.44),
                     (-259521.65, -2368422.39), (-257084.55, -2366084.28),
                     (-255764.12, -2367780.81), (-253819.04, -2367379.84),
                     (-256608.74, -2364323.16), (-256524.28, -2361265.45),
                     (-254515.20, -2358111.31), (-251382.66, -2357374.94),
                     (-254677.18, -2356913.04), (-255194.41, -2353342.96),
                     (-251450.29, -2351170.75), (-248270.48, -2351621.38),
                     (-247694.89, -2349161.58), (-247451.71, -2350411.36),
                     (-243159.71, -2349594.79), (-244370.25, -2348776.06),
                     (-242456.53, -2347838.47), (-244361.09, -2348142.53),
                     (-242978.72, -2347049.73), (-237695.87, -2345846.65),
                     (-242876.19, -2349366.02), (-239978.94, -2348660.88),
                     (-236501.69, -2346547.50), (-238431.56, -2345307.82),
                     (-237608.31, -2343363.59), (-257477.38, -2352310.43),
                     (-261827.03, -2351201.94), (-266379.92, -2352565.72),
                     (-270154.84, -2348477.81), (-272212.57, -2350767.07),
                     (-273520.25, -2350052.07), (-273505.05, -2352359.78),
                     (-270103.49, -2352892.72), (-269866.44, -2355828.24),
                     (-267421.72, -2357787.34), (-265865.54, -2356971.44),
                     (-262273.39, -2359800.74), (-263709.48, -2357977.53),
                     (-261594.45, -2356096.63), (-257409.70, -2363974.27),
                     (-259092.08, -2363797.23), (-258960.14, -2364460.44),
                     (-260258.07, -2364466.85), (-261006.81, -2365555.53),
                     (-258647.84, -2364507.03), (-258569.88, -2366778.78),
                     (-261770.47, -2365417.00), (-266097.59, -2366805.44),
                     (-270047.87, -2365177.17), (-269112.16, -2366141.70),
                     (-275917.99, -2366430.50), (-274624.92, -2365385.14),
                     (-276548.27, -2366665.21), (-277957.04, -2365811.28),
                     (-277527.47, -2367471.01), (-282630.05, -2369366.14),
                     (-293249.38, -2367545.14), (-298367.84, -2371196.44),
                     (-303592.24, -2369888.52), (-303881.70, -2371790.07),
                     (-310762.56, -2372483.61), (-311918.49, -2371018.10),
                     (-310926.08, -2369970.54), (-312702.96, -2369593.02),
                     (-311443.04, -2366714.08), (-307850.17, -2366550.63),
                     (-306512.37, -2365366.92), (-313884.56, -2362314.50),
                     (-310538.43, -2357180.81), (-317188.89, -2360589.73),
                     (-321236.69, -2358009.33), (-324004.19, -2358677.85),
                     (-316584.26, -2363020.27), (-320798.47, -2365481.14),
                     (-324801.58, -2364892.90), (-324134.93, -2363248.61),
                     (-326345.63, -2363350.76), (-326100.80, -2362244.16),
                     (-327663.91, -2363619.20), (-329514.74, -2363131.98),
                     (-324435.64, -2361082.16), (-325764.14, -2359627.69),
                     (-329040.21, -2360328.22), (-329073.83, -2357960.05),
                     (-326594.55, -2356352.69), (-324803.08, -2357121.08),
                     (-321795.38, -2354618.91), (-319769.22, -2356421.68),
                     (-318393.87, -2354350.26), (-317237.36, -2354588.96),
                     (-318333.56, -2355941.59), (-315258.57, -2355492.85),
                     (-316725.48, -2353577.27), (-313718.61, -2353495.75),
                     (-313850.11, -2352300.56), (-313255.78, -2352133.18),
                     (-312772.83, -2351392.04), (-312880.14, -2351049.71),
                     (-335753.71, -2356000.82), (-337299.03, -2355892.25),
                     (-336584.75, -2354614.50), (-337821.53, -2354854.30),
                     (-339325.00, -2351954.99), (-346988.62, -2355639.83),
                     (-347236.69, -2351533.40), (-346137.21, -2353900.29),
                     (-342064.88, -2351428.90), (-344810.06, -2353091.93),
                     (-346071.48, -2351688.18), (-345102.42, -2350725.44),
                     (-347363.46, -2351375.24), (-343205.58, -2349978.64),
                     (-345607.37, -2349661.74), (-345351.41, -2348402.73),
                     (-346521.88, -2350254.77), (-350066.50, -2351120.13),
                     (-348059.27, -2349541.26), (-347141.63, -2350390.03),
                     (-347030.00, -2348556.54), (-340355.41, -2346539.63),
                     (-338741.85, -2348818.01), (-339604.26, -2347859.58),
                     (-342846.35, -2348519.32), (-336194.30, -2350187.63),
                     (-336922.39, -2352491.84), (-334700.45, -2352914.34),
                     (-336014.12, -2353869.00), (-333817.42, -2352749.81),
                     (-334504.92, -2351898.91), (-329804.73, -2350817.63),
                     (-333585.39, -2351391.83), (-331271.67, -2349449.51),
                     (-329623.19, -2350203.34), (-323632.61, -2346494.72),
                     (-323954.80, -2347613.81), (-320940.17, -2346380.17),
                     (-318502.17, -2347564.34), (-318799.36, -2350068.82),
                     (-317332.13, -2345254.12), (-321586.33, -2345418.05),
                     (-322749.93, -2343909.22), (-322129.32, -2343227.34),
                     (-319938.38, -2343491.28), (-320313.27, -2342960.31),
                     (-318495.12, -2343199.11), (-317835.56, -2342601.96),
                     (-318801.70, -2342834.98), (-320925.13, -2341944.19),
                     (-315222.01, -2342237.93), (-312808.77, -2340422.81),
                     (-313511.69, -2339453.38), (-310154.34, -2341470.32),
                     (-309807.34, -2339302.33), (-309024.03, -2338983.06),
                     (-309285.21, -2340079.21), (-307474.34, -2338773.51),
                     (-307423.13, -2340451.18), (-306244.16, -2340202.16),
                     (-307469.79, -2336038.31), (-302439.71, -2334529.55),
                     (-303695.32, -2334684.12), (-302601.72, -2333619.17),
                     (-303718.22, -2333010.76), (-310127.59, -2335565.96),
                     (-313483.07, -2332195.94), (-296738.54, -2329694.03),
                     (-294332.89, -2330094.06), (-291931.89, -2334325.14),
                     (-292419.08, -2331594.24), (-285634.74, -2329551.80),
                     (-291414.04, -2330808.73), (-292905.06, -2330074.09),
                     (-291506.73, -2328436.97), (-295545.38, -2327417.28),
                     (-294767.33, -2326332.32), (-296121.57, -2327686.26),
                     (-301771.12, -2327054.37), (-303633.10, -2328439.35),
                     (-303634.22, -2324407.43), (-302102.78, -2323015.07),
                     (-295760.88, -2322684.68), (-295055.62, -2319850.63),
                     (-287494.33, -2323478.54), (-289017.92, -2326973.43),
                     (-284999.39, -2325472.21), (-284314.08, -2322549.31),
                     (-280749.82, -2322064.31), (-281482.32, -2323541.94),
                     (-278025.62, -2323921.03), (-282561.43, -2324751.72),
                     (-278665.01, -2325482.64), (-280482.40, -2326326.04),
                     (-283963.14, -2325207.34), (-283882.57, -2326886.53),
                     (-281329.85, -2326984.37), (-282601.34, -2327569.56),
                     (-278848.82, -2326944.46), (-278749.25, -2327633.43),
                     (-281883.58, -2328539.16), (-284293.57, -2327504.55),
                     (-285440.19, -2329082.34), (-281478.49, -2328926.75),
                     (-283684.69, -2329498.84), (-284394.18, -2330345.88),
                     (-281428.17, -2329537.78), (-279701.15, -2330902.53),
                     (-286786.70, -2331992.29), (-284344.03, -2332856.94),
                     (-284085.15, -2334756.84), (-286007.81, -2335503.22),
                     (-282104.75, -2336724.06), (-283021.00, -2338297.62),
                     (-280575.77, -2338874.48), (-278573.16, -2336292.20),
                     (-274876.91, -2335388.30), (-275056.69, -2335455.15),
                     (-275423.58, -2337288.49), (-273049.88, -2336906.93),
                     (-273648.12, -2338471.95), (-267625.91, -2338460.39),
                     (-266813.71, -2336500.32), (-259608.01, -2335908.14),
                     (-262615.13, -2334381.18), (-259481.13, -2332522.96),
                     (-257940.44, -2333751.29), (-258518.01, -2335404.43),
                     (-255222.59, -2334196.62), (-253490.89, -2334709.93),
                     (-254524.08, -2336041.47), (-253111.48, -2334663.17),
                     (-252597.45, -2337165.82), (-251016.05, -2334999.83),
                     (-246638.31, -2334452.20), (-247683.56, -2329878.51),
                     (-245126.54, -2328563.87), (-246041.02, -2326855.34),
                     (-244405.24, -2325126.35), (-247673.55, -2320752.08),
                     (-245419.22, -2320672.82), (-244592.08, -2323206.49),
                     (-243462.09, -2322864.54), (-242148.08, -2328444.10),
                     (-240016.42, -2330626.75), (-238668.92, -2329587.11),
                     (-240472.23, -2326056.69), (-236910.00, -2325307.45),
                     (-238800.92, -2324261.57), (-241440.06, -2325264.91),
                     (-240614.28, -2322473.19), (-243381.90, -2320454.89),
                     (-243365.83, -2317837.11), (-237779.56, -2313157.15),
                     (-234626.08, -2313545.56), (-233588.99, -2309970.23),
                     (-229019.68, -2308377.67), (-234086.70, -2306206.03),
                     (-245270.25, -2315967.30), (-249922.80, -2317233.88),
                     (-250316.99, -2315782.11), (-255797.02, -2314658.12),
                     (-249733.82, -2309424.86), (-251560.67, -2309692.89),
                     (-249558.41, -2306940.21), (-250609.54, -2303260.70),
                     (-246403.36, -2302668.50), (-240097.46, -2295956.09),
                     (-241720.10, -2294516.06), (-241978.89, -2296430.24),
                     (-243549.70, -2296322.69), (-246385.32, -2299620.43),
                     (-250221.55, -2299303.00), (-244739.68, -2291308.19),
                     (-245883.07, -2281441.59), (-243359.89, -2281366.17),
                     (-244150.00, -2276696.87), (-242250.40, -2275063.43),
                     (-242593.71, -2271474.19), (-236679.20, -2274135.64),
                     (-228691.47, -2273123.00), (-231497.46, -2276307.65),
                     (-229386.19, -2275637.67), (-229698.19, -2277243.22),
                     (-235793.54, -2279163.11), (-239964.17, -2283555.16),
                     (-236664.75, -2284448.42), (-236283.97, -2282187.50),
                     (-226298.82, -2280475.06), (-227055.86, -2284679.09),
                     (-223881.82, -2283200.29), (-222132.28, -2285166.42),
                     (-223554.69, -2289416.97), (-222814.43, -2294987.42),
                     (-218495.23, -2296043.51), (-216380.94, -2300902.94),
                     (-212233.68, -2298884.57), (-212477.57, -2297361.27),
                     (-216269.14, -2295384.13), (-215209.11, -2294458.58),
                     (-216272.16, -2292104.84), (-220537.03, -2293011.58),
                     (-219606.70, -2287414.76), (-216614.00, -2286289.53),
                     (-216467.08, -2289841.69), (-214235.31, -2291051.87),
                     (-214986.20, -2285021.52), (-210256.79, -2284335.72),
                     (-209897.38, -2286127.19), (-212285.90, -2286970.77),
                     (-210506.61, -2289628.71), (-213223.45, -2292653.45),
                     (-211055.81, -2295035.43), (-208280.18, -2294203.44),
                     (-210001.43, -2292644.02), (-207986.05, -2291243.36),
                     (-209302.61, -2290904.36), (-210088.14, -2286854.61),
                     (-205573.87, -2287958.01), (-208831.80, -2285288.86),
                     (-209734.04, -2280422.37), (-215889.30, -2284036.17),
                     (-222791.73, -2281574.62), (-223021.17, -2278546.40),
                     (-226071.53, -2275553.42), (-227578.06, -2276488.10),
                     (-226037.82, -2275097.01), (-227466.57, -2274602.74),
                     (-227228.45, -2273564.22), (-220674.27, -2275217.60),
                     (-218930.46, -2278648.63), (-218236.44, -2274582.63),
                     (-214937.42, -2275841.32), (-212621.59, -2274477.68),
                     (-210868.82, -2276802.03), (-211737.06, -2275210.07),
                     (-203044.43, -2273217.64), (-200152.17, -2278800.59),
                     (-197322.38, -2275061.53), (-196042.46, -2267298.64),
                     (-202705.56, -2266418.29), (-204414.42, -2261097.49),
                     (-206127.75, -2265687.58), (-208582.80, -2267257.13),
                     (-212634.39, -2267453.75), (-214032.54, -2266061.68),
                     (-213531.16, -2267636.95), (-217945.58, -2267666.15),
                     (-215115.53, -2265059.51), (-217193.14, -2263491.86),
                     (-214550.38, -2261986.07), (-216822.13, -2261319.01),
                     (-215209.17, -2259216.64), (-216623.25, -2256252.21),
                     (-211901.97, -2254552.45), (-210154.13, -2252300.48),
                     (-213334.10, -2250203.26), (-218244.35, -2253210.55),
                     (-222482.34, -2259115.30), (-220239.08, -2258273.50),
                     (-222762.45, -2265021.10), (-228522.05, -2266299.90),
                     (-223615.29, -2262388.87), (-226073.81, -2262131.02),
                     (-229163.33, -2266480.44), (-235125.19, -2268635.06),
                     (-239055.60, -2267516.52), (-240442.73, -2264746.40),
                     (-243871.57, -2263541.08), (-241079.28, -2262483.00),
                     (-242317.73, -2260589.40), (-240179.57, -2260550.65),
                     (-238642.51, -2257061.82), (-236121.35, -2257657.44),
                     (-233383.14, -2255933.50), (-236200.06, -2252936.81),
                     (-237143.57, -2254532.93), (-237250.10, -2250900.88),
                     (-236820.09, -2248447.44), (-234476.31, -2250474.46),
                     (-233413.67, -2247742.74), (-231007.73, -2249862.22),
                     (-232950.52, -2245521.96), (-232758.27, -2243417.01),
                     (-230760.64, -2243540.21), (-230113.32, -2243120.22),
                     (-232214.21, -2242611.58), (-229970.10, -2242302.42),
                     (-231758.08, -2236628.94), (-224015.54, -2234445.12),
                     (-225874.41, -2232823.85), (-225272.27, -2232829.66),
                     (-221610.69, -2237348.33), (-217910.67, -2237936.28),
                     (-213570.91, -2241653.81), (-212789.89, -2240596.56),
                     (-216666.81, -2238124.42), (-216516.78, -2234492.69),
                     (-212638.75, -2233376.81), (-212415.56, -2232064.75),
                     (-208329.36, -2235549.21), (-203531.08, -2231657.25),
                     (-205410.63, -2230413.60), (-207541.87, -2232129.36),
                     (-210047.63, -2231107.19), (-211101.82, -2228284.20),
                     (-214299.71, -2228665.77), (-219367.49, -2234022.64),
                     (-225336.36, -2232622.18), (-223057.28, -2231970.73),
                     (-224366.01, -2230211.36), (-227151.79, -2230494.23),
                     (-229425.74, -2233556.88), (-231076.07, -2232593.68),
                     (-228024.43, -2226769.96), (-224822.89, -2227449.17),
                     (-227435.74, -2226631.40), (-226223.77, -2225064.96),
                     (-228170.75, -2217770.90), (-226559.17, -2215815.41),
                     (-210783.06, -2223580.44), (-211766.42, -2221182.37),
                     (-210540.77, -2220162.41), (-213607.12, -2219296.11),
                     (-211437.05, -2216380.60), (-215362.41, -2217692.42),
                     (-218671.16, -2213113.31), (-224689.50, -2213314.05),
                     (-225796.38, -2209094.31), (-221688.37, -2207401.77),
                     (-216895.38, -2201636.03), (-205642.45, -2205953.73),
                     (-200626.65, -2205160.55), (-205996.52, -2197942.25),
                     (-203827.16, -2193780.68), (-206774.42, -2191284.87),
                     (-207001.25, -2189055.48), (-211778.91, -2188648.99),
                     (-215132.43, -2185343.76), (-212493.14, -2183412.49),
                     (-214184.98, -2181772.88), (-212505.49, -2180515.66),
                     (-200471.18, -2180606.74), (-198600.59, -2178143.22),
                     (-199401.91, -2173411.24), (-205164.71, -2172585.82),
                     (-207802.85, -2173926.57), (-208913.94, -2170571.44),
                     (-210423.05, -2174312.18), (-212822.81, -2173687.44),
                     (-217972.02, -2176732.30), (-223418.04, -2176590.53),
                     (-229173.67, -2180072.16), (-229889.11, -2178419.44),
                     (-235365.75, -2179520.09), (-239345.13, -2178642.18),
                     (-236673.40, -2176142.98), (-233431.64, -2175853.53),
                     (-231734.11, -2171159.27), (-230316.60, -2171307.88),
                     (-228466.76, -2176891.97), (-224192.05, -2173041.05),
                     (-229004.94, -2171646.27), (-228482.85, -2169952.63),
                     (-230764.80, -2167662.90), (-236971.29, -2167268.08),
                     (-242455.73, -2174560.02), (-246974.71, -2177579.37),
                     (-246775.57, -2175965.95), (-248908.42, -2176615.78),
                     (-250821.93, -2175051.79), (-248715.92, -2169096.53),
                     (-252506.39, -2172680.24), (-263420.93, -2170280.68),
                     (-264131.45, -2171304.38), (-269006.83, -2166071.16),
                     (-274652.08, -2166589.33), (-277937.38, -2163788.40),
                     (-279296.19, -2164432.19), (-278759.52, -2162625.46),
                     (-280513.34, -2161865.54), (-280366.79, -2159415.84),
                     (-288814.12, -2144042.62), (-300378.91, -2131373.88),
                     (-317254.37, -2123417.14), (-331883.20, -2119376.31),
                     (-333831.85, -2115943.18), (-336753.93, -2114777.17),
                     (-337008.45, -2111131.75), (-339123.93, -2109845.06),
                     (-337367.01, -2110068.05), (-339832.50, -2109201.81),
                     (-341029.50, -2106101.41), (-340006.04, -2103785.46),
                     (-342745.90, -2098266.59), (-347467.82, -2092362.08),
                     (-350244.03, -2085644.91), (-353155.83, -2085527.68),
                     (-350799.68, -2078464.27), (-332298.25, -2068542.98),
                     (-326486.45, -2070216.36), (-321075.93, -2075476.29),
                     (-315997.47, -2075573.46), (-314868.16, -2077862.53),
                     (-307771.51, -2081298.70), (-296134.53, -2080288.99),
                     (-287281.73, -2083368.34), (-280487.07, -2086596.51),
                     (-269488.22, -2100830.66), (-263883.34, -2103830.52),
                     (-253109.22, -2119371.87), (-247205.39, -2122287.17),
                     (-247366.70, -2124835.32), (-239614.78, -2125780.10),
                     (-234308.26, -2130577.49), (-230400.02, -2131532.68),
                     (-226956.37, -2136362.42), (-222128.13, -2136197.54),
                     (-214939.54, -2141104.13), (-208266.37, -2141101.72),
                     (-207981.31, -2137258.97), (-210163.22, -2132554.99),
                     (-212115.97, -2134163.56), (-213374.25, -2132787.74),
                     (-208606.64, -2127665.15), (-209672.85, -2126093.77),
                     (-205088.67, -2121678.96), (-206096.54, -2118453.17),
                     (-210566.22, -2122050.22), (-211269.11, -2125754.36),
                     (-213131.85, -2126046.51), (-215259.59, -2129845.59),
                     (-221506.77, -2129501.07), (-225821.62, -2127748.97),
                     (-227697.18, -2124488.89), (-222529.67, -2125847.41),
                     (-222310.87, -2122676.68), (-225840.02, -2118943.17),
                     (-231325.83, -2119525.69), (-232483.82, -2114622.91),
                     (-235156.45, -2111737.45), (-228621.86, -2106215.31),
                     (-229739.18, -2107948.83), (-228553.56, -2111545.91),
                     (-219865.38, -2118469.45), (-219565.32, -2120790.80),
                     (-218055.98, -2118001.36), (-219503.61, -2117477.81),
                     (-218056.06, -2115682.33), (-220156.63, -2114432.30),
                     (-219500.11, -2112813.04), (-215640.06, -2117481.75),
                     (-213347.34, -2117178.85), (-217989.71, -2111511.61),
                     (-216426.39, -2108613.91), (-220097.95, -2110332.18),
                     (-222615.12, -2108278.59), (-218944.92, -2103714.41),
                     (-214448.73, -2104771.54), (-209069.22, -2109274.05),
                     (-208924.97, -2106132.93), (-212882.24, -2103927.08),
                     (-212763.41, -2102200.81), (-218028.30, -2099890.52),
                     (-225267.00, -2103564.20), (-222005.66, -2090104.76),
                     (-227623.82, -2097822.72), (-234572.05, -2096704.25),
                     (-237125.08, -2092701.81), (-235242.27, -2090039.78),
                     (-230864.90, -2091389.07), (-228549.97, -2090860.58),
                     (-230826.96, -2090620.49), (-229489.91, -2085126.20),
                     (-220562.69, -2088582.74), (-219788.80, -2091391.78),
                     (-212591.99, -2098068.74), (-208485.27, -2098568.00),
                     (-207602.52, -2095147.38), (-211812.33, -2093278.28),
                     (-211003.84, -2088962.50), (-212894.02, -2089151.41),
                     (-216847.58, -2085958.19), (-217438.99, -2083159.35),
                     (-214133.15, -2078155.55), (-218014.24, -2080284.77),
                     (-224908.91, -2080188.39), (-226766.71, -2077463.53),
                     (-225470.41, -2075470.14), (-227562.96, -2076064.51),
                     (-240242.87, -2070237.77), (-241340.83, -2066290.45),
                     (-251215.78, -2058584.24), (-245733.35, -2053778.34),
                     (-238794.08, -2060586.15), (-231401.74, -2063396.10),
                     (-226966.90, -2067421.76), (-223453.72, -2068807.06),
                     (-220227.52, -2067215.21), (-216219.11, -2067967.17),
                     (-214532.16, -2066506.83), (-214422.61, -2063382.04),
                     (-225062.05, -2063449.31), (-234170.07, -2056586.33),
                     (-231449.00, -2054902.13), (-227030.96, -2056911.13),
                     (-226611.64, -2055912.29), (-229686.23, -2054717.19),
                     (-230470.79, -2051319.06), (-225416.88, -2049994.40),
                     (-223118.65, -2053408.13), (-224817.22, -2050000.97),
                     (-220351.37, -2049403.23), (-221119.49, -2048300.01),
                     (-231103.97, -2049195.44), (-236412.99, -2051577.45),
                     (-245181.89, -2047221.64), (-253442.85, -2051018.01),
                     (-258058.18, -2049269.97), (-259499.68, -2047102.71),
                     (-258925.28, -2044791.33), (-253061.48, -2041499.69),
                     (-252479.13, -2038704.92), (-245356.55, -2034032.76),
                     (-232374.55, -2036062.43), (-230592.55, -2033793.77),
                     (-232780.99, -2032877.64), (-232630.01, -2030637.20),
                     (-230899.22, -2029391.68), (-238026.91, -2025497.35),
                     (-235776.66, -2022308.89), (-242045.87, -2024615.85),
                     (-250687.66, -2033667.09), (-255421.87, -2035478.92),
                     (-258469.71, -2039696.79), (-262086.40, -2039856.25),
                     (-264565.84, -2042749.48), (-269095.13, -2041681.13),
                     (-269386.97, -2037849.63), (-267486.04, -2035024.21),
                     (-261980.95, -2034296.52), (-258059.05, -2029514.36),
                     (-257787.59, -2020376.20), (-246091.61, -2014021.71),
                     (-232663.75, -2012573.78), (-232754.72, -2013976.96),
                     (-230983.12, -2013150.93), (-226021.92, -2014830.88),
                     (-226399.91, -2012376.94), (-223608.31, -2010889.32),
                     (-231881.06, -2006248.49), (-238362.32, -2007076.18),
                     (-246318.81, -2009701.33), (-257165.03, -2016130.36),
                     (-264921.43, -2017103.96), (-270714.35, -2016273.00),
                     (-282141.60, -2010041.43), (-269912.78, -2000185.36),
                     (-263321.26, -1997790.17), (-255033.86, -1996074.76),
                     (-246859.15, -1997028.37), (-233849.50, -1993755.72),
                     (-232480.66, -1991881.94), (-234414.19, -1991198.91),
                     (-234161.11, -1989883.64), (-230705.64, -1983572.40),
                     (-231895.97, -1980118.17), (-236418.47, -1980345.30),
                     (-240645.12, -1988342.64), (-251809.69, -1991780.42),
                     (-265017.62, -1988263.51), (-263274.52, -1984483.99),
                     (-258687.85, -1982404.26), (-261995.81, -1981053.70),
                     (-268100.95, -1982656.75), (-287212.19, -1976221.32),
                     (-279941.71, -1969326.04), (-272285.58, -1965067.82),
                     (-270248.46, -1962148.38), (-271880.20, -1961004.26),
                     (-271447.81, -1957087.08), (-263038.39, -1947492.39),
                     (-263698.27, -1945766.23), (-266287.57, -1945863.67),
                     (-270228.62, -1951543.17), (-274090.77, -1953269.95),
                     (-276652.85, -1963375.05), (-281751.37, -1964113.07),
                     (-289606.02, -1968747.09), (-285826.63, -1961024.22),
                     (-287903.66, -1951136.01), (-285890.23, -1939663.92),
                     (-288425.21, -1934331.99), (-294979.24, -1927688.94),
                     (-294607.24, -1911890.10), (-297587.91, -1906897.18),
                     (-295617.38, -1904460.09), (-291270.07, -1906409.15),
                     (-286536.69, -1905292.66), (-294686.59, -1903748.59),
                     (-297777.08, -1904683.39), (-297393.71, -1903500.32),
                     (-298010.91, -1903149.14), (-299555.87, -1906657.45),
                     (-296897.78, -1911870.04), (-298499.79, -1927130.10),
                     (-290345.68, -1939215.10), (-291196.52, -1952464.70),
                     (-289221.10, -1960232.55), (-293168.49, -1966326.48),
                     (-299339.30, -1970669.27), (-302738.35, -1969647.91),
                     (-303012.20, -1967950.29), (-303709.06, -1968859.36),
                     (-306575.06, -1967395.03), (-309302.57, -1968885.13),
                     (-304733.18, -1971485.82), (-303210.62, -1974304.00),
                     (-304114.73, -1980854.58), (-306275.38, -1982505.97),
                     (-310879.11, -1979414.21), (-311853.90, -1974029.50),
                     (-317177.89, -1979168.14), (-316874.04, -1981173.55),
                     (-318389.96, -1982043.97), (-310471.51, -1988216.38),
                     (-313467.31, -2002510.36), (-320549.68, -2003251.07),
                     (-332135.99, -2007867.17), (-338438.27, -2004034.36),
                     (-337790.48, -2006680.22), (-346167.25, -2007122.99),
                     (-349738.60, -2003963.41), (-349356.63, -1997326.63),
                     (-351604.90, -1996432.31), (-354386.38, -1997791.04),
                     (-356124.32, -1996539.59), (-359061.03, -1988725.64),
                     (-359887.00, -1989754.93), (-356546.48, -1999917.94),
                     (-357637.62, -2000964.77), (-365483.65, -1997511.02),
                     (-368044.96, -1993081.77), (-371136.30, -1970499.70),
                     (-368820.77, -1971482.35), (-367174.79, -1970552.71),
                     (-376672.27, -1964863.48), (-376513.27, -1963563.35),
                     (-371164.35, -1957736.56), (-366917.84, -1958082.86),
                     (-364712.10, -1960404.33), (-364309.35, -1956575.83),
                     (-358248.55, -1953131.22), (-353553.71, -1960758.80),
                     (-352940.18, -1959018.41), (-356781.67, -1950918.64),
                     (-355162.82, -1947985.48), (-350088.74, -1945637.38),
                     (-340615.25, -1947430.85), (-333679.75, -1941185.21),
                     (-330296.08, -1940594.53), (-330793.65, -1939447.36),
                     (-325315.17, -1933851.80), (-320143.77, -1917595.81),
                     (-318854.83, -1916766.33), (-315858.14, -1912013.67),
                     (-317537.59, -1912499.65), (-325782.07, -1925818.32),
                     (-328754.30, -1935675.77), (-334730.76, -1938473.38),
                     (-338199.95, -1942291.46), (-351098.90, -1941772.67),
                     (-358239.50, -1933601.15), (-361484.53, -1932916.98),
                     (-360234.97, -1928921.85), (-354062.14, -1926025.86),
                     (-351055.81, -1927703.54), (-349031.59, -1928130.81),
                     (-348011.12, -1927823.85), (-353205.46, -1924714.93),
                     (-353443.77, -1922826.28), (-342001.17, -1915945.02),
                     (-333748.74, -1908796.51), (-331654.14, -1909296.58),
                     (-333846.08, -1905824.04), (-331287.93, -1901238.69),
                     (-331225.56, -1896275.48), (-326418.10, -1898591.14),
                     (-323935.96, -1896973.30), (-326592.84, -1898048.26),
                     (-328741.78, -1896365.69), (-327572.69, -1896881.78),
                     (-327868.32, -1894899.53), (-331024.10, -1894495.94),
                     (-331376.93, -1891295.32), (-328015.55, -1889487.82),
                     (-332136.59, -1889341.58), (-332257.84, -1884976.20),
                     (-332888.67, -1892221.40), (-335488.97, -1891586.53),
                     (-335618.47, -1888289.49), (-335981.70, -1891454.06),
                     (-340678.72, -1895816.15), (-342494.20, -1895780.70),
                     (-343418.95, -1893442.89), (-340070.36, -1892385.18),
                     (-342096.14, -1891494.07), (-342682.18, -1888855.04),
                     (-341624.85, -1881379.96), (-344682.07, -1891063.99),
                     (-344944.22, -1887508.24), (-346301.78, -1890374.86),
                     (-350146.91, -1890083.42), (-353084.13, -1886453.47),
                     (-353158.09, -1882560.27), (-345657.93, -1875408.26),
                     (-344179.20, -1877311.15), (-337598.16, -1880394.58),
                     (-334779.54, -1880061.20), (-328575.09, -1884248.34),
                     (-325504.85, -1884780.03), (-324737.84, -1883610.42),
                     (-321551.16, -1885786.78), (-318482.32, -1884813.02),
                     (-316625.41, -1886984.08), (-316582.82, -1884720.68),
                     (-314750.55, -1884123.30), (-314301.47, -1885287.80),
                     (-313546.53, -1883349.14), (-310531.75, -1884142.78),
                     (-310764.64, -1885799.92), (-308990.50, -1886578.69),
                     (-308848.19, -1884526.12), (-309888.73, -1885073.90),
                     (-311443.25, -1882562.82), (-316425.46, -1883423.69),
                     (-317674.83, -1885098.72), (-323604.68, -1880291.28),
                     (-322353.78, -1870374.62), (-319213.59, -1871527.70),
                     (-316013.35, -1870062.31), (-317035.88, -1868602.98),
                     (-319194.27, -1869652.34), (-323029.77, -1868092.04),
                     (-324068.19, -1864924.37), (-322318.68, -1864512.74),
                     (-324008.07, -1863953.50), (-321886.22, -1862665.70),
                     (-321743.93, -1864460.28), (-319894.74, -1864329.00),
                     (-318394.75, -1859816.72), (-312955.91, -1862957.33),
                     (-318448.16, -1857464.11), (-319046.78, -1856325.55),
                     (-318880.07, -1855811.55), (-309716.07, -1856903.80),
                     (-306371.32, -1855295.05), (-305541.22, -1852940.06),
                     (-303017.68, -1853933.39), (-302216.58, -1851979.92),
                     (-302828.61, -1848506.21), (-305078.10, -1846647.54),
                     (-303947.42, -1844979.46), (-305149.95, -1843862.58),
                     (-303454.96, -1843062.83), (-305598.86, -1842972.56),
                     (-304829.89, -1841267.91), (-306919.68, -1841423.39),
                     (-306739.62, -1839407.45), (-308681.84, -1838722.72),
                     (-307055.38, -1837652.75), (-306887.00, -1834472.37),
                     (-314836.40, -1828805.09), (-313736.80, -1828111.59),
                     (-316215.11, -1828082.08), (-315685.67, -1824611.79),
                     (-319422.20, -1827261.58), (-322532.37, -1825161.19),
                     (-320080.11, -1819972.80), (-322118.68, -1820238.47),
                     (-324879.02, -1824780.91), (-326362.76, -1824828.61),
                     (-326276.19, -1821134.82), (-329499.30, -1820802.91),
                     (-328886.89, -1819818.57), (-327648.60, -1820383.65),
                     (-327550.63, -1820056.18), (-325992.99, -1820068.30),
                     (-325263.55, -1819532.46), (-328385.70, -1819360.45),
                     (-330705.94, -1820907.99), (-332446.11, -1819572.13),
                     (-331215.12, -1818258.22), (-334890.78, -1816239.35),
                     (-342878.92, -1816037.40), (-341404.25, -1814732.47),
                     (-343055.12, -1812909.03), (-339613.04, -1809882.25),
                     (-334019.78, -1812118.57), (-328130.22, -1806388.62),
                     (-328809.92, -1804959.82), (-331399.98, -1806144.71),
                     (-331342.37, -1803139.38), (-328654.73, -1803129.80),
                     (-322130.60, -1807106.41), (-322353.33, -1805625.94),
                     (-320458.86, -1805399.06), (-322762.06, -1805241.02),
                     (-320756.74, -1803470.89), (-323036.48, -1801280.12),
                     (-322633.96, -1799071.08), (-326968.52, -1799111.24),
                     (-329868.58, -1797531.67), (-328611.76, -1795818.22),
                     (-330263.85, -1796941.91), (-330805.49, -1795543.60),
                     (-327951.86, -1791468.48), (-326196.83, -1792041.71),
                     (-323945.90, -1789312.93), (-321432.52, -1789439.28),
                     (-322224.58, -1788405.98), (-324511.84, -1789395.80),
                     (-326299.43, -1789248.24), (-321746.60, -1782590.17),
                     (-318408.59, -1787421.76), (-315948.84, -1786720.54),
                     (-318402.89, -1780149.61), (-321386.82, -1779520.09),
                     (-321263.29, -1777294.83), (-326242.30, -1775318.89),
                     (-328099.08, -1772906.27), (-326831.70, -1768531.64),
                     (-329362.29, -1765915.98), (-327062.78, -1765667.39),
                     (-325363.12, -1768571.84), (-324711.76, -1764936.62),
                     (-329487.21, -1765688.09), (-329492.47, -1758552.31),
                     (-331652.21, -1758737.65), (-332028.38, -1761196.65),
                     (-334126.49, -1757751.92), (-332711.06, -1757878.70),
                     (-334033.44, -1756560.58), (-332301.53, -1755398.04),
                     (-332593.60, -1753778.56), (-337663.76, -1753743.27),
                     (-341377.75, -1749552.87), (-340644.86, -1747659.71),
                     (-339054.27, -1749683.91), (-333574.23, -1747916.45),
                     (-333997.71, -1745966.41), (-339582.62, -1746730.96),
                     (-339326.16, -1744158.85), (-335292.97, -1743024.26),
                     (-336398.63, -1741435.41), (-335246.67, -1737698.25),
                     (-331450.11, -1744558.47), (-327459.51, -1747509.04),
                     (-325848.71, -1743985.21), (-323695.42, -1745779.16),
                     (-322808.57, -1744541.51), (-325354.03, -1743009.05),
                     (-329576.74, -1744566.02), (-330604.63, -1740699.79),
                     (-332527.35, -1739428.36), (-330846.46, -1738572.88),
                     (-332637.46, -1736679.34), (-332085.03, -1730120.78),
                     (-334081.78, -1727160.90), (-327485.46, -1731411.99),
                     (-322807.21, -1729745.56), (-324579.58, -1724888.94),
                     (-326785.24, -1725923.38), (-325379.17, -1722503.04),
                     (-326752.94, -1719262.67), (-328656.21, -1718420.85),
                     (-331359.61, -1721248.63), (-332901.50, -1716960.27),
                     (-336110.27, -1714825.40), (-335541.00, -1712003.32),
                     (-333842.82, -1711470.47), (-335252.19, -1710912.62),
                     (-334727.49, -1709525.08), (-328939.91, -1712187.80),
                     (-330544.06, -1709028.08), (-329453.45, -1707961.74),
                     (-342342.16, -1705201.06), (-340541.86, -1703710.08),
                     (-343430.40, -1701973.92), (-341900.55, -1700944.60),
                     (-337264.44, -1703136.72), (-334037.55, -1702869.48),
                     (-338079.45, -1701407.78), (-335536.06, -1700419.65),
                     (-335073.82, -1698240.98), (-339138.39, -1698791.10),
                     (-336770.11, -1694647.47), (-334289.77, -1695423.46),
                     (-336913.42, -1691435.69), (-332043.14, -1689634.86),
                     (-329256.74, -1681713.04), (-331541.72, -1680612.02),
                     (-335894.70, -1686484.46), (-345388.33, -1690491.80),
                     (-344757.42, -1691591.27), (-360074.66, -1693971.57),
                     (-364089.58, -1691979.89), (-363914.96, -1694409.24),
                     (-368860.92, -1693543.86), (-366633.24, -1689709.75),
                     (-360763.22, -1690972.76), (-362652.88, -1688610.43),
                     (-361826.48, -1687028.42), (-359221.03, -1688461.65),
                     (-355376.90, -1686238.41), (-348584.74, -1686817.38),
                     (-345954.39, -1685963.39), (-345694.18, -1684059.36),
                     (-342864.07, -1685928.05), (-344883.73, -1681869.66),
                     (-335406.99, -1679429.71), (-333806.04, -1681252.31),
                     (-334884.58, -1679411.36), (-333575.51, -1678536.00),
                     (-333756.87, -1678440.34), (-333807.82, -1678544.94),
                     (-334954.67, -1678791.13), (-334937.17, -1678708.01),
                     (-332364.01, -1677712.57), (-335839.69, -1678344.31),
                     (-335423.82, -1674212.57), (-339571.25, -1678013.10),
                     (-342374.01, -1678324.97), (-343377.25, -1677351.00),
                     (-341175.52, -1676749.99), (-340679.92, -1673601.18),
                     (-342744.48, -1674099.43), (-346556.18, -1670481.61),
                     (-340924.30, -1670408.64), (-332495.84, -1673579.84),
                     (-335341.22, -1671621.40), (-328127.94, -1671604.10),
                     (-327521.52, -1668883.21), (-332200.97, -1665262.28),
                     (-330916.11, -1662599.38), (-332370.09, -1664362.66),
                     (-332341.83, -1665987.00), (-336574.31, -1666466.36),
                     (-336011.96, -1665173.62), (-337548.17, -1664297.08),
                     (-340854.28, -1665600.72), (-346479.57, -1658459.32),
                     (-339056.01, -1660745.81), (-329564.44, -1658940.11),
                     (-326620.93, -1660945.93), (-325641.20, -1658360.75),
                     (-329196.29, -1656253.57), (-325469.62, -1650624.72),
                     (-332520.25, -1651158.70), (-337317.64, -1644600.74),
                     (-336829.01, -1642975.97), (-333663.99, -1643388.83),
                     (-330687.73, -1638641.28), (-336782.88, -1638826.69),
                     (-340579.91, -1637055.66), (-337889.92, -1635559.98),
                     (-332568.77, -1637203.14), (-333729.72, -1635833.87),
                     (-331897.03, -1633747.92), (-332183.05, -1631286.20),
                     (-335455.67, -1628848.58), (-333604.41, -1627515.65),
                     (-333489.96, -1620016.62), (-335444.70, -1618088.14),
                     (-337681.51, -1620406.04), (-338593.53, -1613624.49),
                     (-342470.84, -1614669.57), (-340467.77, -1612426.94),
                     (-341750.60, -1606870.73), (-344226.95, -1607377.85),
                     (-346478.81, -1605336.30), (-348643.57, -1607574.84),
                     (-350187.73, -1606584.18), (-350558.46, -1604406.24),
                     (-348970.82, -1602758.23), (-351397.73, -1602673.31),
                     (-350731.59, -1598730.79), (-354923.49, -1598155.13),
                     (-353720.48, -1596024.64), (-356787.22, -1592702.20),
                     (-361786.05, -1590559.61), (-363011.47, -1584545.50),
                     (-364547.43, -1583575.66), (-366102.70, -1585017.81),
                     (-368626.17, -1581948.96), (-365851.81, -1582880.41),
                     (-368238.88, -1580334.31), (-367022.08, -1579213.46),
                     (-362985.87, -1582914.50), (-360306.62, -1581327.10),
                     (-360388.02, -1573180.89), (-355941.79, -1568597.77),
                     (-362547.62, -1565835.80), (-362246.45, -1562033.05),
                     (-364362.13, -1559530.67), (-368858.49, -1560594.12),
                     (-370982.12, -1557209.10), (-369241.28, -1554304.15),
                     (-366335.27, -1557004.45), (-367018.26, -1555065.75),
                     (-365826.85, -1554399.06), (-367681.19, -1553458.23),
                     (-367667.94, -1550903.28), (-366534.74, -1549162.14),
                     (-362928.43, -1549500.14), (-363344.73, -1547140.95),
                     (-367787.17, -1546681.31), (-372834.85, -1551884.22),
                     (-377087.53, -1550329.71), (-373672.83, -1546115.55),
                     (-368204.74, -1545270.99), (-366263.46, -1543040.98),
                     (-357904.65, -1544138.32), (-361331.38, -1540529.71),
                     (-358268.87, -1534441.76), (-360304.90, -1530539.31),
                     (-363892.36, -1528089.59), (-357488.55, -1519546.40),
                     (-359378.76, -1518309.41), (-361007.53, -1519886.40),
                     (-361641.48, -1518416.43), (-364051.67, -1519883.88),
                     (-366045.99, -1516714.68), (-364025.91, -1513842.98),
                     (-360624.10, -1514682.82), (-359099.29, -1513229.08),
                     (-366184.66, -1507811.05), (-370883.87, -1510825.08),
                     (-374948.80, -1508644.10), (-376360.07, -1506542.65),
                     (-375099.45, -1505657.10), (-375820.13, -1502236.76),
                     (-378752.95, -1500547.67), (-378586.90, -1496777.11),
                     (-380291.15, -1496958.66), (-375797.97, -1495185.32),
                     (-375520.75, -1491431.92), (-378761.09, -1489533.68),
                     (-380781.20, -1490120.23), (-380547.69, -1488490.55),
                     (-386817.74, -1490422.68), (-389283.16, -1494832.96),
                     (-389907.83, -1492518.16), (-391895.30, -1495767.58),
                     (-393769.29, -1494863.78), (-393908.26, -1491488.98),
                     (-390916.63, -1487305.93), (-385238.26, -1484240.77),
                     (-387529.82, -1481173.78), (-383879.84, -1482044.80),
                     (-382260.15, -1479957.29), (-382829.92, -1476330.99),
                     (-385670.38, -1475399.89), (-387352.64, -1477360.76),
                     (-390574.63, -1477026.54), (-393842.04, -1474421.22),
                     (-396452.43, -1475504.78), (-397545.62, -1472407.03),
                     (-393573.09, -1471186.20), (-392092.85, -1467893.09),
                     (-394672.36, -1465436.02), (-397280.86, -1467817.53),
                     (-396189.87, -1464424.76), (-398012.05, -1462525.74),
                     (-403696.64, -1465602.26), (-404071.74, -1461192.72),
                     (-408016.12, -1464741.66), (-412321.68, -1462536.39),
                     (-413524.12, -1460660.70), (-412098.48, -1457601.35),
                     (-414643.50, -1457466.96), (-408367.39, -1449163.04),
                     (-410692.41, -1447255.65), (-418695.43, -1449120.53),
                     (-412610.91, -1444174.07), (-414646.42, -1441338.06),
                     (-417995.57, -1440675.88), (-418987.84, -1438258.75),
                     (-421311.68, -1439351.36), (-424483.58, -1436574.87),
                     (-427593.99, -1442446.76), (-432283.91, -1442357.96),
                     (-427870.65, -1437941.17), (-434327.18, -1438287.93),
                     (-434208.33, -1430812.95), (-438585.05, -1430581.01),
                     (-438801.56, -1427812.74), (-441257.33, -1425009.87),
                     (-446507.62, -1429101.64), (-449069.55, -1427089.64),
                     (-449630.53, -1423768.07), (-451997.52, -1423027.23),
                     (-452641.59, -1426418.17), (-455255.74, -1425067.13),
                     (-456176.12, -1431080.43), (-457257.62, -1431776.60),
                     (-456447.34, -1429281.61), (-458270.25, -1426447.39),
                     (-455552.76, -1420330.14), (-455649.65, -1415109.91),
                     (-457923.25, -1412971.86), (-456998.01, -1407188.84),
                     (-459171.02, -1407620.88), (-460643.88, -1411193.93),
                     (-460864.48, -1408694.96), (-464477.52, -1410965.77),
                     (-463682.32, -1404293.22), (-469707.19, -1404735.62),
                     (-470689.93, -1412883.41), (-475665.39, -1415542.91),
                     (-477785.12, -1421056.68), (-480902.70, -1421745.45),
                     (-481367.10, -1424987.20), (-483942.86, -1427099.55),
                     (-485984.68, -1425991.41), (-490105.98, -1427722.34),
                     (-491929.30, -1426433.88), (-491334.57, -1429003.31),
                     (-492010.43, -1429402.87), (-493374.07, -1424797.80),
                     (-491850.93, -1414228.79), (-489893.26, -1411296.20),
                     (-489398.94, -1405400.00), (-487905.07, -1404544.62),
                     (-489909.57, -1403897.61), (-490551.92, -1401306.97),
                     (-492734.52, -1400995.14), (-493674.76, -1405876.43),
                     (-495991.15, -1406331.50), (-497208.01, -1408619.33),
                     (-495100.35, -1406902.67), (-494743.02, -1409746.57),
                     (-497503.55, -1411473.41), (-498261.47, -1414162.15),
                     (-498430.83, -1412145.66), (-500919.39, -1411452.49),
                     (-500723.33, -1407575.72), (-502910.95, -1406835.11),
                     (-504890.83, -1413227.38), (-502564.21, -1417497.47),
                     (-503986.72, -1418966.19), (-504426.13, -1415695.49),
                     (-505673.73, -1415539.64), (-505697.64, -1422496.08),
                     (-508834.09, -1421887.12), (-508627.14, -1415727.84),
                     (-511676.92, -1413516.38), (-514695.43, -1414517.35),
                     (-514214.73, -1421462.07), (-516674.46, -1419863.68),
                     (-515463.04, -1420583.27), (-515108.80, -1417776.93),
                     (-519669.89, -1419093.04), (-520387.72, -1416497.45),
                     (-518717.01, -1415002.46), (-518480.09, -1411010.46),
                     (-521765.64, -1410678.50), (-524260.53, -1415884.07),
                     (-524102.78, -1421778.97), (-527178.01, -1422486.30),
                     (-527981.14, -1425975.98), (-530735.63, -1426139.74),
                     (-534415.50, -1423555.94), (-538897.62, -1413793.10),
                     (-534487.10, -1411999.80), (-532221.58, -1408594.99),
                     (-532773.70, -1406789.41), (-529859.71, -1406810.72),
                     (-532134.34, -1405463.34), (-530947.71, -1403726.62),
                     (-523734.69, -1403194.78), (-524757.87, -1400493.61),
                     (-523282.02, -1396499.51), (-528811.25, -1391468.30),
                     (-533314.65, -1395339.92), (-536988.17, -1394694.13),
                     (-539270.33, -1392303.45), (-540921.86, -1396992.52),
                     (-543350.12, -1399231.26), (-545010.70, -1398248.09),
                     (-544739.79, -1399995.22), (-546217.82, -1399029.55),
                     (-549921.56, -1402800.15), (-548777.77, -1404963.58),
                     (-550065.01, -1408976.02), (-552519.40, -1410211.18),
                     (-557036.93, -1399132.60), (-553171.66, -1395330.45),
                     (-556345.53, -1392830.29), (-556218.82, -1387870.93),
                     (-558735.82, -1385781.24), (-561021.62, -1387524.26),
                     (-563010.79, -1386528.33), (-564610.42, -1388701.43),
                     (-563268.04, -1391333.23), (-568707.90, -1390393.88),
                     (-570811.26, -1393374.88), (-565225.84, -1399158.24),
                     (-565783.72, -1402992.09), (-567654.39, -1402966.15),
                     (-568821.60, -1405149.65), (-565596.03, -1408078.06),
                     (-562228.39, -1414749.28), (-559552.03, -1426673.75),
                     (-561030.23, -1427859.93), (-563992.28, -1424949.09),
                     (-562566.54, -1423431.58), (-577369.88, -1410288.16),
                     (-577300.94, -1408573.82), (-595457.44, -1395907.57),
                     (-599123.62, -1390442.99), (-601269.30, -1391019.07),
                     (-603527.93, -1389122.98), (-604531.82, -1384545.24),
                     (-599742.58, -1384171.55), (-599084.08, -1382518.25),
                     (-607715.75, -1378276.06), (-604673.51, -1376650.32),
                     (-608053.83, -1371611.29), (-605466.79, -1368497.60),
                     (-608131.61, -1366757.69), (-607978.98, -1364001.35),
                     (-615311.83, -1355023.93), (-617770.16, -1348032.65),
                     (-615155.68, -1343302.48), (-612614.78, -1342009.75),
                     (-608878.01, -1343728.77), (-599365.12, -1343551.63),
                     (-592352.63, -1340864.68), (-592532.20, -1338868.01),
                     (-589540.44, -1338559.19), (-592229.35, -1336852.48),
                     (-588451.48, -1337302.10), (-586741.89, -1335974.43),
                     (-580210.74, -1340640.78), (-577646.70, -1339803.70),
                     (-568836.47, -1345122.30), (-565925.89, -1339337.95),
                     (-568653.24, -1336119.26), (-563977.38, -1334036.40),
                     (-565912.58, -1330285.13), (-569334.63, -1331307.97),
                     (-580524.44, -1329979.65), (-595236.40, -1321255.12),
                     (-596344.12, -1317274.38), (-607968.75, -1304657.48),
                     (-606815.82, -1298836.51), (-600075.97, -1296104.12),
                     (-595296.85, -1290198.08), (-589863.21, -1286930.93),
                     (-589180.76, -1283364.95), (-610870.10, -1296783.02),
                     (-617261.07, -1297491.53), (-619462.28, -1294378.19),
                     (-620479.60, -1295764.47), (-623114.52, -1288191.58),
                     (-621352.13, -1288917.14), (-621294.26, -1286518.60),
                     (-623216.58, -1285876.21), (-624080.01, -1282207.90),
                     (-623271.48, -1281049.54), (-620333.55, -1283265.58),
                     (-620206.35, -1281605.30), (-615189.25, -1282186.64),
                     (-614449.18, -1280492.90), (-618876.08, -1280342.95),
                     (-621488.43, -1273823.67), (-624496.24, -1274720.51),
                     (-624242.67, -1277073.27), (-624661.38, -1276395.93),
                     (-627367.53, -1266138.31), (-623702.55, -1260780.47),
                     (-620470.89, -1261579.70), (-616486.88, -1256089.31),
                     (-611870.24, -1256738.71), (-605929.54, -1260245.36),
                     (-605749.07, -1258550.72), (-609217.96, -1254642.67),
                     (-608101.28, -1253239.63), (-589811.43, -1256017.06),
                     (-580072.23, -1261262.57), (-578591.14, -1264405.02),
                     (-574182.31, -1264897.55), (-555678.18, -1280061.87),
                     (-546408.28, -1283542.15), (-544559.67, -1282005.02),
                     (-539107.27, -1283249.08), (-522149.32, -1298944.80),
                     (-512715.18, -1301350.35), (-510519.47, -1305836.28),
                     (-509273.29, -1305636.78), (-510364.98, -1301132.61),
                     (-502650.89, -1300836.70), (-501892.12, -1298685.62),
                     (-519767.71, -1297955.36), (-537586.41, -1281964.82),
                     (-543328.42, -1279579.90), (-546541.12, -1280327.14),
                     (-554903.09, -1275426.90), (-563423.95, -1266823.20),
                     (-564954.89, -1263275.31), (-543709.45, -1260874.26),
                     (-540720.46, -1262969.73), (-522069.34, -1268214.30),
                     (-508469.04, -1277367.66), (-506941.60, -1286825.81),
                     (-500810.03, -1292429.89), (-499015.14, -1290777.52),
                     (-504822.58, -1283101.29), (-504146.23, -1271938.02),
                     (-499637.98, -1270913.15), (-495129.93, -1274216.57),
                     (-490368.22, -1274394.04), (-488617.70, -1271663.18),
                     (-489465.79, -1269910.15), (-487363.03, -1268643.68),
                     (-487924.57, -1264567.38), (-489709.33, -1263358.90),
                     (-489071.44, -1260728.51), (-487217.46, -1259843.38),
                     (-489833.84, -1258785.42), (-486628.11, -1257148.04),
                     (-486945.04, -1253708.02), (-492569.72, -1249975.48),
                     (-492038.18, -1241480.42), (-493153.75, -1240410.91),
                     (-496461.40, -1243146.79), (-499924.30, -1242737.74),
                     (-500685.94, -1240961.14), (-502785.87, -1242425.77),
                     (-503491.99, -1241081.64), (-505490.43, -1241517.25),
                     (-504602.71, -1243687.18), (-508971.88, -1249765.64),
                     (-517808.55, -1252743.16), (-523656.08, -1252583.12),
                     (-526671.49, -1249738.84), (-527910.12, -1250901.43),
                     (-538454.31, -1247099.60), (-535801.72, -1239245.16),
                     (-536750.82, -1229062.89), (-538796.61, -1227229.75),
                     (-541864.58, -1228646.95), (-540649.21, -1238129.12),
                     (-543324.46, -1244381.78), (-558312.62, -1244401.78),
                     (-560973.46, -1241915.67), (-567629.59, -1231000.64),
                     (-570160.48, -1230562.28), (-570203.24, -1228321.38),
                     (-573146.22, -1227637.78), (-577039.09, -1222042.03),
                     (-554859.91, -1218745.75), (-550279.39, -1211217.87),
                     (-559080.72, -1214976.75), (-564549.61, -1213367.12),
                     (-567411.01, -1214496.14), (-573614.47, -1212128.76),
                     (-579212.33, -1207304.04), (-579239.88, -1204550.61),
                     (-570075.64, -1202543.28), (-563277.85, -1198010.19),
                     (-556746.22, -1199911.53), (-557236.65, -1196752.79),
                     (-563474.97, -1194262.96), (-564315.81, -1192097.27),
                     (-574342.88, -1197484.86), (-587807.13, -1193684.50),
                     (-590020.71, -1187459.05), (-581673.43, -1184262.78),
                     (-581202.81, -1182724.68), (-582091.57, -1180740.01),
                     (-587989.73, -1181536.99), (-590934.40, -1180313.12),
                     (-587308.73, -1174215.30), (-587944.47, -1172952.15),
                     (-590131.45, -1172067.39), (-594450.82, -1174471.72),
                     (-596262.93, -1173249.39), (-595925.49, -1168764.67),
                     (-599727.46, -1165898.66), (-597732.43, -1163078.51),
                     (-598202.57, -1158517.45), (-594485.98, -1156657.73),
                     (-596555.59, -1152997.84), (-600809.33, -1150917.89),
                     (-601405.01, -1140026.51), (-604232.61, -1135137.98),
                     (-598861.59, -1138299.77), (-595582.14, -1137478.54),
                     (-596703.32, -1132091.91), (-593490.61, -1131749.67),
                     (-595364.44, -1129992.05), (-591805.37, -1131203.12),
                     (-590950.64, -1127117.48), (-584798.94, -1129985.15),
                     (-593053.07, -1122456.04), (-590724.87, -1122248.97),
                     (-590773.54, -1120850.69), (-589812.96, -1121645.73),
                     (-591079.69, -1119255.45), (-589117.47, -1119823.46),
                     (-588845.44, -1118623.98), (-587756.56, -1120315.95),
                     (-586312.99, -1118761.59), (-587633.98, -1118032.45),
                     (-585796.83, -1118817.06), (-580740.51, -1116588.77),
                     (-579474.49, -1115286.53), (-580060.66, -1111660.00),
                     (-576223.59, -1111098.77), (-574921.88, -1109174.23),
                     (-576244.61, -1108357.69), (-573396.85, -1108094.91),
                     (-574466.42, -1107137.36), (-572735.14, -1106488.69),
                     (-559444.63, -1111005.51), (-552626.86, -1107284.77),
                     (-544151.10, -1108257.96), (-537809.26, -1115428.80),
                     (-538287.06, -1116499.95), (-537810.32, -1116528.16),
                     (-537975.70, -1117036.04), (-537978.02, -1117544.73),
                     (-537897.35, -1117683.11), (-534195.80, -1109357.68),
                     (-530497.94, -1107471.09), (-515025.44, -1108257.73),
                     (-515818.96, -1105347.95), (-511071.00, -1104343.01),
                     (-502810.86, -1108262.68), (-501223.94, -1107692.13),
                     (-501788.28, -1108340.89), (-501278.86, -1110879.52),
                     (-499798.38, -1108401.43), (-498002.14, -1108854.84),
                     (-498022.56, -1106591.99), (-494642.53, -1105623.92),
                     (-493254.92, -1102740.06), (-493395.26, -1106146.95),
                     (-490250.97, -1106999.53), (-490722.59, -1108745.41),
                     (-488060.11, -1113312.01), (-489378.24, -1107509.92),
                     (-488259.92, -1103727.77), (-492618.10, -1098948.58),
                     (-490824.79, -1096464.68), (-481680.04, -1093064.91),
                     (-475211.42, -1091331.25), (-466202.65, -1091515.76),
                     (-461189.64, -1095905.05), (-454637.85, -1092841.61),
                     (-452461.50, -1094336.31), (-452622.07, -1091846.15),
                     (-450921.75, -1090789.91), (-449043.96, -1093310.14),
                     (-443188.95, -1091458.29), (-442438.77, -1094398.38),
                     (-438745.24, -1094840.50), (-439503.83, -1096635.13),
                     (-437917.28, -1097041.39), (-436650.54, -1095072.29),
                     (-436980.41, -1096640.49), (-435801.00, -1095609.79),
                     (-436181.89, -1097140.30), (-432562.47, -1097527.67),
                     (-431411.07, -1100011.10), (-428363.42, -1101016.91),
                     (-428750.05, -1102282.97), (-424869.69, -1103620.07),
                     (-417507.98, -1097703.36), (-413403.69, -1096468.49),
                     (-412176.81, -1093314.36), (-409110.83, -1093069.93),
                     (-408378.48, -1090339.63), (-404749.68, -1087026.10),
                     (-397443.19, -1083654.52), (-392333.56, -1075374.85),
                     (-385024.00, -1072776.80), (-381448.57, -1068222.55),
                     (-369902.03, -1060135.45), (-367193.98, -1051264.08),
                     (-374002.32, -1043898.79), (-372765.45, -1039682.47),
                     (-364468.55, -1036413.13), (-360664.05, -1036594.44),
                     (-359778.31, -1036338.45), (-361642.03, -1035856.61),
                     (-360407.23, -1032385.14), (-364015.41, -1026008.43),
                     (-371003.86, -1023137.84), (-372648.77, -1021476.14),
                     (-372279.52, -1019249.04), (-357262.42, -1017738.54),
                     (-350651.27, -1011579.59), (-346862.98, -1013956.82),
                     (-344287.60, -1013167.78), (-350839.65, -1008418.81),
                     (-347645.34, -998703.86) , (-344351.76, -995735.72) ,
                     (-347116.69, -997263.87) , (-347169.47, -992923.25) ,
                     (-350338.75, -1003380.66), (-354618.52, -1010867.01),
                     (-358538.57, -1014168.43), (-363248.79, -1013003.50),
                     (-367096.73, -1014560.22), (-371637.26, -1011042.71),
                     (-371656.93, -1007249.19), (-379229.58, -1012331.19),
                     (-385158.03, -1014160.26), (-388962.72, -1012707.13),
                     (-388846.43, -1008804.86), (-391632.12, -1001462.66),
                     (-397568.96, -1003006.27), (-405315.99, -1000830.24),
                     (-403758.00, -992763.09) , (-402020.30, -992229.32) ,
                     (-406903.97, -985852.62) , (-406821.87, -983276.00) ,
                     (-400093.06, -970830.12) , (-401369.16, -970684.51) ,
                     (-400591.10, -968718.14) , (-389920.76, -965392.58) ,
                     (-383531.19, -961602.70) , (-379416.36, -957265.14) ,
                     (-381677.80, -955813.87) , (-380884.49, -953875.60) ,
                     (-378158.94, -952214.33) , (-374209.25, -954309.78) ,
                     (-367215.81, -949361.33) , (-365443.49, -945509.68) ,
                     (-356151.79, -949304.47) , (-354750.76, -954679.29) ,
                     (-353961.28, -951786.39) , (-358294.79, -946842.98) ,
                     (-358201.42, -943217.73) , (-349907.90, -940117.88) ,
                     (-347390.32, -940572.62) , (-342934.66, -935530.80) ,
                     (-341441.39, -928862.62) , (-335090.14, -927467.34) ,
                     (-334955.20, -921805.39) , (-322016.44, -918685.71) ,
                     (-315096.89, -910984.68) , (-313503.93, -912033.33) ,
                     (-312799.92, -916054.77) , (-314401.54, -928268.69) ,
                     (-316792.82, -930872.42) , (-314781.36, -930976.33) ,
                     (-315489.96, -934855.87) , (-313736.43, -935277.53) ,
                     (-314356.93, -939528.23) , (-312801.45, -942128.73) ,
                     (-315190.91, -944523.52) , (-312311.38, -942728.09) ,
                     (-314387.75, -948029.65) , (-311290.99, -953132.63) ,
                     (-311491.90, -940583.59) , (-310108.59, -940714.59) ,
                     (-312644.45, -928956.16) , (-310446.52, -911282.89) ,
                     (-303129.48, -905745.00) , (-302039.23, -907425.91) ,
                     (-300038.61, -906274.90) , (-297909.24, -909717.67) ,
                     (-292044.19, -912234.61) , (-288820.22, -921603.19) ,
                     (-287291.72, -921951.38) , (-288213.07, -922358.31) ,
                     (-285074.18, -927714.79) , (-286116.62, -929129.66) ,
                     (-284156.71, -948731.10) , (-282987.50, -944995.47) ,
                     (-276332.65, -948929.77) , (-266830.26, -943906.88) ,
                     (-266496.80, -936119.82) , (-272925.11, -915712.20) ,
                     (-271400.14, -902340.68) , (-272816.44, -899331.10) ,
                     (-259665.19, -885917.34) , (-259308.77, -883383.61) ,
                     (-262109.34, -878853.57) , (-260796.93, -876835.42) ,
                     (-261647.79, -858249.00) , (-256884.56, -852503.44) ,
                     (-250639.00, -848869.18) , (-238633.52, -844942.51) ,
                     (-223794.42, -855884.18) , (-222229.43, -866938.96) ,
                     (-224496.29, -872142.77) , (-224138.21, -875841.16) ,
                     (-213347.28, -891531.89) , (-214556.21, -887555.12) ,
                     (-211956.78, -888315.05) , (-210020.55, -893117.00) ,
                     (-210950.85, -895926.24) , (-207006.02, -904095.67) ,
                     (-208900.13, -905661.44) , (-210757.38, -904981.78) ,
                     (-209527.88, -908273.26) , (-202342.38, -914314.51) ,
                     (-200009.54, -929224.25) , (-198017.62, -931734.91) ,
                     (-200541.65, -924360.64) , (-200016.96, -919276.91) ,
                     (-198852.37, -920220.00) , (-200657.07, -913201.80) ,
                     (-206566.31, -906554.85) , (-205574.40, -898142.01) ,
                     (-209569.73, -888058.76) , (-212842.50, -885786.24) ,
                     (-213397.28, -882883.91) , (-216770.24, -879480.13) ,
                     (-217714.92, -855113.16) , (-229491.68, -839640.89) ,
                     (-212182.33, -830143.92) , (-181080.79, -826005.34) ,
                     (-179287.94, -834689.10) , (-174138.30, -824975.09) ,
                     (-170602.10, -823514.40) , (-165967.72, -828313.00) ,
                     (-161584.17, -828318.78) , (-161910.12, -830062.19) ,
                     (-162981.88, -829413.81) , (-163819.90, -831663.54) ,
                     (-165161.53, -831574.74) , (-164151.43, -837740.27) ,
                     (-162994.53, -835114.88) , (-161194.78, -835847.80) ,
                     (-162199.84, -832564.75) , (-160996.82, -827501.41) ,
                     (-161435.11, -824371.76) , (-165805.20, -822976.21) ,
                     (-147511.84, -817935.25) , (-143592.62, -825542.48) ,
                     (-140948.66, -848383.75) , (-143353.40, -853037.99) ,
                     (-145046.16, -873063.90) , (-147845.78, -877634.28) ,
                     (-148085.77, -880608.32) , (-146946.57, -880396.72) ,
                     (-152150.96, -886887.22) , (-153153.00, -890688.54) ,
                     (-157738.68, -892836.38) , (-156476.98, -895373.47) ,
                     (-154667.81, -894802.28) , (-155995.17, -897022.83) ,
                     (-155774.84, -903504.88) , (-153520.59, -903362.91) ,
                     (-154968.82, -900185.05) , (-153370.93, -895258.22) ,
                     (-151425.00, -897672.54) , (-137933.77, -880680.97) ,
                     (-134721.09, -861700.47) , (-132775.10, -859653.89) ,
                     (-130088.29, -859979.89) , (-129343.20, -863049.85) ,
                     (-122733.68, -869317.67) , (-119781.15, -875144.40) ,
                     (-113208.64, -878324.51) , (-111018.77, -886625.79) ,
                     (-106398.78, -889262.10) , (-104383.69, -899920.49) ,
                     (-100338.18, -903576.29) , (-99639.19, -911505.57)  ,
                     (-95600.03, -918731.15)  , (-91819.49, -919557.08)  ,
                     (-93372.07, -917723.51)  , (-91089.44, -915275.05) ,
                     (-90615.72, -915193.39)  , (-89793.98, -915617.35)  ,
                     (-89380.75, -915616.62) , (-95465.20, -911297.57)  ,
                     (-95722.43, -902697.94)  , (-101816.98, -896903.89) ,
                     (-103037.29, -887967.59) , (-106736.94, -883515.70) ,
                     (-108712.22, -875604.05) , (-106903.28, -874765.40) ,
                     (-102480.57, -881976.91) , (-101787.40, -880702.94) ,
                     (-101124.79, -881966.46) , (-101402.48, -879539.74) ,
                     (-94902.40, -882988.25)  , (-92140.98, -886980.67)  ,
                     (-91732.62, -885073.96) , (-88144.57, -883111.20)  ,
                     (-84246.13, -882416.03) , (-83603.80, -883629.78) ,
                     (-85609.13, -877454.30)  , (-91627.75, -867907.12) ,
                     (-98045.66, -849985.88) , (-97267.45, -835433.55)  ,
                     (-95699.73, -833683.00) , (-96078.65, -825609.34) ,
                     (-94920.26, -825276.30)  , (-92932.32, -825082.45) ,
                     (-92363.06, -824949.07) , (-96698.69, -825165.49)  ,
                     (-98144.79, -820709.97) , (-96497.87, -812570.90) ,
                     (-93823.09, -814833.49)  , (-93089.44, -812610.01) ,
                     (-90788.99, -812518.42) , (-78669.48, -814535.42)  ,
                     (-71371.73, -821428.97) , (-67495.90, -828180.43) ,
                     (-65664.82, -837418.09)  , (-54704.39, -847733.79) ,
                     (-51183.01, -853596.77) , (-51383.98, -856530.37)  ,
                     (-47244.73, -858310.02) , (-33976.09, -870183.66) ,
                     (-29712.53, -878392.16)  , (-29521.44, -886785.26) ,
                     (-23636.45, -893457.68) , (-16904.14, -908307.22)  ,
                     (-14237.94, -908959.12) , (-13529.84, -913261.78) ,
                     (-11633.11, -915161.30)  , (-11773.44, -913762.41) ,
                     (-9710.94, -914324.84) , (-8326.48, -914339.67)   ,
                     (-1894.89, -909493.86) , (-7264.93, -901518.41) ,
                     (-6455.27, -898102.68)   , (-11345.22, -886042.51) ,
                     (-9543.10, -886118.87) , (-12190.40, -884419.14)  ,
                     (-12926.92, -880440.25) , (-6595.92, -873086.08) ,
                     (-4046.19, -872356.06)   , (-9803.35, -859370.42) ,
                     (-6134.29, -850468.07) , (-760.66, -845761.22)    ,
                     (3395.63, -845234.29) , (7546.95, -850596.60)    ,
                     (9113.73, -849788.45)    , (13332.52, -852961.38) ,
                     (11489.46, -852700.76)   , (11519.78, -853109.82)   ,
                     (23131.61, -854255.94) , (25204.06, -858840.62)   ,
                     (26900.81, -858152.49)   , (28741.02, -859553.59) ,
                     (29987.48, -858084.30)   , (30809.93, -859561.40)   ,
                     (32380.97, -856763.42) , (34690.35, -856226.42)   ,
                     (32849.74, -853817.74)   , (32924.32, -853680.68) ,
                     (33780.86, -853375.32)   , (34358.28, -852993.96)   ,
                     (28465.46, -855453.22) , (23569.13, -851017.68)   ,
                     (15281.41, -849297.02)   , (7502.92, -844514.91) ,
                     (6321.81, -838193.88)    , (10251.59, -837425.48)   ,
                     (11562.89, -832862.54) , (8854.51, -834704.21)    ,
                     (-860.10, -825688.12)    , (-3512.12, -820066.54) ,
                     (-3525.75, -815164.33)   , (-9623.89, -809903.82)   ,
                     (-10974.04, -803115.29) , (-15327.50, -800883.87)  ,
                     (-20311.66, -790738.16)  , (-17631.47, -789651.98) ,
                     (-13233.79, -790598.97)  , (-11723.94, -789109.27)  ,
                     (-8628.58, -790829.62) , (822.57, -791848.03)     ,
                     (6162.61, -790247.42)    , (23701.73, -789335.84) ,
                     (31673.16, -792214.04)   , (31149.40, -798269.35)   ,
                     (36256.17, -805556.41) , (35812.72, -813739.57)   ,
                     (41082.10, -828354.36)   , (43014.55, -826292.74) ,
                     (38582.35, -813165.16)   , (38850.61, -805054.32)   ,
                     (33824.31, -796174.80) , (35585.84, -792683.05)   ,
                     (41620.06, -794481.54)   , (49317.58, -802607.16) ,
                     (54531.27, -810988.03)   , (61260.82, -811847.96)   ,
                     (65193.51, -820045.50) , (66191.19, -829169.68)   ,
                     (68498.19, -834123.82)   , (72708.81, -836736.55) ,
                     (68207.90, -825492.35)   , (68396.11, -819703.03)   ,
                     (70821.83, -819273.30) , (70554.35, -817521.37)   ,
                     (68014.35, -817095.61)   , (64952.02, -813426.07) ,
                     (63829.44, -809142.21)   , (65591.27, -803755.85)   ,
                     (60835.82, -793806.95) , (56471.92, -792527.99)   ,
                     (52111.60, -794019.25)   , (45865.08, -787466.62) ,
                     (32303.91, -781372.67)   , (23305.86, -780688.81)   ,
                     (2992.25, -783091.34) , (-5029.93, -781925.96)   ,
                     (-10544.90, -773447.23)  , (-8112.39, -769276.45) ,
                     (3935.32, -775274.34)    , (4307.62, -774327.89)    ,
                     (-11512.16, -762529.94) , (-11795.01, -759114.61)  ,
                     (-13740.56, -758538.49)  , (-16854.74, -749886.19) ,
                     (-14786.46, -748332.33)  , (-13963.67, -750916.19)  ,
                     (-11854.26, -747459.22) , (-6248.02, -755609.20)   ,
                     (-4420.58, -755487.45)   , (-7196.72, -747997.67) ,
                     (-3840.29, -746447.94)   , (5405.44, -750320.00)    ,
                     (6259.24, -752242.87) , (7726.02, -749837.00)    ,
                     (12151.28, -750343.65)   , (17274.05, -754792.35) ,
                     (15555.41, -749753.61)   , (10896.35, -746157.38)   ,
                     (6759.51, -745864.40) , (3288.20, -743392.42)    ,
                     (3307.22, -741331.63)    , (524.31, -740530.42) ,
                     (1811.35, -739252.58)    , (10518.79, -741974.86)   ,
                     (16130.62, -741838.27) , (16848.98, -740768.03)   ,
                     (13892.05, -740307.98)   , (14670.25, -738514.05) ,
                     (10359.07, -738868.69)   , (11803.90, -737440.00)   ,
                     (11222.87, -735241.11) , (18322.30, -733115.09)   ,
                     (21653.10, -736082.62)   , (21339.42, -733385.11) ,
                     (23722.11, -732987.19)   , (27737.12, -735821.35)   ,
                     (22668.90, -737438.61) , (26242.30, -737443.35)   ,
                     (31724.93, -742181.86)   , (31190.38, -749480.34) ,
                     (33285.61, -747555.76)   , (38158.32, -750612.87)   ,
                     (49538.73, -764310.07) , (58003.90, -765228.91)   ,
                     (64991.86, -764091.00)   , (69576.92, -769680.04) ,
                     (72216.03, -770476.41)   , (74356.89, -777926.36)   ,
                     (80063.99, -779687.25) , (79828.02, -782786.88)   ,
                     (81148.34, -778996.90)   , (85428.92, -777761.69) ,
                     (85462.57, -775549.20)   , (77072.03, -775802.95)   ,
                     (74764.88, -768907.65) , (69024.16, -761839.78)   ,
                     (70418.55, -757113.04)   , (82607.74, -754920.79) ,
                     (85975.83, -752637.49)   , (95997.79, -755087.67)   ,
                     (87101.30, -750724.26) , (82236.48, -752871.57)   ,
                     (73129.83, -753039.28)   , (72816.54, -749441.77) ,
                     (82283.57, -742218.85)   , (91020.03, -740595.38)   ,
                     (92538.48, -742427.21) , (92456.88, -739806.32)   ,
                     (95649.06, -737776.97)   , (95068.82, -736215.45) ,
                     (86848.73, -738611.03)   , (85472.79, -738095.27)   ,
                     (87139.11, -736514.08) , (83878.08, -736025.77)   ,
                     (82575.66, -733804.53)   , (73055.41, -734910.78) ,
                     (70022.76, -733384.11)   , (67786.97, -730604.59)   ,
                     (70458.50, -722966.64) , (66541.16, -718481.36)   ,
                     (67212.01, -712676.91)   , (64412.59, -708234.73) ,
                     (71170.45, -705690.98)   , (75254.90, -697640.25)   ,
                     (77752.63, -695808.53) , (82730.16, -700293.27)   ,
                     (90094.84, -702932.33)   , (94321.48, -709784.68) ,
                     (100112.70, -712562.69)  , (100569.64, -710965.99)  ,
                     (94160.25, -706019.60) , (96825.88, -706094.83)   ,
                     (98169.46, -703218.83)   , (88517.15, -696629.69) ,
                     (88983.75, -692403.70)   , (97189.40, -687047.00)   ,
                     (104520.30, -685092.36) , (108131.22, -687765.53)  ,
                     (108298.92, -691336.91)  , (109694.31, -690806.90) ,
                     (110829.91, -683918.25)  , (112969.49, -681596.70)  ,
                     (115256.56, -681677.71) , (117360.32, -684567.84)  ,
                     (118102.41, -682219.46)  , (119767.93, -683123.51) ,
                     (125706.91, -690329.02)  , (126724.60, -694946.46)  ,
                     (128477.67, -694478.90) , (127729.22, -689049.98)  ,
                     (123575.54, -685535.98)  , (123624.03, -680631.73) ,
                     (132834.48, -674661.37)  , (138781.40, -673235.91)  ,
                     (144812.81, -674370.70) , (145223.30, -675884.83)  ,
                     (149435.81, -673896.93)  , (156170.35, -674885.39) ,
                     (161134.37, -669309.57)  , (164558.50, -667804.60)  ,
                     (178688.81, -669505.24) , (184183.87, -674393.38)  ,
                     (187396.71, -671827.82)  , (185286.94, -669830.76) ,
                     (189573.33, -668880.74)  , (192166.41, -669722.27)  ,
                     (192091.77, -672633.35) , (187336.65, -674225.00)  ,
                     (194431.70, -679438.31)  , (194822.13, -677387.53) ,
                     (197764.69, -677959.27)  , (199260.19, -675571.25)  ,
                     (197843.26, -674239.16) , (195568.81, -674850.75)  ,
                     (194030.65, -672893.72)  , (195890.15, -672972.74) ,
                     (200936.55, -667726.42)  , (214375.11, -666026.61)  ,
                     (235587.04, -672271.49) , (239864.01, -675619.21)  ,
                     (237244.26, -687432.45)  , (228858.47, -698672.80) ,
                     (218421.31, -704208.60)  , (193752.35, -707640.44)  ,
                     (178723.70, -714658.79) , (175192.06, -722159.99)  ,
                     (171426.12, -724063.39)  , (164302.08, -732394.46) ,
                     (159840.35, -733048.04)  , (153883.73, -729160.98)  ,
                     (140685.61, -726666.43) , (140211.55, -727958.05)  ,
                     (143305.20, -729650.02)  , (152551.78, -730346.01) ,
                     (155960.13, -733508.74)  , (156323.77, -736340.25)  ,
                     (154190.63, -739594.47) , (144420.46, -744933.09)  ,
                     (138580.00, -752707.98)  , (131736.39, -754136.92) ,
                     (119314.93, -760056.89)  , (120216.39, -761256.64)  ,
                     (124505.58, -760813.56) , (122328.66, -765425.03)  ,
                     (124450.92, -769641.35)  , (123282.61, -774578.67) ,
                     (125181.01, -778451.39)  , (126146.66, -769232.83)  ,
                     (124387.99, -766110.51) , (128522.92, -758252.90)  ,
                     (132387.13, -756335.82)  , (141805.27, -755328.48) ,
                     (145934.59, -762197.80)  , (143881.66, -754758.48)  ,
                     (144859.03, -750591.16) , (150759.07, -746175.89)  ,
                     (166641.03, -739336.92)  , (170455.79, -746334.06) ,
                     (171925.95, -746349.32)  , (169264.03, -738450.30)  ,
                     (176930.58, -727723.72) , (176528.69, -725764.48)  ,
                     (182009.42, -724042.57)  , (184278.69, -718382.79) ,
                     (193034.27, -714056.18)  , (207254.19, -711959.75)  ,
                     (212311.48, -712401.04) , (214566.62, -716176.67)  ,
                     (215599.82, -711895.48)  , (235522.29, -707606.29) ,
                     (235589.55, -704811.57)  , (241935.10, -697019.73)  ,
                     (253256.54, -686429.85) , (256653.75, -686373.82)  ,
                     (257689.90, -689016.40)  , (260747.43, -690502.72) ,
                     (259441.22, -693268.94)  , (267390.65, -700874.06)  ,
                     (268540.84, -703871.50) , (268055.50, -716364.01)  ,
                     (264652.77, -720144.21)  , (268479.87, -717881.93) ,
                     (267913.13, -727864.76)  , (265867.74, -732432.03)  ,
                     (261668.27, -734785.93) , (266963.74, -733122.87)  ,
                     (269169.37, -726261.76)  , (274104.89, -719857.16) ,
                     (275670.79, -712082.73)  , (278649.67, -710481.73)  ,
                     (282437.02, -712284.14) , (283846.58, -706688.48)  ,
                     (287530.71, -707590.11)  , (286486.29, -713063.67) ,
                     (290776.72, -716387.90)  , (292654.30, -722938.48)  ,
                     (293894.55, -719981.18) , (292425.36, -713343.28)  ,
                     (294455.47, -712731.78)  , (295310.64, -709924.75) ,
                     (298490.75, -709871.70)  , (302460.12, -712749.90)  ,
                     (302764.01, -715107.69) , (306255.56, -713695.72)  ,
                     (310885.50, -715064.06)  , (310112.19, -711570.71) ,
                     (315754.24, -711971.04)  , (341898.52, -726591.08)  ,
                     (342721.44, -731804.43) , (340173.02, -735084.12)  ,
                     (338893.59, -742335.74)  , (334586.62, -746132.48) ,
                     (332920.26, -750350.96)  , (336385.98, -754269.51)  ,
                     (333606.44, -764154.43) , (325034.40, -772362.16)  ,
                     (318044.98, -775178.26)  , (315660.07, -774674.15) ,
                     (309828.15, -781164.55)  , (305177.19, -791079.98)  ,
                     (298644.27, -797882.14) , (281759.90, -803276.45)  ,
                     (253104.24, -808286.24)  , (242439.30, -813121.34) ,
                     (232149.29, -820206.17)  , (225171.95, -822102.50)  ,
                     (222698.14, -824628.58) , (219798.41, -820453.69)  ,
                     (219009.30, -821940.07)  , (213334.63, -819887.90) ,
                     (199438.89, -823348.88)  , (213603.75, -821879.87)  ,
                     (218641.36, -823171.48) , (220751.36, -826012.72)  ,
                     (219431.03, -826600.06)  , (223502.71, -828411.52) ,
                     (208309.05, -843529.60)  , (208501.46, -845562.75)  ,
                     (205600.16, -846398.67) , (202499.87, -851455.70)  ,
                     (198602.78, -854091.15)  , (188737.38, -866305.84) ,
                     (187498.70, -869668.57)  , (188953.82, -872629.61)  ,
                     (188357.92, -873252.41) , (187031.93, -873386.67)  ,
                     (186711.61, -873466.93)  , (186577.37, -873518.77) ,
                     (186404.03, -873624.58)  , (191960.14, -874841.60)  ,
                     (194855.75, -887489.34) , (195464.07, -885347.21)  ,
                     (201766.69, -882203.97)  , (202904.95, -884815.88) ,
                     (201517.58, -876434.14)  , (209367.43, -861833.48)  ,
                     (232980.94, -842002.00) , (236017.72, -846011.37)  ,
                     (238193.94, -843517.27)  , (238066.90, -840907.50) ,
                     (240412.67, -839226.21)  , (240353.27, -836373.13)  ,
                     (244209.19, -833418.08) , (244859.38, -836225.27)  ,
                     (245268.83, -833932.19)  , (246946.30, -834000.74) ,
                     (245000.41, -832493.44)  , (260607.19, -824422.75)  ,
                     (278848.06, -819328.15) , (280833.21, -817385.80)  ,
                     (303145.72, -813477.63)  , (305252.56, -822470.17) ,
                     (309328.88, -830095.54)  , (309872.51, -838833.14)  ,
                     (303088.66, -851548.53) , (290706.67, -868986.49)  ,
                     (283254.75, -876500.03)  , (278642.74, -873185.32) ,
                     (278135.41, -878819.53)  , (276161.26, -881775.64)  ,
                     (277261.06, -880589.93) , (281378.66, -886039.28)  ,
                     (281271.97, -889651.01)  , (280031.18, -890674.36) ,
                     (278101.19, -892532.54)  , (282448.81, -889214.23)  ,
                     (292711.56, -886144.60) , (297892.10, -881025.75)  ,
                     (301158.08, -871842.18)  , (317006.02, -852486.69) ,
                     (320397.01, -843308.68)  , (326790.64, -837831.77)  ,
                     (331792.04, -836557.53) , (322299.28, -805902.31)  ,
                     (331646.17, -796963.89)  , (346857.98, -789598.86) ,
                     (356758.55, -801414.64)  , (363502.71, -816234.44)  ,
                     (372329.62, -848814.61) , (373092.16, -865717.91)  ,
                     (371193.52, -870209.59)  , (366753.15, -873050.36) ,
                     (369319.17, -872396.19)  , (369113.12, -873938.60)  ,
                     (370840.37, -873411.58) , (371536.27, -875209.59)  ,
                     (370058.02, -880833.19)  , (371255.80, -886766.22) ,
                     (370122.88, -901758.41)  , (366345.07, -918119.75)  ,
                     (371117.95, -924654.65) , (370936.98, -934441.42)  ,
                     (365916.25, -939869.07)  , (369870.83, -936727.31) ,
                     (371436.06, -937518.28)  , (367360.47, -945359.54)  ,
                     (369167.81, -947149.60) , (367558.05, -954747.82)  ,
                     (371584.63, -947025.19)  , (380035.78, -950338.02) ,
                     (382209.77, -948980.87)  , (379504.11, -945920.48)  ,
                     (375715.16, -946684.08) , (373691.28, -943777.03)  ,
                     (376318.96, -932974.00)  , (373072.13, -929645.20) ,
                     (376083.01, -923856.89)  , (372216.47, -915325.10)  ,
                     (377241.41, -910880.18) , (381302.20, -901359.38)  ,
                     (380462.32, -896542.67)  , (381811.49, -888131.19) ,
                     (384620.34, -876029.04)  , (387974.95, -870668.08)  ,
                     (387064.14, -864151.27) , (389063.46, -862468.85)  ,
                     (386816.99, -851673.51)  , (390756.23, -831589.85) ,
                     (394746.46, -826628.57)  , (389581.03, -828136.49)  ,
                     (387132.07, -831008.45) , (387828.44, -824360.05)  ,
                     (383987.10, -820956.53)  , (384434.68, -818412.77) ,
                     (382777.66, -820221.60)  , (382686.13, -818560.57)  ,
                     (384772.81, -816991.04) , (386603.67, -818144.21)  ,
                     (385498.71, -815844.81)  , (386624.44, -815033.06) ,
                     (387505.00, -816812.64)  , (386453.75, -819305.31)  ,
                     (388351.49, -818373.50) , (391040.25, -819949.87)  ,
                     (389641.06, -821370.24)  , (390221.93, -822902.70) ,
                     (396290.18, -818909.92)  , (395254.33, -825257.25)  ,
                     (400839.10, -818097.97) , (399797.60, -824093.07)  ,
                     (397692.60, -823056.38)  , (397334.52, -825470.89) ,
                     (399250.60, -826615.53)  , (401442.54, -834608.05)  ,
                     (403142.77, -834688.91) , (403025.25, -840508.51)  ,
                     (405575.36, -844536.97)  , (408747.78, -833592.12) ,
                     (412735.32, -826129.72)  , (415313.28, -827412.08)  ,
                     (419397.03, -826304.02) , (419972.39, -824682.02)  ,
                     (425748.10, -830913.16)  , (425206.56, -825282.48) ,
                     (431060.45, -830357.50)  , (435003.76, -831099.07)  ,
                     (433864.37, -829668.49) , (436989.93, -825232.35)  ,
                     (431416.38, -816839.22)  , (436969.34, -818697.32) ,
                     (435337.52, -815189.31)  , (436448.48, -811848.72)  ,
                     (432269.78, -809485.60) , (430896.08, -800416.39)  ,
                     (433962.07, -799850.21)  , (437508.69, -802260.25) ,
                     (442683.82, -800737.96)  , (437618.99, -798615.05)  ,
                     (435093.75, -794453.71) , (433099.49, -794585.92)  ,
                     (430062.12, -791564.41)  , (430451.62, -774025.70) ,
                     (432080.30, -771082.01)  , (438910.28, -772587.85)  ,
                     (443900.27, -771150.20) , (443045.25, -770035.31)  ,
                     (447891.04, -768963.39)  , (448506.17, -767551.56) ,
                     (453610.28, -769740.67)  , (453944.61, -772712.65)  ,
                     (456273.97, -774384.22) , (464726.68, -764953.53)  ,
                     (468999.29, -764454.73)  , (472641.14, -765519.74) ,
                     (475491.60, -770155.46)  , (478540.57, -768934.52)  ,
                     (480263.01, -765750.78) , (485185.46, -764876.26)  ,
                     (503935.07, -769704.79)  , (508030.53, -773150.89) ,
                     (505862.29, -773320.76)  , (504128.11, -771696.05)  ,
                     (503900.13, -771604.45) , (503671.47, -771650.45)  ,
                     (504989.45, -773514.69)  , (516620.41, -782072.64) ,
                     (520136.87, -787797.61)  , (514955.05, -811459.99)  ,
                     (513068.08, -811445.22) , (512674.64, -811446.67)  ,
                     (510973.46, -811558.24)  , (516537.97, -812808.44) ,
                     (513159.92, -818160.30)  , (512852.16, -821598.10)  ,
                     (514510.24, -824498.90) , (512231.17, -831311.01)  ,
                     (513314.25, -834637.60)  , (511047.83, -837392.37) ,
                     (501692.94, -841318.68)  , (497901.46, -846203.63)  ,
                     (507090.82, -854418.78) , (512434.13, -856202.21)  ,
                     (514107.75, -859903.98)  , (511594.33, -860916.10) ,
                     (513258.94, -861814.99)  , (512125.26, -864659.84)  ,
                     (502414.32, -872340.57) , (500083.19, -876296.13)  ,
                     (502342.23, -886376.83)  , (492937.47, -892876.54) ,
                     (485276.74, -892233.05)  , (475817.47, -896057.73)  ,
                     (468621.35, -890151.63) , (470028.25, -892820.02)  ,
                     (468153.20, -894954.77)  , (465520.39, -892640.86) ,
                     (466205.48, -895932.89)  , (467363.46, -895021.58)  ,
                     (469442.25, -898750.32) , (469723.94, -897637.48)  ,
                     (471255.02, -898934.04)  , (470457.32, -901050.96) ,
                     (472135.45, -901631.00)  , (467931.68, -903932.79)  ,
                     (466187.80, -908939.93) , (465412.97, -909152.32)  ,
                     (464878.88, -909515.93)  , (464403.01, -910112.46) ,
                     (464094.74, -910805.55)  , (465797.88, -909351.12)  ,
                     (465658.48, -912038.20) , (463121.47, -915032.21)  ,
                     (453390.27, -916648.08)  , (450970.94, -915381.20) ,
                     (437132.29, -915891.88)  , (432565.84, -929911.31)  ,
                     (424928.92, -934084.87) , (420732.08, -934402.92)  ,
                     (425071.94, -935940.56)  , (431282.46, -933198.99) ,
                     (431256.19, -938073.51)  , (432900.63, -939498.25)  ,
                     (433117.86, -933305.74) , (434763.83, -933088.91)  ,
                     (437373.48, -928830.75)  , (438358.41, -920911.86) ,
                     (440427.64, -918822.13)  , (447742.54, -918192.13)  ,
                     (450794.30, -921703.43) , (451838.16, -919756.31)  ,
                     (454517.37, -921639.04)  , (461992.62, -919485.27) ,
                     (470370.10, -921410.38)  , (472937.89, -917961.55)  ,
                     (474354.17, -919551.06) , (478605.54, -914761.26)  ,
                     (480017.83, -909520.61)  , (484977.37, -904792.37) ,
                     (490988.67, -906100.74)  , (492388.15, -908797.63)  ,
                     (494570.46, -907272.77) , (497144.68, -908712.70)  ,
                     (497368.06, -906414.07)  , (506501.98, -905410.92) ,
                     (509416.04, -906968.39)  , (509615.00, -913068.50)  ,
                     (507487.89, -918283.44) , (509066.54, -923425.95)  ,
                     (508989.78, -931787.09)  , (504584.75, -940668.90) ,
                     (489847.05, -947641.09)  , (484075.21, -952511.66)  ,
                     (476207.92, -951969.97) , (471728.86, -953662.63)  ,
                     (457203.89, -954136.89)  , (455448.97, -958513.28) ,
                     (456388.56, -966239.98)  , (455038.98, -972691.63)  ,
                     (450733.62, -977649.17) , (445863.31, -977358.15)  ,
                     (449670.94, -978657.62)  , (451793.93, -976805.61) ,
                     (456193.52, -976905.20)  , (455966.57, -981994.26)  ,
                     (454399.15, -983710.08) , (458210.89, -989511.54)  ,
                     (456727.32, -1003339.66) , (459966.20, -1007990.20) ,
                     (461487.58, -1016118.00) , (471816.43, -1011814.27) ,
                     (470608.94, -1007737.86) , (474475.24, -1000485.64) ,
                     (473722.98, -999611.33) , (469031.38, -1004962.94) ,
                     (467878.22, -999185.10)  , (466411.66, -998546.53) ,
                     (466143.94, -986185.60)  , (474327.68, -970055.69)  ,
                     (481135.22, -970529.65) , (488367.90, -960427.74)  ,
                     (496143.00, -956034.01)  , (502414.39, -957139.60) ,
                     (506908.61, -960595.97)  , (506207.17, -964117.72)  ,
                     (507745.64, -967099.10) , (509592.39, -987922.69)  ,
                     (508288.36, -997102.01)  , (504673.79, -1000478.55) ,
                     (489132.53, -1000903.80) , (484950.47, -1008080.85) ,
                     (488546.81, -1014280.38) , (487363.51, -1017544.20) ,
                     (488745.99, -1017716.32) , (487086.24, -1018826.74) ,
                     (489992.31, -1018971.41) , (493070.44, -1026095.79) ,
                     (491915.88, -1030890.66) , (493850.15, -1036519.53) ,
                     (492308.01, -1040304.71) , (493952.98, -1042290.96) ,
                     (494513.56, -1039946.24) , (495367.09, -1040312.74) ,
                     (499577.71, -1049985.79) , (499446.39, -1059121.40) ,
                     (503048.11, -1071077.97) , (500508.98, -1050290.13) ,
                     (507999.12, -1048494.07) , (509154.62, -1050870.95) ,
                     (512846.29, -1050114.90) , (510831.95, -1055398.59) ,
                     (513327.87, -1061278.27) , (513940.94, -1057948.24) ,
                     (515733.41, -1059772.87) , (513736.97, -1063526.72) ,
                     (515553.54, -1065961.85) , (512179.05, -1064294.43) ,
                     (511615.73, -1058550.56) , (508875.94, -1055290.78) ,
                     (510745.96, -1052240.27) , (508816.10, -1051784.02) ,
                     (507268.73, -1053283.93) , (505832.15, -1061632.27) ,
                     (509611.94, -1070422.05) , (508669.16, -1072195.71) ,
                     (507292.28, -1071455.45) , (506315.73, -1066803.11) ,
                     (506044.14, -1074882.51) , (504230.23, -1075076.45) ,
                     (502058.54, -1072652.04) , (502785.21, -1075969.94) ,
                     (501058.18, -1084492.95) , (510513.67, -1085035.12) ,
                     (514874.39, -1090478.68) , (516034.05, -1095827.56) ,
                     (515063.56, -1099733.20) , (511738.67, -1102331.55) ,
                     (508400.96, -1103369.85) , (501912.51, -1102025.06) ,
                     (502986.57, -1103193.77) , (499375.70, -1108563.96) ,
                     (501561.67, -1111246.65) , (499248.01, -1115660.16) ,
                     (496951.09, -1112878.54) , (494857.70, -1113992.85) ,
                     (492858.85, -1118913.83) , (496228.01, -1117501.65) ,
                     (495862.15, -1124024.92) , (496874.52, -1121858.06) ,
                     (498905.28, -1124326.36) , (498088.31, -1129579.65) ,
                     (500403.77, -1126058.37) , (504093.86, -1127705.42) ,
                     (501944.10, -1132501.24) , (498625.47, -1133470.67) ,
                     (499259.64, -1135685.73) , (500498.25, -1136824.75) ,
                     (505493.65, -1132055.10) , (507914.49, -1134022.95) ,
                     (508395.37, -1143486.74) , (507049.14, -1144092.68) ,
                     (510023.99, -1149276.72) , (513541.52, -1170135.71) ,
                     (519365.83, -1177375.07) , (520104.37, -1186182.92) ,
                     (521441.32, -1187617.36) , (519986.42, -1186484.86) ,
                     (519491.80, -1188295.66) , (514976.57, -1188911.51) ,
                     (519604.45, -1190082.90) , (522846.43, -1188616.87) ,
                     (522969.79, -1195480.89) , (520101.06, -1201677.84) ,
                     (522892.56, -1212449.92) , (523642.47, -1203092.73) ,
                     (525029.95, -1203500.36) , (526406.68, -1214304.39) ,
                     (525215.81, -1221914.05) , (527801.71, -1236153.09) ,
                     (530996.78, -1233376.34) , (539089.80, -1232186.33) ,
                     (537395.45, -1248394.87) , (538251.80, -1251014.08) ,
                     (538474.95, -1246569.01) , (540326.11, -1244298.79) ,
                     (540031.55, -1235655.07) , (545950.56, -1233420.24) ,
                     (542186.01, -1233456.72) , (538861.90, -1230151.71) ,
                     (535369.33, -1219674.89) , (535021.09, -1199620.54) ,
                     (536780.08, -1193020.42) , (543950.16, -1194574.87) ,
                     (544910.18, -1201566.36) , (545809.28, -1198689.93) ,
                     (561123.75, -1203751.42) , (576077.09, -1204048.20) ,
                     (580973.82, -1202600.06) , (594253.51, -1212505.66) ,
                     (594267.40, -1215090.57) , (590287.61, -1221477.28) ,
                     (587356.30, -1222577.54) , (583280.92, -1221617.98) ,
                     (567571.34, -1215300.78) , (561856.76, -1216626.66) ,
                     (560493.20, -1222583.16) , (553997.96, -1218906.71) ,
                     (551828.88, -1219400.93) , (551803.78, -1220900.41) ,
                     (553694.68, -1219612.35) , (555580.29, -1221667.32) ,
                     (551710.83, -1229938.30) , (554228.36, -1228383.67) ,
                     (558597.33, -1231004.88) , (566403.14, -1229860.41) ,
                     (571246.89, -1233758.46) , (564076.06, -1234544.82) ,
                     (562530.78, -1237674.88) , (559356.52, -1236633.51) ,
                     (555688.74, -1239024.34) , (559966.55, -1238114.53) ,
                     (562443.73, -1240050.76) , (564450.12, -1236604.64) ,
                     (567961.05, -1235861.53) , (569537.59, -1237598.87) ,
                     (567928.00, -1238635.49) , (568871.88, -1240928.44) ,
                     (553493.86, -1239673.15) , (551643.56, -1242296.35) ,
                     (567175.43, -1243863.25) , (578858.42, -1241202.61) ,
                     (579672.77, -1242563.83) , (577104.46, -1246572.48) ,
                     (567632.52, -1248026.37) , (563476.20, -1252946.47) ,
                     (565781.14, -1252956.33) , (567874.95, -1250047.03) ,
                     (576029.07, -1251077.24) , (585166.12, -1244286.10) ,
                     (597765.82, -1249217.37) , (600333.21, -1256192.59) ,
                     (602425.03, -1252234.22) , (610212.76, -1254471.43) ,
                     (604879.04, -1244837.34) , (603867.26, -1238649.81) ,
                     (605511.53, -1239839.70) , (613522.84, -1239395.27) ,
                     (613468.06, -1238107.61) , (617005.24, -1237451.48) ,
                     (618311.46, -1237804.23) , (618243.04, -1240496.79) ,
                     (622507.49, -1239993.52) , (630470.06, -1250162.37) ,
                     (629765.70, -1252291.94) , (633044.73, -1255069.39) ,
                     (633640.08, -1258906.81) , (635547.07, -1259548.75) ,
                     (641965.93, -1272200.29) , (643857.76, -1281297.51) ,
                     (642190.61, -1287049.08) , (644493.41, -1288443.96) ,
                     (642670.15, -1289676.27) , (645543.07, -1291671.53) ,
                     (644372.91, -1291932.89) , (640389.13, -1288057.54) ,
                     (639447.16, -1289113.35) , (641062.50, -1292696.63) ,
                     (644523.63, -1294457.41) , (644394.26, -1296658.51) ,
                     (638123.48, -1291117.73) , (636372.31, -1290964.43) ,
                     (637360.10, -1292181.58) , (634775.36, -1293117.58) ,
                     (630958.01, -1289991.54) , (627773.09, -1289593.21) ,
                     (628573.27, -1290671.00) , (624697.41, -1292938.28) ,
                     (621422.21, -1291669.95) , (619671.72, -1293483.40) ,
                     (614141.37, -1290483.64) , (609607.21, -1291033.41) ,
                     (603988.56, -1288896.42) , (599214.83, -1290709.22) ,
                     (597627.12, -1293366.67) , (594601.40, -1292418.33) ,
                     (585008.18, -1293603.21) , (583253.51, -1296201.54) ,
                     (576265.95, -1297709.16) , (571709.54, -1301713.93) ,
                     (562552.35, -1301908.55) , (571125.99, -1302513.24) ,
                     (577659.54, -1298103.30) , (579218.08, -1298676.97) ,
                     (578698.44, -1301195.29) , (586111.30, -1296868.21) ,
                     (590417.08, -1298398.92) , (587217.53, -1306630.65) ,
                     (578001.09, -1306155.89) , (565576.28, -1312037.65) ,
                     (573684.47, -1312012.27) , (581842.34, -1308376.31) ,
                     (585034.51, -1310457.47) , (589292.32, -1308840.12) ,
                     (585374.40, -1312435.12) , (583903.33, -1316908.95) ,
                     (581349.62, -1315086.92) , (578314.84, -1317695.13) ,
                     (579660.93, -1319272.71) , (582720.67, -1318520.98) ,
                     (579920.55, -1321723.47) , (577051.55, -1331594.15) ,
                     (574756.99, -1332363.60) , (577195.89, -1334228.83) ,
                     (576487.89, -1336477.79) , (574575.61, -1336285.43) ,
                     (565440.54, -1327005.35) , (561675.28, -1325260.69) ,
                     (557532.50, -1319454.05) , (553865.85, -1319664.92) ,
                     (552684.47, -1323252.87) , (549808.90, -1323664.78) ,
                     (549144.01, -1325747.68) , (553701.25, -1325895.35) ,
                     (558433.80, -1331479.85) , (552210.50, -1333918.87) ,
                     (549508.42, -1340147.41) , (551896.49, -1342619.02) ,
                     (556423.36, -1341438.21) , (557679.13, -1345872.57) ,
                     (561142.85, -1348016.60) , (563662.13, -1352575.07) ,
                     (562327.35, -1346853.35) , (565103.77, -1340275.05) ,
                     (567315.93, -1340198.59) , (567843.31, -1343057.86) ,
                     (570965.52, -1340373.78) , (575078.60, -1343462.69) ,
                     (572155.35, -1347764.13) , (568467.03, -1346583.46) ,
                     (566186.88, -1348751.82) , (568186.22, -1347762.81) ,
                     (572598.96, -1350001.34) , (575509.53, -1345774.21) ,
                     (580100.71, -1347076.80) , (573967.07, -1356690.03) ,
                     (581952.70, -1351299.56) , (582934.01, -1355766.10) ,
                     (579305.88, -1359412.98) , (570842.48, -1359961.08) ,
                     (565651.74, -1354997.54) , (564105.10, -1357158.88) ,
                     (567207.27, -1358684.07) , (567561.06, -1360525.03) ,
                     (563226.91, -1362175.88) , (567668.51, -1364166.62) ,
                     (569837.73, -1362268.62) , (575433.78, -1362661.62) ,
                     (585798.91, -1355499.90) , (586370.10, -1358338.20) ,
                     (589188.77, -1360185.45) , (591843.23, -1374575.80) ,
                     (589631.41, -1378780.77) , (592034.04, -1379979.85) ,
                     (594791.65, -1374589.33) , (596442.11, -1376609.62) ,
                     (597835.78, -1375132.51) , (597449.23, -1373034.18) ,
                     (599204.82, -1372042.21) , (596761.64, -1370620.72) ,
                     (598305.02, -1366212.58) , (599599.69, -1366977.23) ,
                     (598908.21, -1370397.73) , (605204.07, -1365880.09) ,
                     (611929.15, -1370108.72) , (617237.32, -1370472.44) ,
                     (621172.89, -1373662.02) , (627443.08, -1373025.01) ,
                     (621179.46, -1372757.37) , (617678.65, -1369683.40) ,
                     (611077.45, -1368804.75) , (609345.42, -1367700.89) ,
                     (608752.45, -1363839.88) , (608510.76, -1367411.83) ,
                     (604021.42, -1364344.83) , (606131.62, -1362002.68) ,
                     (609724.85, -1361508.76) , (623319.12, -1365374.72) ,
                     (627488.45, -1359424.64) , (632228.74, -1356159.64) ,
                     (635281.96, -1356866.91) , (635181.82, -1355482.39) ,
                     (636006.43, -1358056.36) , (641284.41, -1362436.35) ,
                     (644764.85, -1367401.20) , (646420.54, -1373726.89) ,
                     (640308.10, -1374611.49) , (638465.61, -1382403.56) ,
                     (635353.57, -1387829.42) , (623150.53, -1390646.94) ,
                     (613323.05, -1396193.84) , (612800.41, -1398050.61) ,
                     (608155.23, -1398355.22) , (606458.02, -1401026.62) ,
                     (599665.99, -1401503.17) , (595922.97, -1397422.95) ,
                     (597237.19, -1402591.90) , (598775.58, -1402230.25) ,
                     (600086.12, -1404694.04) , (606964.44, -1402969.08) ,
                     (625158.27, -1393356.10) , (637076.86, -1391343.61) ,
                     (639625.18, -1393117.81) , (647282.37, -1386786.12) ,
                     (654755.99, -1389369.02) , (666786.13, -1400022.02) ,
                     (672296.15, -1400800.06) , (672433.05, -1402909.89) ,
                     (669716.46, -1401211.45) , (666890.99, -1403511.52) ,
                     (668573.41, -1408213.49) , (672994.21, -1411729.86) ,
                     (674133.09, -1414892.96) , (680772.46, -1420068.40) ,
                     (689024.66, -1434967.43) , (692262.61, -1443572.86) ,
                     (691165.97, -1445675.96) , (693111.21, -1445950.34) ,
                     (694811.16, -1453900.35) , (693600.13, -1462469.55) ,
                     (686233.02, -1465064.20) , (682519.94, -1463963.29) ,
                     (679090.06, -1460512.16) , (677799.22, -1452136.51) ,
                     (671081.06, -1449409.34) , (666824.96, -1451530.52) ,
                     (662908.20, -1457990.72) , (660485.24, -1459686.33) ,
                     (657365.35, -1459291.10) , (641388.58, -1453570.92) ,
                     (637522.67, -1448613.94) , (627696.49, -1442695.15) ,
                     (606791.99, -1437283.61) , (604506.95, -1438347.78) ,
                     (605814.50, -1441705.01) , (619713.96, -1444453.59) ,
                     (634136.67, -1451420.32) , (615870.44, -1456841.99) ,
                     (606313.50, -1456087.51) , (603779.57, -1453599.71) ,
                     (602963.40, -1454653.94) , (605598.53, -1457591.21) ,
                     (615831.05, -1458182.66) , (623090.53, -1455358.40) ,
                     (634293.69, -1453764.25) , (639650.79, -1460366.32) ,
                     (648556.52, -1461506.05) , (654245.27, -1463778.93) ,
                     (656406.37, -1466708.01) , (667037.09, -1468894.75) ,
                     (671237.46, -1473133.30) , (669964.49, -1475284.79) ,
                     (666563.79, -1478497.88) , (659232.49, -1478695.38) ,
                     (655043.93, -1483240.99) , (650140.95, -1497717.47) ,
                     (645049.66, -1501781.86) , (645581.08, -1503628.68) ,
                     (640778.44, -1501297.47) , (639281.14, -1497072.86) ,
                     (635927.59, -1494795.82) , (627966.05, -1491699.48) ,
                     (619378.85, -1491139.11) , (620105.88, -1492716.68) ,
                     (629350.45, -1494445.24) , (637055.96, -1497887.41) ,
                     (638329.55, -1499637.76) , (636196.08, -1503481.34) ,
                     (639012.90, -1502984.53) , (646746.63, -1506011.37) ,
                     (649961.79, -1504386.76) , (654053.95, -1498575.44) ,
                     (657275.97, -1486491.31) , (659351.23, -1484958.01) ,
                     (664516.57, -1486465.21) , (671951.51, -1483470.39) ,
                     (672877.77, -1492217.52) , (677348.70, -1499185.22) ,
                     (677062.51, -1504195.23) , (686511.63, -1514967.64) ,
                     (682818.13, -1525852.88) , (676656.30, -1527069.85) ,
                     (677057.13, -1528176.95) , (682121.61, -1528759.75) ,
                     (685388.02, -1524567.50) , (687072.06, -1525429.95) ,
                     (689427.02, -1520955.59) , (698919.40, -1518060.09) ,
                     (699045.35, -1515951.57) , (702205.67, -1515001.63) ,
                     (705757.22, -1516756.64) , (707012.08, -1520570.11) ,
                     (708509.10, -1518158.40) , (711058.66, -1520836.04) ,
                     (710818.43, -1518940.11) , (717504.05, -1519869.78) ,
                     (717720.84, -1511653.69) , (719202.74, -1510675.45) ,
                     (719609.22, -1505545.80) , (721349.25, -1505148.24) ,
                     (725474.33, -1507519.50) , (728762.12, -1514818.38) ,
                     (725853.04, -1517827.39) , (726681.07, -1518898.00) ,
                     (730084.16, -1516481.07) , (733520.60, -1520271.97) ,
                     (738387.29, -1518551.29) , (741869.47, -1519516.87) ,
                     (741119.01, -1530187.01) , (742978.24, -1535897.87) ,
                     (741585.03, -1546465.44) , (735703.22, -1552576.28) ,
                     (718440.84, -1554942.12) , (711557.07, -1545096.66) ,
                     (704980.29, -1540961.36) , (697975.94, -1542435.72) ,
                     (694672.38, -1545997.08) , (682203.74, -1548608.47) ,
                     (670783.36, -1556675.16) , (665579.55, -1555233.87) ,
                     (658530.95, -1547565.42) , (653481.64, -1544845.09) ,
                     (652634.55, -1545777.91) , (658881.16, -1549482.41) ,
                     (663893.47, -1555711.15) , (668215.82, -1557750.59) ,
                     (669834.37, -1563652.11) , (668453.53, -1570988.88) ,
                     (665360.52, -1574601.12) , (662678.37, -1574923.99) ,
                     (659262.42, -1579179.23) , (655988.10, -1579007.14) ,
                     (660244.02, -1580140.50) , (667788.02, -1574870.27) ,
                     (669694.81, -1584823.92) , (666128.49, -1591338.27) ,
                     (666885.40, -1592663.41) , (668443.33, -1591665.52) ,
                     (671736.31, -1597267.57) , (670306.71, -1600833.56) ,
                     (665043.08, -1602370.07) , (664768.28, -1605196.50) ,
                     (672930.29, -1607148.33) , (680445.30, -1605623.79) ,
                     (684578.55, -1613057.44) , (689828.40, -1615608.83) ,
                     (692484.81, -1618786.61) , (699323.33, -1635474.62) ,
                     (699485.43, -1639356.28) , (702455.44, -1637642.02) ,
                     (701623.86, -1632108.74) , (698991.47, -1629056.26) ,
                     (693996.68, -1616650.38) , (690681.07, -1613049.36) ,
                     (687595.85, -1612257.21) , (682697.56, -1603563.70) ,
                     (686027.19, -1596473.06) , (699298.30, -1597803.32) ,
                     (708185.82, -1600881.24) , (721076.20, -1601148.89) ,
                     (734624.81, -1596272.64) , (738398.60, -1604012.05) ,
                     (733924.86, -1609893.77) , (737313.73, -1613215.26) ,
                     (734995.55, -1615431.11) , (741734.34, -1623546.88) ,
                     (742201.91, -1630235.07) , (745937.19, -1633251.64) ,
                     (748153.94, -1632432.15) , (749278.74, -1637764.73) ,
                     (747267.05, -1642896.61) , (744409.98, -1644788.48) ,
                     (739680.76, -1645550.62) , (725111.03, -1652649.47) ,
                     (719976.22, -1651204.91) , (716018.69, -1652430.49) ,
                     (715514.49, -1654939.20) , (717208.58, -1655511.71) ,
                     (719827.28, -1661769.13) , (710998.21, -1672256.46) ,
                     (707409.49, -1684423.61) , (700234.27, -1686493.72) ,
                     (688895.80, -1684054.52) , (682417.01, -1685171.47) ,
                     (670966.76, -1681375.05) , (665184.05, -1681221.63) ,
                     (640026.09, -1669756.10) , (634773.66, -1661995.80) ,
                     (634385.33, -1656933.75) , (647680.12, -1653663.05) ,
                     (678379.96, -1661027.60) , (684999.92, -1655734.11) ,
                     (687657.20, -1648956.45) , (690555.74, -1647152.48) ,
                     (689190.05, -1645728.76) , (682098.77, -1656373.63) ,
                     (677735.29, -1659498.72) , (648864.18, -1650600.45) ,
                     (639426.34, -1653486.24) , (635552.79, -1652724.00) ,
                     (629208.94, -1647089.58) , (625114.21, -1653851.04) ,
                     (622300.63, -1653712.51) , (623509.35, -1658302.55) ,
                     (622024.37, -1663053.26) , (626299.02, -1673411.63) ,
                     (630858.16, -1678247.67) , (629198.58, -1680679.15) ,
                     (624533.24, -1679114.30) , (614213.63, -1679281.62) ,
                     (609776.13, -1677120.96) , (604782.08, -1667708.54) ,
                     (597327.53, -1665982.42) , (591740.79, -1661499.83) ,
                     (591067.88, -1662547.65) , (585550.30, -1655904.55) ,
                     (575635.21, -1651067.47) , (576447.37, -1655168.51) ,
                     (583348.16, -1659601.91) , (586153.94, -1664930.61) ,
                     (594224.32, -1668637.38) , (604916.31, -1670909.18) ,
                     (606208.77, -1676362.11) , (609741.71, -1680745.51) ,
                     (615938.94, -1681397.12) , (617963.69, -1683838.63) ,
                     (623294.63, -1684776.31) , (623869.74, -1686820.95) ,
                     (605060.90, -1700362.64) , (604150.66, -1705639.06) ,
                     (606885.91, -1707547.16) , (606976.11, -1711625.08) ,
                     (601290.73, -1725034.85) , (595421.50, -1728731.06) ,
                     (589668.96, -1730003.54) , (583621.72, -1724941.34) ,
                     (576366.09, -1722028.71) , (574723.19, -1725610.69) ,
                     (566886.29, -1726430.04) , (560847.95, -1723756.60) ,
                     (550454.81, -1714344.17) , (546450.72, -1713930.94) ,
                     (545513.52, -1720760.44) , (549980.96, -1721638.64) ,
                     (558438.08, -1727855.91) , (563999.31, -1727960.06) ,
                     (568596.25, -1731084.49) , (574310.75, -1728215.57) ,
                     (580448.77, -1728251.72) , (584513.79, -1732359.39) ,
                     (578051.95, -1736293.42) , (576493.37, -1746725.21) ,
                     (574180.94, -1747493.42) , (565065.69, -1745231.16) ,
                     (558933.74, -1746662.61) , (555497.00, -1751547.70) ,
                     (550193.96, -1752649.88) , (546824.36, -1755508.31) ,
                     (546837.75, -1757442.62) , (558094.35, -1754629.72) ,
                     (557603.92, -1759215.30) , (562237.06, -1770057.42) ,
                     (560379.51, -1775726.98) , (561476.40, -1776883.85) ,
                     (563701.12, -1770712.60) , (561058.74, -1762814.26) ,
                     (561052.63, -1753193.64) , (564789.76, -1749492.91) ,
                     (572016.88, -1751805.33) , (579401.05, -1750659.45) ,
                     (583184.75, -1738811.00) , (590779.88, -1736409.19) ,
                     (593920.72, -1733665.26) , (599646.86, -1733449.21) ,
                     (608839.51, -1738377.93) , (622855.58, -1738469.96) ,
                     (626282.04, -1736333.12) , (630183.87, -1737795.23) ,
                     (634287.37, -1743117.65) , (632046.11, -1752365.43) ,
                     (624865.85, -1759063.41) , (616810.32, -1760512.91) ,
                     (612728.74, -1772827.59) , (605605.79, -1779003.27) ,
                     (603344.37, -1780294.42) , (598565.19, -1777766.34) ,
                     (593765.44, -1777995.97) , (588107.61, -1774278.54) ,
                     (574360.96, -1783751.61) , (566998.55, -1782786.99) ,
                     (565228.87, -1785559.40) , (576845.09, -1785304.18) ,
                     (586150.47, -1777338.14) , (594634.70, -1781762.69) ,
                     (598927.76, -1781172.18) , (588452.34, -1792384.85) ,
                     (590669.69, -1792880.94) , (599854.71, -1785614.95) ,
                     (603829.29, -1784706.81) , (603646.84, -1802130.37) ,
                     (605548.07, -1803014.03) , (607637.90, -1795492.61) ,
                     (607038.44, -1785247.21) , (612657.02, -1783593.67) ,
                     (616805.48, -1779421.30) , (621927.66, -1767429.30) ,
                     (624138.29, -1765382.30) , (629049.65, -1767915.80) ,
                     (633761.90, -1766114.62) , (637613.52, -1769091.92) ,
                     (641453.99, -1769566.43) , (641496.14, -1771533.32) ,
                     (647717.96, -1770354.69) , (655441.26, -1772298.12) ,
                     (655376.46, -1776015.88) , (662938.87, -1788300.95) ,
                     (658289.63, -1796792.52) , (648876.29, -1803916.12) ,
                     (638942.52, -1806654.09) , (633528.41, -1810462.24) ,
                     (628771.78, -1810787.31) , (620793.21, -1819166.14) ,
                     (615882.21, -1820436.54) , (621393.04, -1820144.28) ,
                     (629581.17, -1813199.27) , (634140.68, -1813735.07) ,
                     (640803.46, -1809263.65) , (649489.60, -1808612.70) ,
                     (647517.40, -1828671.61) , (651366.90, -1836646.85) ,
                     (651404.19, -1842354.02) , (654212.95, -1847546.61) ,
                     (653602.27, -1850437.46) , (655235.15, -1850686.77) ,
                     (656408.73, -1847665.61) , (655198.81, -1844729.57) ,
                     (651841.51, -1842381.94) , (653909.69, -1837754.89) ,
                     (650479.69, -1823451.06) , (652148.25, -1812630.23) ,
                     (656130.66, -1806049.32) , (658813.82, -1805213.70) ,
                     (660767.28, -1799518.91) , (664307.68, -1801073.48) ,
                     (667769.83, -1798019.79) , (670298.91, -1798248.85) ,
                     (674814.90, -1802848.32) , (680289.25, -1805097.23) ,
                     (684318.79, -1803929.86) , (691032.77, -1807829.15) ,
                     (696015.81, -1805710.74) , (697664.14, -1807570.73) ,
                     (700290.35, -1806711.00) , (701786.48, -1808827.95) ,
                     (699020.42, -1809768.13) , (700318.36, -1811679.53) ,
                     (702851.03, -1810500.86) , (702499.73, -1807849.49) ,
                     (706602.00, -1813248.87) , (704369.01, -1818854.99) ,
                     (705365.14, -1820799.40) , (709639.92, -1815086.47) ,
                     (712551.07, -1814115.60) , (729068.58, -1816290.23) ,
                     (730882.73, -1818798.85) , (730844.36, -1823918.27) ,
                     (733718.10, -1822883.79) , (733747.99, -1821269.35) ,
                     (736347.47, -1821344.64) , (755730.71, -1825045.25) ,
                     (756310.21, -1828476.73) , (750083.68, -1834372.63) ,
                     (753001.16, -1838191.53) , (752868.34, -1840944.37) ,
                     (747516.45, -1850057.93) , (745842.40, -1858153.43) ,
                     (748059.15, -1862922.59) , (751970.68, -1860605.19) ,
                     (753241.72, -1852840.99) , (763691.83, -1836468.74) ,
                     (765895.11, -1840776.02) , (761469.34, -1854829.61) ,
                     (766178.36, -1862643.77) , (767671.07, -1861266.49) ,
                     (765132.70, -1858635.71) , (766406.58, -1855616.85) ,
                     (767600.03, -1853947.84) , (771461.65, -1854323.89) ,
                     (770518.47, -1848832.00) , (772521.08, -1844457.10) ,
                     (769906.85, -1842089.29) , (771303.67, -1838317.97) ,
                     (774295.10, -1838095.90) , (775755.41, -1841769.15) ,
                     (782458.42, -1835262.87) , (782786.94, -1838526.51) ,
                     (780091.44, -1841685.82) , (782133.02, -1842404.44) ,
                     (775426.34, -1849002.29) , (778165.79, -1851175.67) ,
                     (781599.66, -1850270.29) , (781633.87, -1852173.30) ,
                     (772460.30, -1857525.74) , (770560.74, -1862475.08) ,
                     (773055.42, -1872382.61) , (781402.81, -1883089.12) ,
                     (784194.84, -1892777.47) , (786695.45, -1892335.78) ,
                     (788129.70, -1889508.82) , (785747.15, -1881854.43) ,
                     (784099.91, -1881289.66) , (784227.40, -1872459.37) ,
                     (783008.42, -1871595.21) , (783458.99, -1869882.30) ,
                     (785383.13, -1870619.54) , (784006.99, -1866681.86) ,
                     (786417.00, -1861621.36) , (787679.43, -1863397.61) ,
                     (789006.41, -1861695.16) , (792942.39, -1864183.31) ,
                     (794323.44, -1863286.13) , (797191.46, -1864561.44) ,
                     (797978.03, -1862412.62) , (801420.35, -1862045.29) ,
                     (798680.37, -1866141.39) , (804315.96, -1865298.63) ,
                     (804543.71, -1866543.51) , (798905.31, -1871264.77) ,
                     (799774.14, -1874110.87) , (803619.28, -1870631.89) ,
                     (805459.90, -1870965.66) , (803444.80, -1873585.05) ,
                     (803213.56, -1877576.65) , (806236.34, -1873897.50) ,
                     (809811.67, -1872585.08) , (804631.32, -1880931.74) ,
                     (801357.73, -1880122.04) , (802785.61, -1881595.75) ,
                     (801382.98, -1883324.36) , (803906.67, -1883728.59) ,
                     (804622.56, -1887224.70) , (806080.43, -1881323.27) ,
                     (810012.98, -1882248.45) , (809110.80, -1885534.77) ,
                     (811333.75, -1884422.35) , (812935.09, -1887678.97) ,
                     (814697.03, -1887515.10) , (815609.44, -1892132.59) ,
                     (812729.38, -1892551.50) , (807024.04, -1889620.41) ,
                     (810715.42, -1892116.61) , (810357.90, -1894637.65) ,
                     (815529.93, -1894902.73) , (804818.17, -1904761.10) ,
                     (803452.53, -1898800.75) , (802942.38, -1903292.21) ,
                     (804246.48, -1905916.75) , (799727.56, -1909297.71) ,
                     (803522.39, -1908404.36) , (810470.53, -1903426.19) ,
                     (814095.58, -1905067.51) , (811306.79, -1902029.60) ,
                     (813143.95, -1900520.43) , (814162.54, -1901694.99) ,
                     (814888.50, -1899353.88) , (818390.13, -1899055.27) ,
                     (817738.38, -1900818.35) , (821013.55, -1905106.97) ,
                     (812066.71, -1914229.23) , (815094.65, -1914637.67) ,
                     (821028.76, -1908760.17) , (819467.41, -1916223.52) ,
                     (821878.76, -1911235.74) , (824746.20, -1912993.44) ,
                     (824310.99, -1910165.36) , (825554.61, -1909877.91) ,
                     (826853.13, -1913020.82) , (824774.64, -1913910.43) ,
                     (823970.83, -1921713.24) , (828290.45, -1923963.56) ,
                     (827251.31, -1925709.16) , (828261.16, -1926998.54) ,
                     (825515.37, -1929425.71) , (821173.42, -1929203.94) ,
                     (826054.20, -1930879.86) , (831073.57, -1926267.86) ,
                     (832724.46, -1928642.50) , (828403.18, -1933396.76) ,
                     (828543.61, -1936418.74) , (832419.38, -1932053.77) ,
                     (839007.20, -1933209.73) , (829978.89, -1936751.78) ,
                     (839530.45, -1937746.85) , (836793.32, -1939656.80) ,
                     (840016.46, -1941311.98) , (837019.12, -1943490.56) ,
                     (833291.07, -1943449.34) , (835989.30, -1945572.92) ,
                     (837133.48, -1952039.30) , (839427.48, -1945892.23) ,
                     (841725.85, -1946856.58) , (840121.13, -1950552.56) ,
                     (842221.72, -1948933.17) , (843777.71, -1949645.71) ,
                     (843266.73, -1948563.16) , (845824.51, -1951950.20) ,
                     (847016.54, -1949225.77) , (849164.14, -1951416.23) ,
                     (847584.47, -1963426.36) , (844696.44, -1966329.69) ,
                     (842158.82, -1963893.58) , (840917.96, -1964460.02) ,
                     (841606.92, -1967437.99) , (840357.19, -1969393.55) ,
                     (838733.67, -1969019.77) , (838993.00, -1971299.22) ,
                     (837488.59, -1971138.42) , (835994.22, -1966160.82) ,
                     (838261.75, -1964017.95) , (834726.72, -1964089.31) ,
                     (834540.11, -1962545.87) , (831625.77, -1961996.72) ,
                     (825717.42, -1971150.75) , (821142.34, -1972056.35) ,
                     (809024.36, -1950937.64) , (803177.69, -1932958.46) ,
                     (800380.18, -1932186.27) , (798771.65, -1938449.09) ,
                     (800063.02, -1943828.64) , (802609.77, -1946403.30) ,
                     (800988.19, -1947747.78) , (801412.74, -1949713.08) ,
                     (810214.09, -1963325.48) , (813917.69, -1977307.19) ,
                     (810686.83, -1980135.65) , (796226.23, -1985115.96) ,
                     (783436.89, -1985510.57) , (767841.27, -1980540.37) ,
                     (754878.89, -1973143.15) , (740617.27, -1952393.55) ,
                     (737215.33, -1942951.47) , (738608.52, -1942500.47) ,
                     (735215.39, -1939993.38) , (736376.28, -1939181.00) ,
                     (733470.91, -1938456.65) , (732727.05, -1936297.96) ,
                     (733802.62, -1936195.54) , (721730.27, -1926806.61) ,
                     (715920.69, -1924326.92) , (714527.64, -1919278.15) ,
                     (710350.27, -1918853.25) , (709371.13, -1910443.60) ,
                     (706689.85, -1910163.92) , (706079.87, -1914823.83) ,
                     (704166.83, -1915092.60) , (702969.23, -1918953.05) ,
                     (700717.60, -1918576.85) , (695150.95, -1922361.27) ,
                     (693993.00, -1921639.81) , (695339.57, -1920332.35) ,
                     (692710.50, -1920975.03) , (680285.28, -1909673.84) ,
                     (677974.63, -1910142.87) , (669681.87, -1903606.65) ,
                     (665450.50, -1905672.83) , (660675.19, -1903156.07) ,
                     (658023.67, -1906251.54) , (651353.43, -1903972.64) ,
                     (649466.53, -1906699.57) , (651086.38, -1908514.75) ,
                     (650114.88, -1909227.51) , (648835.79, -1907442.98) ,
                     (643468.38, -1907980.97) , (638756.03, -1902353.28) ,
                     (638006.08, -1907739.17) , (639565.51, -1910741.05) ,
                     (637589.40, -1913952.04) , (632500.53, -1916855.48) ,
                     (627108.05, -1916389.80) , (620452.52, -1914323.33) ,
                     (611857.04, -1908599.48) , (609446.54, -1902980.62) ,
                     (606029.07, -1900301.68) , (601093.37, -1899788.10) ,
                     (591198.37, -1894352.85) , (590173.99, -1889619.69) ,
                     (579202.72, -1885631.45) , (577748.07, -1882811.30) ,
                     (576623.16, -1883024.32) , (576971.60, -1885907.42) ,
                     (567701.06, -1886951.79) , (562733.60, -1881535.25) ,
                     (555683.77, -1879419.03) , (549991.47, -1875207.05) ,
                     (550039.65, -1879510.15) , (544577.11, -1882318.56) ,
                     (552946.21, -1882028.93) , (560813.64, -1884627.69) ,
                     (562283.88, -1887392.31) , (557995.17, -1891300.41) ,
                     (560481.63, -1896179.99) , (564850.11, -1894340.27) ,
                     (581699.15, -1892193.42) , (585461.07, -1894985.82) ,
                     (577247.60, -1893627.72) , (577704.19, -1897171.58) ,
                     (586489.11, -1898678.06) , (605418.65, -1906707.23) ,
                     (606269.85, -1915004.87) , (597799.76, -1916297.70) ,
                     (591862.08, -1923639.94) , (587372.09, -1922851.80) ,
                     (589714.88, -1923706.68) , (590440.27, -1925869.13) ,
                     (577644.50, -1933910.46) , (574956.47, -1934604.13) ,
                     (572589.57, -1933056.82) , (572139.63, -1934396.59) ,
                     (574009.01, -1935846.67) , (576838.85, -1936036.26) ,
                     (588541.95, -1930326.81) , (600379.49, -1919618.66) ,
                     (616638.79, -1918500.46) , (617639.96, -1922094.90) ,
                     (612705.70, -1926465.04) , (615937.20, -1927269.38) ,
                     (617516.66, -1929602.63) , (619588.18, -1923993.82) ,
                     (622815.70, -1921152.84) , (634284.72, -1921050.28) ,
                     (636373.85, -1923035.89) , (642717.63, -1916978.37) ,
                     (647430.09, -1916824.22) , (649324.25, -1914649.41) ,
                     (656098.13, -1915219.17) , (657408.81, -1912856.66) ,
                     (663713.18, -1911290.00) , (669125.96, -1912158.16) ,
                     (678097.81, -1919275.70) , (681019.83, -1918881.79) ,
                     (686299.02, -1927995.78) , (683736.82, -1936086.02) ,
                     (674265.90, -1934414.11) , (683331.61, -1939141.37) ,
                     (682839.54, -1944488.21) , (674097.90, -1953551.15) ,
                     (672937.20, -1958361.47) , (669621.39, -1959039.98) ,
                     (665492.30, -1963287.64) , (665955.57, -1965365.65) ,
                     (661163.66, -1973824.70) , (653917.22, -1979826.04) ,
                     (640026.15, -1983022.97) , (637190.42, -1985898.60) ,
                     (627028.74, -1989287.07) , (624637.02, -1984851.03) ,
                     (610366.30, -1970510.96) , (605663.57, -1971877.58) ,
                     (612671.06, -1981543.60) , (615550.64, -1983769.28) ,
                     (617568.47, -1983334.68) , (623611.94, -1989862.71) ,
                     (620643.82, -1990955.20) , (607246.65, -1989548.52) ,
                     (602722.70, -1994388.13) , (597906.63, -1992665.63) ,
                     (595947.60, -1995911.76) , (598038.89, -1997111.99) ,
                     (607320.16, -1996534.91) , (610171.17, -2000095.54) ,
                     (616244.65, -1999709.15) , (617808.45, -2018556.54) ,
                     (615973.53, -2028453.47) , (609973.36, -2031499.78) ,
                     (614471.34, -2033724.05) , (610741.62, -2041132.37) ,
                     (606739.38, -2041595.38) , (604099.28, -2045511.87) ,
                     (598680.18, -2046440.51) , (592073.15, -2053173.31) ,
                     (591932.27, -2054980.12) , (586144.02, -2055433.05) ,
                     (585967.51, -2061864.71) , (587366.23, -2060763.50) ,
                     (588623.48, -2063294.91) , (591604.81, -2062989.88) ,
                     (594900.96, -2060018.04) , (597856.10, -2053857.84) ,
                     (607951.59, -2048887.77) , (609266.19, -2046111.19) ,
                     (615297.77, -2042310.16) , (616802.31, -2051049.01) ,
                     (622523.76, -2056287.63) , (625534.85, -2053745.90) ,
                     (628877.18, -2053485.59) , (643486.36, -2042361.96) ,
                     (654271.27, -2037314.83) , (655683.89, -2035146.32) ,
                     (661687.08, -2034919.84) , (669741.88, -2027151.77) ,
                     (678156.34, -2025795.03) , (687458.53, -2031459.91) ,
                     (689150.78, -2034133.60) , (682314.37, -2043427.78) ,
                     (676903.20, -2046812.46) , (669516.16, -2045613.10) ,
                     (667288.46, -2046973.17) , (664037.77, -2052109.75) ,
                     (665030.18, -2052788.17) , (658171.79, -2058948.27) ,
                     (655948.29, -2067008.40) , (643771.15, -2080051.21) ,
                     (640962.32, -2080580.09) , (631614.06, -2077772.38) ,
                     (627820.06, -2079854.16) , (624182.44, -2086969.39) ,
                     (619168.34, -2086735.09) , (622835.43, -2092318.83) ,
                     (635500.95, -2084493.75) , (642380.18, -2090935.66) ,
                     (652262.30, -2082036.40) , (657576.42, -2079861.86) ,
                     (659940.86, -2088531.65) , (665241.31, -2089516.87) ,
                     (667696.89, -2086683.86) , (667516.48, -2071576.94) ,
                     (665291.26, -2063693.91) , (667866.26, -2059381.12) ,
                     (670174.12, -2059845.82) , (672596.16, -2052770.19) ,
                     (680225.96, -2050541.26) , (684445.76, -2050812.50) ,
                     (684175.58, -2052089.84) , (686519.82, -2053119.12) ,
                     (695420.71, -2051272.70) , (704416.23, -2037383.76) ,
                     (710383.79, -2032126.95) , (722272.45, -2016373.37) ,
                     (726075.05, -2015907.58) , (725821.97, -2020195.47) ,
                     (724366.77, -2021107.59) , (725516.16, -2022563.85) ,
                     (724905.41, -2027235.14) , (727481.64, -2031124.73) ,
                     (730547.43, -2029530.99) , (732852.53, -2017573.51) ,
                     (739553.00, -2018980.53) , (742292.92, -2023427.24) ,
                     (743331.75, -2022367.14) , (741624.29, -2019262.25) ,
                     (758011.89, -2023178.54) , (758908.74, -2025571.04) ,
                     (763405.39, -2023922.92) , (779687.39, -2023315.34) ,
                     (783600.75, -2027149.09) , (785405.84, -2023974.16) ,
                     (791720.84, -2023164.83) , (794734.15, -2024379.20) ,
                     (824826.20, -2016530.71) , (837010.73, -2007629.08) ,
                     (843336.26, -1999754.94) , (846971.64, -1999645.35) ,
                     (847557.86, -2006215.85) , (842793.59, -2021458.92) ,
                     (841134.92, -2023018.88) , (837951.51, -2020327.91) ,
                     (838680.91, -2023478.26) , (837648.03, -2024911.05) ,
                     (837153.04, -2023407.38) , (836158.60, -2024301.95) ,
                     (837288.47, -2028543.85) , (831564.68, -2029351.15) ,
                     (829715.97, -2032394.35) , (829495.18, -2030122.94) ,
                     (827696.54, -2031685.91) , (827581.29, -2029549.87) ,
                     (824234.62, -2032001.87) , (825520.55, -2034762.04) ,
                     (831507.40, -2035196.45) , (832562.53, -2036647.16) ,
                     (826992.28, -2038221.09) , (822411.82, -2033672.71) ,
                     (820238.78, -2035885.21) , (824331.17, -2041363.66) ,
                     (818620.38, -2042988.33) , (818236.75, -2044666.31) ,
                     (822281.10, -2045248.83) , (823802.14, -2043665.83) ,
                     (831618.34, -2045505.88) , (830363.13, -2052702.49) ,
                     (826092.49, -2053458.90) , (820968.54, -2051705.45) ,
                     (815509.27, -2047057.17) , (811648.27, -2048621.62) ,
                     (815860.94, -2049543.24) , (821909.00, -2055807.44) ,
                     (822417.91, -2057520.52) , (820079.42, -2056848.20) ,
                     (817481.55, -2058294.68) , (820711.40, -2057929.10) ,
                     (825414.75, -2062757.86) , (824069.54, -2069173.36) ,
                     (813664.70, -2069882.81) , (810332.12, -2066136.10) ,
                     (810825.55, -2064751.82) , (798974.76, -2066196.46) ,
                     (799089.66, -2067362.87) , (806646.40, -2066518.94) ,
                     (815605.62, -2075159.17) , (812374.75, -2076350.88) ,
                     (810482.11, -2079229.84) , (813475.92, -2078001.85) ,
                     (815157.22, -2080733.69) , (811570.13, -2089834.11) ,
                     (804525.62, -2088941.77) , (803027.41, -2085421.10) ,
                     (800879.06, -2086537.27) , (800749.20, -2090010.20) ,
                     (788870.60, -2089014.73) , (801227.79, -2094094.85) ,
                     (803448.00, -2099228.60) , (799555.72, -2099932.39) ,
                     (805050.58, -2105382.30) , (793978.03, -2105611.98) ,
                     (795885.23, -2108761.56) , (796062.70, -2113207.54) ,
                     (794947.85, -2116383.50) , (792809.81, -2117146.35) ,
                     (790011.51, -2115189.08) , (792137.78, -2113375.50) ,
                     (789764.84, -2115072.21) , (783075.26, -2114966.44) ,
                     (779094.53, -2110038.41) , (776157.57, -2108667.61) ,
                     (775422.81, -2109631.60) , (778839.45, -2111653.98) ,
                     (781611.79, -2116561.01) , (785307.10, -2116861.67) ,
                     (789276.55, -2121868.54) , (785806.08, -2127862.57) ,
                     (790455.15, -2125931.57) , (791618.94, -2128865.18) ,
                     (784516.56, -2134866.61) , (784734.04, -2130292.54) ,
                     (782781.74, -2133210.11) , (769821.94, -2132071.78) ,
                     (766989.24, -2136017.70) , (769211.78, -2138256.62) ,
                     (762708.77, -2140487.03) , (762846.35, -2142771.15) ,
                     (777404.83, -2138656.61) , (780073.31, -2141083.47) ,
                     (780949.07, -2144443.47) , (775903.39, -2149050.20) ,
                     (779911.89, -2150121.22) , (780331.67, -2151829.36) ,
                     (775042.83, -2153827.96) , (771021.05, -2150522.00) ,
                     (767699.77, -2152662.90) , (775410.19, -2158730.95) ,
                     (773109.25, -2165226.23) , (769758.12, -2164075.77) ,
                     (768803.20, -2161945.43) , (769883.71, -2160375.56) ,
                     (765211.03, -2162891.48) , (759719.81, -2161123.66) ,
                     (758709.66, -2158321.74) , (758181.77, -2161689.42) ,
                     (761773.83, -2163477.75) , (763452.98, -2166594.92) ,
                     (757531.06, -2170359.51) , (760547.46, -2171287.33) ,
                     (765667.96, -2168905.33) , (767548.04, -2169641.14) ,
                     (768481.79, -2172391.97) , (755124.88, -2176451.56) ,
                     (754335.61, -2178118.33) , (762401.05, -2180830.88) ,
                     (764439.83, -2179703.45) , (763989.70, -2184765.42) ,
                     (755404.64, -2185218.07) , (758517.19, -2188625.94) ,
                     (751428.78, -2188275.13) , (750854.01, -2189365.71) ,
                     (753702.06, -2196527.33) , (742686.75, -2199238.94) ,
                     (742182.14, -2202658.20) , (744931.18, -2204151.74) ,
                     (742761.67, -2207185.70) , (744551.06, -2206617.14) ,
                     (745006.16, -2207879.27) , (740016.78, -2214609.15) ,
                     (738345.94, -2212983.09) , (738173.94, -2217869.07) ,
                     (738265.82, -2212238.98) , (737096.31, -2211738.89) ,
                     (735132.43, -2216151.68) , (731573.99, -2217483.79) ,
                     (729262.40, -2212392.40) , (726832.36, -2220630.39) ,
                     (722279.65, -2217458.53) , (720011.04, -2217984.93) ,
                     (721541.40, -2229738.18) , (710756.81, -2229734.35) ,
                     (708672.44, -2231919.16) , (716323.99, -2235789.30) ,
                     (715572.61, -2237406.39) , (707874.82, -2240370.39) ,
                     (704637.09, -2239833.39) , (705436.48, -2234011.00) ,
                     (703552.61, -2232843.31) , (700570.22, -2241726.86) ,
                     (696435.80, -2244163.95) , (694939.08, -2243105.26) ,
                     (694652.86, -2244670.06) , (701219.45, -2245463.69) ,
                     (703503.97, -2247187.36) , (702830.78, -2249076.48) ,
                     (695219.03, -2250997.35) , (690108.01, -2248476.15) ,
                     (685694.19, -2241138.24) , (684319.06, -2246003.20) ,
                     (688349.34, -2256605.70) , (685745.86, -2254823.90) ,
                     (683947.13, -2257985.25) , (678685.86, -2254307.07) ,
                     (671923.13, -2253963.65) , (672244.80, -2255398.32) ,
                     (678329.71, -2257888.21) , (680582.31, -2261830.37) ,
                     (678599.96, -2263104.70) , (669150.12, -2261019.54) ,
                     (670819.33, -2266276.83) , (666308.31, -2267278.06) ,
                     (665224.17, -2269173.55) , (667781.87, -2272957.29) ,
                     (662585.79, -2274093.14) , (661125.66, -2272462.07) ,
                     (658511.08, -2273791.00) , (660240.61, -2278467.60) ,
                     (659384.02, -2280597.44) , (654101.51, -2276316.11) ,
                     (652820.20, -2278970.83) , (641085.99, -2273424.63) ,
                     (640556.11, -2274719.18) , (644490.74, -2279345.61) ,
                     (649659.93, -2281726.68) , (649130.87, -2284252.09) ,
                     (650920.36, -2286029.90) , (647931.38, -2290883.59) ,
                     (646777.29, -2287176.72) , (644328.96, -2287571.98) ,
                     (643658.07, -2284681.41) , (640117.90, -2286704.36) ,
                     (641934.70, -2289283.73) , (641924.49, -2294299.48) ,
                     (639375.88, -2294485.81) , (638762.42, -2292656.22) ,
                     (635668.27, -2294727.22) , (641041.19, -2297167.48) ,
                     (640351.93, -2298834.95) , (637245.90, -2299288.07) ,
                     (630245.01, -2296606.29) , (629977.89, -2294830.84) ,
                     (632275.82, -2293730.74) , (630495.33, -2293234.96) ,
                     (631125.74, -2291205.54) , (627440.96, -2293431.31) ,
                     (623606.38, -2292438.19) , (621466.75, -2284777.86) ,
                     (619816.67, -2284882.11) , (617333.67, -2281300.01) ,
                     (615955.95, -2282883.32) , (612443.36, -2282920.85) ,
                     (610923.03, -2284979.58) , (612647.09, -2291622.07) ,
                     (611314.86, -2295490.41) , (616688.00, -2299726.76) ,
                     (613539.26, -2301905.05) , (609609.89, -2299515.56) ,
                     (605368.10, -2300303.02) , (603621.45, -2303108.08) ,
                     (608641.56, -2302746.15) , (612092.69, -2304250.82) ,
                     (618448.08, -2314310.11) , (614305.35, -2314274.29) ,
                     (614774.08, -2317318.52) , (613326.22, -2318240.86) ,
                     (609487.38, -2316944.06) , (609275.60, -2319617.42) ,
                     (607023.74, -2319436.60) , (606854.73, -2320866.27) ,
                     (602428.47, -2316653.41) , (600316.94, -2306040.81) ,
                     (597238.94, -2308168.51) , (593234.52, -2308423.70) ,
                     (584297.73, -2304773.57) , (581864.73, -2308490.25) ,
                     (587953.51, -2310136.80) , (588197.95, -2311457.13) ,
                     (597919.21, -2313032.17) , (601792.80, -2321297.44) ,
                     (600661.12, -2324246.22) , (602391.39, -2322983.03) ,
                     (602986.29, -2324761.27) , (599743.97, -2326520.15) ,
                     (599255.79, -2323791.81) , (597237.31, -2325185.74) ,
                     (594922.69, -2324370.20) , (595504.14, -2326165.81) ,
                     (592247.84, -2327713.75) , (589193.02, -2325379.85) ,
                     (589075.25, -2327633.98) , (585926.82, -2328485.84) ,
                     (578805.53, -2322001.25) , (577442.53, -2316904.08) ,
                     (576545.37, -2319213.73) , (570854.24, -2320502.66) ,
                     (574414.71, -2321120.26) , (579842.31, -2326082.42) ,
                     (575022.97, -2327228.10) , (580950.57, -2326840.21) ,
                     (584959.61, -2330816.99) , (580525.42, -2333344.78) ,
                     (578439.15, -2332030.88) , (577962.26, -2334501.58) ,
                     (570219.43, -2332913.28) , (568908.67, -2331041.39) ,
                     (567748.21, -2332178.96) , (560497.05, -2330000.19) ,
                     (560086.73, -2328271.74) , (563430.27, -2327454.11) ,
                     (565590.83, -2325117.51) , (558067.55, -2327299.12) ,
                     (559138.61, -2331131.32) , (563233.62, -2334583.96) ,
                     (557052.74, -2337444.31) , (554582.01, -2335367.70) ,
                     (555185.81, -2333042.09) , (551966.00, -2335865.30) ,
                     (549975.15, -2330013.90) , (549596.85, -2332295.70) ,
                     (548326.44, -2331919.96) , (550485.33, -2326271.51) ,
                     (546416.87, -2324514.62) , (547850.54, -2320470.93) ,
                     (553605.37, -2320294.22) , (555750.91, -2317252.84) ,
                     (554518.72, -2315489.88) , (551258.01, -2317583.48) ,
                     (543672.60, -2318149.68) , (540231.26, -2318124.71) ,
                     (539268.97, -2316435.67) , (537768.87, -2319649.05) ,
                     (533645.75, -2320197.96) , (528227.81, -2310342.26) ,
                     (523555.48, -2307426.40) , (522497.65, -2297130.23) ,
                     (520542.19, -2297393.66) , (519040.41, -2306588.68) ,
                     (515912.41, -2304419.59) , (515319.59, -2298784.84) ,
                     (511169.39, -2290229.82) , (508495.29, -2288332.65) ,
                     (508101.23, -2285327.00) , (504031.20, -2285219.85) ,
                     (503318.04, -2286688.16) , (507380.47, -2294134.12) ,
                     (503109.79, -2292837.26) , (497843.47, -2293559.42) ,
                     (495681.77, -2295931.26) , (498355.32, -2299470.81) ,
                     (504203.62, -2299162.48) , (504112.74, -2301656.51) ,
                     (513333.14, -2311908.93) , (517343.06, -2313487.88) ,
                     (523499.32, -2313238.62) , (533373.89, -2330103.21) ,
                     (527088.48, -2328375.78) , (527208.03, -2326330.91) ,
                     (520816.31, -2327868.75) , (518270.14, -2330351.41) ,
                     (528892.40, -2332222.54) , (529934.27, -2335495.84) ,
                     (533813.02, -2333194.23) , (539265.58, -2334019.52) ,
                     (536408.15, -2336359.62) , (538891.46, -2339003.87) ,
                     (540508.30, -2346564.28) , (536846.93, -2343612.19) ,
                     (535270.57, -2347185.98) , (539065.20, -2348920.45) ,
                     (537721.00, -2351034.05) , (541401.55, -2350500.37) ,
                     (538569.37, -2354443.88) , (542793.51, -2357990.77) ,
                     (538227.05, -2357272.61) , (540935.92, -2361149.33) ,
                     (538835.64, -2362535.67) , (537365.96, -2359357.03) ,
                     (535522.21, -2359241.50) , (539679.49, -2365189.69) ,
                     (539234.09, -2368817.54) , (530374.05, -2364028.32) ,
                     (528770.85, -2367571.08) , (523289.97, -2367847.83) ,
                     (521929.88, -2371280.58) , (523844.79, -2373825.65) ,
                     (520837.81, -2375409.12) , (520182.46, -2377982.08) ,
                     (518021.51, -2377306.06) , (518519.40, -2383480.47) ,
                     (515470.46, -2384594.59) , (516918.28, -2387032.46) ,
                     (511386.33, -2391750.18) , (511066.44, -2393738.15) ,
                     (503195.24, -2394581.91) , (501167.09, -2392585.53) ,
                     (498590.21, -2395688.72) , (501945.59, -2398668.15) ,
                     (506292.47, -2399068.24) , (504517.32, -2400714.41) ,
                     (505093.14, -2404056.21) , (501522.02, -2411638.34) ,
                     (497908.95, -2411834.20) , (496448.66, -2410457.20) ,
                     (494905.90, -2411461.52) , (500926.80, -2420094.46) ,
                     (496639.46, -2423759.64) , (496520.80, -2426427.98) ,
                     (501558.92, -2426140.22) , (502255.16, -2427873.88) ,
                     (500160.05, -2428610.19) , (501089.10, -2431506.20) ,
                     (499212.91, -2434175.56) , (496430.54, -2433185.18) ,
                     (497361.36, -2431003.26) , (494808.50, -2429608.77) ,
                     (493580.79, -2429853.96) , (495403.83, -2432457.44) ,
                     (491977.01, -2430018.89) , (493088.30, -2432568.74) ,
                     (488846.23, -2433705.85) , (491626.14, -2437054.59) ,
                     (493263.89, -2435393.79) , (497600.36, -2436073.05) ,
                     (493650.66, -2438120.51) , (498110.08, -2438857.42) ,
                     (498028.01, -2441533.90) , (496162.53, -2443158.32) ,
                     (503163.10, -2444401.21) , (496938.88, -2448729.87) ,
                     (494025.67, -2448857.95) , (493022.56, -2445642.66) ,
                     (491806.07, -2445697.42) , (487834.45, -2451493.79) ,
                     (496185.85, -2451900.43) , (495555.67, -2456972.32) ,
                     (497901.11, -2458386.62) , (496774.15, -2463613.08) ,
                     (498680.94, -2464584.92) , (497322.20, -2465699.25) ,
                     (492161.63, -2464102.20) , (491749.61, -2469647.14) ,
                     (484184.26, -2474848.60) , (486433.51, -2475527.74) ,
                     (489794.43, -2472394.62) , (492145.69, -2474295.71) ,
                     (490596.07, -2475879.45) , (492030.45, -2477331.71) ,
                     (486088.85, -2478483.57) , (479179.01, -2476784.98) ,
                     (477172.55, -2477635.20) , (487336.22, -2480215.21) ,
                     (485488.90, -2482958.23) , (480885.25, -2482989.99) ,
                     (484767.02, -2487082.75) , (482547.46, -2489603.33) ,
                     (480489.59, -2489239.52) , (479951.41, -2492143.30) ,
                     (482558.46, -2491548.01) , (483399.96, -2493932.74) ,
                     (480959.25, -2495609.83) , (483132.12, -2494800.71) ,
                     (483041.23, -2498673.56) , (485946.06, -2501847.00) ,
                     (488255.83, -2501412.02) , (489223.14, -2503829.72) ,
                     (486972.34, -2507322.16) , (483750.46, -2501894.33) ,
                     (479916.89, -2499631.93) , (485241.57, -2507689.99) ,
                     (482628.21, -2506577.69) , (483156.49, -2508492.09) ,
                     (481751.91, -2509489.70) , (483228.76, -2512294.67) ,
                     (479564.68, -2512281.73) , (481082.72, -2512730.86) ,
                     (482258.46, -2518003.45) , (479838.16, -2520034.13) ,
                     (480599.73, -2524704.42) , (476342.48, -2528382.61) ,
                     (477713.87, -2520348.04) , (476331.48, -2514961.99) ,
                     (474777.01, -2515442.27) , (475732.80, -2519841.35) ,
                     (473423.33, -2527227.33) , (471595.41, -2525857.65) ,
                     (470561.27, -2521171.99) , (471527.32, -2516373.15) ,
                     (468768.44, -2510342.48) , (467222.19, -2511398.30) ,
                     (469308.85, -2518134.64) , (467391.12, -2518774.95) ,
                     (467939.07, -2521093.43) , (464952.77, -2522390.14) ,
                     (467699.26, -2523494.82) , (467888.42, -2526686.73) ,
                     (465965.71, -2528054.44) , (467888.36, -2530772.94) ,
                     (469326.76, -2529918.82) , (471935.81, -2531692.38) ,
                     (472384.89, -2534369.76) , (471527.08, -2538652.44) ,
                     (467557.75, -2538865.72) , (467491.47, -2544362.78) ,
                     (465957.83, -2542877.22) , (461900.13, -2546230.02) ,
                     (461419.12, -2550690.83) , (463722.72, -2547306.02) ,
                     (465046.44, -2549106.85) , (464690.69, -2554066.53) ,
                     (463079.37, -2555233.21) , (460081.29, -2550936.10) ,
                     (461947.20, -2558239.15) , (459778.91, -2557253.85) ,
                     (459833.30, -2560269.53) , (457710.80, -2561716.06) ,
                     (456480.39, -2555485.75) , (454801.48, -2556212.21) ,
                     (455309.87, -2558729.26) , (452578.18, -2558609.31) ,
                     (454401.36, -2559555.21) , (454781.99, -2563523.91) ,
                     (451590.69, -2565100.33) , (443918.03, -2561569.53) ,
                     (444671.52, -2556812.02) , (443281.09, -2552165.48) ,
                     (441902.41, -2556915.83) , (439518.69, -2557029.70) ,
                     (441082.43, -2562576.58) , (440027.49, -2563781.19) ,
                     (448965.36, -2566493.27) , (450063.55, -2568283.91) ,
                     (448391.87, -2570414.98) , (443001.32, -2571289.23) ,
                     (430830.66, -2567679.63) , (430365.21, -2564225.17) ,
                     (428317.37, -2568847.97) , (425273.01, -2569201.27) ,
                     (417780.43, -2559185.15) , (413921.67, -2556463.93) ,
                     (417164.00, -2552159.99) , (413062.75, -2554286.00) ,
                     (409751.89, -2553917.05) , (408520.97, -2556567.61) ,
                     (410797.03, -2558974.54) , (413890.35, -2560187.31) ,
                     (417843.41, -2564665.35) , (421514.09, -2565690.04) ,
                     (420400.28, -2570114.39) , (414141.33, -2572937.91) ,
                     (415083.12, -2575372.04) , (423293.03, -2570858.38) ,
                     (428181.54, -2572539.62) , (421114.66, -2578536.19) ,
                     (425667.26, -2577039.40) , (429577.73, -2585657.77) ,
                     (428041.08, -2586007.98) , (428774.30, -2587942.28) ,
                     (426441.28, -2588049.09) , (423636.75, -2580861.56) ,
                     (418575.09, -2580029.66) , (422467.53, -2581978.65) ,
                     (424068.41, -2588428.35) , (414734.84, -2587101.81) ,
                     (412796.14, -2591779.72) , (410421.54, -2593124.07) ,
                     (414314.66, -2592220.27) , (415893.99, -2589632.15) ,
                     (419373.84, -2591994.17) , (422138.46, -2591351.83) ,
                     (423313.87, -2593700.41) , (417045.42, -2594904.44) ,
                     (416476.24, -2593429.22) , (414374.18, -2593544.04) ,
                     (415374.91, -2595405.48) , (412783.30, -2595906.26) ,
                     (412963.83, -2597010.81) , (417263.52, -2597274.54) ,
                     (415024.97, -2599029.68) , (416386.38, -2601672.41) ,
                     (414804.69, -2603527.80) , (414848.87, -2607048.86) ,
                     (414016.28, -2606232.84) , (409518.88, -2608484.37) ,
                     (413308.28, -2609673.17) , (409716.29, -2614372.55) ,
                     (407249.05, -2613702.72) , (407307.56, -2609450.75) ,
                     (405676.10, -2614331.20) , (402621.60, -2614198.56) ,
                     (404302.95, -2611379.04) , (403207.65, -2607562.10) ,
                     (402851.30, -2612255.00) , (400874.84, -2612815.59) ,
                     (400372.80, -2605345.68) , (400053.63, -2609718.88) ,
                     (398656.40, -2609413.03) , (397952.76, -2611513.10) ,
                     (399398.00, -2614789.66) , (398652.62, -2617843.74) ,
                     (396170.67, -2616714.10) , (395029.50, -2605958.74) ,
                     (393889.54, -2605708.51) , (396212.99, -2598162.09) ,
                     (394848.42, -2597097.19) , (391964.64, -2600143.08) ,
                     (384794.01, -2599652.06) , (381525.86, -2597705.49) ,
                     (382756.48, -2601800.88) , (390687.00, -2603042.35) ,
                     (390907.81, -2608080.15) , (389506.07, -2610920.31) ,
                     (379718.20, -2619064.11) , (377063.38, -2617275.74) ,
                     (372732.02, -2619601.71) , (374189.21, -2621226.32) ,
                     (373704.24, -2624452.71) , (370802.33, -2626498.73) ,
                     (368034.50, -2626553.97) , (367837.01, -2623497.95) ,
                     (363962.59, -2619234.53) , (364617.73, -2604408.31) ,
                     (363249.62, -2604475.10) , (364164.83, -2613926.90) ,
                     (362910.96, -2615117.36) , (353876.06, -2600293.13) ,
                     (359549.18, -2612863.46) , (362750.74, -2616090.88) ,
                     (360943.44, -2619507.78) , (363253.80, -2621208.79) ,
                     (364506.35, -2625401.17) , (362274.88, -2626512.52) ,
                     (355730.35, -2624132.37) , (349598.92, -2619158.61) ,
                     (347206.63, -2613530.43) , (346217.94, -2613457.57) ,
                     (348392.74, -2620243.77) , (360980.63, -2627393.55) ,
                     (365665.85, -2627815.87) , (366118.89, -2634392.49) ,
                     (364278.79, -2636325.40) , (362656.78, -2635491.86) ,
                     (362912.15, -2633902.30) , (361872.81, -2635561.87) ,
                     (359611.25, -2632483.88) , (357635.00, -2633406.92) ,
                     (356095.06, -2631900.82) , (357378.40, -2633810.66) ,
                     (363147.14, -2637455.83) , (362013.07, -2640220.88) ,
                     (337530.00, -2622200.67) , (337483.45, -2626126.42) ,
                     (333001.49, -2628688.71) , (334329.98, -2621888.30) ,
                     (337581.75, -2617880.72) , (332143.60, -2619692.31) ,
                     (333661.14, -2614615.64) , (331765.40, -2615604.90) ,
                     (331139.54, -2610935.95) , (333976.00, -2608238.66) ,
                     (336736.53, -2608229.08) , (338415.15, -2602675.39) ,
                     (341459.33, -2602813.93) , (339783.10, -2596539.49) ,
                     (348211.72, -2582559.93) , (356531.81, -2577555.74) ,
                     (360056.28, -2577706.66) , (365141.17, -2572741.26) ,
                     (368663.15, -2565189.60) , (366221.62, -2564732.52) ,
                     (357415.61, -2574513.38) , (353404.16, -2574551.29) ,
                     (345862.55, -2579259.41) , (340764.64, -2574883.99) ,
                     (338638.18, -2574820.87) , (339492.38, -2579177.62) ,
                     (336435.42, -2580591.28) , (325992.69, -2576260.79) ,
                     (322633.88, -2569202.38) , (323404.10, -2576269.36) ,
                     (314650.86, -2575450.81) , (314173.69, -2581352.09) ,
                     (327431.83, -2582742.66) , (332563.59, -2587051.38) ,
                     (328900.86, -2594689.84) , (327314.36, -2589148.94) ,
                     (324413.03, -2589502.74) , (323494.32, -2591440.54) ,
                     (320233.92, -2589856.97) , (318168.96, -2594819.41) ,
                     (321735.62, -2594489.63) , (322422.61, -2595726.01) ,
                     (325604.17, -2594132.87) , (326837.88, -2595635.88) ,
                     (325536.99, -2597076.48) , (327477.08, -2597854.04) ,
                     (323287.71, -2602852.05) , (323638.78, -2606841.72) ,
                     (318397.82, -2609239.65) , (316422.02, -2605759.20) ,
                     (315413.89, -2608209.75) , (317731.03, -2609880.00) ,
                     (323264.38, -2608151.01) , (324188.04, -2609126.73) ,
                     (324707.06, -2611951.25) , (322405.46, -2613877.98) ,
                     (324133.35, -2615452.00) , (324984.33, -2622687.16) ,
                     (323911.53, -2627292.88) , (321901.01, -2630046.23) ,
                     (320625.18, -2622789.63) , (319480.77, -2626063.56) ,
                     (317814.89, -2625672.93) , (317648.97, -2622540.08) ,
                     (316839.79, -2625529.33) , (314698.09, -2620056.06) ,
                     (317685.62, -2630942.24) , (313282.97, -2631810.74) ,
                     (312786.53, -2629278.10) , (311244.12, -2631350.44) ,
                     (308665.36, -2625773.57) , (306237.46, -2626703.59) ,
                     (306786.30, -2632700.35) , (312322.76, -2635584.97) ,
                     (314428.97, -2638576.37) , (315990.64, -2638068.97) ,
                     (317187.34, -2640417.11) , (317558.84, -2638601.80) ,
                     (319415.34, -2638484.70) , (322509.28, -2641140.88) ,
                     (321801.84, -2645375.50) , (318810.66, -2643662.31) ,
                     (317811.98, -2645179.75) , (320423.50, -2645644.07) ,
                     (319134.11, -2647766.76) , (321019.85, -2649041.38) ,
                     (319330.05, -2651213.04) , (320274.22, -2654420.94) ,
                     (316547.27, -2653155.67) , (319899.58, -2655491.52) ,
                     (318399.04, -2660061.43) , (315884.08, -2660701.47) ,
                     (315278.54, -2658848.20) , (312482.15, -2658056.14) ,
                     (308113.57, -2666640.11) , (306026.53, -2659537.80) ,
                     (309110.58, -2657650.55) , (308523.30, -2656077.79) ,
                     (305974.10, -2658652.56) , (303925.75, -2652599.91) ,
                     (305053.52, -2660807.45) , (303684.34, -2662239.10) ,
                     (301839.08, -2660999.92) , (302645.91, -2658407.72) ,
                     (300049.00, -2656831.45) , (301023.83, -2660450.64) ,
                     (294748.33, -2658941.04) , (296184.51, -2659103.39) ,
                     (294334.11, -2655323.21) , (294809.12, -2656810.54) ,
                     (292660.36, -2658558.63) , (295496.48, -2661436.51) ,
                     (294028.12, -2662130.49) , (299957.92, -2663716.51) ,
                     (301123.12, -2662570.76) , (303047.19, -2669029.50) ,
                     (302193.55, -2669904.25) , (299982.24, -2667575.72) ,
                     (296212.67, -2668859.78) , (291324.72, -2664777.02) ,
                     (290690.93, -2667421.05) , (288669.86, -2666889.82) ,
                     (290309.81, -2668331.15) , (289628.68, -2670791.69) ,
                     (285452.55, -2670763.56) , (286784.60, -2676154.45) ,
                     (284181.15, -2672402.51) , (286696.44, -2666529.26) ,
                     (284947.51, -2666697.12) , (284591.18, -2669549.69) ,
                     (281058.86, -2672850.74) , (276597.76, -2660203.58) ,
                     (275572.90, -2660382.41) , (276543.91, -2662743.47) ,
                     (266343.82, -2653363.06) , (266274.12, -2656915.38) ,
                     (270278.36, -2660397.44) , (272414.62, -2667208.71) ,
                     (274726.98, -2668646.84) , (274742.79, -2671034.64) ,
                     (273294.61, -2671396.64) , (269825.39, -2667807.80) ,
                     (270719.34, -2672722.54) , (269177.80, -2676787.77) ,
                     (267640.14, -2672432.46) , (268907.49, -2667899.48) ,
                     (268584.42, -2665946.18) , (266456.78, -2671971.11) ,
                     (267321.89, -2674548.61) , (265426.21, -2677620.85) ,
                     (263628.91, -2677021.10) , (261656.17, -2670495.88) ,
                     (258862.61, -2668342.43) , (260452.56, -2663400.31) ,
                     (258160.76, -2665980.35) , (253599.45, -2662339.04) ,
                     (251391.13, -2664902.85) , (255777.93, -2668610.53) ,
                     (251600.13, -2665908.33) , (249585.62, -2669897.07) ,
                     (251283.16, -2672271.15) , (249064.70, -2671601.27) ,
                     (246558.03, -2673295.33) , (252264.93, -2675425.18) ,
                     (252022.37, -2677554.72) , (247770.08, -2675583.30) ,
                     (248404.60, -2682230.84) , (242621.35, -2680292.38) ,
                     (239228.96, -2675344.98) , (236826.72, -2675014.68) ,
                     (234480.19, -2677577.11) , (239137.01, -2684300.63) ,
                     (231057.94, -2682878.30) , (230412.30, -2684959.00) ,
                     (236612.87, -2688548.46) , (245260.04, -2689107.64) ,
                     (249331.55, -2691691.31) , (250317.51, -2693282.11) ,
                     (249184.20, -2694173.23) , (245173.98, -2691895.69) ,
                     (244368.09, -2697120.55) , (239025.47, -2696008.59) ,
                     (239151.07, -2697157.20) , (245409.15, -2701504.16) ,
                     (246918.13, -2703896.16) , (245320.26, -2706766.27) ,
                     (248728.62, -2708635.43) , (248470.23, -2704905.92) ,
                     (252284.48, -2710787.86) , (246617.57, -2711639.84) ,
                     (244269.86, -2709906.32) , (245249.97, -2712893.54) ,
                     (242664.66, -2712950.88) , (244837.63, -2714556.46) ,
                     (244673.23, -2716480.49) , (239226.97, -2714601.08) ,
                     (239290.09, -2716908.87) , (241804.23, -2718871.57) ,
                     (245362.71, -2719127.47) , (245376.25, -2720663.08) ,
                     (243163.85, -2720314.92) , (244201.70, -2721646.09) ,
                     (234972.79, -2720210.07) , (236048.84, -2723886.55) ,
                     (239995.12, -2725069.04) , (238755.59, -2727554.63) ,
                     (241957.42, -2729860.53) , (234823.74, -2730145.79) ,
                     (233422.19, -2733675.39) , (232653.67, -2732452.67) ,
                     (230361.96, -2733166.44) , (228908.82, -2735179.74) ,
                     (229819.91, -2741555.46) , (226865.62, -2740133.20) ,
                     (227269.66, -2738389.88) , (222218.57, -2729960.47) ,
                     (221418.47, -2729299.96) , (219044.37, -2730797.49) ,
                     (221073.03, -2731034.46) , (222995.51, -2735252.20) ,
                     (222848.33, -2738128.78) , (212973.76, -2729036.47) ,
                     (211899.89, -2724224.85) , (206950.98, -2720437.94) ,
                     (205010.33, -2722435.41) , (208710.98, -2728433.78) ,
                     (206714.18, -2731782.26) , (207095.86, -2738778.46) ,
                     (202886.85, -2733903.50) , (202381.82, -2730310.63) ,
                     (200823.80, -2730190.05) , (201203.90, -2732361.97) ,
                     (197628.31, -2730360.39) , (199734.79, -2735843.59) ,
                     (196911.05, -2733500.02) , (190546.87, -2732402.87) ,
                     (186659.30, -2726307.49) , (183452.98, -2728843.11) ,
                     (185182.99, -2733418.02) , (188627.27, -2735560.87) ,
                     (189058.75, -2739165.69) , (191484.08, -2740924.95) ,
                     (193671.70, -2747114.60) , (191611.41, -2748341.31) ,
                     (185382.00, -2744498.78) , (183970.07, -2750736.53) ,
                     (186121.77, -2751110.22) , (189549.56, -2756709.42) ,
                     (193605.60, -2758512.92) , (193316.45, -2759980.94) ,
                     (198141.33, -2759971.17) , (198325.57, -2757904.70) ,
                     (199469.81, -2758451.06) , (198396.35, -2762197.69) ,
                     (194910.39, -2760842.36) , (193685.59, -2764231.48) ,
                     (199184.05, -2765232.82) , (199439.86, -2767520.13) ,
                     (205140.49, -2773179.41) , (210179.67, -2774742.12) ,
                     (210281.08, -2778386.05) , (214964.82, -2780778.08) ,
                     (215291.68, -2783389.51) , (213133.64, -2783821.87) ,
                     (215278.22, -2785263.51) , (217676.98, -2799465.48) ,
                     (214838.94, -2800761.75) , (213698.20, -2804435.02) ,
                     (221238.06, -2805413.48) , (227648.25, -2808967.59) ,
                     (226747.09, -2810258.19) , (229028.66, -2810864.94) ,
                     (227240.09, -2812651.31) , (229370.05, -2814548.53) ,
                     (224523.29, -2817135.68) , (225432.84, -2816435.28) ,
                     (222915.82, -2813777.07) , (223754.66, -2816025.62) ,
                     (221005.98, -2815757.77) , (219365.52, -2819093.46) ,
                     (217763.02, -2815603.07) , (219882.65, -2814570.17) ,
                     (216916.79, -2813536.14) , (216741.29, -2815017.42) ,
                     (214392.75, -2810565.81) , (213624.62, -2814397.86) ,
                     (209724.92, -2812054.58) , (209403.96, -2815230.03) ,
                     (206224.63, -2815643.39) , (208660.50, -2814003.22) ,
                     (207109.53, -2813224.96) , (200753.30, -2818898.73) ,
                     (201429.88, -2820407.84) , (205136.25, -2820067.00) ,
                     (211190.63, -2816600.10) , (208952.74, -2819365.71) ,
                     (192985.73, -2823210.28) , (191958.13, -2821622.10) ,
                     (191150.27, -2822847.89) , (186307.01, -2820970.38) ,
                     (179745.00, -2821515.69) , (181591.98, -2819766.96) ,
                     (180667.81, -2817874.14) , (171846.26, -2822977.74) ,
                     (170255.58, -2828476.13) , (171676.80, -2830627.05) ,
                     (174951.89, -2829413.46) , (176426.21, -2831140.18) ,
                     (175746.07, -2832876.20) , (178540.10, -2834263.24) ,
                     (174740.13, -2833715.25) , (177820.03, -2836679.95) ,
                     (175627.66, -2837874.54) , (176632.27, -2840373.31) ,
                     (181917.80, -2838879.36) , (185153.95, -2840472.12) ,
                     (187796.56, -2839237.04) , (194789.61, -2841054.34) ,
                     (196592.53, -2846348.58) , (199105.32, -2848724.04) ,
                     (200705.71, -2848596.05) , (201817.45, -2844658.47) ,
                     (199748.05, -2843275.65) , (201035.38, -2841742.35) ,
                     (199351.45, -2840590.22) , (203922.65, -2837640.15) ,
                     (209963.12, -2837608.42) , (209909.56, -2839001.99) ,
                     (212755.90, -2838854.54) , (214608.39, -2842390.76) ,
                     (219292.65, -2842642.65) , (222179.21, -2847821.98) ,
                     (217113.34, -2856085.91) , (219591.71, -2860061.67) ,
                     (216146.66, -2860913.76) , (214718.78, -2858936.22) ,
                     (213281.40, -2859294.80) , (214721.98, -2857234.11) ,
                     (217148.51, -2857836.13) , (215068.49, -2856324.78) ,
                     (212686.51, -2859229.99) , (210714.42, -2858415.91) ,
                     (210393.62, -2858657.70) , (214186.93, -2861465.22) ,
                     (212104.93, -2860965.10) , (208186.65, -2863306.14) ,
                     (213847.66, -2863511.82) , (215716.36, -2867112.06) ,
                     (217877.89, -2863743.63) , (219647.70, -2864792.28) ,
                     (218457.54, -2865003.13) , (220059.37, -2868243.12) ,
                     (218621.34, -2868557.07) , (220831.26, -2869332.80) ,
                     (220216.22, -2872874.76) , (222133.05, -2875508.16) ,
                     (218910.38, -2879368.40) , (221630.62, -2879560.21) ,
                     (220438.73, -2881381.63) , (222229.41, -2883397.21) ,
                     (222560.54, -2881369.94) , (224009.36, -2881755.28) ,
                     (223390.19, -2883939.80) , (224934.89, -2883369.83) ,
                     (225236.97, -2887873.07) , (227047.68, -2890077.81) ,
                     (219925.84, -2892968.77) , (219098.39, -2891176.88) ,
                     (220787.45, -2890605.52) , (220445.28, -2888067.27) ,
                     (217047.89, -2889641.08) , (216734.54, -2893278.38) ,
                     (217837.21, -2892193.14) , (216633.69, -2894040.77) ,
                     (215176.32, -2894014.28) , (215500.85, -2892615.90) ,
                     (213819.26, -2893664.24) , (201373.73, -2891672.13) ,
                     (193678.83, -2887174.12) , (182271.26, -2883597.34) ,
                     (178317.07, -2873377.31) , (175278.34, -2873743.44) ,
                     (176453.87, -2877919.03) , (175309.31, -2880349.71) ,
                     (167849.72, -2880995.90) , (167159.35, -2886050.60) ,
                     (172949.60, -2888974.81) , (174163.27, -2886178.88) ,
                     (177582.63, -2885483.16) , (189664.93, -2893905.91) ,
                     (193876.07, -2894738.04) , (196656.20, -2892912.50) ,
                     (199027.47, -2894663.21) , (208584.56, -2896369.26) ,
                     (209185.86, -2900494.65) , (210915.85, -2903561.06) ,
                     (212276.26, -2903334.91) , (207602.92, -2904509.12) ,
                     (212256.90, -2906586.24) , (212858.27, -2904741.55) ,
                     (216130.48, -2903470.49) , (213179.97, -2908837.12) ,
                     (214791.54, -2909812.06) , (215707.68, -2907091.29) ,
                     (216196.68, -2912613.76) , (213573.49, -2914362.07) ,
                     (210792.07, -2910377.71) , (208776.04, -2913046.39) ,
                     (210300.37, -2913037.41) , (210695.45, -2914904.47) ,
                     (207170.11, -2913121.01) , (207867.80, -2911612.89) ,
                     (204399.52, -2908357.68) , (206164.42, -2912167.50) ,
                     (205405.81, -2913651.99) , (201795.06, -2907526.42) ,
                     (203345.69, -2913583.76) , (200467.54, -2914416.81) ,
                     (195538.08, -2912510.36) , (200351.28, -2914428.24) ,
                     (204621.09, -2919510.29) , (200087.35, -2921670.83) ,
                     (196733.39, -2919252.90) , (193487.98, -2912248.22) ,
                     (187956.70, -2907851.33) , (187934.76, -2912574.13) ,
                     (192808.48, -2914663.65) , (197405.53, -2922998.32) ,
                     (203559.91, -2922933.15) , (203852.57, -2925529.48) ,
                     (198614.80, -2926544.18) , (204263.42, -2932193.09) ,
                     (203370.71, -2933810.51) , (197805.43, -2929855.26) ,
                     (198769.80, -2927497.00) , (195037.27, -2927433.44) ,
                     (192579.86, -2921403.26) , (190319.33, -2920369.96) ,
                     (185665.12, -2913771.47) , (186367.60, -2912731.98) ,
                     (183381.77, -2911477.71) , (181768.65, -2908416.15) ,
                     (180546.94, -2909389.46) , (187250.66, -2917423.70) ,
                     (191902.00, -2926606.50) , (185002.34, -2920437.18) ,
                     (181316.37, -2919076.76) , (179335.91, -2913821.50) ,
                     (176858.47, -2911675.52) , (178801.30, -2919153.00) ,
                     (173327.63, -2917797.02) , (184324.41, -2923320.60) ,
                     (189362.25, -2929064.32) , (196657.08, -2932140.91) ,
                     (198539.27, -2937117.02) , (194013.24, -2932114.51) ,
                     (190970.17, -2932202.17) , (188670.61, -2930058.42) ,
                     (184599.22, -2930716.97) , (184533.06, -2926849.35) ,
                     (182366.22, -2924265.62) , (178799.29, -2923803.24) ,
                     (178076.90, -2925078.83) , (175495.70, -2923767.84) ,
                     (165490.72, -2909521.44) , (164530.24, -2911348.08) ,
                     (166066.07, -2914825.72) , (156410.37, -2920175.13) ,
                     (157278.05, -2924398.94) , (161450.33, -2930131.68) ,
                     (165392.22, -2930823.08) , (169511.31, -2934753.76) ,
                     (168299.71, -2937017.02) , (162236.71, -2935068.82) ,
                     (165807.07, -2937618.54) , (164432.07, -2940015.22) ,
                     (170141.78, -2939004.02) , (170967.37, -2937572.06) ,
                     (173600.40, -2939244.43) , (176341.17, -2944047.71) ,
                     (172961.18, -2944592.60) , (177396.81, -2945204.03) ,
                     (180832.92, -2948147.87) , (179733.30, -2952838.93) ,
                     (184400.00, -2960270.99) , (181065.14, -2961279.46) ,
                     (180601.87, -2960182.27) , (177899.83, -2962817.72) ,
                     (174823.47, -2957470.46) , (168806.82, -2954801.13) ,
                     (162284.06, -2948207.76) , (158366.84, -2948549.95) ,
                     (148429.42, -2944556.38) , (157599.02, -2950664.61) ,
                     (161873.90, -2951510.59) , (166751.52, -2956644.80) ,
                     (170776.22, -2958258.62) , (179516.83, -2969132.77) ,
                     (171777.77, -2969158.88) , (167404.64, -2965379.90) ,
                     (164851.27, -2965986.55) , (168273.86, -2968495.09) ,
                     (169440.55, -2967526.52) , (170004.31, -2969350.26) ,
                     (168593.49, -2970225.33) , (161421.41, -2967239.77) ,
                     (160019.05, -2962297.84) , (157881.03, -2963831.70) ,
                     (155622.21, -2962089.22) , (158310.48, -2965345.93) ,
                     (156872.87, -2967281.10) , (147274.94, -2950332.20) ,
                     (144551.82, -2951539.05) , (147495.94, -2957728.24) ,
                     (147213.55, -2961250.09) , (142937.41, -2963141.44) ,
                     (147679.56, -2963729.32) , (154391.12, -2968320.07) ,
                     (153978.53, -2971856.75) , (146781.90, -2970969.88) ,
                     (146371.56, -2972464.30) , (148199.92, -2973723.26) ,
                     (156971.24, -2972704.17) , (158382.22, -2975371.40) ,
                     (157434.76, -2971161.65) , (162685.56, -2971079.11) ,
                     (168081.07, -2973332.25) , (167818.85, -2974534.57) ,
                     (168153.33, -2974647.35) , (168910.40, -2973396.33) ,
                     (171956.29, -2974180.29) , (172433.50, -2975719.40) ,
                     (176003.14, -2974685.74) , (176640.71, -2977238.89) ,
                     (175380.05, -2977755.55) , (176955.37, -2980527.38) ,
                     (175392.43, -2983270.74) , (174231.38, -2982240.14) ,
                     (175171.28, -2984291.96) , (172773.12, -2985884.49) ,
                     (169152.52, -2984364.22) , (168148.95, -2981671.76) ,
                     (167810.19, -2986085.05) , (169652.13, -2988488.89) ,
                     (166216.98, -2989418.58) , (169395.74, -2990484.47) ,
                     (169773.86, -2992063.80) , (165195.61, -2995695.76) ,
                     (162407.85, -2992796.90) , (157103.67, -2992530.12) ,
                     (156677.99, -2989574.02) , (159617.38, -2985431.15) ,
                     (157265.14, -2986605.13) , (156296.79, -2989288.13) ,
                     (154358.36, -2989010.86) , (157910.82, -2998139.59) ,
                     (154727.68, -2999852.40) , (144261.10, -2995698.92) ,
                     (138881.40, -2997493.70) , (137805.24, -2991647.40) ,
                     (141864.55, -2989292.06) , (144965.22, -2989587.64) ,
                     (142078.53, -2988183.72) , (137628.08, -2989549.67) ,
                     (136757.00, -2987870.94) , (142261.67, -2982008.01) ,
                     (141793.70, -2981129.29) , (134974.72, -2985886.51) ,
                     (132854.69, -2984948.95) , (134109.53, -2991129.43) ,
                     (126516.51, -2990325.31) , (125722.36, -2992644.04) ,
                     (134403.99, -2993819.90) , (135727.40, -2995467.78) ,
                     (134907.37, -2998782.78) , (131139.14, -3001873.00) ,
                     (128128.79, -2995772.64) , (126491.07, -2995405.93) ,
                     (131722.61, -3010505.06) , (125751.85, -3003003.77) ,
                     (125068.32, -3006981.91) , (128133.49, -3010504.13) ,
                     (124402.90, -3012944.05) , (123814.60, -3007840.28) ,
                     (119862.82, -3000215.39) , (119717.62, -3005035.98) ,
                     (122445.64, -3010680.12) , (121418.59, -3013706.28) ,
                     (115079.00, -3009929.42) , (102701.11, -3008934.68) ,
                     (97778.42, -3003671.78)  , (96876.48, -3005709.25) ,
                     (99452.43, -3010189.23)  , (98806.45, -3012802.86)  ,
                     (106031.34, -3012965.66) , (119672.86, -3017510.30) ,
                     (120858.31, -3018806.08) , (119082.67, -3019598.58) ,
                     (122369.87, -3026350.57) , (125324.16, -3025285.51) ,
                     (122379.44, -3020217.43) , (125689.97, -3018274.12) ,
                     (132934.26, -3022241.46) , (133805.22, -3024510.67) ,
                     (135608.27, -3024745.63) , (135168.26, -3026405.84) ,
                     (138972.51, -3025592.70) , (142276.78, -3036127.62) ,
                     (137226.59, -3037464.62) , (129854.70, -3028944.15) ,
                     (135167.01, -3037032.81) , (130553.03, -3036662.36) ,
                     (129614.20, -3035193.38) , (129523.46, -3036674.33) ,
                     (133590.80, -3038218.52) , (138974.90, -3043270.03) ,
                     (141207.23, -3043212.02) , (140885.32, -3040239.49) ,
                     (146181.08, -3040483.95) , (145432.41, -3043649.84) ,
                     (146967.85, -3044883.04) , (144434.23, -3046369.77) ,
                     (151969.13, -3045420.19) , (145769.93, -3049463.20) ,
                     (142973.16, -3046189.70) , (144476.77, -3048898.12) ,
                     (142498.85, -3049151.87) , (134010.73, -3044596.30) ,
                     (134660.12, -3043413.53) , (132562.16, -3041837.70) ,
                     (131958.73, -3043193.45) , (129736.06, -3041247.25) ,
                     (128728.58, -3042081.50) , (125582.59, -3038517.62) ,
                     (121092.35, -3036851.35) , (122628.16, -3034897.18) ,
                     (121087.53, -3033791.18) , (118341.79, -3034913.09) ,
                     (117948.98, -3036613.88) , (115037.15, -3033925.74) ,
                     (111525.64, -3034425.72) , (108033.51, -3032125.44) ,
                     (106169.63, -3034140.16) , (108385.68, -3035917.48) ,
                     (107171.77, -3039530.61) , (108761.41, -3039885.92) ,
                     (110169.29, -3037676.76) , (121817.13, -3043964.96) ,
                     (126537.56, -3050020.49) , (125489.89, -3051438.27) ,
                     (126431.29, -3053401.58) , (130972.24, -3053662.52) ,
                     (131376.42, -3052276.68) , (133839.49, -3053065.93) ,
                     (137483.70, -3051471.77) , (146421.34, -3055777.00) ,
                     (143794.47, -3057523.74) , (144364.58, -3059427.81) ,
                     (142852.85, -3059635.38) , (142624.43, -3061808.98) ,
                     (144955.38, -3060636.35) , (147476.05, -3062893.83) ,
                     (146348.12, -3063711.51) , (146437.56, -3066414.94) ,
                     (147567.83, -3066214.90) , (146643.93, -3069106.15) ,
                     (142618.16, -3074337.83) , (145856.11, -3077881.41) ,
                     (143684.49, -3080357.00) , (139408.86, -3080433.26) ,
                     (139777.00, -3082024.86) , (141542.82, -3082114.66) ,
                     (140829.22, -3085246.60) , (135386.27, -3085986.59) ,
                     (136778.15, -3086646.79) , (134494.37, -3088021.37) ,
                     (140093.90, -3087973.50) , (134261.61, -3097101.03) ,
                     (135379.35, -3097669.63) , (144875.84, -3088005.66) ,
                     (155261.78, -3087425.02) , (156121.78, -3088963.32) ,
                     (150556.50, -3100164.25) , (138602.36, -3100599.82) ,
                     (150757.80, -3102800.36) , (147650.81, -3105733.78) ,
                     (152223.60, -3105107.03) , (147638.01, -3113116.09) ,
                     (148102.77, -3115137.04) , (144145.72, -3118448.29) ,
                     (136042.71, -3121353.47) , (131210.15, -3121308.43) ,
                     (119895.79, -3113213.24) , (115977.10, -3117240.13) ,
                     (117104.19, -3119123.06) , (119023.94, -3116088.03) ,
                     (121129.80, -3115882.68) , (130408.86, -3125359.27) ,
                     (136623.26, -3123969.64) , (139871.00, -3125763.62) ,
                     (142311.04, -3125037.84) , (141527.41, -3126694.79) ,
                     (145213.13, -3124515.37) , (144603.56, -3123719.75) ,
                     (146291.89, -3121959.98) , (150582.72, -3121744.46) ,
                     (150958.97, -3124366.19) , (145636.58, -3123411.70) ,
                     (149500.26, -3125750.59) , (144410.80, -3125673.39) ,
                     (142060.94, -3127617.69) , (143178.54, -3128467.84) ,
                     (141863.42, -3130429.01) , (145597.43, -3128733.69) ,
                     (147734.91, -3130945.88) , (147012.29, -3132317.42) ,
                     (143756.31, -3133464.20) , (139975.59, -3131662.59) ,
                     (144664.14, -3134586.20) , (143736.71, -3135978.03) ,
                     (137579.86, -3133152.16) , (141726.57, -3138686.22) ,
                     (141082.97, -3141173.23) , (139062.91, -3141975.99) ,
                     (137722.52, -3140052.53) , (130377.32, -3142616.62) ,
                     (112583.16, -3139881.88) , (106990.70, -3137031.29) ,
                     (106206.04, -3138057.40) , (106038.00, -3139495.60) ,
                     (112897.57, -3142949.14) , (111610.55, -3143533.87) ,
                     (113007.45, -3147152.33) , (116050.74, -3144820.83) ,
                     (131073.51, -3145518.87) , (135930.26, -3144395.07) ,
                     (136826.48, -3145254.29) , (132755.01, -3145785.70) ,
                     (136204.24, -3147206.58) , (132648.56, -3150154.36) ,
                     (132493.28, -3152357.03) , (133664.44, -3153603.28) ,
                     (134120.22, -3152820.31) , (136522.90, -3152289.90) ,
                     (134179.91, -3153731.11) , (137328.70, -3153275.37) ,
                     (136463.39, -3155017.62) , (138543.42, -3156025.89) ,
                     (138160.82, -3151805.05) , (140185.03, -3151341.33) ,
                     (140427.43, -3147769.52) , (143198.97, -3148296.51) ,
                     (141244.68, -3150084.68) , (141811.23, -3153605.67) ,
                     (140329.08, -3152509.77) , (140531.97, -3154589.06) ,
                     (138972.13, -3155421.86) , (142181.48, -3154221.41) ,
                     (143714.46, -3159010.12) , (139619.65, -3157961.03) ,
                     (138554.32, -3160075.91) , (139791.33, -3160931.63) ,
                     (138371.20, -3161838.64) , (140081.25, -3162085.96) ,
                     (137100.85, -3162761.56) , (138490.53, -3164578.05) ,
                     (135767.90, -3165775.69) , (134168.86, -3164851.79) ,
                     (132219.03, -3166697.92) , (134836.22, -3168661.80) ,
                     (126863.57, -3169733.09) , (129120.91, -3171348.63) ,
                     (131756.93, -3170766.55) , (130473.96, -3172783.40) ,
                     (123010.49, -3170875.93) , (118184.23, -3166256.24) ,
                     (113248.66, -3168123.13) , (97763.26, -3167632.10)  ,
                     (98737.48, -3169771.99) , (115273.56, -3170411.94) ,
                     (124626.68, -3174121.34) , (121278.85, -3176517.93) ,
                     (121958.49, -3175594.10) , (120557.99, -3175181.99) ,
                     (116466.91, -3176331.51) , (116324.92, -3179141.90) ,
                     (119746.53, -3176887.25) , (121676.83, -3177573.41) ,
                     (120626.00, -3177719.52) , (120018.56, -3178474.40) ,
                     (123745.32, -3177847.40) , (123429.46, -3176723.21) ,
                     (127186.11, -3174879.61) , (130356.00, -3176139.92) ,
                     (128023.43, -3177106.18) , (131517.39, -3178038.95) ,
                     (131305.40, -3180427.11) , (134513.74, -3179937.92) ,
                     (135096.19, -3184099.69) , (130816.52, -3182399.05) ,
                     (130630.74, -3183837.50) , (122288.22, -3184498.56) ,
                     (119069.43, -3181821.61) , (114515.35, -3181240.72) ,
                     (114912.28, -3182903.52) , (113044.54, -3183172.12) ,
                     (101852.68, -3182652.06) , (117552.79, -3186022.24) ,
                     (121191.27, -3188763.75) , (128211.45, -3189104.99) ,
                     (127599.22, -3190733.60) , (131957.71, -3195063.75) ,
                     (127729.63, -3193296.75) , (127199.43, -3194547.37) ,
                     (121586.60, -3194068.21) , (120624.83, -3193007.94) ,
                     (122327.38, -3191939.86) , (118385.25, -3192810.39) ,
                     (118181.45, -3191616.37) , (115172.07, -3191876.28) ,
                     (117606.15, -3194247.21) , (116686.56, -3194839.10) ,
                     (105913.85, -3193035.12) , (103760.54, -3191221.39) ,
                     (95177.81, -3193753.62)  , (84369.77, -3191442.35) ,
                     (75098.50, -3192484.42)  , (75786.49, -3194418.99)  ,
                     (81359.81, -3192867.50) , (92570.88, -3195587.27)  ,
                     (103263.29, -3194104.28) , (103361.87, -3196980.33) ,
                     (107231.78, -3195350.30) , (113512.81, -3196625.60) ,
                     (110748.15, -3202355.54) , (115210.41, -3197646.68) ,
                     (117285.83, -3197979.52) , (117323.88, -3199927.45) ,
                     (117848.82, -3197984.20) , (121368.38, -3197939.06) ,
                     (121890.14, -3200881.41) , (123173.13, -3198225.33) ,
                     (128637.52, -3198687.35) , (124759.46, -3200543.61) ,
                     (126586.94, -3202588.83) , (128856.92, -3201568.41) ,
                     (131180.66, -3202617.40) , (128284.59, -3205741.56) ,
                     (130907.18, -3205902.08) , (129350.00, -3208482.08) ,
                     (125728.50, -3204123.66) , (122378.11, -3204091.86) ,
                     (124664.51, -3208582.16) , (123247.48, -3210940.23) ,
                     (127846.19, -3212835.55) , (113326.11, -3218979.02) ,
                     (115132.32, -3219575.16) , (109505.22, -3219924.97) ,
                     (101885.72, -3216616.27) , (92698.32, -3216453.12) ,
                     (88247.30, -3213885.45) , (85744.61, -3214360.47)  ,
                     (85366.64, -3216766.81) , (108125.32, -3221909.56) ,
                     (105920.31, -3224876.66) , (110318.44, -3222527.81) ,
                     (121458.94, -3225249.05) , (118396.45, -3228539.33) ,
                     (124944.68, -3226039.64) , (124428.80, -3229290.59) ,
                     (117477.02, -3230688.39) , (108382.97, -3227990.42) ,
                     (86289.56, -3225686.71)  , (86960.60, -3224643.80) ,
                     (81123.89, -3224650.49)  , (80417.28, -3226023.51)  ,
                     (97988.33, -3229638.77) , (98331.27, -3232755.26)  ,
                     (102362.35, -3230125.38) , (107849.20, -3230146.61) ,
                     (117137.47, -3232396.00) , (116858.76, -3234735.55) ,
                     (120746.22, -3233531.35) , (121960.77, -3235382.60) ,
                     (125001.01, -3234603.23) , (127510.74, -3236940.36) ,
                     (126187.44, -3237365.34) , (126958.45, -3238743.45) ,
                     (124743.09, -3239298.58) , (123999.44, -3238050.59) ,
                     (124419.07, -3240857.98) , (115571.31, -3247865.88) ,
                     (111557.08, -3245336.22) , (96871.92, -3244476.92)  ,
                     (99977.85, -3246112.01)  , (99967.13, -3247863.73) ,
                     (105710.89, -3246512.65) , (118719.76, -3250678.33) ,
                     (120578.27, -3249948.87) , (116312.51, -3248165.28) ,
                     (126265.50, -3241242.95) , (126313.05, -3244501.78) ,
                     (122020.14, -3247053.36) , (124716.45, -3249166.32) ,
                     (122478.34, -3249649.01) , (123972.82, -3250068.49) ,
                     (122456.01, -3250955.80) , (123385.70, -3252291.40) ,
                     (105114.43, -3252681.28) , (122804.46, -3253654.19) ,
                     (123302.36, -3255118.40) , (121170.95, -3256718.48) ,
                     (121449.75, -3255296.69) , (117770.25, -3255918.50) ,
                     (115091.64, -3259856.65) , (112151.02, -3258595.10) ,
                     (111716.50, -3260254.96) , (105559.14, -3259182.88) ,
                     (105797.77, -3260746.03) , (112452.14, -3261118.66) ,
                     (110199.91, -3264555.17) , (103442.45, -3261566.02) ,
                     (102973.35, -3257901.74) , (100457.22, -3260456.03) ,
                     (95299.31, -3258648.38)  , (97484.43, -3261956.44) ,
                     (109633.35, -3267475.21) , (104014.66, -3268175.74) ,
                     (99458.74, -3266161.34) , (103240.05, -3268145.95) ,
                     (101535.46, -3269258.47) , (96760.55, -3267279.40) ,
                     (97445.47, -3265596.58)  , (95818.39, -3266894.44)  ,
                     (90495.44, -3264610.58) , (89768.65, -3262899.11)  ,
                     (88069.57, -3263757.98)  , (80908.95, -3261158.02) ,
                     (75225.23, -3242475.63)  , (78767.20, -3242068.72)  ,
                     (70422.83, -3237770.88) , (73303.68, -3243160.54)  ,
                     (73938.14, -3249090.66)  , (72619.86, -3251617.78) ,
                     (74721.18, -3250945.23)  , (77377.25, -3254875.74)  ,
                     (78232.96, -3260476.77) , (66656.95, -3258216.19)  ,
                     (60170.93, -3254851.11)  , (57416.76, -3256474.28) ,
                     (53228.31, -3255771.46)  , (51919.21, -3253771.38)  ,
                     (51880.81, -3255317.27) , (50516.51, -3255000.25)  ,
                     (50098.63, -3251481.41)  , (45617.04, -3250328.88) ,
                     (48826.38, -3254684.13)  , (45454.83, -3253990.23)  ,
                     (45761.62, -3257430.61) , (48476.11, -3255695.49)  ,
                     (61351.13, -3258255.71)  , (64345.46, -3260288.14) ,
                     (62997.54, -3264420.23)  , (66458.21, -3260830.46)  ,
                     (69539.07, -3268967.33) , (67092.26, -3270088.83)  ,
                     (67664.05, -3271756.72)  , (71009.16, -3269452.41) ,
                     (69613.17, -3262195.26)  , (78296.78, -3263659.15)  ,
                     (75353.71, -3266775.81) , (80255.85, -3264291.17)  ,
                     (84714.68, -3265307.81)  , (85512.00, -3267143.90) ,
                     (90615.46, -3267745.77)  , (92948.63, -3269185.51)  ,
                     (93117.89, -3272524.53) , (93127.00, -3268871.74)  ,
                     (96502.96, -3270658.47)  , (95539.21, -3272383.05) ,
                     (97269.65, -3273406.33)  , (92936.70, -3274056.06)  ,
                     (90286.40, -3277410.96) , (85362.24, -3277625.03)  ,
                     (88938.44, -3279632.50)  , (81444.72, -3286724.36) ,
                     (86516.06, -3285309.48)  , (90099.84, -3280769.00)  ,
                     (92660.31, -3282936.47) , (94607.90, -3280385.32)  ,
                     (96644.08, -3283378.50)  , (98165.06, -3281525.14) ,
                     (102783.56, -3282945.41) , (101762.43, -3284539.60) ,
                     (105089.20, -3284411.34) , (103914.65, -3287093.58) ,
                     (105207.05, -3287358.24) , (106437.95, -3284626.43) ,
                     (109065.78, -3285421.73) , (109040.09, -3289647.21) ,
                     (104962.43, -3289569.23) , (103672.06, -3291960.96) ,
                     (106754.46, -3290616.56) , (110107.18, -3291504.26) ,
                     (109120.72, -3292470.86) , (111245.42, -3292307.29) ,
                     (109296.89, -3293593.27) , (110150.23, -3295008.08) ,
                     (107680.26, -3295154.49) , (108330.78, -3294078.44) ,
                     (107366.68, -3292999.44) , (105759.50, -3294532.93) ,
                     (101356.67, -3292701.08) , (101432.65, -3295829.22) ,
                     (99911.23, -3294872.41)  , (99757.15, -3296488.54) ,
                     (96805.42, -3297286.23)  , (101535.70, -3297634.42) ,
                     (104034.17, -3301995.23) , (105501.46, -3306585.09) ,
                     (101556.86, -3307223.60) , (101526.00, -3307463.00) ,
                     (107155.90, -3308115.39) , (109403.53, -3306854.08) ,
                     (108662.76, -3308746.08) , (110980.44, -3308326.84) ,
                     (110454.82, -3312640.63) , (108491.15, -3311088.76) ,
                     (109049.98, -3313676.55) , (95870.92, -3311655.88)  ,
                     (94641.12, -3308361.34)  , (94064.31, -3311058.70) ,
                     (87656.45, -3308318.20)  , (80357.15, -3307481.22)  ,
                     (79444.87, -3300811.77) , (78370.42, -3306271.66)  ,
                     (72412.39, -3304543.81)  , (68321.16, -3305512.01) ,
                     (53600.60, -3301671.21)  , (50055.54, -3301883.08)  ,
                     (48351.93, -3305606.11) , (47230.05, -3301848.33)  ,
                     (49721.02, -3296062.10)  , (57279.01, -3288584.11) ,
                     (63154.88, -3285898.49)  , (54479.94, -3288504.43)  ,
                     (54179.70, -3281481.27) , (50407.29, -3276663.24)  ,
                     (52388.93, -3290913.13)  , (47692.46, -3296280.67) ,
                     (47448.89, -3291758.46)  , (42995.72, -3284749.37)  ,
                     (41460.09, -3284833.89) , (44813.97, -3291530.51)  ,
                     (45426.98, -3297322.71)  , (43143.08, -3298471.07) ,
                     (38323.54, -3296467.70)  , (42590.34, -3301151.17)  ,
                     (41392.77, -3305777.41) , (39649.77, -3306919.83)  ,
                     (34165.51, -3306091.02)  , (31001.29, -3303680.34) ,
                     (27780.03, -3318685.47)  , (23947.33, -3325473.64)  ,
                     (19404.13, -3325045.79) , (18070.60, -3318776.86)  ,
                     (19486.42, -3311218.29)  , (18323.59, -3312468.15) ,
                     (16600.91, -3310205.00)  , (14280.23, -3308764.39)  ,
                     (17789.07, -3312948.00) , (17154.44, -3322070.28)  ,
                     (15477.78, -3324854.43)  , (12485.41, -3324311.10) ,
                     (11833.98, -3322394.57)  , (11118.54, -3323990.55)  ,
                     (7150.74, -3310491.23) , (6792.06, -3311119.34)   ,
                     (4800.23, -3310453.79)   , (8379.04, -3307038.11) ,
                     (6512.18, -3305455.69)   , (4986.62, -3307615.54)   ,
                     (3858.88, -3313807.31) , (1439.06, -3313984.04)   ,
                     (-2510.43, -3311168.19)  , (-3377.79, -3314489.69) ,
                     (-5495.29, -3313925.41)  , (-4708.46, -3312957.68)  ,
                     (-4883.46, -3312437.68) , (-7473.95, -3313150.54)  ,
                     (-5595.32, -3316650.45)  , (-9181.26, -3314925.56) ,
                     (-9852.78, -3313497.40)  , (-5273.78, -3309222.71)  ,
                     (-4043.87, -3311369.23) , (-3276.41, -3311424.49)  ,
                     (-3471.07, -3308565.36)  , (-5572.60, -3307294.02) ,
                     (-4460.03, -3304544.88)  , (-2843.51, -3306029.08)  ,
                     (9643.50, -3301056.60) , (13847.56, -3301180.19)  ,
                     (13107.84, -3297710.22)  , (10879.13, -3300784.94) ,
                     (9389.97, -3300233.52)   , (10130.54, -3295682.32)  ,
                     (13465.88, -3292229.03) , (15739.41, -3292438.35)  ,
                     (15190.23, -3287737.50)  , (22249.72, -3279637.84) ,
                     (23708.95, -3272620.09)  , (28464.97, -3268234.31)  ,
                     (30302.35, -3257920.17) , (26137.45, -3267441.35)  ,
                     (21133.19, -3272679.35)  , (19900.91, -3278296.83) ,
                     (14495.73, -3283408.86)  , (11502.95, -3291222.11)  ,
                     (8121.53, -3293193.90) , (7294.36, -3299401.15)   ,
                     (5012.30, -3298684.61)   , (4852.21, -3300619.35) ,
                     (1305.38, -3302101.39)   , (-4008.83, -3301556.54)  ,
                     (-4543.77, -3299607.41) , (-8520.20, -3308509.92)  ,
                     (-11479.73, -3309204.69) , (-12416.94, -3307767.30) ,
                     (-9375.85, -3304392.24)  , (-9420.71, -3302932.91)  ,
                     (-10850.11, -3302326.82) , (-10258.54, -3303003.33) ,
                     (-11796.98, -3304883.25) , (-12698.40, -3304993.32) ,
                     (-10315.20, -3299733.25) , (-10938.11, -3298102.22) ,
                     (-5593.86, -3291614.52)  , (4571.75, -3286188.58)   ,
                     (2066.95, -3285082.16)   , (6378.81, -3272552.98)   ,
                     (9452.58, -3269690.90) , (3187.71, -3271391.47)   ,
                     (2252.85, -3268630.19)   , (11877.51, -3257517.85) ,
                     (14236.03, -3251579.81)  , (12788.91, -3248422.83)  ,
                     (18256.42, -3241517.71) , (24659.95, -3238999.15)  ,
                     (28600.10, -3232443.19)  , (26112.75, -3232613.13) ,
                     (22947.94, -3237141.77)  , (15707.31, -3240863.81)  ,
                     (14818.05, -3244071.64) , (10830.42, -3245816.93)  ,
                     (8323.24, -3256748.03)   , (-1180.70, -3269647.72) ,
                     (-9344.68, -3271673.25)  , (-11690.49, -3270730.70) ,
                     (-9602.37, -3272702.28) , (-11269.81, -3274224.97) ,
                     (-13684.06, -3274997.17) , (-13635.99, -3272104.30) ,
                     (-14506.46, -3273289.86) , (-15987.76, -3271981.55) ,
                     (-14312.42, -3268116.60) , (-16057.47, -3266295.42) ,
                     (-9071.64, -3253210.54) , (-4460.48, -3248180.52)  ,
                     (-10160.97, -3253125.31) , (-13492.08, -3251321.97) ,
                     (-11726.87, -3254685.04) , (-12708.56, -3257618.67) ,
                     (-15534.94, -3255476.45) , (-15590.21, -3260259.63) ,
                     (-19014.57, -3261218.83) , (-24960.96, -3267001.02) ,
                     (-27133.66, -3267081.92) , (-28513.15, -3268526.26) ,
                     (-28997.26, -3268303.58) , (-20473.57, -3255983.92) ,
                     (-22454.04, -3256883.39) , (-22334.50, -3254203.30) ,
                     (-7223.96, -3243748.76) , (-6720.13, -3239124.14)  ,
                     (-11278.44, -3245301.64) , (-17544.13, -3248013.80) ,
                     (-17990.65, -3243379.04) , (-12399.97, -3238502.53) ,
                     (-12228.61, -3235038.24) , (-12792.80, -3237785.36) ,
                     (-17142.47, -3241738.51) , (-20907.94, -3241124.19) ,
                     (-20459.20, -3249730.03) , (-26122.32, -3250866.22) ,
                     (-26493.76, -3259844.99) , (-28479.91, -3256635.29) ,
                     (-32453.37, -3270021.01) , (-34287.82, -3268733.11) ,
                     (-32158.91, -3267209.68) , (-35739.92, -3264563.19) ,
                     (-32865.07, -3262354.15) , (-38880.82, -3263263.19) ,
                     (-38615.18, -3261034.09) , (-33619.70, -3258502.72) ,
                     (-35577.03, -3254198.68) , (-34943.08, -3258380.21) ,
                     (-39451.86, -3259191.74) , (-43016.22, -3254158.52) ,
                     (-35668.95, -3250721.23) , (-34977.11, -3249020.72) ,
                     (-36607.57, -3250931.36) , (-41358.47, -3251644.73) ,
                     (-43049.82, -3250390.46) , (-41446.95, -3249413.48) ,
                     (-45031.15, -3251124.73) , (-46580.02, -3254538.01) ,
                     (-45497.85, -3259146.43) , (-46936.21, -3260258.28) ,
                     (-47257.83, -3258299.97) , (-48967.54, -3258822.33) ,
                     (-49182.35, -3263979.29) , (-51484.88, -3263541.64) ,
                     (-50903.73, -3258434.52) , (-55976.83, -3257973.53) ,
                     (-55927.90, -3256183.67) , (-48357.37, -3252296.64) ,
                     (-53500.44, -3257182.15) , (-44901.16, -3249890.74) ,
                     (-31941.18, -3242501.58) , (-34297.47, -3242030.73) ,
                     (-43107.86, -3247197.71) , (-43504.52, -3245411.83) ,
                     (-46463.93, -3245358.11) , (-45479.88, -3244026.85) ,
                     (-48218.31, -3244467.63) , (-48574.33, -3243203.74) ,
                     (-43539.67, -3241658.85) , (-40861.76, -3238056.05) ,
                     (-31771.57, -3235258.50) , (-35212.79, -3234671.17) ,
                     (-35648.21, -3233297.59) , (-29931.41, -3229800.00) ,
                     (-28453.67, -3226649.43) , (-26806.77, -3226773.13) ,
                     (-23191.59, -3220683.27) , (-15177.68, -3219825.53) ,
                     (-13418.78, -3218095.11) , (-16469.54, -3216508.92) ,
                     (-20742.18, -3218215.42) , (-18826.12, -3211111.62) ,
                     (-23067.82, -3207227.08) , (-21848.92, -3214027.29) ,
                     (-26737.98, -3218696.00) , (-28236.11, -3223352.82) ,
                     (-38730.61, -3232046.85) , (-39647.14, -3234879.57) ,
                     (-42444.42, -3235641.66) , (-42602.25, -3234159.85) ,
                     (-45786.51, -3237477.62) , (-49848.99, -3237186.74) ,
                     (-50702.09, -3233639.04) , (-38834.52, -3226009.26) ,
                     (-41851.91, -3227712.74) , (-46330.19, -3226182.64) ,
                     (-48627.24, -3226990.04) , (-49159.26, -3225710.39) ,
                     (-50328.56, -3228074.04) , (-53123.92, -3228494.31) ,
                     (-52032.32, -3225707.99) , (-56150.73, -3228238.84) ,
                     (-53894.35, -3229132.42) , (-56810.47, -3232265.53) ,
                     (-57282.37, -3240490.37) , (-58482.33, -3239579.44) ,
                     (-60835.78, -3241194.50) , (-63430.82, -3238844.81) ,
                     (-66513.10, -3240095.72) , (-67303.23, -3237472.41) ,
                     (-69688.61, -3237306.49) , (-68249.10, -3235870.96) ,
                     (-69412.86, -3234071.86) , (-67748.64, -3232777.36) ,
                     (-63442.53, -3233302.21) , (-63687.59, -3231500.21) ,
                     (-58356.98, -3230906.05) , (-58201.92, -3228313.28) ,
                     (-49088.12, -3222740.42) , (-47235.82, -3220040.84) ,
                     (-50240.58, -3222395.00) , (-52685.96, -3221944.07) ,
                     (-53902.57, -3223858.82) , (-55280.74, -3223551.64) ,
                     (-55680.56, -3221026.12) , (-59627.47, -3227556.77) ,
                     (-61778.36, -3228850.41) , (-63842.30, -3227484.21) ,
                     (-63538.60, -3230552.09) , (-68455.25, -3229895.30) ,
                     (-64333.52, -3225780.37) , (-50632.78, -3216790.40) ,
                     (-40851.26, -3216048.29) , (-27924.08, -3210119.45) ,
                     (-25010.66, -3203613.28) , (-13852.79, -3196541.68) ,
                     (-14682.57, -3192087.56) , (-11349.76, -3185612.05) ,
                     (-13659.18, -3186217.94) , (-18873.25, -3197733.01) ,
                     (-21703.30, -3197943.25) , (-24849.14, -3188985.06) ,
                     (-24725.39, -3187813.15) , (-23851.98, -3188279.49) ,
                     (-23237.55, -3188040.94) , (-22597.54, -3187400.38) ,
                     (-23955.41, -3188120.89) , (-26740.77, -3184373.02) ,
                     (-28460.19, -3179186.30) , (-27302.31, -3186272.54) ,
                     (-28667.67, -3190363.39) , (-25937.64, -3195123.87) ,
                     (-34258.91, -3206954.11) , (-43089.51, -3213071.13) ,
                     (-46784.08, -3213953.65) , (-45573.30, -3211461.52) ,
                     (-57456.22, -3219437.45) , (-59312.44, -3218077.11) ,
                     (-60485.01, -3215745.88) , (-58640.87, -3214557.35) ,
                     (-61706.93, -3213942.83) , (-62544.05, -3211200.05) ,
                     (-50754.10, -3204524.02) , (-38400.94, -3199968.28) ,
                     (-38077.12, -3198292.74) , (-42892.88, -3197535.60) ,
                     (-42201.71, -3196002.68) , (-41042.34, -3196258.66) ,
                     (-35567.24, -3194345.47) , (-39631.28, -3194143.20) ,
                     (-40161.58, -3190957.18) , (-37230.80, -3191882.31) ,
                     (-36331.25, -3190486.89) , (-35649.02, -3192680.50) ,
                     (-33988.91, -3192006.05) , (-36383.60, -3189461.95) ,
                     (-40177.40, -3188279.16) , (-42548.93, -3192124.68) ,
                     (-43833.72, -3185954.34) , (-48431.20, -3183261.04) ,
                     (-44690.70, -3175198.33) , (-39298.01, -3171607.77) ,
                     (-44976.58, -3170397.40) , (-46993.28, -3174137.57) ,
                     (-48592.38, -3174319.93) , (-51520.89, -3182345.00) ,
                     (-58171.93, -3177772.20) , (-61122.17, -3179471.01) ,
                     (-52837.27, -3184687.62) , (-53438.24, -3186865.19) ,
                     (-50886.64, -3185469.29) , (-48530.01, -3186829.87) ,
                     (-45430.75, -3193362.99) , (-51992.34, -3192820.36) ,
                     (-52990.26, -3194309.10) , (-50925.03, -3197832.72) ,
                     (-60047.16, -3203559.73) , (-64827.90, -3201214.80) ,
                     (-65041.79, -3197523.72) , (-66500.87, -3198554.27) ,
                     (-67061.63, -3196665.86) , (-69897.85, -3198484.14) ,
                     (-71726.84, -3197482.19) , (-72257.78, -3200274.02) ,
                     (-68687.19, -3200079.42) , (-62650.25, -3206362.53) ,
                     (-67161.74, -3209933.84) , (-69720.44, -3210684.35) ,
                     (-70890.98, -3209285.07) , (-70166.73, -3202573.44) ,
                     (-72874.94, -3203353.54) , (-74588.44, -3198631.83) ,
                     (-76700.48, -3199053.41) , (-76294.86, -3200083.47) ,
                     (-78486.45, -3197316.10) , (-76763.40, -3203147.41) ,
                     (-78868.80, -3203642.84) , (-79788.70, -3201334.63) ,
                     (-81993.34, -3200859.19) , (-78422.64, -3205964.79) ,
                     (-79191.94, -3208142.92) , (-87183.97, -3203443.49) ,
                     (-86133.32, -3205468.18) , (-88022.59, -3206028.14) ,
                     (-85984.03, -3214160.24) , (-91471.39, -3206943.12) ,
                     (-90168.32, -3205704.38) , (-90908.16, -3203236.41) ,
                     (-92428.74, -3202893.98) , (-92935.74, -3205070.59) ,
                     (-94908.04, -3201904.72) , (-98666.71, -3202904.94) ,
                     (-91440.17, -3209878.47) , (-88154.81, -3218604.68) ,
                     (-89947.48, -3218137.36) , (-91034.03, -3212760.19) ,
                     (-91759.45, -3211358.64) , (-91973.16, -3218877.48) ,
                     (-94925.80, -3217529.35) , (-99409.08, -3212049.30) ,
                     (-94732.21, -3219220.97) , (-100836.23, -3214593.95),
                     (-106225.90, -3213632.25), (-108045.23, -3214686.31),
                     (-109469.63, -3211009.09), (-117212.44, -3214189.70),
                     (-108199.83, -3205678.77), (-108729.38, -3204325.39),
                     (-118235.39, -3212816.99), (-119232.60, -3211787.67),
                     (-119465.74, -3213438.52), (-122011.89, -3212956.22),
                     (-123505.88, -3216456.35), (-127314.27, -3218755.11),
                     (-128079.01, -3215479.86), (-126868.15, -3215063.85),
                     (-129359.29, -3212334.08), (-128329.97, -3211336.63),
                     (-130284.13, -3210865.53), (-130036.13, -3207392.67),
                     (-132728.69, -3206239.16), (-130718.50, -3211993.97),
                     (-135268.14, -3213672.09), (-138876.80, -3212386.88),
                     (-138528.44, -3208806.40), (-140049.47, -3208598.41),
                     (-139516.69, -3207391.28), (-141676.75, -3206455.23),
                     (-142909.50, -3207845.55), (-137838.75, -3214206.98),
                     (-140975.89, -3213857.35), (-143883.85, -3216019.09),
                     (-139788.46, -3217338.07), (-144191.55, -3218568.61),
                     (-146008.05, -3217131.11), (-150362.35, -3218617.66),
                     (-150080.77, -3217252.00), (-144845.82, -3216310.74),
                     (-149495.42, -3216716.88), (-147840.07, -3215099.51),
                     (-149754.58, -3213609.22), (-150061.32, -3216750.60),
                     (-157108.06, -3216357.53), (-157681.91, -3218583.84),
                     (-161461.85, -3219340.09), (-151995.43, -3218340.01),
                     (-156100.87, -3222118.97), (-145581.63, -3217928.68),
                     (-144165.82, -3218911.54), (-136649.91, -3217523.70),
                     (-131321.87, -3220041.86), (-132602.86, -3218272.58),
                     (-130427.65, -3219076.09), (-132072.78, -3223200.22),
                     (-133713.37, -3221929.37), (-138201.30, -3227082.31),
                     (-139600.05, -3226219.41), (-137628.84, -3225462.17),
                     (-141312.88, -3223711.41), (-147225.96, -3225669.02),
                     (-146710.86, -3226772.49), (-150042.66, -3226876.88),
                     (-153394.86, -3226282.60), (-156134.00, -3223361.40),
                     (-158120.85, -3225182.20), (-162564.40, -3221810.88),
                     (-166941.17, -3222596.81), (-164791.81, -3220939.90),
                     (-165869.94, -3220893.82), (-165013.39, -3218368.77),
                     (-162534.33, -3217276.37), (-166147.04, -3218138.32),
                     (-165252.99, -3217485.52), (-166362.50, -3215804.36),
                     (-167022.53, -3219653.63), (-168569.75, -3219857.15),
                     (-167151.38, -3214481.40), (-169936.72, -3215067.65),
                     (-169166.26, -3215824.42), (-168700.44, -3217116.01),
                     (-169873.95, -3223464.90), (-175796.37, -3225179.98),
                     (-176850.49, -3224141.22), (-178295.74, -3225260.04),
                     (-181240.95, -3225650.64), (-182699.86, -3225403.06),
                     (-181107.74, -3225500.94), (-183207.57, -3223038.52),
                     (-181606.34, -3220942.73), (-179356.28, -3221580.69),
                     (-180528.97, -3220545.68), (-179518.09, -3218717.64),
                     (-175000.87, -3217612.38), (-169064.84, -3213137.43),
                     (-167964.30, -3214611.11), (-165254.82, -3212683.11),
                     (-166001.29, -3215751.42), (-162145.82, -3209697.19),
                     (-158561.34, -3210019.44), (-155519.31, -3206791.40),
                     (-148915.67, -3205629.69), (-145713.79, -3201972.93),
                     (-151029.46, -3205735.10), (-154393.04, -3206190.13),
                     (-153046.30, -3204544.05), (-149966.12, -3204401.11),
                     (-154992.51, -3204146.91), (-154455.43, -3203191.74),
                     (-160523.34, -3204641.13), (-158290.75, -3202726.33),
                     (-161196.40, -3204856.69), (-163822.77, -3205650.58),
                     (-161615.07, -3204296.48), (-162943.31, -3203336.84),
                     (-158605.72, -3202014.70), (-159939.66, -3201409.30),
                     (-158007.54, -3198932.59), (-159643.50, -3198090.80),
                     (-159535.26, -3195183.37), (-162743.57, -3197682.92),
                     (-162220.66, -3195230.47), (-163573.17, -3194979.20),
                     (-157976.45, -3188657.46), (-165731.32, -3193728.87),
                     (-168488.46, -3191948.14), (-172263.08, -3194478.58),
                     (-173659.14, -3189719.42), (-170512.91, -3187245.48),
                     (-169249.09, -3182247.86), (-166700.03, -3179212.51),
                     (-169513.34, -3182221.10), (-171513.69, -3186435.98),
                     (-174960.93, -3189102.41), (-176835.80, -3183807.20),
                     (-178064.63, -3183952.19), (-178448.99, -3180360.66),
                     (-172349.07, -3177056.40), (-172847.36, -3174461.74),
                     (-170656.20, -3173405.06), (-173672.82, -3172781.18),
                     (-170704.44, -3169700.58), (-164839.28, -3167246.18),
                     (-158399.22, -3167615.56), (-165263.23, -3165842.92),
                     (-169361.45, -3166592.50), (-172723.83, -3169472.43),
                     (-173245.79, -3167258.71), (-172029.53, -3166935.26),
                     (-173904.80, -3166749.82), (-175660.31, -3175515.02),
                     (-178953.82, -3176788.11), (-179981.06, -3175353.80),
                     (-181637.79, -3182355.19), (-185235.75, -3181908.93),
                     (-185333.83, -3180063.80), (-182167.49, -3179637.53),
                     (-181258.17, -3176737.07), (-185053.91, -3179780.11),
                     (-185715.95, -3178692.60), (-186812.52, -3181382.83),
                     (-187583.69, -3178419.08), (-189597.95, -3181401.53),
                     (-194195.56, -3182662.78), (-192643.57, -3181054.69),
                     (-196921.82, -3179857.80), (-193384.82, -3174525.31),
                     (-197963.32, -3177384.39), (-196383.89, -3174314.65),
                     (-197345.72, -3173567.22), (-191407.27, -3171317.69),
                     (-197295.77, -3172772.97), (-199309.07, -3176925.17),
                     (-201316.15, -3177746.20), (-200300.80, -3172028.48),
                     (-197526.44, -3168857.55), (-193003.81, -3169811.10),
                     (-185710.88, -3168509.59), (-190550.39, -3166577.34),
                     (-191946.30, -3168111.43), (-194899.56, -3167445.44),
                     (-191978.68, -3164126.47), (-192093.58, -3161274.17),
                     (-183557.74, -3162922.89), (-182871.80, -3159292.41),
                     (-186567.79, -3161646.62), (-191270.95, -3160144.28),
                     (-196545.06, -3158137.96), (-195621.65, -3154516.66),
                     (-198187.00, -3157100.03), (-202366.53, -3156726.47),
                     (-199732.60, -3150362.66), (-209159.59, -3157925.17),
                     (-210436.05, -3158255.67), (-210635.80, -3156710.36),
                     (-213020.51, -3158351.20), (-213312.92, -3157138.54),
                     (-209258.73, -3152130.44), (-213666.08, -3155356.50),
                     (-214087.53, -3153952.87), (-219784.05, -3159684.42),
                     (-218408.82, -3158075.48), (-219876.59, -3157957.46),
                     (-216373.20, -3154759.03), (-219611.36, -3155912.86),
                     (-218962.54, -3153877.73), (-224022.39, -3154313.93),
                     (-217931.63, -3150400.68), (-209876.70, -3147674.58),
                     (-206468.08, -3149378.34), (-194974.26, -3143295.67),
                     (-173820.50, -3142470.12), (-179472.85, -3140108.98),
                     (-191575.17, -3141683.71), (-181769.87, -3137189.90),
                     (-183908.38, -3133430.66), (-194640.90, -3140254.02),
                     (-198647.54, -3140104.53), (-204962.58, -3144396.42),
                     (-216061.17, -3145633.42), (-214525.19, -3146542.36),
                     (-220916.35, -3148605.47), (-218977.66, -3146980.73),
                     (-220382.27, -3145656.60), (-218408.28, -3145441.34),
                     (-226033.38, -3143902.49), (-225117.47, -3141865.51),
                     (-226577.76, -3141096.18), (-221354.91, -3139169.04),
                     (-216482.91, -3139837.43), (-211856.32, -3138528.53),
                     (-224426.60, -3139125.10), (-225448.21, -3136360.27),
                     (-226113.67, -3138555.40), (-228845.56, -3138367.76),
                     (-229313.82, -3136856.16), (-232593.12, -3137988.43),
                     (-234248.83, -3135942.46), (-232267.54, -3134486.71),
                     (-235448.47, -3135228.63), (-230930.51, -3132966.37),
                     (-233698.53, -3131680.53), (-230474.35, -3129922.28),
                     (-227362.35, -3131893.22), (-224494.78, -3130438.71),
                     (-220023.35, -3131541.23), (-215637.62, -3134377.72),
                     (-200594.75, -3131793.68), (-198444.96, -3128920.00),
                     (-195168.86, -3128669.84), (-199790.91, -3126420.69),
                     (-201605.72, -3129194.95), (-218245.47, -3131202.22),
                     (-218670.78, -3129563.33), (-215922.38, -3129574.34),
                     (-214594.26, -3126663.39), (-217027.91, -3128517.00),
                     (-219292.11, -3127519.97), (-220619.20, -3129825.43),
                     (-222662.63, -3129278.41), (-221063.49, -3128079.97),
                     (-222339.70, -3125202.36), (-221047.59, -3123381.92),
                     (-222546.73, -3121693.06), (-220601.00, -3119406.53),
                     (-221616.69, -3119215.86), (-216516.18, -3118459.87),
                     (-213820.57, -3116338.27), (-210542.00, -3117721.50),
                     (-212990.14, -3113082.21), (-209636.77, -3110583.67),
                     (-212263.67, -3111147.27), (-217444.96, -3116533.35),
                     (-225543.43, -3118005.51), (-223428.46, -3111999.04),
                     (-222091.70, -3111780.22), (-223861.61, -3109416.06),
                     (-223688.85, -3110776.39), (-226916.99, -3110849.06),
                     (-229390.32, -3117764.04), (-232829.21, -3117282.05),
                     (-232949.09, -3113516.97), (-234007.94, -3114044.95),
                     (-236666.21, -3110834.78), (-235031.32, -3111030.17),
                     (-231192.74, -3104358.60), (-232186.34, -3103963.00),
                     (-227096.15, -3097449.63), (-225066.35, -3097241.95),
                     (-227296.76, -3095067.23), (-232028.88, -3098484.63),
                     (-234660.49, -3105926.89), (-238621.39, -3107400.89),
                     (-237297.78, -3104551.21), (-239643.51, -3105538.33),
                     (-240309.32, -3104968.33), (-238806.21, -3103889.37),
                     (-238830.17, -3102381.54), (-240667.61, -3102537.99),
                     (-239760.56, -3100593.01), (-236850.11, -3098260.36),
                     (-239721.04, -3098175.48), (-237126.74, -3096382.27),
                     (-236631.56, -3093646.54), (-233127.82, -3092437.26),
                     (-237777.11, -3091847.13), (-237608.16, -3090475.76),
                     (-228247.79, -3087559.01), (-224622.90, -3088782.66),
                     (-214838.15, -3081921.30), (-213988.74, -3079645.86),
                     (-209568.13, -3080283.47), (-206461.82, -3077572.60),
                     (-211672.37, -3078624.41), (-213284.26, -3076176.64),
                     (-215504.75, -3076837.55), (-212207.80, -3069602.84),
                     (-219750.06, -3077677.51), (-220699.59, -3075102.40),
                     (-214307.80, -3062946.72), (-215715.86, -3061993.51),
                     (-219380.90, -3066149.35), (-224096.75, -3084025.36),
                     (-228299.95, -3083126.52), (-236597.79, -3086637.91),
                     (-239307.32, -3086287.37), (-238583.55, -3084398.51),
                     (-234423.06, -3083833.27), (-237634.71, -3082325.54),
                     (-236791.34, -3076507.69), (-238646.20, -3077189.76),
                     (-241906.87, -3083985.33), (-245580.70, -3082666.54),
                     (-244124.16, -3084881.66), (-250160.88, -3085741.08),
                     (-251861.36, -3081817.65), (-253305.02, -3082570.13),
                     (-252697.40, -3080125.01), (-248178.94, -3079786.59),
                     (-246327.70, -3082176.21), (-244628.69, -3081729.99),
                     (-249208.94, -3077159.56), (-244791.88, -3077256.18),
                     (-239265.84, -3074869.26), (-241227.48, -3073562.53),
                     (-247800.82, -3075798.25), (-249855.65, -3073816.16),
                     (-248386.19, -3072285.36), (-251619.59, -3073606.63),
                     (-252146.11, -3071251.37), (-250937.50, -3070401.65),
                     (-253021.17, -3069715.98), (-245079.88, -3069672.98),
                     (-242686.20, -3071953.49), (-232328.75, -3075857.41),
                     (-237664.95, -3071609.44), (-229976.71, -3069411.19),
                     (-230893.81, -3067695.81), (-228987.89, -3064469.01),
                     (-233639.83, -3066413.21), (-233055.32, -3061104.50),
                     (-231615.44, -3061014.77), (-233491.84, -3059599.93),
                     (-238805.13, -3067598.77), (-244259.15, -3065685.72),
                     (-250259.35, -3066368.99), (-252245.47, -3065310.62),
                     (-247038.20, -3064013.97), (-243829.49, -3057145.79),
                     (-240691.98, -3057613.00), (-238029.86, -3055510.30),
                     (-235269.03, -3057649.70), (-230962.77, -3058220.68),
                     (-229556.01, -3056564.61), (-229551.27, -3055651.80),
                     (-228305.03, -3053831.61), (-228093.08, -3052615.89),
                     (-232114.32, -3056496.77), (-238028.63, -3053477.87),
                     (-242357.84, -3055157.40), (-244128.77, -3054017.79),
                     (-240996.76, -3047600.97), (-244214.76, -3050675.94),
                     (-245139.53, -3054239.43), (-251471.46, -3052573.94),
                     (-259039.63, -3053330.16), (-258847.38, -3052037.87),
                     (-255105.28, -3050917.99), (-254666.88, -3047218.54),
                     (-256192.30, -3047430.09), (-257217.49, -3050376.98),
                     (-260748.16, -3049011.52), (-260637.67, -3045071.58),
                     (-258691.77, -3043207.91), (-260408.26, -3041410.46),
                     (-260027.63, -3038855.62), (-256785.37, -3038569.96),
                     (-257986.68, -3036206.76), (-243743.28, -3039863.59),
                     (-247997.83, -3038528.14), (-250382.21, -3034186.92),
                     (-252122.29, -3034774.21), (-244299.12, -3031038.43),
                     (-250330.89, -3032247.90), (-251235.94, -3031447.51),
                     (-250956.46, -3029629.87), (-251367.17, -3029234.79),
                     (-254868.69, -3033683.42), (-256854.53, -3030355.63),
                     (-257929.38, -3032351.68), (-256058.80, -3035800.61),
                     (-258374.89, -3035105.17), (-258860.50, -3032667.98),
                     (-258846.12, -3035675.78), (-262051.09, -3031883.24),
                     (-262306.78, -3034082.29), (-263877.90, -3033596.34),
                     (-264392.82, -3030399.68), (-264915.09, -3033371.36),
                     (-261594.12, -3040904.83), (-261774.67, -3042655.45),
                     (-263262.94, -3041646.79), (-264929.14, -3042655.13),
                     (-265308.84, -3040757.90), (-266935.24, -3042094.27),
                     (-268107.08, -3039880.68), (-267936.38, -3036655.42),
                     (-265932.25, -3035988.24), (-266551.15, -3034086.27),
                     (-267629.75, -3036539.77), (-270002.26, -3034113.63),
                     (-271145.69, -3035764.12), (-272631.54, -3033458.48),
                     (-272730.95, -3031709.78), (-268521.48, -3029757.09),
                     (-270387.60, -3027855.15), (-273055.78, -3026872.50),
                     (-271098.55, -3028459.97), (-274347.91, -3028536.66),
                     (-276548.10, -3024929.74), (-277681.97, -3025450.63),
                     (-275474.77, -3023765.66), (-278600.64, -3024648.21),
                     (-277437.12, -3021380.88), (-276350.06, -3021699.05),
                     (-278071.58, -3016984.66), (-275999.59, -3018023.73),
                     (-274478.56, -3015854.18), (-275997.15, -3014018.07),
                     (-275704.09, -3010337.38), (-273372.51, -3010284.37),
                     (-274413.62, -3008822.51), (-273570.42, -3007643.79),
                     (-273690.70, -3008809.04), (-268045.60, -3009745.98),
                     (-268816.01, -3008371.33), (-266802.07, -3008255.18),
                     (-264295.67, -3003656.23), (-265052.88, -3002724.12),
                     (-261794.08, -2999380.18), (-261195.69, -2996146.57),
                     (-265872.22, -3000961.21), (-269213.85, -3008801.34),
                     (-270623.23, -3005769.88), (-270118.86, -3001317.51),
                     (-265569.70, -2996606.54), (-264487.36, -2990685.74),
                     (-254641.04, -2985787.20), (-256674.97, -2985253.62),
                     (-256679.83, -2981164.61), (-258683.55, -2984620.92),
                     (-269310.53, -2993219.58), (-270006.62, -2990703.77),
                     (-268755.10, -2989273.54), (-271387.67, -2988265.93),
                     (-270735.06, -2995042.23), (-276369.09, -3001126.63),
                     (-276922.94, -2997521.23), (-278972.42, -2995719.57),
                     (-274715.82, -2989716.39), (-275696.31, -2987260.18),
                     (-273432.23, -2985847.14), (-273708.53, -2983405.80),
                     (-268118.89, -2978571.57), (-269467.04, -2977814.82),
                     (-267531.92, -2976309.26), (-267563.00, -2973482.89),
                     (-250017.78, -2968720.07), (-243078.59, -2962922.24),
                     (-247301.29, -2961165.40), (-255037.90, -2967791.57),
                     (-268568.87, -2971408.12), (-272918.45, -2979898.76),
                     (-274887.33, -2980871.13), (-275426.93, -2984227.64),
                     (-277121.78, -2984258.01), (-278586.98, -2990579.83),
                     (-281859.30, -2989930.65), (-281514.77, -2987743.78),
                     (-280004.10, -2988784.45), (-279372.09, -2987231.25),
                     (-281406.45, -2981607.10), (-280522.23, -2979609.63),
                     (-278454.34, -2980942.14), (-280052.92, -2978630.10),
                     (-276523.23, -2974524.84), (-276949.62, -2973244.69),
                     (-273125.56, -2972671.64), (-275243.44, -2972392.46),
                     (-271427.24, -2969905.99), (-271354.86, -2967502.59),
                     (-267207.35, -2966491.05), (-270881.14, -2964347.40),
                     (-269661.03, -2963356.62), (-271385.26, -2963824.86),
                     (-271763.05, -2962080.91), (-273287.33, -2962039.40),
                     (-273222.73, -2960283.23), (-272100.97, -2960516.26),
                     (-270746.59, -2959364.05), (-272878.43, -2959510.30),
                     (-273518.05, -2960575.09), (-274258.49, -2959499.82),
                     (-276050.64, -2961047.22), (-272492.55, -2962592.46),
                     (-274255.20, -2969951.63), (-281601.48, -2973012.19),
                     (-281916.28, -2970950.28), (-284388.63, -2971530.27),
                     (-283465.31, -2969155.65), (-285099.50, -2967619.59),
                     (-286259.55, -2970012.23), (-287668.98, -2967733.49),
                     (-290348.53, -2969175.22), (-291001.48, -2966695.09),
                     (-285544.44, -2965969.84), (-284045.96, -2963156.24),
                     (-285578.89, -2961218.41), (-286167.52, -2962494.99),
                     (-286169.94, -2960964.95), (-284832.56, -2960547.25),
                     (-284801.20, -2959961.14), (-287022.61, -2959553.62),
                     (-287212.80, -2964061.62), (-288894.34, -2964533.43),
                     (-290145.33, -2963844.91), (-288673.40, -2963262.67),
                     (-291190.25, -2961177.30), (-290987.89, -2959522.45),
                     (-290217.33, -2960306.82), (-288780.63, -2958370.76),
                     (-291007.93, -2954082.22), (-288529.22, -2956809.27),
                     (-288852.64, -2953425.60), (-285528.42, -2955652.58),
                     (-286849.18, -2952252.19), (-282619.15, -2951987.40),
                     (-279163.89, -2949849.48), (-278802.08, -2948066.84),
                     (-279444.42, -2949438.40), (-282003.89, -2947350.21),
                     (-279865.22, -2945574.29), (-270027.47, -2942497.78),
                     (-268089.95, -2943081.01), (-266528.09, -2942184.82),
                     (-261256.16, -2942333.07), (-261240.47, -2941894.11),
                     (-260175.20, -2942288.96), (-259585.62, -2941800.93),
                     (-257615.56, -2942063.55), (-257443.43, -2941817.17),
                     (-269502.71, -2940275.80), (-269993.17, -2941605.04),
                     (-273297.95, -2941747.24), (-272782.93, -2939757.63),
                     (-275018.48, -2939644.57), (-276433.82, -2942523.61),
                     (-282044.70, -2945905.84), (-284616.91, -2943522.36),
                     (-282745.23, -2942337.00), (-284899.38, -2942567.63),
                     (-285990.23, -2938797.13), (-286429.68, -2940337.01),
                     (-289160.46, -2939856.22), (-290691.91, -2942609.48),
                     (-291921.60, -2940880.52), (-290916.32, -2939134.30),
                     (-295514.90, -2941812.14), (-298359.16, -2940353.81),
                     (-298384.29, -2942554.81), (-304920.92, -2949128.42),
                     (-305312.89, -2943062.68), (-300730.52, -2938870.89),
                     (-299165.31, -2940475.14), (-296518.72, -2934699.78),
                     (-300959.67, -2936570.43), (-309391.86, -2946645.10),
                     (-309243.13, -2942549.74), (-310526.98, -2942708.35),
                     (-310709.27, -2946036.55), (-311566.78, -2937703.93),
                     (-308800.69, -2934307.99), (-309182.33, -2935984.84),
                     (-306896.77, -2935758.37), (-306421.88, -2937392.86),
                     (-305939.42, -2935593.02), (-308231.64, -2933647.74),
                     (-310833.06, -2935754.28), (-312986.39, -2934999.37),
                     (-313167.98, -2933099.62), (-312984.61, -2934147.25),
                     (-311270.46, -2932094.50), (-311244.57, -2933801.68),
                     (-308271.52, -2931088.37), (-309346.91, -2928889.69),
                     (-310982.98, -2931038.53), (-313417.27, -2928491.36),
                     (-311418.19, -2924854.27), (-312635.21, -2923580.72),
                     (-307967.58, -2922192.14), (-297820.66, -2923433.07),
                     (-288744.62, -2921990.51), (-286486.65, -2923429.84),
                     (-280510.71, -2923274.16), (-279161.16, -2922858.59),
                     (-280254.67, -2921099.11), (-277207.85, -2919743.24),
                     (-263685.09, -2923230.56), (-274225.12, -2918159.63),
                     (-285100.83, -2921680.75), (-289227.03, -2920148.67),
                     (-294754.40, -2921346.81), (-296384.84, -2918695.40),
                     (-299004.48, -2921283.24), (-304916.11, -2919792.89),
                     (-309989.72, -2921040.34), (-311405.89, -2919569.40),
                     (-309908.86, -2917759.89), (-307122.54, -2918905.04),
                     (-306445.60, -2918329.97), (-309178.55, -2916399.08),
                     (-305524.34, -2910118.93), (-307498.13, -2909912.18),
                     (-307901.97, -2908167.66), (-312857.00, -2920943.61),
                     (-317124.23, -2917968.56), (-315038.26, -2919069.43),
                     (-315987.05, -2917207.79), (-313749.59, -2917150.76),
                     (-314299.54, -2915682.86), (-312649.15, -2914506.82),
                     (-315567.49, -2912114.34), (-317110.77, -2913947.83),
                     (-318201.39, -2910926.43), (-314491.14, -2910818.79),
                     (-314238.93, -2907030.64), (-309186.44, -2907827.11),
                     (-307668.09, -2905668.01), (-297988.89, -2904673.02),
                     (-299323.96, -2901659.00), (-309101.06, -2903110.90),
                     (-310640.78, -2902127.28), (-311353.19, -2890229.67),
                     (-309045.93, -2891997.04), (-307345.46, -2888657.37),
                     (-298731.60, -2893492.26), (-302148.04, -2896418.45),
                     (-298241.50, -2894129.86), (-284725.56, -2891658.67),
                     (-280153.41, -2891681.29), (-280733.41, -2894993.70),
                     (-278010.22, -2889969.26), (-285820.35, -2889784.82),
                     (-288072.54, -2891133.48), (-288617.72, -2889331.41),
                     (-296501.31, -2892919.12), (-303164.76, -2890738.84),
                     (-307430.89, -2886682.71), (-308707.02, -2889613.17),
                     (-311872.24, -2889866.30), (-311444.86, -2891099.59),
                     (-313757.75, -2891060.58), (-312772.02, -2892836.51),
                     (-314736.98, -2892834.50), (-312943.19, -2893904.44),
                     (-312528.58, -2899434.59), (-310346.09, -2902950.53),
                     (-313387.50, -2905080.80), (-314101.40, -2902524.81),
                     (-318883.45, -2899042.12), (-321368.64, -2900070.47),
                     (-323251.32, -2898449.28), (-324180.96, -2900580.55),
                     (-325437.92, -2899978.26), (-325488.87, -2898241.34),
                     (-322979.45, -2898096.19), (-324315.32, -2897133.14),
                     (-323563.43, -2894190.43), (-325934.34, -2897738.95),
                     (-326688.76, -2896413.02), (-325118.72, -2894745.01),
                     (-326644.58, -2895581.12), (-329454.79, -2893859.80),
                     (-328878.19, -2892015.15), (-326658.90, -2891838.51),
                     (-327673.08, -2888944.90), (-326245.67, -2890152.02),
                     (-327249.00, -2887992.12), (-327993.17, -2888925.80),
                     (-330331.26, -2887459.86), (-329828.64, -2885211.37),
                     (-326166.03, -2887461.63), (-325551.80, -2891076.14),
                     (-323746.37, -2890093.37), (-323432.56, -2894058.15),
                     (-321653.07, -2896651.74), (-320300.02, -2897078.25),
                     (-322455.82, -2892870.25), (-320761.12, -2893490.16),
                     (-319726.17, -2890636.09), (-316926.12, -2890228.50),
                     (-314938.72, -2887798.07), (-315900.52, -2887461.29),
                     (-322540.71, -2892421.24), (-324134.51, -2887940.55),
                     (-326434.61, -2885013.23), (-327641.60, -2886161.77),
                     (-331048.41, -2881782.21), (-327243.06, -2881569.62),
                     (-326361.49, -2880168.76), (-322130.08, -2879990.02),
                     (-319719.60, -2879198.71), (-319839.90, -2878395.04),
                     (-326375.14, -2879462.69), (-326601.55, -2876623.71),
                     (-329417.61, -2880782.47), (-329942.59, -2878820.85),
                     (-331483.25, -2880211.52), (-330549.13, -2877905.54),
                     (-331433.98, -2878779.21), (-331860.67, -2878382.31),
                     (-330473.63, -2874424.71), (-328985.51, -2873116.51),
                     (-327903.67, -2875078.13), (-328485.04, -2872818.12),
                     (-323408.48, -2871947.65), (-323536.37, -2870380.27),
                     (-323242.39, -2871482.34), (-318885.70, -2873248.09),
                     (-319066.41, -2874958.63), (-314454.96, -2874596.36),
                     (-313405.40, -2871599.26), (-319201.13, -2872906.87),
                     (-321967.97, -2870517.62), (-312656.07, -2869772.11),
                     (-312817.15, -2866854.30), (-307316.71, -2862216.64),
                     (-295691.96, -2857815.21), (-298339.22, -2856804.80),
                     (-310151.01, -2861025.04), (-315355.42, -2867304.18),
                     (-316872.64, -2864462.23), (-317187.04, -2868825.41),
                     (-324113.33, -2868912.47), (-324503.11, -2862629.65),
                     (-320863.32, -2865065.93), (-321330.22, -2860063.91),
                     (-318590.66, -2860207.60), (-320614.55, -2857591.18),
                     (-319187.31, -2853932.87), (-322024.87, -2853618.65),
                     (-321246.79, -2850697.55), (-316929.75, -2852531.85),
                     (-321431.12, -2847456.21), (-324196.12, -2850882.94),
                     (-326358.89, -2850010.22), (-326542.57, -2847046.52),
                     (-328588.17, -2848381.73), (-330014.37, -2847190.74),
                     (-331417.79, -2843584.83), (-329245.24, -2841326.84),
                     (-326229.03, -2840227.25), (-321551.99, -2841132.93),
                     (-313938.51, -2845290.38), (-318722.53, -2840128.45),
                     (-304363.86, -2837238.86), (-300868.22, -2837679.22),
                     (-299470.33, -2839420.53), (-298362.75, -2837240.95),
                     (-295268.12, -2836203.91), (-291599.75, -2838067.58),
                     (-290105.92, -2835267.43), (-286166.50, -2833982.69),
                     (-282272.07, -2829210.57), (-277161.54, -2832392.60),
                     (-271987.96, -2832449.35), (-272205.06, -2834533.37),
                     (-269108.19, -2831490.95), (-266068.48, -2831806.79),
                     (-260970.39, -2828358.09), (-257026.49, -2829541.86),
                     (-254114.24, -2828542.51), (-253612.66, -2832455.90),
                     (-252424.65, -2830588.99), (-253212.82, -2828312.61),
                     (-256630.93, -2826994.57), (-255139.07, -2826856.56),
                     (-255692.62, -2824575.49), (-261711.84, -2825355.24),
                     (-266549.91, -2828275.44), (-276130.61, -2828682.38),
                     (-265323.13, -2811423.72), (-268283.03, -2812328.62),
                     (-274909.61, -2821465.70), (-275467.46, -2819944.81),
                     (-276885.25, -2823716.56), (-279786.03, -2825301.11),
                     (-284599.53, -2825163.36), (-288121.57, -2829739.56),
                     (-300237.70, -2833633.30), (-302530.48, -2832893.79),
                     (-321051.23, -2837510.51), (-321563.15, -2835978.04),
                     (-326725.79, -2835798.14), (-325373.83, -2834095.05),
                     (-328081.85, -2834233.17), (-329448.14, -2830969.15),
                     (-324075.31, -2826271.53), (-316685.68, -2830781.58),
                     (-317845.08, -2827135.84), (-324519.19, -2824936.52),
                     (-330705.86, -2829723.53), (-331653.52, -2823577.04),
                     (-332400.87, -2825286.52), (-332669.08, -2824037.57),
                     (-333648.17, -2825849.78), (-334575.78, -2824936.33),
                     (-332615.38, -2822309.52), (-327617.70, -2822165.83),
                     (-325790.66, -2820645.94), (-320277.79, -2822195.63),
                     (-316864.07, -2821181.80), (-315432.37, -2824522.85),
                     (-310478.15, -2827490.70), (-303598.13, -2824689.81),
                     (-299960.86, -2820435.26), (-294623.75, -2823936.53),
                     (-289969.64, -2823125.16), (-291101.20, -2821719.07),
                     (-289336.62, -2820951.37), (-289958.33, -2819628.39),
                     (-294810.24, -2820420.08), (-299019.42, -2817184.40),
                     (-290446.12, -2805040.99), (-290420.91, -2802850.73),
                     (-284376.53, -2800970.23), (-282329.89, -2805716.20),
                     (-278516.81, -2808117.95), (-275487.76, -2807951.91),
                     (-276606.76, -2805788.34), (-280275.47, -2805083.23),
                     (-279939.84, -2799359.11), (-277625.66, -2802948.34),
                     (-275058.12, -2802997.25), (-274024.63, -2804859.26),
                     (-270889.63, -2804513.90), (-265162.45, -2808395.21),
                     (-263671.91, -2806230.29), (-261162.80, -2806841.96),
                     (-259210.38, -2805495.39), (-258721.27, -2802495.40),
                     (-255671.14, -2802939.57), (-256520.51, -2797605.16),
                     (-260391.57, -2799701.93), (-261015.83, -2802896.19),
                     (-266345.82, -2803832.60), (-268273.18, -2801848.71),
                     (-274891.22, -2800559.09), (-277925.90, -2796032.88),
                     (-266323.31, -2789864.76), (-276832.52, -2793122.30),
                     (-278768.17, -2789135.44), (-275730.60, -2785654.53),
                     (-280674.96, -2786554.52), (-282686.44, -2782326.44),
                     (-283652.81, -2784299.56), (-288104.76, -2784402.49),
                     (-288878.89, -2782173.69), (-286470.04, -2779125.20),
                     (-281871.04, -2776773.82), (-275705.22, -2780563.88),
                     (-271492.95, -2780604.85), (-270212.48, -2777291.76),
                     (-267124.57, -2778490.07), (-266705.47, -2776430.84),
                     (-270771.72, -2775933.73), (-273411.17, -2777994.75),
                     (-276508.65, -2773538.11), (-268655.98, -2771890.67),
                     (-258811.77, -2777194.11), (-256190.48, -2793497.70),
                     (-253773.98, -2799553.38), (-249135.07, -2801628.86),
                     (-243595.29, -2808656.25), (-239674.21, -2809692.85),
                     (-237165.09, -2814412.45), (-232230.58, -2818903.16),
                     (-226633.38, -2818965.28), (-229240.29, -2813803.46),
                     (-233411.76, -2812689.36), (-233263.70, -2808149.23),
                     (-240644.50, -2804972.16), (-239704.38, -2803072.27),
                     (-246058.17, -2798821.12), (-249660.91, -2793450.85),
                     (-251464.71, -2781257.20), (-244544.10, -2776152.68),
                     (-246561.96, -2774195.15), (-251812.09, -2775876.69),
                     (-254836.51, -2772379.92), (-252885.72, -2768494.78),
                     (-248934.21, -2767269.76), (-248532.04, -2765501.52),
                     (-250116.91, -2765162.05), (-248681.14, -2762012.49),
                     (-240770.74, -2759183.31), (-244484.07, -2758405.15),
                     (-247477.11, -2761378.42), (-247033.79, -2760198.53),
                     (-249874.51, -2759728.91), (-258810.13, -2770156.68),
                     (-259496.64, -2766932.03), (-260746.80, -2768845.70),
                     (-270015.31, -2766449.05), (-271426.87, -2757602.19),
                     (-269559.49, -2756629.71), (-271524.11, -2756716.40),
                     (-269844.61, -2754469.35), (-273165.26, -2752312.92),
                     (-271558.24, -2750759.10), (-272663.63, -2750585.22),
                     (-271734.88, -2750215.38), (-272478.84, -2748678.59),
                     (-272867.61, -2751001.63), (-273757.53, -2750441.66),
                     (-273159.91, -2743472.12), (-275209.98, -2742849.19),
                     (-272832.40, -2739363.79), (-273606.15, -2736861.75),
                     (-275975.10, -2736642.98), (-277393.75, -2734452.62),
                     (-276226.51, -2729296.13), (-278804.49, -2723427.37),
                     (-274110.76, -2720508.04), (-268265.69, -2715051.90),
                     (-272952.87, -2718302.64), (-273541.70, -2717270.93),
                     (-270282.06, -2713387.51), (-273896.68, -2717407.27),
                     (-279934.03, -2720437.15), (-283051.75, -2712370.38),
                     (-285025.10, -2711871.57), (-283085.86, -2715748.02),
                     (-284076.48, -2717130.68), (-282780.26, -2718112.23),
                     (-282756.17, -2723158.55), (-280615.97, -2725686.65),
                     (-283972.28, -2728075.51), (-281661.70, -2728288.90),
                     (-280459.02, -2731418.89), (-282744.88, -2740279.96),
                     (-281021.91, -2742211.18), (-277665.73, -2738580.81),
                     (-274407.98, -2739228.13), (-274071.42, -2740751.11),
                     (-275568.37, -2742928.38), (-274005.89, -2743471.15),
                     (-274213.86, -2746016.93), (-276243.31, -2748401.53),
                     (-274087.17, -2749269.11), (-276073.50, -2750403.65),
                     (-275526.32, -2753262.56), (-278506.62, -2753154.88),
                     (-275453.13, -2753678.80), (-272161.19, -2757087.65),
                     (-277378.86, -2762876.59), (-274223.31, -2763411.02),
                     (-273805.20, -2766812.34), (-277662.97, -2768102.45),
                     (-276074.24, -2763801.37), (-278023.34, -2764152.14),
                     (-283139.51, -2767558.04), (-282548.00, -2769576.55),
                     (-286041.81, -2773094.45), (-294069.44, -2775551.55),
                     (-293549.75, -2773941.11), (-294712.81, -2774169.64),
                     (-295357.17, -2776963.91), (-292683.20, -2775142.93),
                     (-291812.77, -2776315.14), (-294192.19, -2779219.31),
                     (-298616.37, -2779060.53), (-298456.80, -2777821.93),
                     (-300251.42, -2778771.24), (-303211.05, -2777334.41),
                     (-300055.68, -2772759.36), (-300883.73, -2770920.40),
                     (-298210.22, -2768135.40), (-298742.92, -2766677.55),
                     (-294887.33, -2765973.08), (-295210.29, -2763077.87),
                     (-293566.16, -2764653.04), (-292088.06, -2763931.49),
                     (-293824.01, -2763778.31), (-292100.42, -2762383.02),
                     (-291404.09, -2760617.24), (-291769.41, -2760344.59),
                     (-291592.90, -2759829.32), (-291778.66, -2759321.81),
                     (-291964.21, -2759142.33), (-292498.69, -2762005.19),
                     (-293171.15, -2760065.89), (-300054.62, -2760698.87),
                     (-305086.08, -2765351.16), (-304938.21, -2768652.34),
                     (-306769.16, -2769948.18), (-308355.30, -2775419.22),
                     (-309673.06, -2775863.46), (-309840.76, -2774136.99),
                     (-312951.39, -2776889.40), (-314164.49, -2786696.34),
                     (-318041.67, -2790874.55), (-317497.37, -2792774.95),
                     (-320586.67, -2795165.85), (-323244.44, -2793626.11),
                     (-321176.19, -2795074.15), (-321473.18, -2797322.97),
                     (-323043.64, -2797243.90), (-327748.84, -2804098.85),
                     (-331467.72, -2804418.59), (-328914.61, -2805160.03),
                     (-329720.40, -2809988.40), (-328876.61, -2809346.35),
                     (-330007.74, -2812004.70), (-331654.13, -2811489.14),
                     (-332270.00, -2813607.66), (-332570.39, -2812581.33),
                     (-334150.72, -2817533.28), (-340630.01, -2821217.86),
                     (-343234.79, -2817925.36), (-342713.39, -2821127.17),
                     (-344753.82, -2820368.41), (-344956.79, -2821444.12),
                     (-346800.27, -2820895.98), (-346178.82, -2818912.17),
                     (-347000.12, -2817928.47), (-347721.66, -2820476.42),
                     (-346224.31, -2822625.68), (-350541.44, -2823583.57),
                     (-349478.11, -2821575.63), (-350400.45, -2817613.13),
                     (-348227.74, -2818274.60), (-350893.18, -2816477.49),
                     (-349215.75, -2815019.00), (-349690.71, -2813445.63),
                     (-351846.95, -2816639.42), (-352769.01, -2812677.20),
                     (-354127.29, -2812795.48), (-350976.65, -2811787.10),
                     (-352139.65, -2811720.80), (-351308.50, -2809147.94),
                     (-350891.19, -2810352.17), (-350061.35, -2809253.19),
                     (-351308.61, -2806690.22), (-349990.41, -2806129.36),
                     (-349659.53, -2807685.87), (-348690.62, -2808198.38),
                     (-348319.39, -2804728.21), (-349952.35, -2802769.08),
                     (-348542.10, -2801340.44), (-350838.55, -2800392.49),
                     (-349597.03, -2796168.09), (-346516.03, -2794977.46),
                     (-350642.88, -2796377.46), (-348015.30, -2793823.06),
                     (-349309.85, -2791939.48), (-349901.66, -2794234.80),
                     (-350964.56, -2794194.32), (-349907.00, -2792099.56),
                     (-350837.20, -2792731.05), (-350047.06, -2791538.94),
                     (-351242.69, -2791196.27), (-349717.22, -2790190.58),
                     (-351211.21, -2790761.41), (-351282.22, -2789788.89),
                     (-349850.24, -2789795.83), (-349991.88, -2790120.62),
                     (-349534.50, -2790121.81), (-349369.14, -2791309.96),
                     (-349207.26, -2788432.94), (-347305.97, -2789970.53),
                     (-348307.37, -2787944.08), (-346033.99, -2787192.91),
                     (-344412.17, -2788974.28), (-345179.29, -2787123.63),
                     (-342771.62, -2786753.14), (-348580.85, -2785722.03),
                     (-347265.20, -2784489.01), (-348441.73, -2784831.13),
                     (-347091.95, -2782870.54), (-347072.04, -2781323.48),
                     (-349265.40, -2782697.09), (-348791.95, -2779093.78),
                     (-346946.70, -2780694.37), (-347203.61, -2778183.00),
                     (-345015.19, -2779030.44), (-342247.70, -2775556.85),
                     (-343645.40, -2774968.58), (-344177.87, -2776665.73),
                     (-345302.70, -2775434.90), (-345847.75, -2773155.03),
                     (-344795.23, -2774787.02), (-342442.83, -2770276.29),
                     (-346390.53, -2770584.57), (-347573.27, -2764439.87),
                     (-344361.33, -2759263.67), (-344345.78, -2760754.48),
                     (-343600.46, -2759519.88), (-342547.86, -2761150.94),
                     (-339717.38, -2757072.85), (-340320.57, -2760805.01),
                     (-339474.42, -2759990.46), (-339131.37, -2761429.61),
                     (-337529.10, -2758182.41), (-338291.88, -2761225.96),
                     (-335630.81, -2758590.19), (-336474.82, -2756514.16),
                     (-337087.99, -2757879.44), (-338197.26, -2755687.91),
                     (-335626.22, -2756225.28), (-333717.09, -2754472.80),
                     (-332678.23, -2756510.60), (-331888.62, -2754579.36),
                     (-333202.65, -2754030.74), (-333406.21, -2752928.84),
                     (-332422.45, -2753558.97), (-331980.26, -2751328.78),
                     (-330096.65, -2753105.84), (-330734.43, -2750322.87),
                     (-328945.44, -2749695.96), (-329236.42, -2751607.02),
                     (-328721.89, -2749515.77), (-326175.55, -2750283.12),
                     (-324760.58, -2747951.95), (-319965.23, -2747877.94),
                     (-318405.41, -2745007.30), (-315366.67, -2750204.40),
                     (-314722.07, -2747150.17), (-311650.07, -2744323.86),
                     (-311644.13, -2745374.22), (-310144.77, -2742235.40),
                     (-306050.51, -2745470.14), (-306806.25, -2742676.02),
                     (-307127.18, -2743780.85), (-309677.00, -2742226.61),
                     (-309366.19, -2740392.30), (-302048.53, -2737139.02),
                     (-299483.27, -2734668.09), (-298923.71, -2731576.28),
                     (-300442.70, -2729665.93), (-300638.29, -2733728.76),
                     (-302625.50, -2735692.98), (-308544.51, -2733593.20),
                     (-307225.23, -2736155.22), (-305859.58, -2735380.08),
                     (-304962.79, -2736831.83), (-305937.04, -2738041.70),
                     (-307450.76, -2737181.39), (-308309.80, -2739234.77),
                     (-311115.43, -2732664.70), (-313990.95, -2736401.16),
                     (-311378.68, -2739013.24), (-312604.60, -2736256.14),
                     (-311357.99, -2734404.58), (-309175.93, -2739011.54),
                     (-311573.73, -2739195.47), (-312645.78, -2741330.07),
                     (-321940.45, -2746136.48), (-320394.71, -2737355.20),
                     (-316508.62, -2735930.66), (-316307.61, -2737059.49),
                     (-314380.83, -2734434.41), (-315905.84, -2734097.59),
                     (-314914.09, -2732729.71), (-316812.53, -2734118.31),
                     (-318013.16, -2731964.21), (-319651.94, -2732562.21),
                     (-318638.67, -2730159.89), (-321544.52, -2730055.63),
                     (-323125.25, -2735314.75), (-321804.75, -2737030.98),
                     (-328372.79, -2739658.70), (-328602.75, -2741638.12),
                     (-327679.05, -2742738.45), (-327491.52, -2740977.90),
                     (-325867.07, -2741618.34), (-326642.82, -2745066.79),
                     (-324364.00, -2746418.15), (-323259.56, -2745367.81),
                     (-322817.62, -2746699.77), (-328496.03, -2749043.18),
                     (-328423.16, -2747533.77), (-326625.85, -2747928.63),
                     (-325569.79, -2746786.35), (-329315.01, -2743847.86),
                     (-331225.75, -2746300.98), (-330510.42, -2749865.02),
                     (-337718.97, -2753125.98), (-339837.50, -2751088.80),
                     (-339430.22, -2753016.19), (-341981.80, -2753940.57),
                     (-343527.07, -2753102.95), (-342531.57, -2751166.53),
                     (-335729.82, -2747747.17), (-335212.13, -2749057.95),
                     (-335036.75, -2747412.10), (-337149.48, -2748062.80),
                     (-336506.63, -2746146.07), (-334530.73, -2746501.81),
                     (-334823.08, -2744866.53), (-333038.41, -2744005.52),
                     (-335746.93, -2744767.40), (-337205.30, -2742569.22),
                     (-337276.34, -2743787.43), (-338775.48, -2738237.44),
                     (-339118.09, -2745721.87), (-348006.01, -2751163.70),
                     (-347692.75, -2747285.37), (-346552.26, -2748633.12),
                     (-346241.28, -2747089.99), (-342892.13, -2746894.60),
                     (-342185.81, -2744927.20), (-343081.32, -2744158.82),
                     (-344023.34, -2746277.25), (-346055.87, -2746584.77),
                     (-343764.40, -2745224.10), (-346512.57, -2742536.77),
                     (-346547.46, -2745043.50), (-346900.06, -2744992.43),
                     (-347597.83, -2738771.86), (-337637.53, -2734322.73),
                     (-336163.82, -2735005.00), (-334856.21, -2731954.56),
                     (-340195.02, -2732590.26), (-337727.59, -2729227.62),
                     (-338879.24, -2727959.04), (-342417.61, -2730047.57),
                     (-344064.79, -2729214.99), (-341912.05, -2727096.06),
                     (-343507.76, -2727013.30), (-342518.38, -2724581.44),
                     (-340577.09, -2723475.95), (-345140.27, -2724547.81),
                     (-344580.28, -2722726.55), (-346154.58, -2723127.11),
                     (-345290.19, -2721863.75), (-346559.77, -2722280.94),
                     (-347028.30, -2719168.53), (-345117.01, -2716981.42),
                     (-342989.93, -2716451.81), (-341512.74, -2718184.29),
                     (-336952.48, -2715901.27), (-341112.66, -2716215.03),
                     (-342321.84, -2712935.97), (-339716.17, -2711203.25),
                     (-335096.66, -2708898.24), (-334181.70, -2709886.24),
                     (-331567.28, -2709974.38), (-333612.01, -2708648.58),
                     (-332301.18, -2707563.63), (-341097.92, -2711580.56),
                     (-342137.56, -2710127.41), (-343293.98, -2710849.71),
                     (-337929.15, -2706759.60), (-339004.68, -2706731.34),
                     (-337072.04, -2705013.63), (-337666.89, -2703492.13),
                     (-335592.18, -2702898.41), (-329271.72, -2694743.11),
                     (-330282.54, -2694110.28), (-332119.84, -2696579.99),
                     (-332143.85, -2695441.00), (-341976.56, -2706442.04),
                     (-345964.67, -2706932.83), (-343225.08, -2702762.39),
                     (-345165.25, -2702602.15), (-346538.06, -2700590.10),
                     (-343784.18, -2699368.79), (-344234.81, -2701943.83),
                     (-342836.05, -2702763.79), (-338476.31, -2697430.72),
                     (-339940.34, -2697769.75), (-340817.57, -2695752.64),
                     (-338698.86, -2694609.17), (-339144.52, -2692784.04),
                     (-340126.19, -2693786.37), (-341099.18, -2692440.07),
                     (-346242.70, -2697561.12), (-346134.13, -2692472.59),
                     (-344618.89, -2690566.22), (-346406.41, -2689850.00),
                     (-346763.03, -2695348.50), (-348760.60, -2698485.78),
                     (-347256.06, -2696956.65), (-346840.06, -2696884.50),
                     (-347656.68, -2698517.37), (-356230.24, -2706414.01),
                     (-357712.86, -2704753.60), (-355437.33, -2702840.11),
                     (-355809.28, -2701692.45), (-357129.73, -2703124.68),
                     (-356524.42, -2701295.19), (-354979.48, -2700207.95),
                     (-355293.75, -2701777.46), (-354358.54, -2702023.73),
                     (-352699.40, -2699608.30), (-354412.91, -2699277.55),
                     (-352438.71, -2699344.03), (-351047.12, -2698064.71),
                     (-353045.77, -2698083.95), (-352134.68, -2696520.59),
                     (-351461.98, -2697584.38), (-352268.90, -2694786.44),
                     (-353563.48, -2697882.41), (-355230.15, -2697120.48),
                     (-355867.70, -2695188.01), (-353409.25, -2692245.03),
                     (-356197.02, -2695267.95), (-357704.51, -2691404.52),
                     (-354569.17, -2687721.08), (-350101.24, -2687356.14),
                     (-347934.96, -2683189.22), (-342138.89, -2683199.03),
                     (-342139.53, -2684290.65), (-339463.53, -2682698.50),
                     (-336516.11, -2677742.32), (-330499.00, -2676216.33),
                     (-327336.87, -2677053.29), (-327651.57, -2675456.34),
                     (-320945.69, -2670726.52), (-319798.43, -2666510.75),
                     (-314807.41, -2665701.38), (-317156.48, -2662746.35),
                     (-320607.38, -2663994.19), (-323211.76, -2663032.94),
                     (-322503.41, -2665262.47), (-324671.41, -2666894.60),
                     (-322797.57, -2667065.05), (-322771.23, -2669280.56),
                     (-333005.14, -2674594.44), (-336133.16, -2674842.27),
                     (-335741.98, -2673320.97), (-341976.52, -2680594.56),
                     (-339205.07, -2675833.39), (-343093.48, -2680416.43),
                     (-345211.91, -2680072.49), (-345865.03, -2678284.37),
                     (-352921.08, -2684314.66), (-352234.80, -2681184.06),
                     (-353640.41, -2682605.48), (-353023.72, -2679215.77),
                     (-354185.62, -2680361.49), (-354507.52, -2678754.77),
                     (-350602.98, -2675212.48), (-350430.34, -2673877.07),
                     (-351472.11, -2675439.95), (-352861.31, -2675902.50),
                     (-344374.62, -2664118.33), (-348142.58, -2666537.73),
                     (-354964.85, -2677044.41), (-355324.34, -2675244.12),
                     (-355899.82, -2676799.15), (-356722.39, -2675419.10),
                     (-356495.27, -2670968.54), (-357641.50, -2670931.83),
                     (-351892.74, -2664184.00), (-346424.13, -2651760.29),
                     (-359993.03, -2670998.70), (-361407.65, -2670613.38),
                     (-361448.50, -2668293.93), (-364907.38, -2667964.81),
                     (-363675.55, -2668058.73), (-364782.80, -2663843.83),
                     (-362316.41, -2660412.32), (-364405.12, -2660477.83),
                     (-364700.31, -2658494.96), (-350415.17, -2650983.58),
                     (-352953.74, -2650505.23), (-362734.47, -2655650.83),
                     (-363034.04, -2653843.80), (-359091.40, -2650747.29),
                     (-357538.20, -2646869.41), (-355051.51, -2647282.90),
                     (-357185.56, -2645219.25), (-354809.80, -2637068.14),
                     (-355396.65, -2634415.39), (-358543.71, -2644317.31),
                     (-362824.25, -2650009.34), (-364636.18, -2650352.35),
                     (-365701.80, -2646745.35), (-369574.71, -2649731.06),
                     (-374097.42, -2648761.45), (-376016.48, -2649820.20),
                     (-382817.56, -2646113.39), (-379113.09, -2642150.85),
                     (-372510.84, -2640829.70), (-365112.94, -2636713.13),
                     (-365963.03, -2636505.05), (-365852.44, -2636022.50),
                     (-363165.96, -2635788.76), (-366615.96, -2635547.54),
                     (-366007.70, -2633155.12), (-368986.55, -2637297.80),
                     (-378006.99, -2640801.75), (-377527.28, -2639864.66),
                     (-379716.50, -2639932.42), (-380258.51, -2637953.53),
                     (-379345.41, -2636510.04), (-378225.68, -2637184.05),
                     (-378260.00, -2635086.60), (-369468.80, -2632343.93),
                     (-373968.36, -2632526.42), (-372809.80, -2629888.61),
                     (-371062.29, -2630135.74), (-372362.23, -2628976.55),
                     (-364432.79, -2625036.65), (-359469.10, -2627810.77),
                     (-360029.39, -2626267.37), (-357636.60, -2625377.75),
                     (-360611.65, -2626001.44), (-361439.95, -2624254.19),
                     (-354266.76, -2620551.01), (-351835.56, -2621189.94),
                     (-347189.87, -2627737.79), (-338504.12, -2629716.77),
                     (-337112.20, -2634911.02), (-335405.94, -2631472.59),
                     (-332377.04, -2631157.02), (-335208.83, -2629080.99),
                     (-330343.53, -2621111.46), (-319440.42, -2616723.34),
                     (-315782.60, -2616213.24), (-315763.84, -2618220.33),
                     (-313645.81, -2619346.94), (-308737.60, -2628138.10),
                     (-308882.28, -2622933.73), (-313760.84, -2616195.79),
                     (-306649.78, -2608204.77), (-316264.89, -2613648.18),
                     (-329117.30, -2616708.60), (-332736.42, -2619839.05),
                     (-336411.13, -2628094.08), (-346786.50, -2624931.69),
                     (-349325.61, -2618669.77), (-343766.63, -2615632.68),
                     (-346642.51, -2614801.58), (-345662.08, -2611898.67),
                     (-354107.47, -2618532.79), (-357135.78, -2613991.41),
                     (-359074.85, -2614870.81), (-357222.41, -2619798.08),
                     (-369653.40, -2624908.37), (-370125.67, -2623897.43),
                     (-372849.29, -2624882.36), (-377458.73, -2628235.94),
                     (-380422.34, -2626067.10), (-379581.52, -2622872.96),
                     (-376945.63, -2624845.58), (-375084.16, -2624843.80),
                     (-380986.41, -2620277.79), (-372433.00, -2617279.59),
                     (-372975.58, -2616116.35), (-363968.71, -2610783.44),
                     (-361295.95, -2611840.40), (-361060.27, -2609964.10),
                     (-364520.71, -2609706.74), (-379709.33, -2618751.61),
                     (-380946.34, -2617686.68), (-379137.13, -2616508.73),
                     (-381000.17, -2615584.32), (-383859.56, -2617804.63),
                     (-387501.21, -2617729.60), (-390287.81, -2613305.04),
                     (-389097.73, -2611720.13), (-389646.65, -2610889.67),
                     (-389448.75, -2610140.88), (-388587.49, -2609173.28),
                     (-389262.91, -2610568.60), (-385957.02, -2610376.10),
                     (-385801.21, -2608677.23), (-382636.27, -2607103.05),
                     (-386751.31, -2607789.25), (-388230.78, -2606010.19),
                     (-387483.99, -2603946.26), (-375103.23, -2596602.45),
                     (-360809.60, -2591221.55), (-351660.47, -2584482.27),
                     (-348335.02, -2577059.51), (-344017.15, -2575781.77),
                     (-343247.73, -2573484.80), (-340653.83, -2573385.34),
                     (-331580.39, -2566987.32), (-322685.02, -2566023.29),
                     (-320467.83, -2562923.60), (-312319.89, -2562965.33),
                     (-316522.15, -2559659.85), (-309072.91, -2547721.21),
                     (-293387.15, -2540066.31), (-285735.08, -2540891.95),
                     (-290103.89, -2537805.05), (-290042.48, -2535855.85),
                     (-281556.81, -2531246.69), (-277613.26, -2526823.86),
                     (-272923.02, -2526855.27), (-269466.32, -2529247.01),
                     (-271663.02, -2524930.50), (-270582.59, -2523335.23),
                     (-266893.88, -2524620.95), (-263919.40, -2528569.57),
                     (-259120.74, -2528942.32), (-256160.50, -2531657.84),
                     (-249816.27, -2528338.30), (-245386.15, -2531684.25),
                     (-235853.48, -2532504.09), (-236966.54, -2531229.78),
                     (-239366.01, -2530907.78), (-240549.37, -2530031.47),
                     (-239711.99, -2530335.07), (-239513.00, -2528704.64),
                     (-242666.96, -2530055.66), (-251159.48, -2526779.48),
                     (-254045.82, -2529721.07), (-261477.21, -2525451.66),
                     (-264481.28, -2521370.57), (-262727.69, -2518599.61),
                     (-258931.72, -2517753.68), (-253157.76, -2513197.49),
                     (-254155.73, -2511419.87), (-262781.02, -2514148.29),
                     (-268734.20, -2518982.13), (-272703.79, -2518998.59),
                     (-288892.05, -2528819.35), (-305233.97, -2542432.36),
                     (-311742.46, -2544335.09), (-314953.89, -2552430.93),
                     (-320578.70, -2559343.71), (-323394.08, -2560711.30),
                     (-324839.50, -2560121.17), (-326191.90, -2560019.74),
                     (-323671.00, -2561131.23), (-332935.59, -2564201.35),
                     (-337824.74, -2568930.08), (-349033.87, -2574923.36),
                     (-354189.89, -2583164.59), (-357750.01, -2586018.90),
                     (-380676.54, -2598097.16)], crs=NSIDCNorth)

