from typing import Any, Dict, List, Optional, Sequence, Tuple, Union

import numpy as np

from ..core import Env
from ..spaces.space import Space

__all__ = ["VectorEnv"]

class VectorEnv(Env):
    def __init__(
        self, num_envs: int, observation_space: Space, action_space: Space
    ) -> None: ...
    def reset_async(self) -> None: ...
    def reset_wait(self, **kwargs: Any) -> Any: ...
    def step_async(self, actions: Sequence[Any]) -> None: ...
    def step_wait(
        self, **kwargs: Any
    ) -> Tuple[Any, np.ndarray, np.ndarray, Dict[str, Any]]: ...
    def step(
        self, actions: Sequence[Any]
    ) -> Tuple[Any, np.ndarray, np.ndarray, Dict[str, Any]]: ...
    def close_extras(self, **kwargs: Any) -> None: ...
    def close(self, **kwargs: Any) -> None: ...
    def seed(self, seeds: Optional[Union[int, Sequence[int]]] = ...) -> List[int]: ...

class VectorEnvWrapper(VectorEnv):
    def __init__(self, env: VectorEnv) -> None: ...
